// third_party/blink/public/mojom/choosers/popup_menu.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.PopupMenuClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.PopupMenuClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.PopupMenuClientInterface }
 */
blink.mojom.PopupMenuClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.PopupMenuClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.PopupMenuClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.PopupMenuClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } indices
   */

  didAcceptIndices(
      indices) {
    this.proxy.sendMessage(
        0,
        blink.mojom.PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        [
          indices
        ],
        false);
  }

  
  /**
   */

  didCancel() {
    this.proxy.sendMessage(
        1,
        blink.mojom.PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PopupMenuClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.PopupMenuClientReceiver = class {
  /**
   * @param {!blink.mojom.PopupMenuClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.PopupMenuClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.PopupMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PopupMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        impl.didAcceptIndices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        impl.didCancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.PopupMenuClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PopupMenuClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.PopupMenuClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.PopupMenuClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PopupMenuClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.PopupMenuClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.PopupMenuClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.PopupMenuClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didAcceptIndices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
        null,
        this.didAcceptIndices.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didCancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.PopupMenuClient_DidCancel_ParamsSpec.$,
        null,
        this.didCancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.MenuItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupMenuClient_DidAcceptIndices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.PopupMenuClient_DidCancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.MenuItemSpec.TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.MenuItem_Type = {
  
  kOption: 0,
  kCheckableOption: 1,
  kGroup: 2,
  kSeparator: 3,
  kSubMenu: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


mojo.internal.Struct(
    blink.mojom.MenuItemSpec.$,
    'MenuItem',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'toolTip', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        blink.mojom.MenuItemSpec.TypeSpec.$,
        blink.mojom.MenuItem_Type.kOption,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'action', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'textDirection', 24,
        0,
        mojoBase.mojom.TextDirectionSpec.$,
        mojoBase.mojom.TextDirection.LEFT_TO_RIGHT,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasTextDirectionOverride', 28,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'enabled', 28,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'checked', 28,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.MenuItem = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.label;
    /** @export { (string|undefined) } */
    this.toolTip;
    /** @export { !blink.mojom.MenuItem_Type } */
    this.type;
    /** @export { !number } */
    this.action;
    /** @export { !mojoBase.mojom.TextDirection } */
    this.textDirection;
    /** @export { !boolean } */
    this.hasTextDirectionOverride;
    /** @export { !boolean } */
    this.enabled;
    /** @export { !boolean } */
    this.checked;
  }
};



mojo.internal.Struct(
    blink.mojom.PopupMenuClient_DidAcceptIndices_ParamsSpec.$,
    'PopupMenuClient_DidAcceptIndices_Params',
    [
      mojo.internal.StructField(
        'indices', 0,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.PopupMenuClient_DidAcceptIndices_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.indices;
  }
};



mojo.internal.Struct(
    blink.mojom.PopupMenuClient_DidCancel_ParamsSpec.$,
    'PopupMenuClient_DidCancel_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.PopupMenuClient_DidCancel_Params = class {
  constructor() {
  }
};

