// third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/call_stack_generator/call_stack_generator.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }



  function CallStackGenerator_CollectJavaScriptCallStack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CallStackGenerator_CollectJavaScriptCallStack_Params.prototype.initDefaults_ = function() {
  };
  CallStackGenerator_CollectJavaScriptCallStack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CallStackGenerator_CollectJavaScriptCallStack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CallStackGenerator_CollectJavaScriptCallStack_Params.encodedSize = codec.kStructHeaderSize + 0;

  CallStackGenerator_CollectJavaScriptCallStack_Params.decode = function(decoder) {
    var packed;
    var val = new CallStackGenerator_CollectJavaScriptCallStack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CallStackGenerator_CollectJavaScriptCallStack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CallStackGenerator_CollectJavaScriptCallStack_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CallStackGenerator_CollectJavaScriptCallStack_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.prototype.initDefaults_ = function() {
    this.javascriptCallStack = null;
    this.frameToken = null;
  };
  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.javascriptCallStack
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.frameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CallStackGenerator_CollectJavaScriptCallStack_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.javascriptCallStack =
        decoder.decodeStruct(codec.String);
    val.frameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    return val;
  };

  CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.javascriptCallStack);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.frameToken);
  };
  var kCallStackGenerator_CollectJavaScriptCallStack_Name = 0;

  function CallStackGeneratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CallStackGenerator,
                                                   handleOrPtrInfo);
  }

  function CallStackGeneratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CallStackGenerator, associatedInterfacePtrInfo);
  }

  CallStackGeneratorAssociatedPtr.prototype =
      Object.create(CallStackGeneratorPtr.prototype);
  CallStackGeneratorAssociatedPtr.prototype.constructor =
      CallStackGeneratorAssociatedPtr;

  function CallStackGeneratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  CallStackGeneratorPtr.prototype.collectJavaScriptCallStack = function() {
    return CallStackGeneratorProxy.prototype.collectJavaScriptCallStack
        .apply(this.ptr.getProxy(), arguments);
  };

  CallStackGeneratorProxy.prototype.collectJavaScriptCallStack = function() {
    var params_ = new CallStackGenerator_CollectJavaScriptCallStack_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCallStackGenerator_CollectJavaScriptCallStack_Name,
          codec.align(CallStackGenerator_CollectJavaScriptCallStack_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CallStackGenerator_CollectJavaScriptCallStack_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CallStackGenerator_CollectJavaScriptCallStack_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CallStackGeneratorStub(delegate) {
    this.delegate_ = delegate;
  }
  CallStackGeneratorStub.prototype.collectJavaScriptCallStack = function() {
    return this.delegate_ && this.delegate_.collectJavaScriptCallStack && this.delegate_.collectJavaScriptCallStack();
  }

  CallStackGeneratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CallStackGeneratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCallStackGenerator_CollectJavaScriptCallStack_Name:
      var params = reader.decodeStruct(CallStackGenerator_CollectJavaScriptCallStack_Params);
      this.collectJavaScriptCallStack().then(function(response) {
        var responseParams =
            new CallStackGenerator_CollectJavaScriptCallStack_ResponseParams();
        responseParams.javascriptCallStack = response.javascriptCallStack;
        responseParams.frameToken = response.frameToken;
        var builder = new codec.MessageV1Builder(
            kCallStackGenerator_CollectJavaScriptCallStack_Name,
            codec.align(CallStackGenerator_CollectJavaScriptCallStack_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CallStackGenerator_CollectJavaScriptCallStack_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCallStackGeneratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCallStackGenerator_CollectJavaScriptCallStack_Name:
        if (message.expectsResponse())
          paramsClass = CallStackGenerator_CollectJavaScriptCallStack_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCallStackGeneratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCallStackGenerator_CollectJavaScriptCallStack_Name:
        if (message.isResponse())
          paramsClass = CallStackGenerator_CollectJavaScriptCallStack_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CallStackGenerator = {
    name: 'blink.mojom.CallStackGenerator',
    kVersion: 0,
    ptrClass: CallStackGeneratorPtr,
    proxyClass: CallStackGeneratorProxy,
    stubClass: CallStackGeneratorStub,
    validateRequest: validateCallStackGeneratorRequest,
    validateResponse: validateCallStackGeneratorResponse,
  };
  CallStackGeneratorStub.prototype.validator = validateCallStackGeneratorRequest;
  CallStackGeneratorProxy.prototype.validator = validateCallStackGeneratorResponse;
  exports.CallStackGenerator = CallStackGenerator;
  exports.CallStackGeneratorPtr = CallStackGeneratorPtr;
  exports.CallStackGeneratorAssociatedPtr = CallStackGeneratorAssociatedPtr;
})();