// third_party/blink/public/mojom/blob/data_element.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/data_element.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/data_element.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-import-headers.h"
#include "third_party/blink/public/mojom/blob/data_element.mojom-test-utils.h"


namespace blink::mojom {
constexpr uint64_t DataElementBytes::kMaximumEmbeddedDataSize;
DataElementBytes::DataElementBytes()
    : length(),
      embedded_data(),
      data() {}

DataElementBytes::DataElementBytes(
    uint64_t length_in,
    std::optional<std::vector<uint8_t>> embedded_data_in,
    ::mojo::PendingRemote<BytesProvider> data_in)
    : length(std::move(length_in)),
      embedded_data(std::move(embedded_data_in)),
      data(std::move(data_in)) {}

DataElementBytes::~DataElementBytes() = default;

void DataElementBytes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "embedded_data"), this->embedded_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<BytesProvider>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementBytes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementFile::DataElementFile()
    : path(),
      offset(),
      length(),
      expected_modification_time() {}

DataElementFile::DataElementFile(
    const ::base::FilePath& path_in,
    uint64_t offset_in,
    uint64_t length_in,
    std::optional<::base::Time> expected_modification_time_in)
    : path(std::move(path_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)),
      expected_modification_time(std::move(expected_modification_time_in)) {}

DataElementFile::~DataElementFile() = default;

void DataElementFile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expected_modification_time"), this->expected_modification_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementFile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementBlob::DataElementBlob()
    : blob(),
      offset(),
      length() {}

DataElementBlob::DataElementBlob(
    ::mojo::PendingRemote<::blink::mojom::Blob> blob_in,
    uint64_t offset_in,
    uint64_t length_in)
    : blob(std::move(blob_in)),
      offset(std::move(offset_in)),
      length(std::move(length_in)) {}

DataElementBlob::~DataElementBlob() = default;

void DataElementBlob::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blob"), this->blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length"), this->length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataElementBlob::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataElementPtr
DataElement::NewBytes(
    DataElementBytesPtr value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
      std::move(value));
}

DataElementPtr
DataElement::NewFile(
    DataElementFilePtr value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFile)>,
      std::move(value));
}

DataElementPtr
DataElement::NewBlob(
    DataElementBlobPtr value) {
  return DataElementPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBlob)>,
      std::move(value));
}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    DataElementBytesPtr value)
    : tag_(Tag::kBytes),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBytes)>,
            std::move(value)) {}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    DataElementFilePtr value)
    : tag_(Tag::kFile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFile)>,
            std::move(value)) {}

DataElement::DataElement(
    std::in_place_index_t<static_cast<size_t>(Tag::kBlob)>,
    DataElementBlobPtr value)
    : tag_(Tag::kBlob),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBlob)>,
            std::move(value)) {}
DataElement::~DataElement() {
  DestroyActive();
}

void DataElement::set_bytes(DataElementBytesPtr bytes) {
  if (tag_ == Tag::kBytes) {
    data_.bytes = std::move(bytes);
  } else {
    DestroyActive();
    tag_ = Tag::kBytes;
    new (&data_.bytes) DataElementBytesPtr(
        std::move(bytes));
  }
}

void DataElement::set_file(DataElementFilePtr file) {
  if (tag_ == Tag::kFile) {
    data_.file = std::move(file);
  } else {
    DestroyActive();
    tag_ = Tag::kFile;
    new (&data_.file) DataElementFilePtr(
        std::move(file));
  }
}

void DataElement::set_blob(DataElementBlobPtr blob) {
  if (tag_ == Tag::kBlob) {
    data_.blob = std::move(blob);
  } else {
    DestroyActive();
    tag_ = Tag::kBlob;
    new (&data_.blob) DataElementBlobPtr(
        std::move(blob));
  }
}


DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBytes)>,
    DataElementBytesPtr value)
    : bytes(std::move(value)) {}

DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
    DataElementFilePtr value)
    : file(std::move(value)) {}

DataElement::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBlob)>,
    DataElementBlobPtr value)
    : blob(std::move(value)) {}

void DataElement::DestroyActive() {
  switch (tag_) {

    case Tag::kBytes:
      std::destroy_at(&data_.bytes);
      break;
    case Tag::kFile:
      std::destroy_at(&data_.file);
      break;
    case Tag::kBlob:
      std::destroy_at(&data_.blob);
      break;
  }
}

bool DataElement::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

BytesProvider::IPCStableHashFunction BytesProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BytesProvider>(message.name())) {
    case messages::BytesProvider::kRequestAsReply: {
      return &BytesProvider::RequestAsReply_Sym::IPCStableHash;
    }
    case messages::BytesProvider::kRequestAsStream: {
      return &BytesProvider::RequestAsStream_Sym::IPCStableHash;
    }
    case messages::BytesProvider::kRequestAsFile: {
      return &BytesProvider::RequestAsFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BytesProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BytesProvider>(message.name())) {
      case messages::BytesProvider::kRequestAsReply:
            return "Receive blink::mojom::BytesProvider::RequestAsReply";
      case messages::BytesProvider::kRequestAsStream:
            return "Receive blink::mojom::BytesProvider::RequestAsStream";
      case messages::BytesProvider::kRequestAsFile:
            return "Receive blink::mojom::BytesProvider::RequestAsFile";
    }
  } else {
    switch (static_cast<messages::BytesProvider>(message.name())) {
      case messages::BytesProvider::kRequestAsReply:
            return "Receive reply blink::mojom::BytesProvider::RequestAsReply";
      case messages::BytesProvider::kRequestAsStream:
            return "Receive reply blink::mojom::BytesProvider::RequestAsStream";
      case messages::BytesProvider::kRequestAsFile:
            return "Receive reply blink::mojom::BytesProvider::RequestAsFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BytesProvider::RequestAsReply_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff5bba46;  // IPCStableHash for blink::mojom::BytesProvider::RequestAsReply
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BytesProvider::RequestAsStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x45b662ff;  // IPCStableHash for blink::mojom::BytesProvider::RequestAsStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BytesProvider::RequestAsFile_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x33dac1f4;  // IPCStableHash for blink::mojom::BytesProvider::RequestAsFile
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BytesProvider_RequestAsReply_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BytesProvider_RequestAsReply_ForwardToCallback(
      BytesProvider::RequestAsReplyCallback callback
      ) : callback_(std::move(callback)) {
  }

  BytesProvider_RequestAsReply_ForwardToCallback(const BytesProvider_RequestAsReply_ForwardToCallback&) = delete;
  BytesProvider_RequestAsReply_ForwardToCallback& operator=(const BytesProvider_RequestAsReply_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BytesProvider::RequestAsReplyCallback callback_;
};

class BytesProvider_RequestAsFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BytesProvider_RequestAsFile_ForwardToCallback(
      BytesProvider::RequestAsFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  BytesProvider_RequestAsFile_ForwardToCallback(const BytesProvider_RequestAsFile_ForwardToCallback&) = delete;
  BytesProvider_RequestAsFile_ForwardToCallback& operator=(const BytesProvider_RequestAsFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BytesProvider::RequestAsFileCallback callback_;
};

BytesProviderProxy::BytesProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BytesProviderProxy::RequestAsReply(
    RequestAsReplyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BytesProvider::RequestAsReply");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BytesProvider::kRequestAsReply), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BytesProvider_RequestAsReply_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BytesProvider::Name_);
  message.set_method_name("RequestAsReply");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BytesProvider_RequestAsReply_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BytesProviderProxy::RequestAsStream(
    ::mojo::ScopedDataPipeProducerHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BytesProvider::RequestAsStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BytesProvider::kRequestAsStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BytesProvider_RequestAsStream_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
    in_pipe,
    &params->pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid pipe in BytesProvider.RequestAsStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BytesProvider::Name_);
  message.set_method_name("RequestAsStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BytesProviderProxy::RequestAsFile(
    uint64_t in_source_offset, uint64_t in_source_size, ::base::File in_file, uint64_t in_file_offset, RequestAsFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BytesProvider::RequestAsFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_offset"), in_source_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_size"), in_source_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file_offset"), in_file_offset,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BytesProvider::kRequestAsFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BytesProvider_RequestAsFile_Params_Data> params(
          message);
  params.Allocate();

  params->source_offset = in_source_offset;

  params->source_size = in_source_size;
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_file,
    file_fragment);

  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null file in BytesProvider.RequestAsFile request");

  params->file_offset = in_file_offset;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BytesProvider::Name_);
  message.set_method_name("RequestAsFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BytesProvider_RequestAsFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BytesProvider_RequestAsReply_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BytesProvider::RequestAsReplyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BytesProvider_RequestAsReply_ProxyToResponder> proxy(
        new BytesProvider_RequestAsReply_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BytesProvider_RequestAsReply_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BytesProvider_RequestAsReply_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BytesProvider_RequestAsReply_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BytesProvider::RequestAsReplyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_data);
};

bool BytesProvider_RequestAsReply_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BytesProvider_RequestAsReply_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BytesProvider_RequestAsReply_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BytesProvider.0
  bool success = true;
  std::vector<uint8_t> p_data{};
  BytesProvider_RequestAsReply_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BytesProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void BytesProvider_RequestAsReply_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BytesProvider::RequestAsReply", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BytesProvider::kRequestAsReply), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BytesProvider_RequestAsReply_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BytesProvider::Name_);
  message.set_method_name("RequestAsReply");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BytesProvider_RequestAsFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BytesProvider::RequestAsFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BytesProvider_RequestAsFile_ProxyToResponder> proxy(
        new BytesProvider_RequestAsFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BytesProvider_RequestAsFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BytesProvider_RequestAsFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BytesProvider_RequestAsFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BytesProvider::RequestAsFileCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::base::Time> in_time_file_modified);
};

bool BytesProvider_RequestAsFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BytesProvider_RequestAsFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BytesProvider_RequestAsFile_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BytesProvider.2
  bool success = true;
  std::optional<::base::Time> p_time_file_modified{};
  BytesProvider_RequestAsFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTimeFileModified(&p_time_file_modified))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BytesProvider::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_time_file_modified));
  }
  return true;
}

void BytesProvider_RequestAsFile_ProxyToResponder::Run(
    std::optional<::base::Time> in_time_file_modified) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BytesProvider::RequestAsFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time_file_modified"), in_time_file_modified,
                        "<value of type std::optional<::base::Time>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BytesProvider::kRequestAsFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BytesProvider_RequestAsFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time_file_modified)::BaseType> time_file_modified_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_time_file_modified,
    time_file_modified_fragment);

  params->time_file_modified.Set(
      time_file_modified_fragment.is_null() ? nullptr : time_file_modified_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BytesProvider::Name_);
  message.set_method_name("RequestAsFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BytesProviderStubDispatch::Accept(
    BytesProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BytesProvider>(message->header()->name)) {
    case messages::BytesProvider::kRequestAsReply: {
      break;
    }
    case messages::BytesProvider::kRequestAsStream: {
      DCHECK(message->is_serialized());
      internal::BytesProvider_RequestAsStream_Params_Data* params =
          reinterpret_cast<internal::BytesProvider_RequestAsStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BytesProvider.1
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      BytesProvider_RequestAsStream_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BytesProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAsStream(        
        std::move(p_pipe));
      return true;
    }
    case messages::BytesProvider::kRequestAsFile: {
      break;
    }
  }
  return false;
}

// static
bool BytesProviderStubDispatch::AcceptWithResponder(
    BytesProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BytesProvider>(message->header()->name)) {
    case messages::BytesProvider::kRequestAsReply: {
      internal::BytesProvider_RequestAsReply_Params_Data* params =
          reinterpret_cast<
              internal::BytesProvider_RequestAsReply_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BytesProvider.0
      bool success = true;
      BytesProvider_RequestAsReply_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BytesProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          BytesProvider_RequestAsReply_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAsReply(std::move(callback));
      return true;
    }
    case messages::BytesProvider::kRequestAsStream: {
      break;
    }
    case messages::BytesProvider::kRequestAsFile: {
      internal::BytesProvider_RequestAsFile_Params_Data* params =
          reinterpret_cast<
              internal::BytesProvider_RequestAsFile_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BytesProvider.2
      bool success = true;
      uint64_t p_source_offset{};
      uint64_t p_source_size{};
      ::base::File p_file{};
      uint64_t p_file_offset{};
      BytesProvider_RequestAsFile_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_source_offset = input_data_view.source_offset();
      if (success)
        p_source_size = input_data_view.source_size();
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (success)
        p_file_offset = input_data_view.file_offset();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BytesProvider::Name_, 2, false);
        return false;
      }
      auto callback =
          BytesProvider_RequestAsFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestAsFile(        
        std::move(p_source_offset), 
        std::move(p_source_size), 
        std::move(p_file), 
        std::move(p_file_offset), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBytesProviderValidationInfo[] = {
    { &internal::BytesProvider_RequestAsReply_Params_Data::Validate,
     &internal::BytesProvider_RequestAsReply_ResponseParams_Data::Validate},
    { &internal::BytesProvider_RequestAsStream_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BytesProvider_RequestAsFile_Params_Data::Validate,
     &internal::BytesProvider_RequestAsFile_ResponseParams_Data::Validate},
};

bool BytesProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::BytesProvider::Name_,
    kBytesProviderValidationInfo);
}

bool BytesProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::BytesProvider::Name_,
    kBytesProviderValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::DataElementBytes::DataView, ::blink::mojom::DataElementBytesPtr>::Read(
    ::blink::mojom::DataElementBytes::DataView input,
    ::blink::mojom::DataElementBytesPtr* output) {
  bool success = true;
  ::blink::mojom::DataElementBytesPtr result(::blink::mojom::DataElementBytes::New());
  
      if (success)
        result->length = input.length();
      if (success && !input.ReadEmbeddedData(&result->embedded_data))
        success = false;
      if (success) {
        result->data =
            input.TakeData<decltype(result->data)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DataElementFile::DataView, ::blink::mojom::DataElementFilePtr>::Read(
    ::blink::mojom::DataElementFile::DataView input,
    ::blink::mojom::DataElementFilePtr* output) {
  bool success = true;
  ::blink::mojom::DataElementFilePtr result(::blink::mojom::DataElementFile::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
      if (success && !input.ReadExpectedModificationTime(&result->expected_modification_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::DataElementBlob::DataView, ::blink::mojom::DataElementBlobPtr>::Read(
    ::blink::mojom::DataElementBlob::DataView input,
    ::blink::mojom::DataElementBlobPtr* output) {
  bool success = true;
  ::blink::mojom::DataElementBlobPtr result(::blink::mojom::DataElementBlob::New());
  
      if (success) {
        result->blob =
            input.TakeBlob<decltype(result->blob)>();
      }
      if (success)
        result->offset = input.offset();
      if (success)
        result->length = input.length();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::DataElement::DataView, ::blink::mojom::DataElementPtr>::Read(
    ::blink::mojom::DataElement::DataView input,
    ::blink::mojom::DataElementPtr* output) {
  using UnionType = ::blink::mojom::DataElement;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kBytes: {
      ::blink::mojom::DataElementBytesPtr result_bytes{};
      if (!input.ReadBytes(&result_bytes))
        return false;

      *output = UnionType::NewBytes(
          std::move(result_bytes));
      break;
    }
    case Tag::kFile: {
      ::blink::mojom::DataElementFilePtr result_file{};
      if (!input.ReadFile(&result_file))
        return false;

      *output = UnionType::NewFile(
          std::move(result_file));
      break;
    }
    case Tag::kBlob: {
      ::blink::mojom::DataElementBlobPtr result_blob{};
      if (!input.ReadBlob(&result_blob))
        return false;

      *output = UnionType::NewBlob(
          std::move(result_blob));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BytesProviderInterceptorForTesting::RequestAsReply(RequestAsReplyCallback callback) {
  GetForwardingInterface()->RequestAsReply(std::move(callback));
}
void BytesProviderInterceptorForTesting::RequestAsStream(::mojo::ScopedDataPipeProducerHandle pipe) {
  GetForwardingInterface()->RequestAsStream(
    std::move(pipe)
    );
}
void BytesProviderInterceptorForTesting::RequestAsFile(uint64_t source_offset, uint64_t source_size, ::base::File file, uint64_t file_offset, RequestAsFileCallback callback) {
  GetForwardingInterface()->RequestAsFile(
    std::move(source_offset)
    , 
    std::move(source_size)
    , 
    std::move(file)
    , 
    std::move(file_offset)
    , std::move(callback));
}
BytesProviderAsyncWaiter::BytesProviderAsyncWaiter(
    BytesProvider* proxy) : proxy_(proxy) {}

BytesProviderAsyncWaiter::~BytesProviderAsyncWaiter() = default;


void BytesProviderAsyncWaiter::RequestAsReply(
    std::vector<uint8_t>* out_data) {
  base::RunLoop loop;
  proxy_->RequestAsReply(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_data
,
             const std::vector<uint8_t>& data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::vector<uint8_t> BytesProviderAsyncWaiter::RequestAsReply(
    ) {
  std::vector<uint8_t> async_wait_result;
  RequestAsReply(&async_wait_result);
  return async_wait_result;
}

void BytesProviderAsyncWaiter::RequestAsFile(
    uint64_t source_offset, uint64_t source_size, ::base::File file, uint64_t file_offset, std::optional<::base::Time>* out_time_file_modified) {
  base::RunLoop loop;
  proxy_->RequestAsFile(
      std::move(source_offset),
      std::move(source_size),
      std::move(file),
      std::move(file_offset),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::Time>* out_time_file_modified
,
             std::optional<::base::Time> time_file_modified) {*out_time_file_modified = std::move(time_file_modified);
            loop->Quit();
          },
          &loop,
          out_time_file_modified));
  loop.Run();
}

std::optional<::base::Time> BytesProviderAsyncWaiter::RequestAsFile(
    uint64_t source_offset, uint64_t source_size, ::base::File file, uint64_t file_offset) {
  std::optional<::base::Time> async_wait_result;
  RequestAsFile(std::move(source_offset),std::move(source_size),std::move(file),std::move(file_offset),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif