// third_party/blink/public/mojom/blob/blob_registry.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BlobRemote as blink_mojom_BlobRemote,
  BlobPendingReceiver as blink_mojom_BlobPendingReceiver
} from './blob.mojom.m.js';

import {
  DataElement as blink_mojom_DataElement,
  DataElementSpec as blink_mojom_DataElementSpec
} from './data_element.mojom.m.js';

import {
  SerializedBlob as blink_mojom_SerializedBlob,
  SerializedBlobSpec as blink_mojom_SerializedBlobSpec
} from './serialized_blob.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProgressClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ProgressClient', scope);
  }
}

/** @interface */
export class ProgressClientInterface {
  
  /**
   * @param { !bigint } delta
   */

  onProgress(delta) {}
}

/**
 * @implements { ProgressClientInterface }
 */
export class ProgressClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProgressClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProgressClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProgressClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } delta
   */

  onProgress(
      delta) {
    this.proxy.sendMessage(
        0,
        ProgressClient_OnProgress_ParamsSpec.$,
        null,
        [
          delta
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProgressClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProgressClientReceiver {
  /**
   * @param {!ProgressClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProgressClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProgressClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProgressClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProgressClient_OnProgress_ParamsSpec.$,
        null,
        impl.onProgress.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProgressClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ProgressClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProgressClientRemote}
   */
  static getRemote() {
    let remote = new ProgressClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProgressClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProgressClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProgressClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProgressClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProgress =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProgressClient_OnProgress_ParamsSpec.$,
        null,
        this.onProgress.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class BlobRegistryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.BlobRegistry', scope);
  }
}

/** @interface */
export class BlobRegistryInterface {
  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !string } contentDisposition
   * @param { !Array<!blink_mojom_DataElement> } elements
   * @return {!Promise}
   */

  register(blob, uuid, contentType, contentDisposition, elements) {}
  
  /**
   * @param { !string } contentType
   * @param { !string } contentDisposition
   * @param { !bigint } lengthHint
   * @param { !MojoHandle } data
   * @param { ?Object } progressClient
   * @return {!Promise<{
        blob: ?blink_mojom_SerializedBlob,
   *  }>}
   */

  registerFromStream(contentType, contentDisposition, lengthHint, data, progressClient) {}
}

/**
 * @implements { BlobRegistryInterface }
 */
export class BlobRegistryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!BlobRegistryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          BlobRegistryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!BlobRegistryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_BlobPendingReceiver } blob
   * @param { !string } uuid
   * @param { !string } contentType
   * @param { !string } contentDisposition
   * @param { !Array<!blink_mojom_DataElement> } elements
   * @return {!Promise}
   */

  register(
      blob,
      uuid,
      contentType,
      contentDisposition,
      elements) {
    return this.proxy.sendMessage(
        0,
        BlobRegistry_Register_ParamsSpec.$,
        BlobRegistry_Register_ResponseParamsSpec.$,
        [
          blob,
          uuid,
          contentType,
          contentDisposition,
          elements
        ],
        false);
  }

  
  /**
   * @param { !string } contentType
   * @param { !string } contentDisposition
   * @param { !bigint } lengthHint
   * @param { !MojoHandle } data
   * @param { ?Object } progressClient
   * @return {!Promise<{
        blob: ?blink_mojom_SerializedBlob,
   *  }>}
   */

  registerFromStream(
      contentType,
      contentDisposition,
      lengthHint,
      data,
      progressClient) {
    return this.proxy.sendMessage(
        1,
        BlobRegistry_RegisterFromStream_ParamsSpec.$,
        BlobRegistry_RegisterFromStream_ResponseParamsSpec.$,
        [
          contentType,
          contentDisposition,
          lengthHint,
          data,
          progressClient
        ],
        false);
  }
}

/**
 * An object which receives request messages for the BlobRegistry
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BlobRegistryReceiver {
  /**
   * @param {!BlobRegistryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!BlobRegistryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        BlobRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        BlobRegistry_Register_ParamsSpec.$,
        BlobRegistry_Register_ResponseParamsSpec.$,
        impl.register.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        BlobRegistry_RegisterFromStream_ParamsSpec.$,
        BlobRegistry_RegisterFromStream_ResponseParamsSpec.$,
        impl.registerFromStream.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class BlobRegistry {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.BlobRegistry";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!BlobRegistryRemote}
   */
  static getRemote() {
    let remote = new BlobRegistryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the BlobRegistry
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BlobRegistryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      BlobRegistryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!BlobRegistryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.register =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        BlobRegistry_Register_ParamsSpec.$,
        BlobRegistry_Register_ResponseParamsSpec.$,
        this.register.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerFromStream =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        BlobRegistry_RegisterFromStream_ParamsSpec.$,
        BlobRegistry_RegisterFromStream_ResponseParamsSpec.$,
        this.registerFromStream.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProgressClient_OnProgress_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobRegistry_Register_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobRegistry_Register_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobRegistry_RegisterFromStream_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const BlobRegistry_RegisterFromStream_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProgressClient_OnProgress_ParamsSpec.$,
    'ProgressClient_OnProgress_Params',
    [
      mojo.internal.StructField(
        'delta', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProgressClient_OnProgress_Params {
  constructor() {
    /** @type { !bigint } */
    this.delta;
  }
}



mojo.internal.Struct(
    BlobRegistry_Register_ParamsSpec.$,
    'BlobRegistry_Register_Params',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_BlobPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'uuid', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentType', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentDisposition', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'elements', 32,
        0,
        mojo.internal.Array(blink_mojom_DataElementSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class BlobRegistry_Register_Params {
  constructor() {
    /** @type { !blink_mojom_BlobPendingReceiver } */
    this.blob;
    /** @type { !string } */
    this.uuid;
    /** @type { !string } */
    this.contentType;
    /** @type { !string } */
    this.contentDisposition;
    /** @type { !Array<!blink_mojom_DataElement> } */
    this.elements;
  }
}



mojo.internal.Struct(
    BlobRegistry_Register_ResponseParamsSpec.$,
    'BlobRegistry_Register_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class BlobRegistry_Register_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    BlobRegistry_RegisterFromStream_ParamsSpec.$,
    'BlobRegistry_RegisterFromStream_Params',
    [
      mojo.internal.StructField(
        'contentType', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentDisposition', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lengthHint', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 24,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'progressClient', 28,
        0,
        mojo.internal.AssociatedInterfaceProxy(ProgressClientRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class BlobRegistry_RegisterFromStream_Params {
  constructor() {
    /** @type { !string } */
    this.contentType;
    /** @type { !string } */
    this.contentDisposition;
    /** @type { !bigint } */
    this.lengthHint;
    /** @type { !MojoHandle } */
    this.data;
    /** @type { (Object|undefined) } */
    this.progressClient;
  }
}



mojo.internal.Struct(
    BlobRegistry_RegisterFromStream_ResponseParamsSpec.$,
    'BlobRegistry_RegisterFromStream_ResponseParams',
    [
      mojo.internal.StructField(
        'blob', 0,
        0,
        blink_mojom_SerializedBlobSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class BlobRegistry_RegisterFromStream_ResponseParams {
  constructor() {
    /** @type { (blink_mojom_SerializedBlob|undefined) } */
    this.blob;
  }
}

