// third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/background_fetch/background_fetch.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-blink.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class BackgroundFetchRegistrationObserverProxy;

template <typename ImplRefTraits>
class BackgroundFetchRegistrationObserverStub;

class BackgroundFetchRegistrationObserverRequestValidator;


class PLATFORM_EXPORT BackgroundFetchRegistrationObserver
    : public BackgroundFetchRegistrationObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BackgroundFetchRegistrationObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundFetchRegistrationObserverInterfaceBase;
  using Proxy_ = BackgroundFetchRegistrationObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundFetchRegistrationObserverStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundFetchRegistrationObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnProgressMinVersion = 0,
    kOnRecordsUnavailableMinVersion = 0,
    kOnRequestCompletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnProgress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRecordsUnavailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRequestCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundFetchRegistrationObserver() = default;

  virtual void OnProgress(uint64_t upload_total, uint64_t uploaded, uint64_t download_total, uint64_t downloaded, BackgroundFetchResult result, BackgroundFetchFailureReason failure_reason) = 0;

  virtual void OnRecordsUnavailable() = 0;

  virtual void OnRequestCompleted(::blink::mojom::blink::FetchAPIRequestPtr request, ::blink::mojom::blink::FetchAPIResponsePtr response) = 0;
};

class BackgroundFetchServiceProxy;

template <typename ImplRefTraits>
class BackgroundFetchServiceStub;

class BackgroundFetchServiceRequestValidator;
class BackgroundFetchServiceResponseValidator;


class PLATFORM_EXPORT BackgroundFetchService
    : public BackgroundFetchServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BackgroundFetchService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundFetchServiceInterfaceBase;
  using Proxy_ = BackgroundFetchServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundFetchServiceStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundFetchServiceRequestValidator;
  using ResponseValidator_ = BackgroundFetchServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFetchMinVersion = 0,
    kGetRegistrationMinVersion = 0,
    kGetDeveloperIdsMinVersion = 0,
    kGetIconDisplaySizeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Fetch_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetRegistration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeveloperIds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIconDisplaySize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundFetchService() = default;

  using FetchCallback = base::OnceCallback<void(BackgroundFetchError, BackgroundFetchRegistrationPtr)>;
  using FetchMojoCallback = base::OnceCallback<void(BackgroundFetchError, BackgroundFetchRegistrationPtr)>;

  virtual void Fetch(int64_t service_worker_registration_id, const ::blink::String& developer_id, ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> requests, BackgroundFetchOptionsPtr options, const ::SkBitmap& icon, BackgroundFetchUkmDataPtr ukm_data, FetchCallback callback) = 0;

  using GetRegistrationCallback = base::OnceCallback<void(BackgroundFetchError, BackgroundFetchRegistrationPtr)>;
  using GetRegistrationMojoCallback = base::OnceCallback<void(BackgroundFetchError, BackgroundFetchRegistrationPtr)>;

  virtual void GetRegistration(int64_t service_worker_registration_id, const ::blink::String& developer_id, GetRegistrationCallback callback) = 0;

  using GetDeveloperIdsCallback = base::OnceCallback<void(BackgroundFetchError, const ::blink::Vector<::blink::String>&)>;
  using GetDeveloperIdsMojoCallback = base::OnceCallback<void(BackgroundFetchError, const ::blink::Vector<::blink::String>&)>;

  virtual void GetDeveloperIds(int64_t service_worker_registration_id, GetDeveloperIdsCallback callback) = 0;

  using GetIconDisplaySizeCallback = base::OnceCallback<void(const ::gfx::Size&)>;
  using GetIconDisplaySizeMojoCallback = base::OnceCallback<void(const ::gfx::Size&)>;

  virtual void GetIconDisplaySize(GetIconDisplaySizeCallback callback) = 0;
};

class BackgroundFetchRegistrationServiceProxy;

template <typename ImplRefTraits>
class BackgroundFetchRegistrationServiceStub;

class BackgroundFetchRegistrationServiceRequestValidator;
class BackgroundFetchRegistrationServiceResponseValidator;


class PLATFORM_EXPORT BackgroundFetchRegistrationService
    : public BackgroundFetchRegistrationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BackgroundFetchRegistrationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackgroundFetchRegistrationServiceInterfaceBase;
  using Proxy_ = BackgroundFetchRegistrationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundFetchRegistrationServiceStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundFetchRegistrationServiceRequestValidator;
  using ResponseValidator_ = BackgroundFetchRegistrationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdateUIMinVersion = 0,
    kAbortMinVersion = 0,
    kMatchRequestsMinVersion = 0,
    kAddRegistrationObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MatchRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddRegistrationObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackgroundFetchRegistrationService() = default;

  using UpdateUICallback = base::OnceCallback<void(BackgroundFetchError)>;
  using UpdateUIMojoCallback = base::OnceCallback<void(BackgroundFetchError)>;

  virtual void UpdateUI(const ::blink::String& title, const ::SkBitmap& icon, UpdateUICallback callback) = 0;

  using AbortCallback = base::OnceCallback<void(BackgroundFetchError)>;
  using AbortMojoCallback = base::OnceCallback<void(BackgroundFetchError)>;

  virtual void Abort(AbortCallback callback) = 0;

  using MatchRequestsCallback = base::OnceCallback<void(::blink::Vector<BackgroundFetchSettledFetchPtr>)>;
  using MatchRequestsMojoCallback = base::OnceCallback<void(::blink::Vector<BackgroundFetchSettledFetchPtr>)>;

  virtual void MatchRequests(::blink::mojom::blink::FetchAPIRequestPtr request_to_match, ::blink::mojom::blink::CacheQueryOptionsPtr cache_query_options, bool match_all, MatchRequestsCallback callback) = 0;

  virtual void AddRegistrationObserver(::mojo::PendingRemote<BackgroundFetchRegistrationObserver> observer) = 0;
};



class PLATFORM_EXPORT BackgroundFetchRegistrationObserverProxy
    : public BackgroundFetchRegistrationObserver {
 public:
  using InterfaceType = BackgroundFetchRegistrationObserver;

  explicit BackgroundFetchRegistrationObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnProgress(uint64_t upload_total, uint64_t uploaded, uint64_t download_total, uint64_t downloaded, BackgroundFetchResult result, BackgroundFetchFailureReason failure_reason) final;
  
  void OnRecordsUnavailable() final;
  
  void OnRequestCompleted(::blink::mojom::blink::FetchAPIRequestPtr request, ::blink::mojom::blink::FetchAPIResponsePtr response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT BackgroundFetchServiceProxy
    : public BackgroundFetchService {
 public:
  using InterfaceType = BackgroundFetchService;

  explicit BackgroundFetchServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Fetch(int64_t service_worker_registration_id, const ::blink::String& developer_id, ::blink::Vector<::blink::mojom::blink::FetchAPIRequestPtr> requests, BackgroundFetchOptionsPtr options, const ::SkBitmap& icon, BackgroundFetchUkmDataPtr ukm_data, FetchCallback callback) final;
  
  void GetRegistration(int64_t service_worker_registration_id, const ::blink::String& developer_id, GetRegistrationCallback callback) final;
  
  void GetDeveloperIds(int64_t service_worker_registration_id, GetDeveloperIdsCallback callback) final;
  
  void GetIconDisplaySize(GetIconDisplaySizeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT BackgroundFetchRegistrationServiceProxy
    : public BackgroundFetchRegistrationService {
 public:
  using InterfaceType = BackgroundFetchRegistrationService;

  explicit BackgroundFetchRegistrationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateUI(const ::blink::String& title, const ::SkBitmap& icon, UpdateUICallback callback) final;
  
  void Abort(AbortCallback callback) final;
  
  void MatchRequests(::blink::mojom::blink::FetchAPIRequestPtr request_to_match, ::blink::mojom::blink::CacheQueryOptionsPtr cache_query_options, bool match_all, MatchRequestsCallback callback) final;
  
  void AddRegistrationObserver(::mojo::PendingRemote<BackgroundFetchRegistrationObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT BackgroundFetchRegistrationObserverStubDispatch {
 public:
  static bool Accept(BackgroundFetchRegistrationObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundFetchRegistrationObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundFetchRegistrationObserver>>
class BackgroundFetchRegistrationObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundFetchRegistrationObserverStub() = default;
  ~BackgroundFetchRegistrationObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchRegistrationObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchRegistrationObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BackgroundFetchServiceStubDispatch {
 public:
  static bool Accept(BackgroundFetchService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundFetchService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundFetchService>>
class BackgroundFetchServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundFetchServiceStub() = default;
  ~BackgroundFetchServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BackgroundFetchRegistrationServiceStubDispatch {
 public:
  static bool Accept(BackgroundFetchRegistrationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundFetchRegistrationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundFetchRegistrationService>>
class BackgroundFetchRegistrationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundFetchRegistrationServiceStub() = default;
  ~BackgroundFetchRegistrationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchRegistrationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundFetchRegistrationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT BackgroundFetchRegistrationObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BackgroundFetchServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BackgroundFetchRegistrationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BackgroundFetchServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT BackgroundFetchRegistrationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT BackgroundFetchUkmData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundFetchUkmData, T>::value>;
  using DataView = BackgroundFetchUkmDataDataView;
  using Data_ = internal::BackgroundFetchUkmData_Data;

  template <typename... Args>
  static BackgroundFetchUkmDataPtr New(Args&&... args) {
    return BackgroundFetchUkmDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundFetchUkmDataPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundFetchUkmDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundFetchUkmData>::Convert(*this);
  }


  BackgroundFetchUkmData();

  explicit BackgroundFetchUkmData(
      int64_t ideal_to_chosen_icon_size);


  ~BackgroundFetchUkmData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundFetchUkmDataPtr>
  BackgroundFetchUkmDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchUkmData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchUkmData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundFetchUkmData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundFetchUkmData_UnserializedMessageContext<
            UserType, BackgroundFetchUkmData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundFetchUkmData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundFetchUkmData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundFetchUkmData_UnserializedMessageContext<
            UserType, BackgroundFetchUkmData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundFetchUkmData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t ideal_to_chosen_icon_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundFetchUkmData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT BackgroundFetchSettledFetch {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundFetchSettledFetch, T>::value>;
  using DataView = BackgroundFetchSettledFetchDataView;
  using Data_ = internal::BackgroundFetchSettledFetch_Data;

  template <typename... Args>
  static BackgroundFetchSettledFetchPtr New(Args&&... args) {
    return BackgroundFetchSettledFetchPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundFetchSettledFetchPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundFetchSettledFetchPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundFetchSettledFetch>::Convert(*this);
  }


  BackgroundFetchSettledFetch();

  BackgroundFetchSettledFetch(
      ::blink::mojom::blink::FetchAPIRequestPtr request,
      ::blink::mojom::blink::FetchAPIResponsePtr response);

BackgroundFetchSettledFetch(const BackgroundFetchSettledFetch&) = delete;
BackgroundFetchSettledFetch& operator=(const BackgroundFetchSettledFetch&) = delete;

  ~BackgroundFetchSettledFetch();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundFetchSettledFetchPtr>
  BackgroundFetchSettledFetchPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundFetchSettledFetch::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundFetchSettledFetch_UnserializedMessageContext<
            UserType, BackgroundFetchSettledFetch::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundFetchSettledFetch::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundFetchSettledFetch::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundFetchSettledFetch_UnserializedMessageContext<
            UserType, BackgroundFetchSettledFetch::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundFetchSettledFetch::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::blink::FetchAPIRequestPtr request;
  
  ::blink::mojom::blink::FetchAPIResponsePtr response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT BackgroundFetchOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundFetchOptions, T>::value>;
  using DataView = BackgroundFetchOptionsDataView;
  using Data_ = internal::BackgroundFetchOptions_Data;

  template <typename... Args>
  static BackgroundFetchOptionsPtr New(Args&&... args) {
    return BackgroundFetchOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundFetchOptionsPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundFetchOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundFetchOptions>::Convert(*this);
  }


  BackgroundFetchOptions();

  BackgroundFetchOptions(
      ::blink::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons,
      uint64_t download_total,
      const ::blink::String& title);

BackgroundFetchOptions(const BackgroundFetchOptions&) = delete;
BackgroundFetchOptions& operator=(const BackgroundFetchOptions&) = delete;

  ~BackgroundFetchOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundFetchOptionsPtr>
  BackgroundFetchOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundFetchOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundFetchOptions_UnserializedMessageContext<
            UserType, BackgroundFetchOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundFetchOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundFetchOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundFetchOptions_UnserializedMessageContext<
            UserType, BackgroundFetchOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundFetchOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::mojom::blink::ManifestImageResourcePtr> icons;
  
  uint64_t download_total;
  
  ::blink::String title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundFetchOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT BackgroundFetchRegistrationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundFetchRegistrationData, T>::value>;
  using DataView = BackgroundFetchRegistrationDataDataView;
  using Data_ = internal::BackgroundFetchRegistrationData_Data;

  template <typename... Args>
  static BackgroundFetchRegistrationDataPtr New(Args&&... args) {
    return BackgroundFetchRegistrationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundFetchRegistrationDataPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundFetchRegistrationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundFetchRegistrationData>::Convert(*this);
  }


  BackgroundFetchRegistrationData();

  BackgroundFetchRegistrationData(
      const ::blink::String& developer_id,
      uint64_t upload_total,
      uint64_t uploaded,
      uint64_t download_total,
      uint64_t downloaded,
      BackgroundFetchResult result,
      BackgroundFetchFailureReason failure_reason);


  ~BackgroundFetchRegistrationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundFetchRegistrationDataPtr>
  BackgroundFetchRegistrationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchRegistrationData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundFetchRegistrationData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundFetchRegistrationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundFetchRegistrationData_UnserializedMessageContext<
            UserType, BackgroundFetchRegistrationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundFetchRegistrationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundFetchRegistrationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundFetchRegistrationData_UnserializedMessageContext<
            UserType, BackgroundFetchRegistrationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundFetchRegistrationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String developer_id;
  
  uint64_t upload_total;
  
  uint64_t uploaded;
  
  uint64_t download_total;
  
  uint64_t downloaded;
  
  BackgroundFetchResult result;
  
  BackgroundFetchFailureReason failure_reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT BackgroundFetchRegistration {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundFetchRegistration, T>::value>;
  using DataView = BackgroundFetchRegistrationDataView;
  using Data_ = internal::BackgroundFetchRegistration_Data;

  template <typename... Args>
  static BackgroundFetchRegistrationPtr New(Args&&... args) {
    return BackgroundFetchRegistrationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundFetchRegistrationPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundFetchRegistrationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundFetchRegistration>::Convert(*this);
  }


  BackgroundFetchRegistration();

  BackgroundFetchRegistration(
      BackgroundFetchRegistrationDataPtr registration_data,
      ::mojo::PendingRemote<BackgroundFetchRegistrationService> registration_interface);

BackgroundFetchRegistration(const BackgroundFetchRegistration&) = delete;
BackgroundFetchRegistration& operator=(const BackgroundFetchRegistration&) = delete;

  ~BackgroundFetchRegistration();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundFetchRegistrationPtr>
  BackgroundFetchRegistrationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundFetchRegistration::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundFetchRegistration_UnserializedMessageContext<
            UserType, BackgroundFetchRegistration::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundFetchRegistration::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundFetchRegistration::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundFetchRegistration_UnserializedMessageContext<
            UserType, BackgroundFetchRegistration::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundFetchRegistration::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BackgroundFetchRegistrationDataPtr registration_data;
  
  ::mojo::PendingRemote<BackgroundFetchRegistrationService> registration_interface;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundFetchRegistration::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
BackgroundFetchSettledFetchPtr BackgroundFetchSettledFetch::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(response)
  );
}

template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>*>
bool BackgroundFetchSettledFetch::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  return true;
}

template <typename T, BackgroundFetchSettledFetch::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.request < rhs.request)
    return true;
  if (rhs.request < lhs.request)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundFetchOptionsPtr BackgroundFetchOptions::Clone() const {
  return New(
      mojo::Clone(icons),
      mojo::Clone(download_total),
      mojo::Clone(title)
  );
}

template <typename T, BackgroundFetchOptions::EnableIfSame<T>*>
bool BackgroundFetchOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  if (!mojo::Equals(this->download_total, other_struct.download_total))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, BackgroundFetchOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  if (lhs.download_total < rhs.download_total)
    return true;
  if (rhs.download_total < lhs.download_total)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundFetchRegistrationDataPtr BackgroundFetchRegistrationData::Clone() const {
  return New(
      mojo::Clone(developer_id),
      mojo::Clone(upload_total),
      mojo::Clone(uploaded),
      mojo::Clone(download_total),
      mojo::Clone(downloaded),
      mojo::Clone(result),
      mojo::Clone(failure_reason)
  );
}

template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>*>
bool BackgroundFetchRegistrationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->developer_id, other_struct.developer_id))
    return false;
  if (!mojo::Equals(this->upload_total, other_struct.upload_total))
    return false;
  if (!mojo::Equals(this->uploaded, other_struct.uploaded))
    return false;
  if (!mojo::Equals(this->download_total, other_struct.download_total))
    return false;
  if (!mojo::Equals(this->downloaded, other_struct.downloaded))
    return false;
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  if (!mojo::Equals(this->failure_reason, other_struct.failure_reason))
    return false;
  return true;
}

template <typename T, BackgroundFetchRegistrationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.developer_id < rhs.developer_id)
    return true;
  if (rhs.developer_id < lhs.developer_id)
    return false;
  if (lhs.upload_total < rhs.upload_total)
    return true;
  if (rhs.upload_total < lhs.upload_total)
    return false;
  if (lhs.uploaded < rhs.uploaded)
    return true;
  if (rhs.uploaded < lhs.uploaded)
    return false;
  if (lhs.download_total < rhs.download_total)
    return true;
  if (rhs.download_total < lhs.download_total)
    return false;
  if (lhs.downloaded < rhs.downloaded)
    return true;
  if (rhs.downloaded < lhs.downloaded)
    return false;
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  if (lhs.failure_reason < rhs.failure_reason)
    return true;
  if (rhs.failure_reason < lhs.failure_reason)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundFetchRegistrationPtr BackgroundFetchRegistration::Clone() const {
  return New(
      mojo::Clone(registration_data),
      mojo::Clone(registration_interface)
  );
}

template <typename T, BackgroundFetchRegistration::EnableIfSame<T>*>
bool BackgroundFetchRegistration::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_data, other_struct.registration_data))
    return false;
  if (!mojo::Equals(this->registration_interface, other_struct.registration_interface))
    return false;
  return true;
}

template <typename T, BackgroundFetchRegistration::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration_data < rhs.registration_data)
    return true;
  if (rhs.registration_data < lhs.registration_data)
    return false;
  if (lhs.registration_interface < rhs.registration_interface)
    return true;
  if (rhs.registration_interface < lhs.registration_interface)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundFetchUkmDataPtr BackgroundFetchUkmData::Clone() const {
  return New(
      mojo::Clone(ideal_to_chosen_icon_size)
  );
}

template <typename T, BackgroundFetchUkmData::EnableIfSame<T>*>
bool BackgroundFetchUkmData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ideal_to_chosen_icon_size, other_struct.ideal_to_chosen_icon_size))
    return false;
  return true;
}

template <typename T, BackgroundFetchUkmData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ideal_to_chosen_icon_size < rhs.ideal_to_chosen_icon_size)
    return true;
  if (rhs.ideal_to_chosen_icon_size < lhs.ideal_to_chosen_icon_size)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BackgroundFetchSettledFetch::DataView,
                                         ::blink::mojom::blink::BackgroundFetchSettledFetchPtr> {
  static bool IsNull(const ::blink::mojom::blink::BackgroundFetchSettledFetchPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BackgroundFetchSettledFetchPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::BackgroundFetchSettledFetch::request)& request(
       ::blink::mojom::blink::BackgroundFetchSettledFetchPtr& input) {
    return input->request;
  }

  static  decltype(::blink::mojom::blink::BackgroundFetchSettledFetch::response)& response(
       ::blink::mojom::blink::BackgroundFetchSettledFetchPtr& input) {
    return input->response;
  }

  static bool Read(::blink::mojom::blink::BackgroundFetchSettledFetch::DataView input, ::blink::mojom::blink::BackgroundFetchSettledFetchPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BackgroundFetchOptions::DataView,
                                         ::blink::mojom::blink::BackgroundFetchOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::BackgroundFetchOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BackgroundFetchOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BackgroundFetchOptions::icons)& icons(
      const ::blink::mojom::blink::BackgroundFetchOptionsPtr& input) {
    return input->icons;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchOptions::download_total) download_total(
      const ::blink::mojom::blink::BackgroundFetchOptionsPtr& input) {
    return input->download_total;
  }

  static const decltype(::blink::mojom::blink::BackgroundFetchOptions::title)& title(
      const ::blink::mojom::blink::BackgroundFetchOptionsPtr& input) {
    return input->title;
  }

  static bool Read(::blink::mojom::blink::BackgroundFetchOptions::DataView input, ::blink::mojom::blink::BackgroundFetchOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BackgroundFetchRegistrationData::DataView,
                                         ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BackgroundFetchRegistrationDataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::developer_id)& developer_id(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->developer_id;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::upload_total) upload_total(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->upload_total;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::uploaded) uploaded(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->uploaded;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::download_total) download_total(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->download_total;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::downloaded) downloaded(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->downloaded;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::result) result(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->result;
  }

  static decltype(::blink::mojom::blink::BackgroundFetchRegistrationData::failure_reason) failure_reason(
      const ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr& input) {
    return input->failure_reason;
  }

  static bool Read(::blink::mojom::blink::BackgroundFetchRegistrationData::DataView input, ::blink::mojom::blink::BackgroundFetchRegistrationDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BackgroundFetchRegistration::DataView,
                                         ::blink::mojom::blink::BackgroundFetchRegistrationPtr> {
  static bool IsNull(const ::blink::mojom::blink::BackgroundFetchRegistrationPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BackgroundFetchRegistrationPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BackgroundFetchRegistration::registration_data)& registration_data(
      const ::blink::mojom::blink::BackgroundFetchRegistrationPtr& input) {
    return input->registration_data;
  }

  static  decltype(::blink::mojom::blink::BackgroundFetchRegistration::registration_interface)& registration_interface(
       ::blink::mojom::blink::BackgroundFetchRegistrationPtr& input) {
    return input->registration_interface;
  }

  static bool Read(::blink::mojom::blink::BackgroundFetchRegistration::DataView input, ::blink::mojom::blink::BackgroundFetchRegistrationPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BackgroundFetchUkmData::DataView,
                                         ::blink::mojom::blink::BackgroundFetchUkmDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::BackgroundFetchUkmDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BackgroundFetchUkmDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::BackgroundFetchUkmData::ideal_to_chosen_icon_size) ideal_to_chosen_icon_size(
      const ::blink::mojom::blink::BackgroundFetchUkmDataPtr& input) {
    return input->ideal_to_chosen_icon_size;
  }

  static bool Read(::blink::mojom::blink::BackgroundFetchUkmData::DataView input, ::blink::mojom::blink::BackgroundFetchUkmDataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BACKGROUND_FETCH_BACKGROUND_FETCH_MOJOM_BLINK_H_