// third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ARRAY_BUFFER_ARRAY_BUFFER_CONTENTS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ARRAY_BUFFER_ARRAY_BUFFER_CONTENTS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT SerializedArrayBufferContents {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedArrayBufferContents, T>::value>;
  using DataView = SerializedArrayBufferContentsDataView;
  using Data_ = internal::SerializedArrayBufferContents_Data;

  template <typename... Args>
  static SerializedArrayBufferContentsPtr New(Args&&... args) {
    return SerializedArrayBufferContentsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedArrayBufferContentsPtr From(const U& u) {
    return mojo::TypeConverter<SerializedArrayBufferContentsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedArrayBufferContents>::Convert(*this);
  }


  SerializedArrayBufferContents();

  SerializedArrayBufferContents(
      ::mojo_base::BigBuffer contents,
      bool is_resizable_by_user_javascript,
      uint64_t max_byte_length);

SerializedArrayBufferContents(const SerializedArrayBufferContents&) = delete;
SerializedArrayBufferContents& operator=(const SerializedArrayBufferContents&) = delete;

  ~SerializedArrayBufferContents();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedArrayBufferContentsPtr>
  SerializedArrayBufferContentsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedArrayBufferContents::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedArrayBufferContents_UnserializedMessageContext<
            UserType, SerializedArrayBufferContents::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SerializedArrayBufferContents::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SerializedArrayBufferContents::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedArrayBufferContents_UnserializedMessageContext<
            UserType, SerializedArrayBufferContents::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedArrayBufferContents::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer contents;
  
  bool is_resizable_by_user_javascript;
  
  uint64_t max_byte_length;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedArrayBufferContents::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SerializedArrayBufferContentsPtr SerializedArrayBufferContents::Clone() const {
  return New(
      mojo::Clone(contents),
      mojo::Clone(is_resizable_by_user_javascript),
      mojo::Clone(max_byte_length)
  );
}

template <typename T, SerializedArrayBufferContents::EnableIfSame<T>*>
bool SerializedArrayBufferContents::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->contents, other_struct.contents))
    return false;
  if (!mojo::Equals(this->is_resizable_by_user_javascript, other_struct.is_resizable_by_user_javascript))
    return false;
  if (!mojo::Equals(this->max_byte_length, other_struct.max_byte_length))
    return false;
  return true;
}

template <typename T, SerializedArrayBufferContents::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.contents < rhs.contents)
    return true;
  if (rhs.contents < lhs.contents)
    return false;
  if (lhs.is_resizable_by_user_javascript < rhs.is_resizable_by_user_javascript)
    return true;
  if (rhs.is_resizable_by_user_javascript < lhs.is_resizable_by_user_javascript)
    return false;
  if (lhs.max_byte_length < rhs.max_byte_length)
    return true;
  if (rhs.max_byte_length < lhs.max_byte_length)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SerializedArrayBufferContents::DataView,
                                         ::blink::mojom::SerializedArrayBufferContentsPtr> {
  static bool IsNull(const ::blink::mojom::SerializedArrayBufferContentsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SerializedArrayBufferContentsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::SerializedArrayBufferContents::contents)& contents(
       ::blink::mojom::SerializedArrayBufferContentsPtr& input) {
    return input->contents;
  }

  static decltype(::blink::mojom::SerializedArrayBufferContents::is_resizable_by_user_javascript) is_resizable_by_user_javascript(
      const ::blink::mojom::SerializedArrayBufferContentsPtr& input) {
    return input->is_resizable_by_user_javascript;
  }

  static decltype(::blink::mojom::SerializedArrayBufferContents::max_byte_length) max_byte_length(
      const ::blink::mojom::SerializedArrayBufferContentsPtr& input) {
    return input->max_byte_length;
  }

  static bool Read(::blink::mojom::SerializedArrayBufferContents::DataView input, ::blink::mojom::SerializedArrayBufferContentsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ARRAY_BUFFER_ARRAY_BUFFER_CONTENTS_MOJOM_H_