// third_party/blink/public/mojom/annotation/annotation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/annotation/annotation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/annotation/annotation.mojom-params-data.h"
#include "third_party/blink/public/mojom/annotation/annotation.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/annotation/annotation.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/annotation/annotation.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SelectorCreationResult::SelectorCreationResult()
    : host_receiver(),
      agent_remote(),
      serialized_selector(),
      selected_text() {}

SelectorCreationResult::SelectorCreationResult(
    ::mojo::PendingReceiver<AnnotationAgentHost> host_receiver_in,
    ::mojo::PendingRemote<AnnotationAgent> agent_remote_in,
    const ::blink::String& serialized_selector_in,
    const ::blink::String& selected_text_in)
    : host_receiver(std::move(host_receiver_in)),
      agent_remote(std::move(agent_remote_in)),
      serialized_selector(std::move(serialized_selector_in)),
      selected_text(std::move(selected_text_in)) {}

SelectorCreationResult::~SelectorCreationResult() = default;

void SelectorCreationResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_receiver"), this->host_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<AnnotationAgentHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "agent_remote"), this->agent_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<AnnotationAgent>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serialized_selector"), this->serialized_selector,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_text"), this->selected_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectorCreationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectorPtr
Selector::NewSerializedSelector(
    const ::blink::String& value) {
  return SelectorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSerializedSelector)>,
      std::move(value));
}

SelectorPtr
Selector::NewNodeId(
    int32_t value) {
  return SelectorPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNodeId)>,
      std::move(value));
}

Selector::Selector(
    std::in_place_index_t<static_cast<size_t>(Tag::kSerializedSelector)>,
    const ::blink::String& value)
    : tag_(Tag::kSerializedSelector),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSerializedSelector)>,
            std::move(value)) {}

Selector::Selector(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeId)>,
    int32_t value)
    : tag_(Tag::kNodeId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNodeId)>,
            std::move(value)) {}
Selector::~Selector() {
  DestroyActive();
}

void Selector::set_serialized_selector(const ::blink::String& serialized_selector) {
  if (tag_ == Tag::kSerializedSelector) {
    data_.serialized_selector = std::move(serialized_selector);
  } else {
    DestroyActive();
    tag_ = Tag::kSerializedSelector;
    new (&data_.serialized_selector) ::blink::String(
        std::move(serialized_selector));
  }
}

void Selector::set_node_id(int32_t node_id) {
  if (tag_ != Tag::kNodeId) {
    DestroyActive();
    tag_ = Tag::kNodeId;
  }
  data_.node_id = node_id;
}


Selector::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSerializedSelector)>,
    const ::blink::String& value)
    : serialized_selector(std::move(value)) {}

Selector::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNodeId)>,
    int32_t value)
    : node_id(std::move(value)) {}

void Selector::DestroyActive() {
  switch (tag_) {

    case Tag::kSerializedSelector:
      std::destroy_at(&data_.serialized_selector);
      break;
    case Tag::kNodeId:
      std::destroy_at(&data_.node_id);
      break;
  }
}
size_t Selector::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSerializedSelector:
      return mojo::internal::WTFHash(seed, data_.serialized_selector);
    case Tag::kNodeId:
      return mojo::internal::WTFHash(seed, data_.node_id);
    default:
      NOTREACHED();
  }
}

bool Selector::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

AnnotationAgent::IPCStableHashFunction AnnotationAgent::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AnnotationAgent>(message.name())) {
    case messages::AnnotationAgent::kScrollIntoView: {
      return &AnnotationAgent::ScrollIntoView_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AnnotationAgent::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AnnotationAgent>(message.name())) {
      case messages::AnnotationAgent::kScrollIntoView:
            return "Receive blink::mojom::AnnotationAgent::ScrollIntoView";
    }
  } else {
    switch (static_cast<messages::AnnotationAgent>(message.name())) {
      case messages::AnnotationAgent::kScrollIntoView:
            return "Receive reply blink::mojom::AnnotationAgent::ScrollIntoView";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AnnotationAgent::ScrollIntoView_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc428ed8b;  // IPCStableHash for blink::mojom::AnnotationAgent::ScrollIntoView
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AnnotationAgentProxy::AnnotationAgentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnnotationAgentProxy::ScrollIntoView(
    bool in_applies_focus) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnnotationAgent::ScrollIntoView", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("applies_focus"), in_applies_focus,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgent::kScrollIntoView), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgent_ScrollIntoView_Params_Data> params(
          message);
  params.Allocate();

  params->applies_focus = in_applies_focus;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgent::Name_);
  message.set_method_name("ScrollIntoView");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AnnotationAgentStubDispatch::Accept(
    AnnotationAgent* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AnnotationAgent>(message->header()->name)) {
    case messages::AnnotationAgent::kScrollIntoView: {
      DCHECK(message->is_serialized());
      internal::AnnotationAgent_ScrollIntoView_Params_Data* params =
          reinterpret_cast<internal::AnnotationAgent_ScrollIntoView_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnnotationAgent.0
      bool success = true;
      bool p_applies_focus{};
      AnnotationAgent_ScrollIntoView_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_applies_focus = input_data_view.applies_focus();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnnotationAgent::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ScrollIntoView(        
        std::move(p_applies_focus));
      return true;
    }
  }
  return false;
}

// static
bool AnnotationAgentStubDispatch::AcceptWithResponder(
    AnnotationAgent* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AnnotationAgent>(message->header()->name)) {
    case messages::AnnotationAgent::kScrollIntoView: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnnotationAgentValidationInfo[] = {
    { &internal::AnnotationAgent_ScrollIntoView_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnnotationAgentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AnnotationAgent::Name_,
    kAnnotationAgentValidationInfo);
}

// The declaration includes the definition on other builds.

AnnotationAgentHost::IPCStableHashFunction AnnotationAgentHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AnnotationAgentHost>(message.name())) {
    case messages::AnnotationAgentHost::kDidFinishAttachment: {
      return &AnnotationAgentHost::DidFinishAttachment_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AnnotationAgentHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AnnotationAgentHost>(message.name())) {
      case messages::AnnotationAgentHost::kDidFinishAttachment:
            return "Receive blink::mojom::AnnotationAgentHost::DidFinishAttachment";
    }
  } else {
    switch (static_cast<messages::AnnotationAgentHost>(message.name())) {
      case messages::AnnotationAgentHost::kDidFinishAttachment:
            return "Receive reply blink::mojom::AnnotationAgentHost::DidFinishAttachment";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AnnotationAgentHost::DidFinishAttachment_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2fedb653;  // IPCStableHash for blink::mojom::AnnotationAgentHost::DidFinishAttachment
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AnnotationAgentHostProxy::AnnotationAgentHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnnotationAgentHostProxy::DidFinishAttachment(
    const ::gfx::Rect& in_document_relative_rect, AttachmentResult in_attachment_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnnotationAgentHost::DidFinishAttachment", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_relative_rect"), in_document_relative_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("attachment_result"), in_attachment_result,
                        "<value of type AttachmentResult>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgentHost::kDidFinishAttachment), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgentHost_DidFinishAttachment_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->document_relative_rect)::BaseType> document_relative_rect_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
    in_document_relative_rect,
    document_relative_rect_fragment);

  params->document_relative_rect.Set(
      document_relative_rect_fragment.is_null() ? nullptr : document_relative_rect_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_relative_rect.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_relative_rect in AnnotationAgentHost.DidFinishAttachment request");

  
  mojo::internal::Serialize<::blink::mojom::AttachmentResult>(
    in_attachment_result,
    &params->attachment_result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgentHost::Name_);
  message.set_method_name("DidFinishAttachment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AnnotationAgentHostStubDispatch::Accept(
    AnnotationAgentHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AnnotationAgentHost>(message->header()->name)) {
    case messages::AnnotationAgentHost::kDidFinishAttachment: {
      DCHECK(message->is_serialized());
      internal::AnnotationAgentHost_DidFinishAttachment_Params_Data* params =
          reinterpret_cast<internal::AnnotationAgentHost_DidFinishAttachment_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnnotationAgentHost.0
      bool success = true;
      ::gfx::Rect p_document_relative_rect{};
      AttachmentResult p_attachment_result{};
      AnnotationAgentHost_DidFinishAttachment_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDocumentRelativeRect(&p_document_relative_rect))
        success = false;
      if (success && !input_data_view.ReadAttachmentResult(&p_attachment_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnnotationAgentHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFinishAttachment(        
        std::move(p_document_relative_rect), 
        std::move(p_attachment_result));
      return true;
    }
  }
  return false;
}

// static
bool AnnotationAgentHostStubDispatch::AcceptWithResponder(
    AnnotationAgentHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AnnotationAgentHost>(message->header()->name)) {
    case messages::AnnotationAgentHost::kDidFinishAttachment: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnnotationAgentHostValidationInfo[] = {
    { &internal::AnnotationAgentHost_DidFinishAttachment_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnnotationAgentHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AnnotationAgentHost::Name_,
    kAnnotationAgentHostValidationInfo);
}

// The declaration includes the definition on other builds.

AnnotationAgentContainer::IPCStableHashFunction AnnotationAgentContainer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AnnotationAgentContainer>(message.name())) {
    case messages::AnnotationAgentContainer::kCreateAgent: {
      return &AnnotationAgentContainer::CreateAgent_Sym::IPCStableHash;
    }
    case messages::AnnotationAgentContainer::kCreateAgentFromSelection: {
      return &AnnotationAgentContainer::CreateAgentFromSelection_Sym::IPCStableHash;
    }
    case messages::AnnotationAgentContainer::kRemoveAgentsOfType: {
      return &AnnotationAgentContainer::RemoveAgentsOfType_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AnnotationAgentContainer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AnnotationAgentContainer>(message.name())) {
      case messages::AnnotationAgentContainer::kCreateAgent:
            return "Receive blink::mojom::AnnotationAgentContainer::CreateAgent";
      case messages::AnnotationAgentContainer::kCreateAgentFromSelection:
            return "Receive blink::mojom::AnnotationAgentContainer::CreateAgentFromSelection";
      case messages::AnnotationAgentContainer::kRemoveAgentsOfType:
            return "Receive blink::mojom::AnnotationAgentContainer::RemoveAgentsOfType";
    }
  } else {
    switch (static_cast<messages::AnnotationAgentContainer>(message.name())) {
      case messages::AnnotationAgentContainer::kCreateAgent:
            return "Receive reply blink::mojom::AnnotationAgentContainer::CreateAgent";
      case messages::AnnotationAgentContainer::kCreateAgentFromSelection:
            return "Receive reply blink::mojom::AnnotationAgentContainer::CreateAgentFromSelection";
      case messages::AnnotationAgentContainer::kRemoveAgentsOfType:
            return "Receive reply blink::mojom::AnnotationAgentContainer::RemoveAgentsOfType";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AnnotationAgentContainer::CreateAgent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd70c5f62;  // IPCStableHash for blink::mojom::AnnotationAgentContainer::CreateAgent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnnotationAgentContainer::CreateAgentFromSelection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82b995ca;  // IPCStableHash for blink::mojom::AnnotationAgentContainer::CreateAgentFromSelection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnnotationAgentContainer::RemoveAgentsOfType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2bce567;  // IPCStableHash for blink::mojom::AnnotationAgentContainer::RemoveAgentsOfType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback(
      AnnotationAgentContainer::CreateAgentFromSelectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback(const AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback&) = delete;
  AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback& operator=(const AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AnnotationAgentContainer::CreateAgentFromSelectionCallback callback_;
};

AnnotationAgentContainerProxy::AnnotationAgentContainerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnnotationAgentContainerProxy::CreateAgent(
    ::mojo::PendingRemote<AnnotationAgentHost> in_host_remote, ::mojo::PendingReceiver<AnnotationAgent> in_agent_receiver, AnnotationType in_type, SelectorPtr in_selector, std::optional<int32_t> in_search_range_start_node_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnnotationAgentContainer::CreateAgent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_remote"), in_host_remote,
                        "<value of type ::mojo::PendingRemote<AnnotationAgentHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_receiver"), in_agent_receiver,
                        "<value of type ::mojo::PendingReceiver<AnnotationAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AnnotationType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selector"), in_selector,
                        "<value of type SelectorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("search_range_start_node_id"), in_search_range_start_node_id,
                        "<value of type std::optional<int32_t>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgentContainer::kCreateAgent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgentContainer_CreateAgent_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::AnnotationAgentHostInterfaceBase>>(
    in_host_remote,
    &params->host_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->host_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid host_remote in AnnotationAgentContainer.CreateAgent request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::AnnotationAgentInterfaceBase>>(
    in_agent_receiver,
    &params->agent_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent_receiver in AnnotationAgentContainer.CreateAgent request");

  
  mojo::internal::Serialize<::blink::mojom::AnnotationType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<decltype(params->selector)>
      selector_fragment(params.message());
  selector_fragment.Claim(&params->selector);
  
  mojo::internal::Serialize<::blink::mojom::SelectorDataView>(
    in_selector,
    selector_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->selector.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null selector in AnnotationAgentContainer.CreateAgent request");
  params->search_range_start_node_id_$flag = in_search_range_start_node_id.has_value();
  if (in_search_range_start_node_id.has_value()) {
    params->search_range_start_node_id_$value = in_search_range_start_node_id.value();
  }

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgentContainer::Name_);
  message.set_method_name("CreateAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnnotationAgentContainerProxy::CreateAgentFromSelection(
    AnnotationType in_type, CreateAgentFromSelectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnnotationAgentContainer::CreateAgentFromSelection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AnnotationType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgentContainer::kCreateAgentFromSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgentContainer_CreateAgentFromSelection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AnnotationType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgentContainer::Name_);
  message.set_method_name("CreateAgentFromSelection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AnnotationAgentContainerProxy::RemoveAgentsOfType(
    AnnotationType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnnotationAgentContainer::RemoveAgentsOfType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type AnnotationType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgentContainer::kRemoveAgentsOfType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgentContainer_RemoveAgentsOfType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::AnnotationType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgentContainer::Name_);
  message.set_method_name("RemoveAgentsOfType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AnnotationAgentContainer::CreateAgentFromSelectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder> proxy(
        new AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AnnotationAgentContainer::CreateAgentFromSelectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SelectorCreationResultPtr in_result, ::shared_highlighting::LinkGenerationError in_error, ::shared_highlighting::LinkGenerationReadyStatus in_ready_status);
};

bool AnnotationAgentContainer_CreateAgentFromSelection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AnnotationAgentContainer.1
  bool success = true;
  SelectorCreationResultPtr p_result{};
  ::shared_highlighting::LinkGenerationError p_error{};
  ::shared_highlighting::LinkGenerationReadyStatus p_ready_status{};
  AnnotationAgentContainer_CreateAgentFromSelection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadReadyStatus(&p_ready_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AnnotationAgentContainer::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_error), 
std::move(p_ready_status));
  }
  return true;
}

void AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder::Run(
    SelectorCreationResultPtr in_result, ::shared_highlighting::LinkGenerationError in_error, ::shared_highlighting::LinkGenerationReadyStatus in_ready_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AnnotationAgentContainer::CreateAgentFromSelection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SelectorCreationResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::shared_highlighting::LinkGenerationError>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ready_status"), in_ready_status,
                        "<value of type ::shared_highlighting::LinkGenerationReadyStatus>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnnotationAgentContainer::kCreateAgentFromSelection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SelectorCreationResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  mojo::internal::Serialize<::blink::mojom::LinkGenerationError>(
    in_error,
    &params->error);

  
  mojo::internal::Serialize<::blink::mojom::LinkGenerationReadyStatus>(
    in_ready_status,
    &params->ready_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnnotationAgentContainer::Name_);
  message.set_method_name("CreateAgentFromSelection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AnnotationAgentContainerStubDispatch::Accept(
    AnnotationAgentContainer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AnnotationAgentContainer>(message->header()->name)) {
    case messages::AnnotationAgentContainer::kCreateAgent: {
      DCHECK(message->is_serialized());
      internal::AnnotationAgentContainer_CreateAgent_Params_Data* params =
          reinterpret_cast<internal::AnnotationAgentContainer_CreateAgent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnnotationAgentContainer.0
      bool success = true;
      ::mojo::PendingRemote<AnnotationAgentHost> p_host_remote{};
      ::mojo::PendingReceiver<AnnotationAgent> p_agent_receiver{};
      AnnotationType p_type{};
      SelectorPtr p_selector{};
      std::optional<int32_t> p_search_range_start_node_id{};
      AnnotationAgentContainer_CreateAgent_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_host_remote =
            input_data_view.TakeHostRemote<decltype(p_host_remote)>();
      }
      if (success) {
        p_agent_receiver =
            input_data_view.TakeAgentReceiver<decltype(p_agent_receiver)>();
      }
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadSelector(&p_selector))
        success = false;
      if (success) {
        p_search_range_start_node_id = input_data_view.search_range_start_node_id();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnnotationAgentContainer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAgent(        
        std::move(p_host_remote), 
        std::move(p_agent_receiver), 
        std::move(p_type), 
        std::move(p_selector), 
        std::move(p_search_range_start_node_id));
      return true;
    }
    case messages::AnnotationAgentContainer::kCreateAgentFromSelection: {
      break;
    }
    case messages::AnnotationAgentContainer::kRemoveAgentsOfType: {
      DCHECK(message->is_serialized());
      internal::AnnotationAgentContainer_RemoveAgentsOfType_Params_Data* params =
          reinterpret_cast<internal::AnnotationAgentContainer_RemoveAgentsOfType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnnotationAgentContainer.2
      bool success = true;
      AnnotationType p_type{};
      AnnotationAgentContainer_RemoveAgentsOfType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnnotationAgentContainer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveAgentsOfType(        
        std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool AnnotationAgentContainerStubDispatch::AcceptWithResponder(
    AnnotationAgentContainer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AnnotationAgentContainer>(message->header()->name)) {
    case messages::AnnotationAgentContainer::kCreateAgent: {
      break;
    }
    case messages::AnnotationAgentContainer::kCreateAgentFromSelection: {
      internal::AnnotationAgentContainer_CreateAgentFromSelection_Params_Data* params =
          reinterpret_cast<
              internal::AnnotationAgentContainer_CreateAgentFromSelection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AnnotationAgentContainer.1
      bool success = true;
      AnnotationType p_type{};
      AnnotationAgentContainer_CreateAgentFromSelection_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnnotationAgentContainer::Name_, 1, false);
        return false;
      }
      auto callback =
          AnnotationAgentContainer_CreateAgentFromSelection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateAgentFromSelection(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::AnnotationAgentContainer::kRemoveAgentsOfType: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnnotationAgentContainerValidationInfo[] = {
    { &internal::AnnotationAgentContainer_CreateAgent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnnotationAgentContainer_CreateAgentFromSelection_Params_Data::Validate,
     &internal::AnnotationAgentContainer_CreateAgentFromSelection_ResponseParams_Data::Validate},
    { &internal::AnnotationAgentContainer_RemoveAgentsOfType_Params_Data::Validate,
     nullptr /* no response */},
};

bool AnnotationAgentContainerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AnnotationAgentContainer::Name_,
    kAnnotationAgentContainerValidationInfo);
}

bool AnnotationAgentContainerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::AnnotationAgentContainer::Name_,
    kAnnotationAgentContainerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SelectorCreationResult::DataView, ::blink::mojom::blink::SelectorCreationResultPtr>::Read(
    ::blink::mojom::blink::SelectorCreationResult::DataView input,
    ::blink::mojom::blink::SelectorCreationResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SelectorCreationResultPtr result(::blink::mojom::blink::SelectorCreationResult::New());
  
      if (success) {
        result->host_receiver =
            input.TakeHostReceiver<decltype(result->host_receiver)>();
      }
      if (success) {
        result->agent_remote =
            input.TakeAgentRemote<decltype(result->agent_remote)>();
      }
      if (success && !input.ReadSerializedSelector(&result->serialized_selector))
        success = false;
      if (success && !input.ReadSelectedText(&result->selected_text))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::Selector::DataView, ::blink::mojom::blink::SelectorPtr>::Read(
    ::blink::mojom::blink::Selector::DataView input,
    ::blink::mojom::blink::SelectorPtr* output) {
  using UnionType = ::blink::mojom::blink::Selector;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSerializedSelector: {
      ::blink::String result_serialized_selector{};
      if (!input.ReadSerializedSelector(&result_serialized_selector))
        return false;

      *output = UnionType::NewSerializedSelector(
          std::move(result_serialized_selector));
      break;
    }
    case Tag::kNodeId: {
      *output = UnionType::NewNodeId(input.node_id());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AnnotationAgentInterceptorForTesting::ScrollIntoView(bool applies_focus) {
  GetForwardingInterface()->ScrollIntoView(
    std::move(applies_focus)
    );
}
AnnotationAgentAsyncWaiter::AnnotationAgentAsyncWaiter(
    AnnotationAgent* proxy) : proxy_(proxy) {}

AnnotationAgentAsyncWaiter::~AnnotationAgentAsyncWaiter() = default;





void AnnotationAgentHostInterceptorForTesting::DidFinishAttachment(const ::gfx::Rect& document_relative_rect, AttachmentResult attachment_result) {
  GetForwardingInterface()->DidFinishAttachment(
    std::move(document_relative_rect)
    , 
    std::move(attachment_result)
    );
}
AnnotationAgentHostAsyncWaiter::AnnotationAgentHostAsyncWaiter(
    AnnotationAgentHost* proxy) : proxy_(proxy) {}

AnnotationAgentHostAsyncWaiter::~AnnotationAgentHostAsyncWaiter() = default;





void AnnotationAgentContainerInterceptorForTesting::CreateAgent(::mojo::PendingRemote<AnnotationAgentHost> host_remote, ::mojo::PendingReceiver<AnnotationAgent> agent_receiver, AnnotationType type, SelectorPtr selector, std::optional<int32_t> search_range_start_node_id) {
  GetForwardingInterface()->CreateAgent(
    std::move(host_remote)
    , 
    std::move(agent_receiver)
    , 
    std::move(type)
    , 
    std::move(selector)
    , 
    std::move(search_range_start_node_id)
    );
}
void AnnotationAgentContainerInterceptorForTesting::CreateAgentFromSelection(AnnotationType type, CreateAgentFromSelectionCallback callback) {
  GetForwardingInterface()->CreateAgentFromSelection(
    std::move(type)
    , std::move(callback));
}
void AnnotationAgentContainerInterceptorForTesting::RemoveAgentsOfType(AnnotationType type) {
  GetForwardingInterface()->RemoveAgentsOfType(
    std::move(type)
    );
}
AnnotationAgentContainerAsyncWaiter::AnnotationAgentContainerAsyncWaiter(
    AnnotationAgentContainer* proxy) : proxy_(proxy) {}

AnnotationAgentContainerAsyncWaiter::~AnnotationAgentContainerAsyncWaiter() = default;


void AnnotationAgentContainerAsyncWaiter::CreateAgentFromSelection(
    AnnotationType type, SelectorCreationResultPtr* out_result, ::shared_highlighting::LinkGenerationError* out_error, ::shared_highlighting::LinkGenerationReadyStatus* out_ready_status) {
  base::RunLoop loop;
  proxy_->CreateAgentFromSelection(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             SelectorCreationResultPtr* out_result
,
             ::shared_highlighting::LinkGenerationError* out_error
,
             ::shared_highlighting::LinkGenerationReadyStatus* out_ready_status
,
             SelectorCreationResultPtr result,
             ::shared_highlighting::LinkGenerationError error,
             ::shared_highlighting::LinkGenerationReadyStatus ready_status) {*out_result = std::move(result);*out_error = std::move(error);*out_ready_status = std::move(ready_status);
            loop->Quit();
          },
          &loop,
          out_result,
          out_error,
          out_ready_status));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif