// third_party/blink/public/mojom/ai/model_streaming_responder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-params-data.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-import-headers.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-test-utils.h"


namespace blink::mojom {
ModelExecutionContextInfo::ModelExecutionContextInfo()
    : current_tokens() {}

ModelExecutionContextInfo::ModelExecutionContextInfo(
    uint64_t current_tokens_in)
    : current_tokens(std::move(current_tokens_in)) {}

ModelExecutionContextInfo::~ModelExecutionContextInfo() = default;
size_t ModelExecutionContextInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->current_tokens);
  return seed;
}

void ModelExecutionContextInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_tokens"), this->current_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ModelExecutionContextInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ModelStreamingResponder::IPCStableHashFunction ModelStreamingResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ModelStreamingResponder>(message.name())) {
    case messages::ModelStreamingResponder::kOnCompletion: {
      return &ModelStreamingResponder::OnCompletion_Sym::IPCStableHash;
    }
    case messages::ModelStreamingResponder::kOnError: {
      return &ModelStreamingResponder::OnError_Sym::IPCStableHash;
    }
    case messages::ModelStreamingResponder::kOnStreaming: {
      return &ModelStreamingResponder::OnStreaming_Sym::IPCStableHash;
    }
    case messages::ModelStreamingResponder::kOnQuotaOverflow: {
      return &ModelStreamingResponder::OnQuotaOverflow_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ModelStreamingResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ModelStreamingResponder>(message.name())) {
      case messages::ModelStreamingResponder::kOnCompletion:
            return "Receive blink::mojom::ModelStreamingResponder::OnCompletion";
      case messages::ModelStreamingResponder::kOnError:
            return "Receive blink::mojom::ModelStreamingResponder::OnError";
      case messages::ModelStreamingResponder::kOnStreaming:
            return "Receive blink::mojom::ModelStreamingResponder::OnStreaming";
      case messages::ModelStreamingResponder::kOnQuotaOverflow:
            return "Receive blink::mojom::ModelStreamingResponder::OnQuotaOverflow";
    }
  } else {
    switch (static_cast<messages::ModelStreamingResponder>(message.name())) {
      case messages::ModelStreamingResponder::kOnCompletion:
            return "Receive reply blink::mojom::ModelStreamingResponder::OnCompletion";
      case messages::ModelStreamingResponder::kOnError:
            return "Receive reply blink::mojom::ModelStreamingResponder::OnError";
      case messages::ModelStreamingResponder::kOnStreaming:
            return "Receive reply blink::mojom::ModelStreamingResponder::OnStreaming";
      case messages::ModelStreamingResponder::kOnQuotaOverflow:
            return "Receive reply blink::mojom::ModelStreamingResponder::OnQuotaOverflow";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ModelStreamingResponder::OnCompletion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf1945e83;  // IPCStableHash for blink::mojom::ModelStreamingResponder::OnCompletion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelStreamingResponder::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71b322bb;  // IPCStableHash for blink::mojom::ModelStreamingResponder::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelStreamingResponder::OnStreaming_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x124c8584;  // IPCStableHash for blink::mojom::ModelStreamingResponder::OnStreaming
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ModelStreamingResponder::OnQuotaOverflow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3cd7edfd;  // IPCStableHash for blink::mojom::ModelStreamingResponder::OnQuotaOverflow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ModelStreamingResponderProxy::ModelStreamingResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ModelStreamingResponderProxy::OnCompletion(
    ModelExecutionContextInfoPtr in_context_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ModelStreamingResponder::OnCompletion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_info"), in_context_info,
                        "<value of type ModelExecutionContextInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelStreamingResponder::kOnCompletion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ModelStreamingResponder_OnCompletion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->context_info)::BaseType> context_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ModelExecutionContextInfoDataView>(
    in_context_info,
    context_info_fragment);

  params->context_info.Set(
      context_info_fragment.is_null() ? nullptr : context_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelStreamingResponder::Name_);
  message.set_method_name("OnCompletion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelStreamingResponderProxy::OnError(
    ModelStreamingResponseStatus in_status, ::blink::mojom::QuotaErrorInfoPtr in_quota_error_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ModelStreamingResponder::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ModelStreamingResponseStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("quota_error_info"), in_quota_error_info,
                        "<value of type ::blink::mojom::QuotaErrorInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelStreamingResponder::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ModelStreamingResponder_OnError_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ModelStreamingResponseStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->quota_error_info)::BaseType> quota_error_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::QuotaErrorInfoDataView>(
    in_quota_error_info,
    quota_error_info_fragment);

  params->quota_error_info.Set(
      quota_error_info_fragment.is_null() ? nullptr : quota_error_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelStreamingResponder::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelStreamingResponderProxy::OnStreaming(
    const std::string& in_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ModelStreamingResponder::OnStreaming", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelStreamingResponder::kOnStreaming), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ModelStreamingResponder_OnStreaming_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in ModelStreamingResponder.OnStreaming request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelStreamingResponder::Name_);
  message.set_method_name("OnStreaming");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ModelStreamingResponderProxy::OnQuotaOverflow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ModelStreamingResponder::OnQuotaOverflow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ModelStreamingResponder::kOnQuotaOverflow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ModelStreamingResponder_OnQuotaOverflow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ModelStreamingResponder::Name_);
  message.set_method_name("OnQuotaOverflow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ModelStreamingResponderStubDispatch::Accept(
    ModelStreamingResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ModelStreamingResponder>(message->header()->name)) {
    case messages::ModelStreamingResponder::kOnCompletion: {
      DCHECK(message->is_serialized());
      internal::ModelStreamingResponder_OnCompletion_Params_Data* params =
          reinterpret_cast<internal::ModelStreamingResponder_OnCompletion_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelStreamingResponder.0
      bool success = true;
      ModelExecutionContextInfoPtr p_context_info{};
      ModelStreamingResponder_OnCompletion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadContextInfo(&p_context_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelStreamingResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompletion(        
        std::move(p_context_info));
      return true;
    }
    case messages::ModelStreamingResponder::kOnError: {
      DCHECK(message->is_serialized());
      internal::ModelStreamingResponder_OnError_Params_Data* params =
          reinterpret_cast<internal::ModelStreamingResponder_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelStreamingResponder.1
      bool success = true;
      ModelStreamingResponseStatus p_status{};
      ::blink::mojom::QuotaErrorInfoPtr p_quota_error_info{};
      ModelStreamingResponder_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success && !input_data_view.ReadQuotaErrorInfo(&p_quota_error_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelStreamingResponder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_status), 
        std::move(p_quota_error_info));
      return true;
    }
    case messages::ModelStreamingResponder::kOnStreaming: {
      DCHECK(message->is_serialized());
      internal::ModelStreamingResponder_OnStreaming_Params_Data* params =
          reinterpret_cast<internal::ModelStreamingResponder_OnStreaming_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelStreamingResponder.2
      bool success = true;
      std::string p_text{};
      ModelStreamingResponder_OnStreaming_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelStreamingResponder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStreaming(        
        std::move(p_text));
      return true;
    }
    case messages::ModelStreamingResponder::kOnQuotaOverflow: {
      DCHECK(message->is_serialized());
      internal::ModelStreamingResponder_OnQuotaOverflow_Params_Data* params =
          reinterpret_cast<internal::ModelStreamingResponder_OnQuotaOverflow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ModelStreamingResponder.3
      bool success = true;
      ModelStreamingResponder_OnQuotaOverflow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ModelStreamingResponder::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnQuotaOverflow(        );
      return true;
    }
  }
  return false;
}

// static
bool ModelStreamingResponderStubDispatch::AcceptWithResponder(
    ModelStreamingResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ModelStreamingResponder>(message->header()->name)) {
    case messages::ModelStreamingResponder::kOnCompletion: {
      break;
    }
    case messages::ModelStreamingResponder::kOnError: {
      break;
    }
    case messages::ModelStreamingResponder::kOnStreaming: {
      break;
    }
    case messages::ModelStreamingResponder::kOnQuotaOverflow: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kModelStreamingResponderValidationInfo[] = {
    { &internal::ModelStreamingResponder_OnCompletion_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelStreamingResponder_OnError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelStreamingResponder_OnStreaming_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ModelStreamingResponder_OnQuotaOverflow_Params_Data::Validate,
     nullptr /* no response */},
};

bool ModelStreamingResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ModelStreamingResponder::Name_,
    kModelStreamingResponderValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::ModelExecutionContextInfo::DataView, ::blink::mojom::ModelExecutionContextInfoPtr>::Read(
    ::blink::mojom::ModelExecutionContextInfo::DataView input,
    ::blink::mojom::ModelExecutionContextInfoPtr* output) {
  bool success = true;
  ::blink::mojom::ModelExecutionContextInfoPtr result(::blink::mojom::ModelExecutionContextInfo::New());
  
      if (success)
        result->current_tokens = input.current_tokens();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ModelStreamingResponderInterceptorForTesting::OnCompletion(ModelExecutionContextInfoPtr context_info) {
  GetForwardingInterface()->OnCompletion(
    std::move(context_info)
    );
}
void ModelStreamingResponderInterceptorForTesting::OnError(ModelStreamingResponseStatus status, ::blink::mojom::QuotaErrorInfoPtr quota_error_info) {
  GetForwardingInterface()->OnError(
    std::move(status)
    , 
    std::move(quota_error_info)
    );
}
void ModelStreamingResponderInterceptorForTesting::OnStreaming(const std::string& text) {
  GetForwardingInterface()->OnStreaming(
    std::move(text)
    );
}
void ModelStreamingResponderInterceptorForTesting::OnQuotaOverflow() {
  GetForwardingInterface()->OnQuotaOverflow();
}
ModelStreamingResponderAsyncWaiter::ModelStreamingResponderAsyncWaiter(
    ModelStreamingResponder* proxy) : proxy_(proxy) {}

ModelStreamingResponderAsyncWaiter::~ModelStreamingResponderAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif