// third_party/blink/public/mojom/ai/model_download_progress_observer.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.ModelDownloadProgressObserver');
goog.provide('blink.mojom.ModelDownloadProgressObserverReceiver');
goog.provide('blink.mojom.ModelDownloadProgressObserverCallbackRouter');
goog.provide('blink.mojom.ModelDownloadProgressObserverInterface');
goog.provide('blink.mojom.ModelDownloadProgressObserverRemote');
goog.provide('blink.mojom.ModelDownloadProgressObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.ModelDownloadProgressObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.ModelDownloadProgressObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.ModelDownloadProgressObserverInterface = class {
  
  /**
   * @param { !bigint } downloadedBytes
   * @param { !bigint } totalBytes
   */

  onDownloadProgressUpdate(downloadedBytes, totalBytes) {}
};

/**
 * @export
 * @implements { blink.mojom.ModelDownloadProgressObserverInterface }
 */
blink.mojom.ModelDownloadProgressObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.ModelDownloadProgressObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.ModelDownloadProgressObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.ModelDownloadProgressObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } downloadedBytes
   * @param { !bigint } totalBytes
   */

  onDownloadProgressUpdate(
      downloadedBytes,
      totalBytes) {
    this.proxy.sendMessage(
        0,
        blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        [
          downloadedBytes,
          totalBytes
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ModelDownloadProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.ModelDownloadProgressObserverReceiver = class {
  /**
   * @param {!blink.mojom.ModelDownloadProgressObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.ModelDownloadProgressObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.ModelDownloadProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ModelDownloadProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        impl.onDownloadProgressUpdate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.ModelDownloadProgressObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ModelDownloadProgressObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.ModelDownloadProgressObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.ModelDownloadProgressObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ModelDownloadProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.ModelDownloadProgressObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.ModelDownloadProgressObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.ModelDownloadProgressObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDownloadProgressUpdate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
        null,
        this.onDownloadProgressUpdate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_ParamsSpec.$,
    'ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params',
    [
      mojo.internal.StructField(
        'downloadedBytes', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'totalBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params');

/** @record */
blink.mojom.ModelDownloadProgressObserver_OnDownloadProgressUpdate_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.downloadedBytes;
    /** @export { !bigint } */
    this.totalBytes;
  }
};

