// third_party/blink/public/mojom/ai/ai_rewriter.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/ai/ai_rewriter.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_common$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/ai_common.mojom', 'ai_common.mojom.js');
  }
  var model_streaming_responder$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/ai/model_streaming_responder.mojom', 'model_streaming_responder.mojom.js');
  }


  var AIRewriterTone = {};
  AIRewriterTone.kAsIs = 0;
  AIRewriterTone.kMoreFormal = 1;
  AIRewriterTone.kMoreCasual = 2;
  AIRewriterTone.MIN_VALUE = 0;
  AIRewriterTone.MAX_VALUE = 2;

  AIRewriterTone.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIRewriterTone.toKnownEnumValue = function(value) {
    return value;
  };

  AIRewriterTone.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIRewriterFormat = {};
  AIRewriterFormat.kAsIs = 0;
  AIRewriterFormat.kPlainText = 1;
  AIRewriterFormat.kMarkdown = 2;
  AIRewriterFormat.MIN_VALUE = 0;
  AIRewriterFormat.MAX_VALUE = 2;

  AIRewriterFormat.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIRewriterFormat.toKnownEnumValue = function(value) {
    return value;
  };

  AIRewriterFormat.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AIRewriterLength = {};
  AIRewriterLength.kAsIs = 0;
  AIRewriterLength.kShorter = 1;
  AIRewriterLength.kLonger = 2;
  AIRewriterLength.MIN_VALUE = 0;
  AIRewriterLength.MAX_VALUE = 2;

  AIRewriterLength.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AIRewriterLength.toKnownEnumValue = function(value) {
    return value;
  };

  AIRewriterLength.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AIRewriterCreateOptions(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIRewriterCreateOptions.prototype.initDefaults_ = function() {
    this.sharedContext = null;
    this.tone = 0;
    this.format = 0;
    this.length = 0;
    this.expectedInputLanguages = null;
    this.expectedContextLanguages = null;
    this.outputLanguage = null;
  };
  AIRewriterCreateOptions.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIRewriterCreateOptions.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.sharedContext
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.tone
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AIRewriterTone);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.format
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AIRewriterFormat);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.length
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, AIRewriterLength);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.expectedInputLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.expectedContextLanguages
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ai_common$.AILanguageCode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriterCreateOptions.outputLanguage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, ai_common$.AILanguageCode, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIRewriterCreateOptions.encodedSize = codec.kStructHeaderSize + 48;

  AIRewriterCreateOptions.decode = function(decoder) {
    var packed;
    var val = new AIRewriterCreateOptions();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sharedContext =
        decoder.decodeStruct(codec.String);
    val.tone =
        decoder.decodeStruct(new codec.Enum(AIRewriterTone));
    val.format =
        decoder.decodeStruct(new codec.Enum(AIRewriterFormat));
    val.length =
        decoder.decodeStruct(new codec.Enum(AIRewriterLength));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.expectedInputLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.expectedContextLanguages =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode));
    val.outputLanguage =
        decoder.decodeStructPointer(ai_common$.AILanguageCode);
    return val;
  };

  AIRewriterCreateOptions.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIRewriterCreateOptions.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sharedContext);
    encoder.encodeStruct(codec.Int32, val.tone);
    encoder.encodeStruct(codec.Int32, val.format);
    encoder.encodeStruct(codec.Int32, val.length);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedInputLanguages);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_common$.AILanguageCode), val.expectedContextLanguages);
    encoder.encodeStructPointer(ai_common$.AILanguageCode, val.outputLanguage);
  };
  function AIRewriter_Rewrite_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIRewriter_Rewrite_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
    this.pendingResponder = new model_streaming_responder$.ModelStreamingResponderPtr();
  };
  AIRewriter_Rewrite_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIRewriter_Rewrite_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriter_Rewrite_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriter_Rewrite_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, true)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriter_Rewrite_Params.pendingResponder
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIRewriter_Rewrite_Params.encodedSize = codec.kStructHeaderSize + 24;

  AIRewriter_Rewrite_Params.decode = function(decoder) {
    var packed;
    var val = new AIRewriter_Rewrite_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    val.pendingResponder =
        decoder.decodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr));
    return val;
  };

  AIRewriter_Rewrite_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIRewriter_Rewrite_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
    encoder.encodeStruct(new codec.Interface(model_streaming_responder$.ModelStreamingResponderPtr), val.pendingResponder);
  };
  function AIRewriter_MeasureUsage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIRewriter_MeasureUsage_Params.prototype.initDefaults_ = function() {
    this.input = null;
    this.context = null;
  };
  AIRewriter_MeasureUsage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIRewriter_MeasureUsage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriter_MeasureUsage_Params.input
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AIRewriter_MeasureUsage_Params.context
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AIRewriter_MeasureUsage_Params.encodedSize = codec.kStructHeaderSize + 16;

  AIRewriter_MeasureUsage_Params.decode = function(decoder) {
    var packed;
    var val = new AIRewriter_MeasureUsage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.input =
        decoder.decodeStruct(codec.String);
    val.context =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AIRewriter_MeasureUsage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIRewriter_MeasureUsage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.input);
    encoder.encodeStruct(codec.String, val.context);
  };
  function AIRewriter_MeasureUsage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AIRewriter_MeasureUsage_ResponseParams.prototype.initDefaults_ = function() {
    this.number_of_tokens_$flag = false;
    this.number_of_tokens_$value = 0;
  };
  AIRewriter_MeasureUsage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AIRewriter_MeasureUsage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  AIRewriter_MeasureUsage_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AIRewriter_MeasureUsage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AIRewriter_MeasureUsage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.number_of_tokens_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.number_of_tokens_$value =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  AIRewriter_MeasureUsage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AIRewriter_MeasureUsage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.number_of_tokens_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.number_of_tokens_$value);
  };
  var kAIRewriter_Rewrite_Name = 0;
  var kAIRewriter_MeasureUsage_Name = 1;

  function AIRewriterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AIRewriter,
                                                   handleOrPtrInfo);
  }

  function AIRewriterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AIRewriter, associatedInterfacePtrInfo);
  }

  AIRewriterAssociatedPtr.prototype =
      Object.create(AIRewriterPtr.prototype);
  AIRewriterAssociatedPtr.prototype.constructor =
      AIRewriterAssociatedPtr;

  function AIRewriterProxy(receiver) {
    this.receiver_ = receiver;
  }
  AIRewriterPtr.prototype.rewrite = function() {
    return AIRewriterProxy.prototype.rewrite
        .apply(this.ptr.getProxy(), arguments);
  };

  AIRewriterProxy.prototype.rewrite = function(input, context, pendingResponder) {
    var params_ = new AIRewriter_Rewrite_Params();
    params_.input = input;
    params_.context = context;
    params_.pendingResponder = pendingResponder;
    var builder = new codec.MessageV0Builder(
        kAIRewriter_Rewrite_Name,
        codec.align(AIRewriter_Rewrite_Params.encodedSize));
    builder.encodeStruct(AIRewriter_Rewrite_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AIRewriterPtr.prototype.measureUsage = function() {
    return AIRewriterProxy.prototype.measureUsage
        .apply(this.ptr.getProxy(), arguments);
  };

  AIRewriterProxy.prototype.measureUsage = function(input, context) {
    var params_ = new AIRewriter_MeasureUsage_Params();
    params_.input = input;
    params_.context = context;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAIRewriter_MeasureUsage_Name,
          codec.align(AIRewriter_MeasureUsage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AIRewriter_MeasureUsage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AIRewriter_MeasureUsage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AIRewriterStub(delegate) {
    this.delegate_ = delegate;
  }
  AIRewriterStub.prototype.rewrite = function(input, context, pendingResponder) {
    return this.delegate_ && this.delegate_.rewrite && this.delegate_.rewrite(input, context, pendingResponder);
  }
  AIRewriterStub.prototype.measureUsage = function(input, context) {
    return this.delegate_ && this.delegate_.measureUsage && this.delegate_.measureUsage(input, context);
  }

  AIRewriterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIRewriter_Rewrite_Name:
      var params = reader.decodeStruct(AIRewriter_Rewrite_Params);
      this.rewrite(params.input, params.context, params.pendingResponder);
      return true;
    default:
      return false;
    }
  };

  AIRewriterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAIRewriter_MeasureUsage_Name:
      var params = reader.decodeStruct(AIRewriter_MeasureUsage_Params);
      this.measureUsage(params.input, params.context).then(function(response) {
        var responseParams =
            new AIRewriter_MeasureUsage_ResponseParams();
        responseParams.numberOfTokens = response.numberOfTokens;
        var builder = new codec.MessageV1Builder(
            kAIRewriter_MeasureUsage_Name,
            codec.align(AIRewriter_MeasureUsage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AIRewriter_MeasureUsage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAIRewriterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAIRewriter_Rewrite_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AIRewriter_Rewrite_Params;
      break;
      case kAIRewriter_MeasureUsage_Name:
        if (message.expectsResponse())
          paramsClass = AIRewriter_MeasureUsage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAIRewriterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAIRewriter_MeasureUsage_Name:
        if (message.isResponse())
          paramsClass = AIRewriter_MeasureUsage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AIRewriter = {
    name: 'blink.mojom.AIRewriter',
    kVersion: 0,
    ptrClass: AIRewriterPtr,
    proxyClass: AIRewriterProxy,
    stubClass: AIRewriterStub,
    validateRequest: validateAIRewriterRequest,
    validateResponse: validateAIRewriterResponse,
  };
  AIRewriterStub.prototype.validator = validateAIRewriterRequest;
  AIRewriterProxy.prototype.validator = validateAIRewriterResponse;
  exports.AIRewriterTone = AIRewriterTone;
  exports.AIRewriterFormat = AIRewriterFormat;
  exports.AIRewriterLength = AIRewriterLength;
  exports.AIRewriterCreateOptions = AIRewriterCreateOptions;
  exports.AIRewriter = AIRewriter;
  exports.AIRewriterPtr = AIRewriterPtr;
  exports.AIRewriterAssociatedPtr = AIRewriterAssociatedPtr;
})();