// third_party/blink/public/mojom/ai/ai_proofreader.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_PROOFREADER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_PROOFREADER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_proofreader.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_common.mojom.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class AIProofreaderProxy;

template <typename ImplRefTraits>
class AIProofreaderStub;

class AIProofreaderRequestValidator;


class BLINK_COMMON_EXPORT AIProofreader
    : public AIProofreaderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AIProofreader";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AIProofreaderInterfaceBase;
  using Proxy_ = AIProofreaderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AIProofreaderStub<ImplRefTraits>;

  using RequestValidator_ = AIProofreaderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kProofreadMinVersion = 0,
    kGetCorrectionTypeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Proofread_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCorrectionType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AIProofreader() = default;

  virtual void Proofread(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) = 0;

  virtual void GetCorrectionType(const std::string& input, const std::string& corrected_input, const std::string& correction_instruction, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) = 0;
};



class BLINK_COMMON_EXPORT AIProofreaderProxy
    : public AIProofreader {
 public:
  using InterfaceType = AIProofreader;

  explicit AIProofreaderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Proofread(const std::string& input, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) final;
  
  void GetCorrectionType(const std::string& input, const std::string& corrected_input, const std::string& correction_instruction, ::mojo::PendingRemote<::blink::mojom::ModelStreamingResponder> pending_responder) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT AIProofreaderStubDispatch {
 public:
  static bool Accept(AIProofreader* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AIProofreader* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AIProofreader>>
class AIProofreaderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AIProofreaderStub() = default;
  ~AIProofreaderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIProofreaderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIProofreaderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT AIProofreaderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT AIProofreaderCreateOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AIProofreaderCreateOptions, T>::value>;
  using DataView = AIProofreaderCreateOptionsDataView;
  using Data_ = internal::AIProofreaderCreateOptions_Data;

  template <typename... Args>
  static AIProofreaderCreateOptionsPtr New(Args&&... args) {
    return AIProofreaderCreateOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AIProofreaderCreateOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AIProofreaderCreateOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AIProofreaderCreateOptions>::Convert(*this);
  }


  AIProofreaderCreateOptions();

  AIProofreaderCreateOptions(
      bool include_correction_types,
      bool include_correction_explanations,
      ::blink::mojom::AILanguageCodePtr correction_explanation_language,
      std::vector<::blink::mojom::AILanguageCodePtr> expected_input_languages);

AIProofreaderCreateOptions(const AIProofreaderCreateOptions&) = delete;
AIProofreaderCreateOptions& operator=(const AIProofreaderCreateOptions&) = delete;

  ~AIProofreaderCreateOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AIProofreaderCreateOptionsPtr>
  AIProofreaderCreateOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIProofreaderCreateOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AIProofreaderCreateOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AIProofreaderCreateOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AIProofreaderCreateOptions_UnserializedMessageContext<
            UserType, AIProofreaderCreateOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AIProofreaderCreateOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AIProofreaderCreateOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AIProofreaderCreateOptions_UnserializedMessageContext<
            UserType, AIProofreaderCreateOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AIProofreaderCreateOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_correction_types;
  
  bool include_correction_explanations;
  
  ::blink::mojom::AILanguageCodePtr correction_explanation_language;
  
  std::vector<::blink::mojom::AILanguageCodePtr> expected_input_languages;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AIProofreaderCreateOptionsPtr AIProofreaderCreateOptions::Clone() const {
  return New(
      mojo::Clone(include_correction_types),
      mojo::Clone(include_correction_explanations),
      mojo::Clone(correction_explanation_language),
      mojo::Clone(expected_input_languages)
  );
}

template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>*>
bool AIProofreaderCreateOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_correction_types, other_struct.include_correction_types))
    return false;
  if (!mojo::Equals(this->include_correction_explanations, other_struct.include_correction_explanations))
    return false;
  if (!mojo::Equals(this->correction_explanation_language, other_struct.correction_explanation_language))
    return false;
  if (!mojo::Equals(this->expected_input_languages, other_struct.expected_input_languages))
    return false;
  return true;
}

template <typename T, AIProofreaderCreateOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_correction_types < rhs.include_correction_types)
    return true;
  if (rhs.include_correction_types < lhs.include_correction_types)
    return false;
  if (lhs.include_correction_explanations < rhs.include_correction_explanations)
    return true;
  if (rhs.include_correction_explanations < lhs.include_correction_explanations)
    return false;
  if (lhs.correction_explanation_language < rhs.correction_explanation_language)
    return true;
  if (rhs.correction_explanation_language < lhs.correction_explanation_language)
    return false;
  if (lhs.expected_input_languages < rhs.expected_input_languages)
    return true;
  if (rhs.expected_input_languages < lhs.expected_input_languages)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AIProofreaderCreateOptions::DataView,
                                         ::blink::mojom::AIProofreaderCreateOptionsPtr> {
  static bool IsNull(const ::blink::mojom::AIProofreaderCreateOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AIProofreaderCreateOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::AIProofreaderCreateOptions::include_correction_types) include_correction_types(
      const ::blink::mojom::AIProofreaderCreateOptionsPtr& input) {
    return input->include_correction_types;
  }

  static decltype(::blink::mojom::AIProofreaderCreateOptions::include_correction_explanations) include_correction_explanations(
      const ::blink::mojom::AIProofreaderCreateOptionsPtr& input) {
    return input->include_correction_explanations;
  }

  static const decltype(::blink::mojom::AIProofreaderCreateOptions::correction_explanation_language)& correction_explanation_language(
      const ::blink::mojom::AIProofreaderCreateOptionsPtr& input) {
    return input->correction_explanation_language;
  }

  static const decltype(::blink::mojom::AIProofreaderCreateOptions::expected_input_languages)& expected_input_languages(
      const ::blink::mojom::AIProofreaderCreateOptionsPtr& input) {
    return input->expected_input_languages;
  }

  static bool Read(::blink::mojom::AIProofreaderCreateOptions::DataView input, ::blink::mojom::AIProofreaderCreateOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_PROOFREADER_MOJOM_H_