// third_party/blink/public/mojom/ai/ai_language_model.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/ai/ai_language_model.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/on_device_model/public/mojom/on_device_model.mojom-blink.h"
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "third_party/blink/public/mojom/ai/ai_common.mojom-blink.h"
#include "third_party/blink/public/mojom/ai/model_streaming_responder.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AIManagerCreateLanguageModelClientProxy;

template <typename ImplRefTraits>
class AIManagerCreateLanguageModelClientStub;

class AIManagerCreateLanguageModelClientRequestValidator;


class PLATFORM_EXPORT AIManagerCreateLanguageModelClient
    : public AIManagerCreateLanguageModelClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AIManagerCreateLanguageModelClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AIManagerCreateLanguageModelClientInterfaceBase;
  using Proxy_ = AIManagerCreateLanguageModelClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AIManagerCreateLanguageModelClientStub<ImplRefTraits>;

  using RequestValidator_ = AIManagerCreateLanguageModelClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnResultMinVersion = 0,
    kOnErrorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AIManagerCreateLanguageModelClient() = default;

  virtual void OnResult(::mojo::PendingRemote<AILanguageModel> language_model_remote, AILanguageModelInstanceInfoPtr info) = 0;

  virtual void OnError(::blink::mojom::blink::AIManagerCreateClientError error, ::blink::mojom::blink::QuotaErrorInfoPtr quota_error_info) = 0;
};

class AILanguageModelProxy;

template <typename ImplRefTraits>
class AILanguageModelStub;

class AILanguageModelRequestValidator;
class AILanguageModelResponseValidator;


class PLATFORM_EXPORT AILanguageModel
    : public AILanguageModelInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AILanguageModel";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AILanguageModelInterfaceBase;
  using Proxy_ = AILanguageModelProxy;

  template <typename ImplRefTraits>
  using Stub_ = AILanguageModelStub<ImplRefTraits>;

  using RequestValidator_ = AILanguageModelRequestValidator;
  using ResponseValidator_ = AILanguageModelResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPromptMinVersion = 0,
    kAppendMinVersion = 0,
    kForkMinVersion = 0,
    kDestroyMinVersion = 0,
    kMeasureInputUsageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Prompt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Append_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Fork_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Destroy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MeasureInputUsage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AILanguageModel() = default;

  virtual void Prompt(::blink::Vector<AILanguageModelPromptPtr> prompts, ::on_device_model::mojom::blink::ResponseConstraintPtr constraint, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> pending_responder) = 0;

  virtual void Append(::blink::Vector<AILanguageModelPromptPtr> prompts, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> client) = 0;

  virtual void Fork(::mojo::PendingRemote<AIManagerCreateLanguageModelClient> client) = 0;

  virtual void Destroy() = 0;

  using MeasureInputUsageCallback = base::OnceCallback<void(std::optional<uint32_t>)>;
  using MeasureInputUsageMojoCallback = base::OnceCallback<void(std::optional<uint32_t>)>;

  virtual void MeasureInputUsage(::blink::Vector<AILanguageModelPromptPtr> input, MeasureInputUsageCallback callback) = 0;
};



class PLATFORM_EXPORT AIManagerCreateLanguageModelClientProxy
    : public AIManagerCreateLanguageModelClient {
 public:
  using InterfaceType = AIManagerCreateLanguageModelClient;

  explicit AIManagerCreateLanguageModelClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnResult(::mojo::PendingRemote<AILanguageModel> language_model_remote, AILanguageModelInstanceInfoPtr info) final;
  
  void OnError(::blink::mojom::blink::AIManagerCreateClientError error, ::blink::mojom::blink::QuotaErrorInfoPtr quota_error_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT AILanguageModelProxy
    : public AILanguageModel {
 public:
  using InterfaceType = AILanguageModel;

  explicit AILanguageModelProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Prompt(::blink::Vector<AILanguageModelPromptPtr> prompts, ::on_device_model::mojom::blink::ResponseConstraintPtr constraint, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> pending_responder) final;
  
  void Append(::blink::Vector<AILanguageModelPromptPtr> prompts, ::mojo::PendingRemote<::blink::mojom::blink::ModelStreamingResponder> client) final;
  
  void Fork(::mojo::PendingRemote<AIManagerCreateLanguageModelClient> client) final;
  
  void Destroy() final;
  
  void MeasureInputUsage(::blink::Vector<AILanguageModelPromptPtr> input, MeasureInputUsageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AIManagerCreateLanguageModelClientStubDispatch {
 public:
  static bool Accept(AIManagerCreateLanguageModelClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AIManagerCreateLanguageModelClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AIManagerCreateLanguageModelClient>>
class AIManagerCreateLanguageModelClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AIManagerCreateLanguageModelClientStub() = default;
  ~AIManagerCreateLanguageModelClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIManagerCreateLanguageModelClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AIManagerCreateLanguageModelClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AILanguageModelStubDispatch {
 public:
  static bool Accept(AILanguageModel* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AILanguageModel* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AILanguageModel>>
class AILanguageModelStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AILanguageModelStub() = default;
  ~AILanguageModelStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AILanguageModelStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AILanguageModelStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AIManagerCreateLanguageModelClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AILanguageModelRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT AILanguageModelResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT AILanguageModelSamplingParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelSamplingParams, T>::value>;
  using DataView = AILanguageModelSamplingParamsDataView;
  using Data_ = internal::AILanguageModelSamplingParams_Data;

  template <typename... Args>
  static AILanguageModelSamplingParamsPtr New(Args&&... args) {
    return AILanguageModelSamplingParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelSamplingParamsPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelSamplingParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelSamplingParams>::Convert(*this);
  }


  AILanguageModelSamplingParams();

  AILanguageModelSamplingParams(
      uint32_t top_k,
      float temperature);


  ~AILanguageModelSamplingParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelSamplingParamsPtr>
  AILanguageModelSamplingParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelSamplingParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelSamplingParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelSamplingParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelSamplingParams_UnserializedMessageContext<
            UserType, AILanguageModelSamplingParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelSamplingParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelSamplingParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelSamplingParams_UnserializedMessageContext<
            UserType, AILanguageModelSamplingParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelSamplingParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t top_k;
  
  float temperature;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT AILanguageModelPromptContent {
 public:
  using DataView = AILanguageModelPromptContentDataView;
  using Data_ = internal::AILanguageModelPromptContent_Data;
  using Tag = Data_::AILanguageModelPromptContent_Tag;

  template <typename... Args>
  static AILanguageModelPromptContentPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |text|.
  static AILanguageModelPromptContentPtr NewText(
      const ::blink::String& value);
  // Construct an instance holding |bitmap|.
  static AILanguageModelPromptContentPtr NewBitmap(
      const ::SkBitmap& value);
  // Construct an instance holding |audio|.
  static AILanguageModelPromptContentPtr NewAudio(
      ::on_device_model::mojom::blink::AudioDataPtr value);

  template <typename U>
  static AILanguageModelPromptContentPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelPromptContentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelPromptContent>::Convert(*this);
  }
  ~AILanguageModelPromptContent();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AILanguageModelPromptContent(const AILanguageModelPromptContent& other) = delete;
  AILanguageModelPromptContent& operator=(const AILanguageModelPromptContent& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AILanguageModelPromptContentPtr>
  AILanguageModelPromptContentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AILanguageModelPromptContent>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AILanguageModelPromptContent>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_text() const { return tag_ == Tag::kText; }
  const ::blink::String& get_text() const {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  ::blink::String& get_text() {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  void set_text(const ::blink::String& text);

  bool is_bitmap() const { return tag_ == Tag::kBitmap; }
  const ::SkBitmap& get_bitmap() const {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  ::SkBitmap& get_bitmap() {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  void set_bitmap(const ::SkBitmap& bitmap);

  bool is_audio() const { return tag_ == Tag::kAudio; }
  const ::on_device_model::mojom::blink::AudioDataPtr& get_audio() const {
    CHECK(tag_ == Tag::kAudio);
    return data_.audio;
  }
  ::on_device_model::mojom::blink::AudioDataPtr& get_audio() {
    CHECK(tag_ == Tag::kAudio);
    return data_.audio;
  }
  void set_audio(::on_device_model::mojom::blink::AudioDataPtr audio);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelPromptContent::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AILanguageModelPromptContent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
        const ::blink::String& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
        const ::SkBitmap& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
        ::on_device_model::mojom::blink::AudioDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::blink::String text;
    ::SkBitmap bitmap;
    ::on_device_model::mojom::blink::AudioDataPtr audio;
  };

  AILanguageModelPromptContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
      const ::blink::String& value);
  AILanguageModelPromptContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
      const ::SkBitmap& value);
  AILanguageModelPromptContent(
      std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
      ::on_device_model::mojom::blink::AudioDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class PLATFORM_EXPORT AILanguageModelParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelParams, T>::value>;
  using DataView = AILanguageModelParamsDataView;
  using Data_ = internal::AILanguageModelParams_Data;

  template <typename... Args>
  static AILanguageModelParamsPtr New(Args&&... args) {
    return AILanguageModelParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelParamsPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelParams>::Convert(*this);
  }


  AILanguageModelParams();

  AILanguageModelParams(
      AILanguageModelSamplingParamsPtr default_sampling_params,
      AILanguageModelSamplingParamsPtr max_sampling_params);

AILanguageModelParams(const AILanguageModelParams&) = delete;
AILanguageModelParams& operator=(const AILanguageModelParams&) = delete;

  ~AILanguageModelParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelParamsPtr>
  AILanguageModelParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelParams::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelParams::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelParams_UnserializedMessageContext<
            UserType, AILanguageModelParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelParams_UnserializedMessageContext<
            UserType, AILanguageModelParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AILanguageModelSamplingParamsPtr default_sampling_params;
  
  AILanguageModelSamplingParamsPtr max_sampling_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AILanguageModelInstanceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelInstanceInfo, T>::value>;
  using DataView = AILanguageModelInstanceInfoDataView;
  using Data_ = internal::AILanguageModelInstanceInfo_Data;

  template <typename... Args>
  static AILanguageModelInstanceInfoPtr New(Args&&... args) {
    return AILanguageModelInstanceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelInstanceInfoPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelInstanceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelInstanceInfo>::Convert(*this);
  }


  AILanguageModelInstanceInfo();

  AILanguageModelInstanceInfo(
      uint64_t input_quota,
      uint64_t input_usage,
      AILanguageModelSamplingParamsPtr sampling_params,
      std::optional<::blink::Vector<AILanguageModelPromptType>> input_types);

AILanguageModelInstanceInfo(const AILanguageModelInstanceInfo&) = delete;
AILanguageModelInstanceInfo& operator=(const AILanguageModelInstanceInfo&) = delete;

  ~AILanguageModelInstanceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelInstanceInfoPtr>
  AILanguageModelInstanceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelInstanceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelInstanceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelInstanceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelInstanceInfo_UnserializedMessageContext<
            UserType, AILanguageModelInstanceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelInstanceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelInstanceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelInstanceInfo_UnserializedMessageContext<
            UserType, AILanguageModelInstanceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelInstanceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t input_quota;
  
  uint64_t input_usage;
  
  AILanguageModelSamplingParamsPtr sampling_params;
  
  std::optional<::blink::Vector<AILanguageModelPromptType>> input_types;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AILanguageModelExpected {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelExpected, T>::value>;
  using DataView = AILanguageModelExpectedDataView;
  using Data_ = internal::AILanguageModelExpected_Data;

  template <typename... Args>
  static AILanguageModelExpectedPtr New(Args&&... args) {
    return AILanguageModelExpectedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelExpectedPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelExpectedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelExpected>::Convert(*this);
  }


  AILanguageModelExpected();

  AILanguageModelExpected(
      AILanguageModelPromptType type,
      std::optional<::blink::Vector<::blink::mojom::blink::AILanguageCodePtr>> languages);

AILanguageModelExpected(const AILanguageModelExpected&) = delete;
AILanguageModelExpected& operator=(const AILanguageModelExpected&) = delete;

  ~AILanguageModelExpected();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelExpectedPtr>
  AILanguageModelExpectedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelExpected::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AILanguageModelExpected::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelExpected::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelExpected_UnserializedMessageContext<
            UserType, AILanguageModelExpected::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelExpected::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelExpected::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelExpected_UnserializedMessageContext<
            UserType, AILanguageModelExpected::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelExpected::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AILanguageModelPromptType type;
  
  std::optional<::blink::Vector<::blink::mojom::blink::AILanguageCodePtr>> languages;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelExpected::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AILanguageModelPrompt {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelPrompt, T>::value>;
  using DataView = AILanguageModelPromptDataView;
  using Data_ = internal::AILanguageModelPrompt_Data;

  template <typename... Args>
  static AILanguageModelPromptPtr New(Args&&... args) {
    return AILanguageModelPromptPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelPromptPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelPromptPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelPrompt>::Convert(*this);
  }


  AILanguageModelPrompt();

  AILanguageModelPrompt(
      AILanguageModelPromptRole role,
      ::blink::Vector<AILanguageModelPromptContentPtr> content,
      bool is_prefix);

AILanguageModelPrompt(const AILanguageModelPrompt&) = delete;
AILanguageModelPrompt& operator=(const AILanguageModelPrompt&) = delete;

  ~AILanguageModelPrompt();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelPromptPtr>
  AILanguageModelPromptPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelPrompt::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelPrompt_UnserializedMessageContext<
            UserType, AILanguageModelPrompt::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelPrompt::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelPrompt::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelPrompt_UnserializedMessageContext<
            UserType, AILanguageModelPrompt::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelPrompt::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AILanguageModelPromptRole role;
  
  ::blink::Vector<AILanguageModelPromptContentPtr> content;
  
  bool is_prefix;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelPrompt::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AILanguageModelCreateOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AILanguageModelCreateOptions, T>::value>;
  using DataView = AILanguageModelCreateOptionsDataView;
  using Data_ = internal::AILanguageModelCreateOptions_Data;

  template <typename... Args>
  static AILanguageModelCreateOptionsPtr New(Args&&... args) {
    return AILanguageModelCreateOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AILanguageModelCreateOptionsPtr From(const U& u) {
    return mojo::TypeConverter<AILanguageModelCreateOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AILanguageModelCreateOptions>::Convert(*this);
  }


  AILanguageModelCreateOptions();

  AILanguageModelCreateOptions(
      AILanguageModelSamplingParamsPtr sampling_params,
      ::blink::Vector<AILanguageModelPromptPtr> initial_prompts,
      std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_inputs,
      std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_outputs);

AILanguageModelCreateOptions(const AILanguageModelCreateOptions&) = delete;
AILanguageModelCreateOptions& operator=(const AILanguageModelCreateOptions&) = delete;

  ~AILanguageModelCreateOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AILanguageModelCreateOptionsPtr>
  AILanguageModelCreateOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AILanguageModelCreateOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AILanguageModelCreateOptions_UnserializedMessageContext<
            UserType, AILanguageModelCreateOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AILanguageModelCreateOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AILanguageModelCreateOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AILanguageModelCreateOptions_UnserializedMessageContext<
            UserType, AILanguageModelCreateOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AILanguageModelCreateOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AILanguageModelSamplingParamsPtr sampling_params;
  
  ::blink::Vector<AILanguageModelPromptPtr> initial_prompts;
  
  std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_inputs;
  
  std::optional<::blink::Vector<AILanguageModelExpectedPtr>> expected_outputs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
AILanguageModelPromptContentPtr AILanguageModelPromptContent::Clone() const {
  switch (tag_) {
    case Tag::kText:
      return NewText(
          mojo::Clone(data_.text));
    case Tag::kBitmap:
      return NewBitmap(
          mojo::Clone(data_.bitmap));
    case Tag::kAudio:
      return NewAudio(
          mojo::Clone(data_.audio));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AILanguageModelPromptContent>::value>::type*>
bool AILanguageModelPromptContent::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kText:
      return mojo::Equals(data_.text, other.data_.text);
    case Tag::kBitmap:
      return mojo::Equals(data_.bitmap, other.data_.bitmap);
    case Tag::kAudio:
      return mojo::Equals(data_.audio, other.data_.audio);
  }

  return false;
}
template <typename StructPtrType>
AILanguageModelSamplingParamsPtr AILanguageModelSamplingParams::Clone() const {
  return New(
      mojo::Clone(top_k),
      mojo::Clone(temperature)
  );
}

template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>*>
bool AILanguageModelSamplingParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->top_k, other_struct.top_k))
    return false;
  if (!mojo::Equals(this->temperature, other_struct.temperature))
    return false;
  return true;
}

template <typename T, AILanguageModelSamplingParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.top_k < rhs.top_k)
    return true;
  if (rhs.top_k < lhs.top_k)
    return false;
  if (lhs.temperature < rhs.temperature)
    return true;
  if (rhs.temperature < lhs.temperature)
    return false;
  return false;
}
template <typename StructPtrType>
AILanguageModelParamsPtr AILanguageModelParams::Clone() const {
  return New(
      mojo::Clone(default_sampling_params),
      mojo::Clone(max_sampling_params)
  );
}

template <typename T, AILanguageModelParams::EnableIfSame<T>*>
bool AILanguageModelParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_sampling_params, other_struct.default_sampling_params))
    return false;
  if (!mojo::Equals(this->max_sampling_params, other_struct.max_sampling_params))
    return false;
  return true;
}

template <typename T, AILanguageModelParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_sampling_params < rhs.default_sampling_params)
    return true;
  if (rhs.default_sampling_params < lhs.default_sampling_params)
    return false;
  if (lhs.max_sampling_params < rhs.max_sampling_params)
    return true;
  if (rhs.max_sampling_params < lhs.max_sampling_params)
    return false;
  return false;
}
template <typename StructPtrType>
AILanguageModelInstanceInfoPtr AILanguageModelInstanceInfo::Clone() const {
  return New(
      mojo::Clone(input_quota),
      mojo::Clone(input_usage),
      mojo::Clone(sampling_params),
      mojo::Clone(input_types)
  );
}

template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>*>
bool AILanguageModelInstanceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_quota, other_struct.input_quota))
    return false;
  if (!mojo::Equals(this->input_usage, other_struct.input_usage))
    return false;
  if (!mojo::Equals(this->sampling_params, other_struct.sampling_params))
    return false;
  if (!mojo::Equals(this->input_types, other_struct.input_types))
    return false;
  return true;
}

template <typename T, AILanguageModelInstanceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_quota < rhs.input_quota)
    return true;
  if (rhs.input_quota < lhs.input_quota)
    return false;
  if (lhs.input_usage < rhs.input_usage)
    return true;
  if (rhs.input_usage < lhs.input_usage)
    return false;
  if (lhs.sampling_params < rhs.sampling_params)
    return true;
  if (rhs.sampling_params < lhs.sampling_params)
    return false;
  if (lhs.input_types < rhs.input_types)
    return true;
  if (rhs.input_types < lhs.input_types)
    return false;
  return false;
}
template <typename StructPtrType>
AILanguageModelExpectedPtr AILanguageModelExpected::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(languages)
  );
}

template <typename T, AILanguageModelExpected::EnableIfSame<T>*>
bool AILanguageModelExpected::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->languages, other_struct.languages))
    return false;
  return true;
}

template <typename T, AILanguageModelExpected::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.languages < rhs.languages)
    return true;
  if (rhs.languages < lhs.languages)
    return false;
  return false;
}
template <typename StructPtrType>
AILanguageModelPromptPtr AILanguageModelPrompt::Clone() const {
  return New(
      mojo::Clone(role),
      mojo::Clone(content),
      mojo::Clone(is_prefix)
  );
}

template <typename T, AILanguageModelPrompt::EnableIfSame<T>*>
bool AILanguageModelPrompt::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->role, other_struct.role))
    return false;
  if (!mojo::Equals(this->content, other_struct.content))
    return false;
  if (!mojo::Equals(this->is_prefix, other_struct.is_prefix))
    return false;
  return true;
}

template <typename T, AILanguageModelPrompt::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.role < rhs.role)
    return true;
  if (rhs.role < lhs.role)
    return false;
  if (lhs.content < rhs.content)
    return true;
  if (rhs.content < lhs.content)
    return false;
  if (lhs.is_prefix < rhs.is_prefix)
    return true;
  if (rhs.is_prefix < lhs.is_prefix)
    return false;
  return false;
}
template <typename StructPtrType>
AILanguageModelCreateOptionsPtr AILanguageModelCreateOptions::Clone() const {
  return New(
      mojo::Clone(sampling_params),
      mojo::Clone(initial_prompts),
      mojo::Clone(expected_inputs),
      mojo::Clone(expected_outputs)
  );
}

template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>*>
bool AILanguageModelCreateOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sampling_params, other_struct.sampling_params))
    return false;
  if (!mojo::Equals(this->initial_prompts, other_struct.initial_prompts))
    return false;
  if (!mojo::Equals(this->expected_inputs, other_struct.expected_inputs))
    return false;
  if (!mojo::Equals(this->expected_outputs, other_struct.expected_outputs))
    return false;
  return true;
}

template <typename T, AILanguageModelCreateOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sampling_params < rhs.sampling_params)
    return true;
  if (rhs.sampling_params < lhs.sampling_params)
    return false;
  if (lhs.initial_prompts < rhs.initial_prompts)
    return true;
  if (rhs.initial_prompts < lhs.initial_prompts)
    return false;
  if (lhs.expected_inputs < rhs.expected_inputs)
    return true;
  if (rhs.expected_inputs < lhs.expected_inputs)
    return false;
  if (lhs.expected_outputs < rhs.expected_outputs)
    return true;
  if (rhs.expected_outputs < lhs.expected_outputs)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelSamplingParams::DataView,
                                         ::blink::mojom::blink::AILanguageModelSamplingParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelSamplingParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelSamplingParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AILanguageModelSamplingParams::top_k) top_k(
      const ::blink::mojom::blink::AILanguageModelSamplingParamsPtr& input) {
    return input->top_k;
  }

  static decltype(::blink::mojom::blink::AILanguageModelSamplingParams::temperature) temperature(
      const ::blink::mojom::blink::AILanguageModelSamplingParamsPtr& input) {
    return input->temperature;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelSamplingParams::DataView input, ::blink::mojom::blink::AILanguageModelSamplingParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelParams::DataView,
                                         ::blink::mojom::blink::AILanguageModelParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AILanguageModelParams::default_sampling_params)& default_sampling_params(
      const ::blink::mojom::blink::AILanguageModelParamsPtr& input) {
    return input->default_sampling_params;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelParams::max_sampling_params)& max_sampling_params(
      const ::blink::mojom::blink::AILanguageModelParamsPtr& input) {
    return input->max_sampling_params;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelParams::DataView input, ::blink::mojom::blink::AILanguageModelParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelInstanceInfo::DataView,
                                         ::blink::mojom::blink::AILanguageModelInstanceInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelInstanceInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelInstanceInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AILanguageModelInstanceInfo::input_quota) input_quota(
      const ::blink::mojom::blink::AILanguageModelInstanceInfoPtr& input) {
    return input->input_quota;
  }

  static decltype(::blink::mojom::blink::AILanguageModelInstanceInfo::input_usage) input_usage(
      const ::blink::mojom::blink::AILanguageModelInstanceInfoPtr& input) {
    return input->input_usage;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelInstanceInfo::sampling_params)& sampling_params(
      const ::blink::mojom::blink::AILanguageModelInstanceInfoPtr& input) {
    return input->sampling_params;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelInstanceInfo::input_types)& input_types(
      const ::blink::mojom::blink::AILanguageModelInstanceInfoPtr& input) {
    return input->input_types;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelInstanceInfo::DataView input, ::blink::mojom::blink::AILanguageModelInstanceInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelExpected::DataView,
                                         ::blink::mojom::blink::AILanguageModelExpectedPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelExpectedPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelExpectedPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AILanguageModelExpected::type) type(
      const ::blink::mojom::blink::AILanguageModelExpectedPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelExpected::languages)& languages(
      const ::blink::mojom::blink::AILanguageModelExpectedPtr& input) {
    return input->languages;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelExpected::DataView input, ::blink::mojom::blink::AILanguageModelExpectedPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelPrompt::DataView,
                                         ::blink::mojom::blink::AILanguageModelPromptPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelPromptPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelPromptPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AILanguageModelPrompt::role) role(
      const ::blink::mojom::blink::AILanguageModelPromptPtr& input) {
    return input->role;
  }

  static  decltype(::blink::mojom::blink::AILanguageModelPrompt::content)& content(
       ::blink::mojom::blink::AILanguageModelPromptPtr& input) {
    return input->content;
  }

  static decltype(::blink::mojom::blink::AILanguageModelPrompt::is_prefix) is_prefix(
      const ::blink::mojom::blink::AILanguageModelPromptPtr& input) {
    return input->is_prefix;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelPrompt::DataView input, ::blink::mojom::blink::AILanguageModelPromptPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AILanguageModelCreateOptions::DataView,
                                         ::blink::mojom::blink::AILanguageModelCreateOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelCreateOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelCreateOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AILanguageModelCreateOptions::sampling_params)& sampling_params(
      const ::blink::mojom::blink::AILanguageModelCreateOptionsPtr& input) {
    return input->sampling_params;
  }

  static  decltype(::blink::mojom::blink::AILanguageModelCreateOptions::initial_prompts)& initial_prompts(
       ::blink::mojom::blink::AILanguageModelCreateOptionsPtr& input) {
    return input->initial_prompts;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelCreateOptions::expected_inputs)& expected_inputs(
      const ::blink::mojom::blink::AILanguageModelCreateOptionsPtr& input) {
    return input->expected_inputs;
  }

  static const decltype(::blink::mojom::blink::AILanguageModelCreateOptions::expected_outputs)& expected_outputs(
      const ::blink::mojom::blink::AILanguageModelCreateOptionsPtr& input) {
    return input->expected_outputs;
  }

  static bool Read(::blink::mojom::blink::AILanguageModelCreateOptions::DataView input, ::blink::mojom::blink::AILanguageModelCreateOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT UnionTraits<::blink::mojom::blink::AILanguageModelPromptContent::DataView,
                                        ::blink::mojom::blink::AILanguageModelPromptContentPtr> {
  static bool IsNull(const ::blink::mojom::blink::AILanguageModelPromptContentPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AILanguageModelPromptContentPtr* output) { output->reset(); }

  static ::blink::mojom::blink::AILanguageModelPromptContent::Tag GetTag(const ::blink::mojom::blink::AILanguageModelPromptContentPtr& input) {
    return input->which();
  }

  static const ::blink::String& text(const ::blink::mojom::blink::AILanguageModelPromptContentPtr& input) {
    return input->get_text();
  }

  static  ::SkBitmap& bitmap( ::blink::mojom::blink::AILanguageModelPromptContentPtr& input) {
    return input->get_bitmap();
  }

  static const ::on_device_model::mojom::blink::AudioDataPtr& audio(const ::blink::mojom::blink::AILanguageModelPromptContentPtr& input) {
    return input->get_audio();
  }

  static bool Read(::blink::mojom::blink::AILanguageModelPromptContent::DataView input, ::blink::mojom::blink::AILanguageModelPromptContentPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_AI_AI_LANGUAGE_MODEL_MOJOM_BLINK_H_