// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated from template:
//   templates/runtime_feature_state_context.h.tmpl
// and input files:
//   ../../third_party/blink/renderer/platform/runtime_enabled_features.json5


#ifndef THIRD_PARTY_BLINK_PUBLIC_COMMON_RUNTIME_FEATURE_STATE_RUNTIME_FEATURE_STATE_CONTEXT_H_
#define THIRD_PARTY_BLINK_PUBLIC_COMMON_RUNTIME_FEATURE_STATE_RUNTIME_FEATURE_STATE_CONTEXT_H_

#include "base/containers/flat_map.h"
#include "third_party/blink/public/common/common_export.h"
#include "third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom-shared.h"
#include "third_party/blink/public/common/runtime_feature_state/runtime_feature_state_read_context.h"

namespace blink {

// This class, and its parent class, contain the feature states for blink
// runtime features which have opted in via the
// browser_process_read_write_access and browser_process_read_access parameters
// in runtime_enabled_features.json5. It collapses feature values from selected
// sources such as base::features, enterprise policy, and origin trial into a
// final value that browser and renderer processes can use.
//
// Specifically, this class allows for read/write access from the browser
// process prior to a page's navigation committing. Post navigation commit this
// class is changed to a RuntimeFeatureStateReadContext which is not mutable
// from the browser process but may receive updates from a renderer process for
// features which allow overrides from origin trials.

class BLINK_COMMON_EXPORT RuntimeFeatureStateContext
    : public RuntimeFeatureStateReadContext {
 public:
  explicit RuntimeFeatureStateContext() { PopulateInitialValues(); }

  // Note: The Is*Enabled() functions are defined in the parent class.

  void SetBlinkExtensionChromeOSEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kBlinkExtensionChromeOS,
        enabled);
  }
  void SetBlinkExtensionChromeOSKioskEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kBlinkExtensionChromeOSKiosk,
        enabled);
  }
  void SetBlockCanvasReadbackEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kBlockCanvasReadback,
        enabled);
  }
  void SetGetDisplayMediaWindowAudioCaptureEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kGetDisplayMediaWindowAudioCapture,
        enabled);
  }
  void SetOriginTrialsSampleAPIBrowserReadWriteEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kOriginTrialsSampleAPIBrowserReadWrite,
        enabled);
  }
  void SetTestFeatureEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kTestFeature,
        enabled);
  }
  void SetTestFeatureForBrowserProcessReadWriteAccessOriginTrialEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kTestFeatureForBrowserProcessReadWriteAccessOriginTrial,
        enabled);
  }
  void SetThirdPartyStoragePartitioningUserBypassEnabled(bool enabled) {
    return SetIsEnabled(
        blink::mojom::RuntimeFeature::kThirdPartyStoragePartitioningUserBypass,
        enabled);
  }

 private:
  void PopulateInitialValues();

  void SetIsEnabled(blink::mojom::RuntimeFeature feature, bool enabled) {
    feature_overrides_[feature] = enabled;
  }
};

}  // namespace blink

#endif // THIRD_PARTY_BLINK_PUBLIC_COMMON_RUNTIME_FEATURE_STATE_RUNTIME_FEATURE_STATE_CONTEXT_H_
