// storage/browser/quota/quota_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_H_
#define STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "storage/browser/quota/quota_internals.mojom-features.h"  // IWYU pragma: export
#include "storage/browser/quota/quota_internals.mojom-shared.h"  // IWYU pragma: export
#include "storage/browser/quota/quota_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "third_party/blink/public/mojom/quota/quota_types.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace storage::mojom {

class QuotaInternalsHandlerProxy;

template <typename ImplRefTraits>
class QuotaInternalsHandlerStub;

class QuotaInternalsHandlerRequestValidator;
class QuotaInternalsHandlerResponseValidator;


class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandler
    : public QuotaInternalsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "storage.mojom.QuotaInternalsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = QuotaInternalsHandlerInterfaceBase;
  using Proxy_ = QuotaInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuotaInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = QuotaInternalsHandlerRequestValidator;
  using ResponseValidator_ = QuotaInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDiskAvailabilityAndTempPoolSizeMinVersion = 0,
    kGetStatisticsMinVersion = 0,
    kSimulateStoragePressureMinVersion = 0,
    kRetrieveBucketsTableMinVersion = 0,
    kGetGlobalUsageForInternalsMinVersion = 0,
    kIsSimulateStoragePressureAvailableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDiskAvailabilityAndTempPoolSize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStatistics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SimulateStoragePressure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RetrieveBucketsTable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetGlobalUsageForInternals_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsSimulateStoragePressureAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~QuotaInternalsHandler() = default;

  using GetDiskAvailabilityAndTempPoolSizeCallback = base::OnceCallback<void(int64_t, int64_t, int64_t)>;
  using GetDiskAvailabilityAndTempPoolSizeMojoCallback = base::OnceCallback<void(int64_t, int64_t, int64_t)>;

  virtual void GetDiskAvailabilityAndTempPoolSize(GetDiskAvailabilityAndTempPoolSizeCallback callback) = 0;

  using GetStatisticsCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;
  using GetStatisticsMojoCallback = base::OnceCallback<void(const base::flat_map<std::string, std::string>&)>;

  virtual void GetStatistics(GetStatisticsCallback callback) = 0;

  virtual void SimulateStoragePressure(const ::url::Origin& origin_url) = 0;

  using RetrieveBucketsTableCallback = base::OnceCallback<void(std::vector<BucketTableEntryPtr>)>;
  using RetrieveBucketsTableMojoCallback = base::OnceCallback<void(std::vector<BucketTableEntryPtr>)>;

  virtual void RetrieveBucketsTable(RetrieveBucketsTableCallback callback) = 0;

  using GetGlobalUsageForInternalsCallback = base::OnceCallback<void(int64_t, int64_t)>;
  using GetGlobalUsageForInternalsMojoCallback = base::OnceCallback<void(int64_t, int64_t)>;

  virtual void GetGlobalUsageForInternals(GetGlobalUsageForInternalsCallback callback) = 0;

  using IsSimulateStoragePressureAvailableCallback = base::OnceCallback<void(bool)>;
  using IsSimulateStoragePressureAvailableMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsSimulateStoragePressureAvailable(IsSimulateStoragePressureAvailableCallback callback) = 0;
};



class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerProxy
    : public QuotaInternalsHandler {
 public:
  using InterfaceType = QuotaInternalsHandler;

  explicit QuotaInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDiskAvailabilityAndTempPoolSize(GetDiskAvailabilityAndTempPoolSizeCallback callback) final;
  
  void GetStatistics(GetStatisticsCallback callback) final;
  
  void SimulateStoragePressure(const ::url::Origin& origin_url) final;
  
  void RetrieveBucketsTable(RetrieveBucketsTableCallback callback) final;
  
  void GetGlobalUsageForInternals(GetGlobalUsageForInternalsCallback callback) final;
  
  void IsSimulateStoragePressureAvailable(IsSimulateStoragePressureAvailableCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerStubDispatch {
 public:
  static bool Accept(QuotaInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuotaInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuotaInternalsHandler>>
class QuotaInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuotaInternalsHandlerStub() = default;
  ~QuotaInternalsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuotaInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) QuotaInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) BucketTableEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BucketTableEntry, T>::value>;
  using DataView = BucketTableEntryDataView;
  using Data_ = internal::BucketTableEntry_Data;

  template <typename... Args>
  static BucketTableEntryPtr New(Args&&... args) {
    return BucketTableEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BucketTableEntryPtr From(const U& u) {
    return mojo::TypeConverter<BucketTableEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BucketTableEntry>::Convert(*this);
  }


  BucketTableEntry();

  BucketTableEntry(
      int64_t bucket_id,
      const std::string& storage_key,
      const std::string& name,
      int64_t usage,
      int64_t use_count,
      ::base::Time last_accessed,
      ::base::Time last_modified);


  ~BucketTableEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BucketTableEntryPtr>
  BucketTableEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketTableEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BucketTableEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BucketTableEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BucketTableEntry_UnserializedMessageContext<
            UserType, BucketTableEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BucketTableEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BucketTableEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BucketTableEntry_UnserializedMessageContext<
            UserType, BucketTableEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BucketTableEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t bucket_id;
  
  std::string storage_key;
  
  std::string name;
  
  int64_t usage;
  
  int64_t use_count;
  
  ::base::Time last_accessed;
  
  ::base::Time last_modified;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BucketTableEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BucketTableEntryPtr BucketTableEntry::Clone() const {
  return New(
      mojo::Clone(bucket_id),
      mojo::Clone(storage_key),
      mojo::Clone(name),
      mojo::Clone(usage),
      mojo::Clone(use_count),
      mojo::Clone(last_accessed),
      mojo::Clone(last_modified)
  );
}

template <typename T, BucketTableEntry::EnableIfSame<T>*>
bool BucketTableEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->bucket_id, other_struct.bucket_id))
    return false;
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->use_count, other_struct.use_count))
    return false;
  if (!mojo::Equals(this->last_accessed, other_struct.last_accessed))
    return false;
  if (!mojo::Equals(this->last_modified, other_struct.last_modified))
    return false;
  return true;
}

template <typename T, BucketTableEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.bucket_id < rhs.bucket_id)
    return true;
  if (rhs.bucket_id < lhs.bucket_id)
    return false;
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  if (lhs.use_count < rhs.use_count)
    return true;
  if (rhs.use_count < lhs.use_count)
    return false;
  if (lhs.last_accessed < rhs.last_accessed)
    return true;
  if (rhs.last_accessed < lhs.last_accessed)
    return false;
  if (lhs.last_modified < rhs.last_modified)
    return true;
  if (rhs.last_modified < lhs.last_modified)
    return false;
  return false;
}


}  // storage::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(STORAGE_BROWSER_INTERFACES) StructTraits<::storage::mojom::BucketTableEntry::DataView,
                                         ::storage::mojom::BucketTableEntryPtr> {
  static bool IsNull(const ::storage::mojom::BucketTableEntryPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::BucketTableEntryPtr* output) { output->reset(); }

  static decltype(::storage::mojom::BucketTableEntry::bucket_id) bucket_id(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->bucket_id;
  }

  static const decltype(::storage::mojom::BucketTableEntry::storage_key)& storage_key(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->storage_key;
  }

  static const decltype(::storage::mojom::BucketTableEntry::name)& name(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->name;
  }

  static decltype(::storage::mojom::BucketTableEntry::usage) usage(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->usage;
  }

  static decltype(::storage::mojom::BucketTableEntry::use_count) use_count(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->use_count;
  }

  static const decltype(::storage::mojom::BucketTableEntry::last_accessed)& last_accessed(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->last_accessed;
  }

  static const decltype(::storage::mojom::BucketTableEntry::last_modified)& last_modified(
      const ::storage::mojom::BucketTableEntryPtr& input) {
    return input->last_modified;
  }

  static bool Read(::storage::mojom::BucketTableEntry::DataView input, ::storage::mojom::BucketTableEntryPtr* output);
};

}  // namespace mojo

#endif  // STORAGE_BROWSER_QUOTA_QUOTA_INTERNALS_MOJOM_H_