// skia/public/mojom/image_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_DATA_VIEW_H_
#define SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "skia/public/mojom/image_info.mojom-shared-internal.h"


namespace skia::mojom {
class ImageInfoDataView;

class BitmapN32ImageInfoDataView;



}  // skia::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::skia::mojom::ImageInfoDataView> {
  using Data = ::skia::mojom::internal::ImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::skia::mojom::BitmapN32ImageInfoDataView> {
  using Data = ::skia::mojom::internal::BitmapN32ImageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace skia::mojom {


enum class ColorType : int32_t {
  
  UNKNOWN = 0,
  
  ALPHA_8 = 1,
  
  RGB_565 = 2,
  
  ARGB_4444 = 3,
  
  RGBA_8888 = 4,
  
  BGRA_8888 = 5,
  
  DEPRECATED_INDEX_8 = 6,
  
  GRAY_8 = 7,
  kMinValue = 0,
  kMaxValue = 7,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorType value);
inline bool IsKnownEnumValue(ColorType value) {
  return internal::ColorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorType ToKnownEnumValue(ColorType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorType::kDefaultValue;
}


enum class AlphaType : int32_t {
  
  UNKNOWN = 0,
  
  ALPHA_TYPE_OPAQUE = 1,
  
  PREMUL = 2,
  
  UNPREMUL = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, AlphaType value);
inline bool IsKnownEnumValue(AlphaType value) {
  return internal::AlphaType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline AlphaType ToKnownEnumValue(AlphaType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return AlphaType::kDefaultValue;
}


class ImageInfoDataView {
 public:
  ImageInfoDataView() = default;

  ImageInfoDataView(
      internal::ImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadColorType(UserType* output) const {
    auto data_value = data_->color_type;
    return mojo::internal::Deserialize<::skia::mojom::ColorType>(
        data_value, output);
  }
  ColorType color_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::ColorType>(data_->color_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetColorTransferFunctionDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTransferFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_transfer_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorTransferFunction` instead "
    "of `ReadColorTransferFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_transfer_function.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetColorToXyzMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorToXyzMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_to_xyz_matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorToXyzMatrix` instead "
    "of `ReadColorToXyzMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_to_xyz_matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::ImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BitmapN32ImageInfoDataView {
 public:
  BitmapN32ImageInfoDataView() = default;

  BitmapN32ImageInfoDataView(
      internal::BitmapN32ImageInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAlphaType(UserType* output) const {
    auto data_value = data_->alpha_type;
    return mojo::internal::Deserialize<::skia::mojom::AlphaType>(
        data_value, output);
  }
  AlphaType alpha_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::skia::mojom::AlphaType>(data_->alpha_type));
  }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  inline void GetColorTransferFunctionDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTransferFunction(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_transfer_function` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorTransferFunction` instead "
    "of `ReadColorTransferFunction if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_transfer_function.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetColorToXyzMatrixDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorToXyzMatrix(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<float>, UserType>(),
    "Attempting to read the optional `color_to_xyz_matrix` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorToXyzMatrix` instead "
    "of `ReadColorToXyzMatrix if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_to_xyz_matrix.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::BitmapN32ImageInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // skia::mojom

#endif  // SKIA_PUBLIC_MOJOM_IMAGE_INFO_MOJOM_DATA_VIEW_H_