// skia/public/mojom/bitmap.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_BLINK_H_
#define SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "skia/public/mojom/bitmap.mojom-features.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-shared.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "skia/public/mojom/image_info.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "skia/public/mojom/bitmap_skbitmap_mojom_traits.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace skia::mojom::blink {











class  BitmapN32 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitmapN32, T>::value>;
  using DataView = BitmapN32DataView;
  using Data_ = internal::BitmapN32_Data;

  template <typename... Args>
  static BitmapN32Ptr New(Args&&... args) {
    return BitmapN32Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitmapN32Ptr From(const U& u) {
    return mojo::TypeConverter<BitmapN32Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitmapN32>::Convert(*this);
  }


  BitmapN32();

  BitmapN32(
      const ::SkImageInfo& image_info,
      ::mojo_base::BigBuffer pixel_data);

BitmapN32(const BitmapN32&) = delete;
BitmapN32& operator=(const BitmapN32&) = delete;

  ~BitmapN32();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitmapN32Ptr>
  BitmapN32Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitmapN32::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitmapN32_UnserializedMessageContext<
            UserType, BitmapN32::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BitmapN32::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BitmapN32::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitmapN32_UnserializedMessageContext<
            UserType, BitmapN32::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitmapN32::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkImageInfo image_info;
  
  ::mojo_base::BigBuffer pixel_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitmapN32::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BitmapWithArbitraryBpp {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitmapWithArbitraryBpp, T>::value>;
  using DataView = BitmapWithArbitraryBppDataView;
  using Data_ = internal::BitmapWithArbitraryBpp_Data;

  template <typename... Args>
  static BitmapWithArbitraryBppPtr New(Args&&... args) {
    return BitmapWithArbitraryBppPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitmapWithArbitraryBppPtr From(const U& u) {
    return mojo::TypeConverter<BitmapWithArbitraryBppPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitmapWithArbitraryBpp>::Convert(*this);
  }


  BitmapWithArbitraryBpp();

  BitmapWithArbitraryBpp(
      const ::SkImageInfo& image_info,
      uint64_t UNUSED_row_bytes,
      ::mojo_base::BigBuffer pixel_data);

BitmapWithArbitraryBpp(const BitmapWithArbitraryBpp&) = delete;
BitmapWithArbitraryBpp& operator=(const BitmapWithArbitraryBpp&) = delete;

  ~BitmapWithArbitraryBpp();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitmapWithArbitraryBppPtr>
  BitmapWithArbitraryBppPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitmapWithArbitraryBpp::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitmapWithArbitraryBpp_UnserializedMessageContext<
            UserType, BitmapWithArbitraryBpp::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BitmapWithArbitraryBpp::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BitmapWithArbitraryBpp::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitmapWithArbitraryBpp_UnserializedMessageContext<
            UserType, BitmapWithArbitraryBpp::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitmapWithArbitraryBpp::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkImageInfo image_info;
  
  uint64_t UNUSED_row_bytes;
  
  ::mojo_base::BigBuffer pixel_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BitmapMappedFromTrustedProcess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BitmapMappedFromTrustedProcess, T>::value>;
  using DataView = BitmapMappedFromTrustedProcessDataView;
  using Data_ = internal::BitmapMappedFromTrustedProcess_Data;

  template <typename... Args>
  static BitmapMappedFromTrustedProcessPtr New(Args&&... args) {
    return BitmapMappedFromTrustedProcessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BitmapMappedFromTrustedProcessPtr From(const U& u) {
    return mojo::TypeConverter<BitmapMappedFromTrustedProcessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BitmapMappedFromTrustedProcess>::Convert(*this);
  }


  BitmapMappedFromTrustedProcess();

  BitmapMappedFromTrustedProcess(
      const ::SkImageInfo& image_info,
      uint64_t UNUSED_row_bytes,
      ::mojo_base::BigBuffer pixel_data);

BitmapMappedFromTrustedProcess(const BitmapMappedFromTrustedProcess&) = delete;
BitmapMappedFromTrustedProcess& operator=(const BitmapMappedFromTrustedProcess&) = delete;

  ~BitmapMappedFromTrustedProcess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BitmapMappedFromTrustedProcessPtr>
  BitmapMappedFromTrustedProcessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BitmapMappedFromTrustedProcess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BitmapMappedFromTrustedProcess_UnserializedMessageContext<
            UserType, BitmapMappedFromTrustedProcess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BitmapMappedFromTrustedProcess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BitmapMappedFromTrustedProcess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BitmapMappedFromTrustedProcess_UnserializedMessageContext<
            UserType, BitmapMappedFromTrustedProcess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BitmapMappedFromTrustedProcess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkImageInfo image_info;
  
  uint64_t UNUSED_row_bytes;
  
  ::mojo_base::BigBuffer pixel_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InlineBitmap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InlineBitmap, T>::value>;
  using DataView = InlineBitmapDataView;
  using Data_ = internal::InlineBitmap_Data;

  template <typename... Args>
  static InlineBitmapPtr New(Args&&... args) {
    return InlineBitmapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InlineBitmapPtr From(const U& u) {
    return mojo::TypeConverter<InlineBitmapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InlineBitmap>::Convert(*this);
  }


  InlineBitmap();

  InlineBitmap(
      const ::SkImageInfo& image_info,
      ::blink::Vector<uint8_t> pixel_data);


  ~InlineBitmap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InlineBitmapPtr>
  InlineBitmapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InlineBitmap::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InlineBitmap::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InlineBitmap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InlineBitmap_UnserializedMessageContext<
            UserType, InlineBitmap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InlineBitmap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InlineBitmap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InlineBitmap_UnserializedMessageContext<
            UserType, InlineBitmap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InlineBitmap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkImageInfo image_info;
  
  ::blink::Vector<uint8_t> pixel_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InlineBitmap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BitmapN32Ptr BitmapN32::Clone() const {
  return New(
      mojo::Clone(image_info),
      mojo::Clone(pixel_data)
  );
}

template <typename T, BitmapN32::EnableIfSame<T>*>
bool BitmapN32::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_info, other_struct.image_info))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  return true;
}

template <typename T, BitmapN32::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_info < rhs.image_info)
    return true;
  if (rhs.image_info < lhs.image_info)
    return false;
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  return false;
}
template <typename StructPtrType>
BitmapWithArbitraryBppPtr BitmapWithArbitraryBpp::Clone() const {
  return New(
      mojo::Clone(image_info),
      mojo::Clone(UNUSED_row_bytes),
      mojo::Clone(pixel_data)
  );
}

template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>*>
bool BitmapWithArbitraryBpp::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_info, other_struct.image_info))
    return false;
  if (!mojo::Equals(this->UNUSED_row_bytes, other_struct.UNUSED_row_bytes))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  return true;
}

template <typename T, BitmapWithArbitraryBpp::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_info < rhs.image_info)
    return true;
  if (rhs.image_info < lhs.image_info)
    return false;
  if (lhs.UNUSED_row_bytes < rhs.UNUSED_row_bytes)
    return true;
  if (rhs.UNUSED_row_bytes < lhs.UNUSED_row_bytes)
    return false;
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  return false;
}
template <typename StructPtrType>
BitmapMappedFromTrustedProcessPtr BitmapMappedFromTrustedProcess::Clone() const {
  return New(
      mojo::Clone(image_info),
      mojo::Clone(UNUSED_row_bytes),
      mojo::Clone(pixel_data)
  );
}

template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>*>
bool BitmapMappedFromTrustedProcess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_info, other_struct.image_info))
    return false;
  if (!mojo::Equals(this->UNUSED_row_bytes, other_struct.UNUSED_row_bytes))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  return true;
}

template <typename T, BitmapMappedFromTrustedProcess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_info < rhs.image_info)
    return true;
  if (rhs.image_info < lhs.image_info)
    return false;
  if (lhs.UNUSED_row_bytes < rhs.UNUSED_row_bytes)
    return true;
  if (rhs.UNUSED_row_bytes < lhs.UNUSED_row_bytes)
    return false;
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  return false;
}
template <typename StructPtrType>
InlineBitmapPtr InlineBitmap::Clone() const {
  return New(
      mojo::Clone(image_info),
      mojo::Clone(pixel_data)
  );
}

template <typename T, InlineBitmap::EnableIfSame<T>*>
bool InlineBitmap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_info, other_struct.image_info))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  return true;
}

template <typename T, InlineBitmap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_info < rhs.image_info)
    return true;
  if (rhs.image_info < lhs.image_info)
    return false;
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  return false;
}


}  // skia::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::skia::mojom::blink::BitmapN32::DataView,
                                         ::skia::mojom::blink::BitmapN32Ptr> {
  static bool IsNull(const ::skia::mojom::blink::BitmapN32Ptr& input) { return !input; }
  static void SetToNull(::skia::mojom::blink::BitmapN32Ptr* output) { output->reset(); }

  static const decltype(::skia::mojom::blink::BitmapN32::image_info)& image_info(
      const ::skia::mojom::blink::BitmapN32Ptr& input) {
    return input->image_info;
  }

  static  decltype(::skia::mojom::blink::BitmapN32::pixel_data)& pixel_data(
       ::skia::mojom::blink::BitmapN32Ptr& input) {
    return input->pixel_data;
  }

  static bool Read(::skia::mojom::blink::BitmapN32::DataView input, ::skia::mojom::blink::BitmapN32Ptr* output);
};


template <>
struct  StructTraits<::skia::mojom::blink::BitmapWithArbitraryBpp::DataView,
                                         ::skia::mojom::blink::BitmapWithArbitraryBppPtr> {
  static bool IsNull(const ::skia::mojom::blink::BitmapWithArbitraryBppPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::blink::BitmapWithArbitraryBppPtr* output) { output->reset(); }

  static const decltype(::skia::mojom::blink::BitmapWithArbitraryBpp::image_info)& image_info(
      const ::skia::mojom::blink::BitmapWithArbitraryBppPtr& input) {
    return input->image_info;
  }

  static decltype(::skia::mojom::blink::BitmapWithArbitraryBpp::UNUSED_row_bytes) UNUSED_row_bytes(
      const ::skia::mojom::blink::BitmapWithArbitraryBppPtr& input) {
    return input->UNUSED_row_bytes;
  }

  static  decltype(::skia::mojom::blink::BitmapWithArbitraryBpp::pixel_data)& pixel_data(
       ::skia::mojom::blink::BitmapWithArbitraryBppPtr& input) {
    return input->pixel_data;
  }

  static bool Read(::skia::mojom::blink::BitmapWithArbitraryBpp::DataView input, ::skia::mojom::blink::BitmapWithArbitraryBppPtr* output);
};


template <>
struct  StructTraits<::skia::mojom::blink::BitmapMappedFromTrustedProcess::DataView,
                                         ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr> {
  static bool IsNull(const ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr* output) { output->reset(); }

  static const decltype(::skia::mojom::blink::BitmapMappedFromTrustedProcess::image_info)& image_info(
      const ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr& input) {
    return input->image_info;
  }

  static decltype(::skia::mojom::blink::BitmapMappedFromTrustedProcess::UNUSED_row_bytes) UNUSED_row_bytes(
      const ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr& input) {
    return input->UNUSED_row_bytes;
  }

  static  decltype(::skia::mojom::blink::BitmapMappedFromTrustedProcess::pixel_data)& pixel_data(
       ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr& input) {
    return input->pixel_data;
  }

  static bool Read(::skia::mojom::blink::BitmapMappedFromTrustedProcess::DataView input, ::skia::mojom::blink::BitmapMappedFromTrustedProcessPtr* output);
};


template <>
struct  StructTraits<::skia::mojom::blink::InlineBitmap::DataView,
                                         ::skia::mojom::blink::InlineBitmapPtr> {
  static bool IsNull(const ::skia::mojom::blink::InlineBitmapPtr& input) { return !input; }
  static void SetToNull(::skia::mojom::blink::InlineBitmapPtr* output) { output->reset(); }

  static const decltype(::skia::mojom::blink::InlineBitmap::image_info)& image_info(
      const ::skia::mojom::blink::InlineBitmapPtr& input) {
    return input->image_info;
  }

  static const decltype(::skia::mojom::blink::InlineBitmap::pixel_data)& pixel_data(
      const ::skia::mojom::blink::InlineBitmapPtr& input) {
    return input->pixel_data;
  }

  static bool Read(::skia::mojom::blink::InlineBitmap::DataView input, ::skia::mojom::blink::InlineBitmapPtr* output);
};

}  // namespace mojo

#endif  // SKIA_PUBLIC_MOJOM_BITMAP_MOJOM_BLINK_H_