// services/webnn/public/mojom/webnn_tensor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_tensor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_tensor.mojom-params-data.h"
namespace webnn {
namespace mojom {

namespace internal {
// static
bool ReadTensorResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ReadTensorResult_Data* object = static_cast<const ReadTensorResult_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ReadTensorResult_Tag::kBuffer: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_buffer, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_buffer,
                                                   validation_context))
        return false;
      return true;
    }
    case ReadTensorResult_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ReadTensorResult");
      return false;
    }
  }
}
// static
bool WebNNTensor_ExportTensor_ResponseParam_Result_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const WebNNTensor_ExportTensor_ResponseParam_Result_Data* object = static_cast<const WebNNTensor_ExportTensor_ResponseParam_Result_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case WebNNTensor_ExportTensor_ResponseParam_Result_Tag::kSuccess: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case WebNNTensor_ExportTensor_ResponseParam_Result_Tag::kFailure: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_failure, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_failure, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in WebNNTensor_ExportTensor_ResponseParam_Result");
      return false;
    }
  }
}


// static
bool TensorUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TensorUsage_Data* object =
      static_cast<const TensorUsage_Data*>(data);

  return true;
}

TensorUsage_Data::TensorUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TensorInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TensorInfo_Data* object =
      static_cast<const TensorInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->descriptor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->descriptor, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->usage, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->usage, validation_context))
    return false;

  return true;
}

TensorInfo_Data::TensorInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_ReadTensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_ReadTensor_Params_Data* object =
      static_cast<const WebNNTensor_ReadTensor_Params_Data*>(data);

  return true;
}

WebNNTensor_ReadTensor_Params_Data::WebNNTensor_ReadTensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_ReadTensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_ReadTensor_ResponseParams_Data* object =
      static_cast<const WebNNTensor_ReadTensor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNTensor_ReadTensor_ResponseParams_Data::WebNNTensor_ReadTensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_WriteTensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_WriteTensor_Params_Data* object =
      static_cast<const WebNNTensor_WriteTensor_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->src_buffer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->src_buffer, validation_context))
    return false;

  return true;
}

WebNNTensor_WriteTensor_Params_Data::WebNNTensor_WriteTensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_ExportTensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_ExportTensor_Params_Data* object =
      static_cast<const WebNNTensor_ExportTensor_Params_Data*>(data);

  return true;
}

WebNNTensor_ExportTensor_Params_Data::WebNNTensor_ExportTensor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_ExportTensor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_ExportTensor_ResponseParams_Data* object =
      static_cast<const WebNNTensor_ExportTensor_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

WebNNTensor_ExportTensor_ResponseParams_Data::WebNNTensor_ExportTensor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebNNTensor_ImportTensor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebNNTensor_ImportTensor_Params_Data* object =
      static_cast<const WebNNTensor_ImportTensor_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fence, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fence, validation_context))
    return false;

  return true;
}

WebNNTensor_ImportTensor_Params_Data::WebNNTensor_ImportTensor_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn