// services/webnn/public/mojom/webnn_graph.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_graph.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_graph.mojom-blink-import-headers.h"
#include "services/webnn/public/mojom/webnn_graph.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace webnn::mojom::blink {
OperandDescriptor::OperandDescriptor()
    : data_type(),
      shape(),
      pending_permutation() {}

OperandDescriptor::OperandDescriptor(
    ::webnn::OperandDataType data_type_in,
    ::blink::Vector<uint32_t> shape_in,
    ::blink::Vector<uint32_t> pending_permutation_in)
    : data_type(std::move(data_type_in)),
      shape(std::move(shape_in)),
      pending_permutation(std::move(pending_permutation_in)) {}

OperandDescriptor::~OperandDescriptor() = default;

void OperandDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_type"), this->data_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::webnn::OperandDataType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shape"), this->shape,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending_permutation"), this->pending_permutation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OperandDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OperandId::OperandId()
    : id() {}

OperandId::OperandId(
    uint32_t id_in)
    : id(std::move(id_in)) {}

OperandId::~OperandId() = default;

void OperandId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OperandId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Operand::Operand()
    : kind(),
      descriptor(mojo::internal::DefaultConstructTag()),
      name() {}

Operand::Operand(
    Operand::Kind kind_in,
    const ::webnn::OperandDescriptor& descriptor_in,
    const ::blink::String& name_in)
    : kind(std::move(kind_in)),
      descriptor(std::move(descriptor_in)),
      name(std::move(name_in)) {}

Operand::~Operand() = default;

void Operand::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Operand::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor"), this->descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandDescriptor&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Operand::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ArgMinMax::ArgMinMax()
    : kind(),
      input_operand_id(),
      output_operand_id(),
      axis(),
      keep_dimensions(false),
      label() {}

ArgMinMax::ArgMinMax(
    ArgMinMax::Kind kind_in,
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    bool keep_dimensions_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      keep_dimensions(std::move(keep_dimensions_in)),
      label(std::move(label_in)) {}

ArgMinMax::~ArgMinMax() = default;

void ArgMinMax::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ArgMinMax::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_dimensions"), this->keep_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ArgMinMax::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BatchNormalization::BatchNormalization()
    : input_operand_id(),
      mean_operand_id(),
      variance_operand_id(),
      output_operand_id(),
      scale_operand_id(),
      bias_operand_id(),
      axis(1U),
      epsilon(1e-5f),
      label() {}

BatchNormalization::BatchNormalization(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& mean_operand_id_in,
    const ::webnn::OperandId& variance_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const std::optional<::webnn::OperandId>& scale_operand_id_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    uint32_t axis_in,
    float epsilon_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      mean_operand_id(std::move(mean_operand_id_in)),
      variance_operand_id(std::move(variance_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      scale_operand_id(std::move(scale_operand_id_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      axis(std::move(axis_in)),
      epsilon(std::move(epsilon_in)),
      label(std::move(label_in)) {}

BatchNormalization::~BatchNormalization() = default;

void BatchNormalization::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mean_operand_id"), this->mean_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variance_operand_id"), this->variance_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_operand_id"), this->scale_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "epsilon"), this->epsilon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BatchNormalization::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Clamp::Clamp()
    : input_operand_id(),
      output_operand_id(),
      min_value(mojo::internal::DefaultConstructTag()),
      max_value(mojo::internal::DefaultConstructTag()),
      label() {}

Clamp::Clamp(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::webnn::MLNumber& min_value_in,
    const ::webnn::MLNumber& max_value_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      min_value(std::move(min_value_in)),
      max_value(std::move(max_value_in)),
      label(std::move(label_in)) {}

Clamp::~Clamp() = default;

void Clamp::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_value"), this->min_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::MLNumber&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_value"), this->max_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::MLNumber&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Clamp::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Concat::Concat()
    : input_operand_ids(),
      output_operand_id(),
      axis(),
      label() {}

Concat::Concat(
    ::blink::Vector<::webnn::OperandId> input_operand_ids_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_ids(std::move(input_operand_ids_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

Concat::~Concat() = default;

void Concat::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_ids"), this->input_operand_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Concat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Size2d::Size2d()
    : height(),
      width() {}

Size2d::Size2d(
    uint32_t height_in,
    uint32_t width_in)
    : height(std::move(height_in)),
      width(std::move(width_in)) {}

Size2d::~Size2d() = default;
size_t Size2d::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->height);
  seed = mojo::internal::WTFHash(seed, this->width);
  return seed;
}

void Size2d::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "width"), this->width,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Size2d::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Padding2d::Padding2d()
    : beginning(),
      ending() {}

Padding2d::Padding2d(
    Size2dPtr beginning_in,
    Size2dPtr ending_in)
    : beginning(std::move(beginning_in)),
      ending(std::move(ending_in)) {}

Padding2d::~Padding2d() = default;
size_t Padding2d::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->beginning);
  seed = mojo::internal::WTFHash(seed, this->ending);
  return seed;
}

void Padding2d::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "beginning"), this->beginning,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ending"), this->ending,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Padding2d::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Conv2d::Conv2d()
    : kind(),
      input_operand_id(),
      filter_operand_id(),
      output_operand_id(),
      padding(),
      strides(),
      dilations(),
      groups(1U),
      bias_operand_id(),
      label() {}

Conv2d::Conv2d(
    Conv2d::Kind kind_in,
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& filter_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    Padding2dPtr padding_in,
    Size2dPtr strides_in,
    Size2dPtr dilations_in,
    uint32_t groups_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      input_operand_id(std::move(input_operand_id_in)),
      filter_operand_id(std::move(filter_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      padding(std::move(padding_in)),
      strides(std::move(strides_in)),
      dilations(std::move(dilations_in)),
      groups(std::move(groups_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      label(std::move(label_in)) {}

Conv2d::~Conv2d() = default;

void Conv2d::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Conv2d::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "filter_operand_id"), this->filter_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "padding"), this->padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Padding2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dilations"), this->dilations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "groups"), this->groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Conv2d::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CumulativeSum::CumulativeSum()
    : input_operand_id(),
      output_operand_id(),
      axis(),
      exclusive(false),
      reversed(false),
      label() {}

CumulativeSum::CumulativeSum(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    bool exclusive_in,
    bool reversed_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      exclusive(std::move(exclusive_in)),
      reversed(std::move(reversed_in)),
      label(std::move(label_in)) {}

CumulativeSum::~CumulativeSum() = default;

void CumulativeSum::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclusive"), this->exclusive,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reversed"), this->reversed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CumulativeSum::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DequantizeLinear::DequantizeLinear()
    : input_operand_id(),
      scale_operand_id(),
      zero_point_operand_id(),
      output_operand_id(),
      label() {}

DequantizeLinear::DequantizeLinear(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& scale_operand_id_in,
    const ::webnn::OperandId& zero_point_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      scale_operand_id(std::move(scale_operand_id_in)),
      zero_point_operand_id(std::move(zero_point_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

DequantizeLinear::~DequantizeLinear() = default;

void DequantizeLinear::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_operand_id"), this->scale_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zero_point_operand_id"), this->zero_point_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DequantizeLinear::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ElementWiseBinary::ElementWiseBinary()
    : kind(),
      lhs_operand_id(),
      rhs_operand_id(),
      output_operand_id(),
      label() {}

ElementWiseBinary::ElementWiseBinary(
    ElementWiseBinary::Kind kind_in,
    const ::webnn::OperandId& lhs_operand_id_in,
    const ::webnn::OperandId& rhs_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      lhs_operand_id(std::move(lhs_operand_id_in)),
      rhs_operand_id(std::move(rhs_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

ElementWiseBinary::~ElementWiseBinary() = default;

void ElementWiseBinary::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ElementWiseBinary::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lhs_operand_id"), this->lhs_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rhs_operand_id"), this->rhs_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ElementWiseBinary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ElementWiseUnary::ElementWiseUnary()
    : kind(),
      input_operand_id(),
      output_operand_id(),
      label() {}

ElementWiseUnary::ElementWiseUnary(
    ElementWiseUnary::Kind kind_in,
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

ElementWiseUnary::~ElementWiseUnary() = default;

void ElementWiseUnary::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ElementWiseUnary::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ElementWiseUnary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Expand::Expand()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Expand::Expand(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Expand::~Expand() = default;

void Expand::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Expand::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConstantPadding::ConstantPadding()
    : value(mojo::internal::DefaultConstructTag()) {}

ConstantPadding::ConstantPadding(
    const ::webnn::MLNumber& value_in)
    : value(std::move(value_in)) {}

ConstantPadding::~ConstantPadding() = default;

void ConstantPadding::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::MLNumber&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConstantPadding::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EdgePadding::EdgePadding() {}

EdgePadding::~EdgePadding() = default;
size_t EdgePadding::Hash(size_t seed) const {
  return seed;
}

void EdgePadding::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool EdgePadding::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReflectionPadding::ReflectionPadding() {}

ReflectionPadding::~ReflectionPadding() = default;
size_t ReflectionPadding::Hash(size_t seed) const {
  return seed;
}

void ReflectionPadding::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool ReflectionPadding::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InstanceNormalization::InstanceNormalization()
    : input_operand_id(),
      output_operand_id(),
      scale_operand_id(),
      bias_operand_id(),
      epsilon(1e-5f),
      label() {}

InstanceNormalization::InstanceNormalization(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const std::optional<::webnn::OperandId>& scale_operand_id_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    float epsilon_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      scale_operand_id(std::move(scale_operand_id_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      epsilon(std::move(epsilon_in)),
      label(std::move(label_in)) {}

InstanceNormalization::~InstanceNormalization() = default;

void InstanceNormalization::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_operand_id"), this->scale_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "epsilon"), this->epsilon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InstanceNormalization::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Matmul::Matmul()
    : a_operand_id(),
      b_operand_id(),
      output_operand_id(),
      label() {}

Matmul::Matmul(
    const ::webnn::OperandId& a_operand_id_in,
    const ::webnn::OperandId& b_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : a_operand_id(std::move(a_operand_id_in)),
      b_operand_id(std::move(b_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Matmul::~Matmul() = default;

void Matmul::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a_operand_id"), this->a_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "b_operand_id"), this->b_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Matmul::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Pad::Pad()
    : input_operand_id(),
      output_operand_id(),
      beginning_padding(),
      ending_padding(),
      mode(),
      label() {}

Pad::Pad(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<uint32_t> beginning_padding_in,
    ::blink::Vector<uint32_t> ending_padding_in,
    PaddingModePtr mode_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      beginning_padding(std::move(beginning_padding_in)),
      ending_padding(std::move(ending_padding_in)),
      mode(std::move(mode_in)),
      label(std::move(label_in)) {}

Pad::~Pad() = default;

void Pad::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "beginning_padding"), this->beginning_padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ending_padding"), this->ending_padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaddingModePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Pad::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Reduce::Reduce()
    : kind(),
      input_operand_id(),
      output_operand_id(),
      axes(),
      keep_dimensions(false),
      label() {}

Reduce::Reduce(
    Reduce::Kind kind_in,
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<uint32_t> axes_in,
    bool keep_dimensions_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axes(std::move(axes_in)),
      keep_dimensions(std::move(keep_dimensions_in)),
      label(std::move(label_in)) {}

Reduce::~Reduce() = default;

void Reduce::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Reduce::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keep_dimensions"), this->keep_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Reduce::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Pool2d::Pool2d()
    : kind(),
      input_operand_id(),
      output_operand_id(),
      window_dimensions(),
      padding(),
      strides(),
      dilations(),
      label() {}

Pool2d::Pool2d(
    Pool2d::Kind kind_in,
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    Size2dPtr window_dimensions_in,
    Padding2dPtr padding_in,
    Size2dPtr strides_in,
    Size2dPtr dilations_in,
    const ::blink::String& label_in)
    : kind(std::move(kind_in)),
      input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      window_dimensions(std::move(window_dimensions_in)),
      padding(std::move(padding_in)),
      strides(std::move(strides_in)),
      dilations(std::move(dilations_in)),
      label(std::move(label_in)) {}

Pool2d::~Pool2d() = default;

void Pool2d::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "kind"), this->kind,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Pool2d::Kind>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_dimensions"), this->window_dimensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "padding"), this->padding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Padding2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "strides"), this->strides,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dilations"), this->dilations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Size2dPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Pool2d::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Range::Range()
    : start(),
      size(),
      stride() {}

Range::Range(
    uint32_t start_in,
    uint32_t size_in,
    uint32_t stride_in)
    : start(std::move(start_in)),
      size(std::move(size_in)),
      stride(std::move(stride_in)) {}

Range::~Range() = default;

void Range::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start"), this->start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride"), this->stride,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Range::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Slice::Slice()
    : input_operand_id(),
      output_operand_id(),
      ranges(),
      label() {}

Slice::Slice(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<::webnn::Range> ranges_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      ranges(std::move(ranges_in)),
      label(std::move(label_in)) {}

Slice::~Slice() = default;

void Slice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ranges"), this->ranges,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::Range>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Slice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Elu::Elu()
    : input_operand_id(),
      output_operand_id(),
      alpha(1.0f),
      label() {}

Elu::Elu(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    float alpha_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      alpha(std::move(alpha_in)),
      label(std::move(label_in)) {}

Elu::~Elu() = default;

void Elu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Elu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gather::Gather()
    : input_operand_id(),
      indices_operand_id(),
      output_operand_id(),
      axis(0U),
      label() {}

Gather::Gather(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& indices_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      indices_operand_id(std::move(indices_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

Gather::~Gather() = default;

void Gather::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indices_operand_id"), this->indices_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Gather::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GatherElements::GatherElements()
    : input_operand_id(),
      indices_operand_id(),
      output_operand_id(),
      axis(0U),
      label() {}

GatherElements::GatherElements(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& indices_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      indices_operand_id(std::move(indices_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

GatherElements::~GatherElements() = default;

void GatherElements::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indices_operand_id"), this->indices_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GatherElements::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GatherND::GatherND()
    : input_operand_id(),
      indices_operand_id(),
      output_operand_id(),
      label() {}

GatherND::GatherND(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& indices_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      indices_operand_id(std::move(indices_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

GatherND::~GatherND() = default;

void GatherND::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indices_operand_id"), this->indices_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GatherND::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gelu::Gelu()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Gelu::Gelu(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Gelu::~Gelu() = default;

void Gelu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Gelu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gru::Gru()
    : input_operand_id(),
      weight_operand_id(),
      recurrent_weight_operand_id(),
      steps(),
      hidden_size(),
      output_operand_ids(),
      bias_operand_id(),
      recurrent_bias_operand_id(),
      initial_hidden_state_operand_id(),
      reset_after(),
      return_sequence(),
      direction(),
      layout(),
      activations(),
      label() {}

Gru::Gru(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& weight_operand_id_in,
    const ::webnn::OperandId& recurrent_weight_operand_id_in,
    uint32_t steps_in,
    uint32_t hidden_size_in,
    ::blink::Vector<::webnn::OperandId> output_operand_ids_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    const std::optional<::webnn::OperandId>& recurrent_bias_operand_id_in,
    const std::optional<::webnn::OperandId>& initial_hidden_state_operand_id_in,
    bool reset_after_in,
    bool return_sequence_in,
    RecurrentNetworkDirection direction_in,
    GruWeightLayout layout_in,
    ::blink::Vector<RecurrentNetworkActivation> activations_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      weight_operand_id(std::move(weight_operand_id_in)),
      recurrent_weight_operand_id(std::move(recurrent_weight_operand_id_in)),
      steps(std::move(steps_in)),
      hidden_size(std::move(hidden_size_in)),
      output_operand_ids(std::move(output_operand_ids_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      recurrent_bias_operand_id(std::move(recurrent_bias_operand_id_in)),
      initial_hidden_state_operand_id(std::move(initial_hidden_state_operand_id_in)),
      reset_after(std::move(reset_after_in)),
      return_sequence(std::move(return_sequence_in)),
      direction(std::move(direction_in)),
      layout(std::move(layout_in)),
      activations(std::move(activations_in)),
      label(std::move(label_in)) {}

Gru::~Gru() = default;

void Gru::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight_operand_id"), this->weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_weight_operand_id"), this->recurrent_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "steps"), this->steps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_size"), this->hidden_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_ids"), this->output_operand_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_bias_operand_id"), this->recurrent_bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_hidden_state_operand_id"), this->initial_hidden_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reset_after"), this->reset_after,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "return_sequence"), this->return_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RecurrentNetworkDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GruWeightLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activations"), this->activations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<RecurrentNetworkActivation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Gru::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GruCell::GruCell()
    : input_operand_id(),
      weight_operand_id(),
      recurrent_weight_operand_id(),
      hidden_state_operand_id(),
      hidden_size(),
      output_operand_id(),
      bias_operand_id(),
      recurrent_bias_operand_id(),
      reset_after(),
      layout(),
      activations(),
      label() {}

GruCell::GruCell(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& weight_operand_id_in,
    const ::webnn::OperandId& recurrent_weight_operand_id_in,
    const ::webnn::OperandId& hidden_state_operand_id_in,
    uint32_t hidden_size_in,
    const ::webnn::OperandId& output_operand_id_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    const std::optional<::webnn::OperandId>& recurrent_bias_operand_id_in,
    bool reset_after_in,
    GruWeightLayout layout_in,
    ::blink::Vector<RecurrentNetworkActivation> activations_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      weight_operand_id(std::move(weight_operand_id_in)),
      recurrent_weight_operand_id(std::move(recurrent_weight_operand_id_in)),
      hidden_state_operand_id(std::move(hidden_state_operand_id_in)),
      hidden_size(std::move(hidden_size_in)),
      output_operand_id(std::move(output_operand_id_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      recurrent_bias_operand_id(std::move(recurrent_bias_operand_id_in)),
      reset_after(std::move(reset_after_in)),
      layout(std::move(layout_in)),
      activations(std::move(activations_in)),
      label(std::move(label_in)) {}

GruCell::~GruCell() = default;

void GruCell::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight_operand_id"), this->weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_weight_operand_id"), this->recurrent_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_state_operand_id"), this->hidden_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_size"), this->hidden_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_bias_operand_id"), this->recurrent_bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reset_after"), this->reset_after,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GruWeightLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activations"), this->activations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<RecurrentNetworkActivation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GruCell::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Gemm::Gemm()
    : a_operand_id(),
      b_operand_id(),
      output_operand_id(),
      c_operand_id(),
      alpha(1.0f),
      beta(1.0f),
      a_transpose(false),
      b_transpose(false),
      label() {}

Gemm::Gemm(
    const ::webnn::OperandId& a_operand_id_in,
    const ::webnn::OperandId& b_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const std::optional<::webnn::OperandId>& c_operand_id_in,
    float alpha_in,
    float beta_in,
    bool a_transpose_in,
    bool b_transpose_in,
    const ::blink::String& label_in)
    : a_operand_id(std::move(a_operand_id_in)),
      b_operand_id(std::move(b_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      c_operand_id(std::move(c_operand_id_in)),
      alpha(std::move(alpha_in)),
      beta(std::move(beta_in)),
      a_transpose(std::move(a_transpose_in)),
      b_transpose(std::move(b_transpose_in)),
      label(std::move(label_in)) {}

Gemm::~Gemm() = default;

void Gemm::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a_operand_id"), this->a_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "b_operand_id"), this->b_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "c_operand_id"), this->c_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "beta"), this->beta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "a_transpose"), this->a_transpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "b_transpose"), this->b_transpose,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Gemm::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HardSigmoid::HardSigmoid()
    : input_operand_id(),
      output_operand_id(),
      alpha(0.2f),
      beta(0.5f),
      label() {}

HardSigmoid::HardSigmoid(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    float alpha_in,
    float beta_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      alpha(std::move(alpha_in)),
      beta(std::move(beta_in)),
      label(std::move(label_in)) {}

HardSigmoid::~HardSigmoid() = default;

void HardSigmoid::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "beta"), this->beta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HardSigmoid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HardSwish::HardSwish()
    : input_operand_id(),
      output_operand_id(),
      label() {}

HardSwish::HardSwish(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

HardSwish::~HardSwish() = default;

void HardSwish::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HardSwish::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LayerNormalization::LayerNormalization()
    : input_operand_id(),
      output_operand_id(),
      scale_operand_id(),
      bias_operand_id(),
      axes(),
      epsilon(1e-5f),
      label() {}

LayerNormalization::LayerNormalization(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const std::optional<::webnn::OperandId>& scale_operand_id_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    ::blink::Vector<uint32_t> axes_in,
    float epsilon_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      scale_operand_id(std::move(scale_operand_id_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      axes(std::move(axes_in)),
      epsilon(std::move(epsilon_in)),
      label(std::move(label_in)) {}

LayerNormalization::~LayerNormalization() = default;

void LayerNormalization::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_operand_id"), this->scale_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "epsilon"), this->epsilon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LayerNormalization::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LeakyRelu::LeakyRelu()
    : input_operand_id(),
      output_operand_id(),
      alpha(0.01f),
      label() {}

LeakyRelu::LeakyRelu(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    float alpha_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      alpha(std::move(alpha_in)),
      label(std::move(label_in)) {}

LeakyRelu::~LeakyRelu() = default;

void LeakyRelu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LeakyRelu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Linear::Linear()
    : input_operand_id(),
      output_operand_id(),
      alpha(1.0f),
      beta(0),
      label() {}

Linear::Linear(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    float alpha_in,
    float beta_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      alpha(std::move(alpha_in)),
      beta(std::move(beta_in)),
      label(std::move(label_in)) {}

Linear::~Linear() = default;

void Linear::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha"), this->alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "beta"), this->beta,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Linear::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Lstm::Lstm()
    : input_operand_id(),
      weight_operand_id(),
      recurrent_weight_operand_id(),
      output_operand_ids(),
      steps(),
      hidden_size(),
      bias_operand_id(),
      recurrent_bias_operand_id(),
      peephole_weight_operand_id(),
      initial_hidden_state_operand_id(),
      initial_cell_state_operand_id(),
      return_sequence(),
      direction(),
      layout(),
      activations(),
      label() {}

Lstm::Lstm(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& weight_operand_id_in,
    const ::webnn::OperandId& recurrent_weight_operand_id_in,
    ::blink::Vector<::webnn::OperandId> output_operand_ids_in,
    uint32_t steps_in,
    uint32_t hidden_size_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    const std::optional<::webnn::OperandId>& recurrent_bias_operand_id_in,
    const std::optional<::webnn::OperandId>& peephole_weight_operand_id_in,
    const std::optional<::webnn::OperandId>& initial_hidden_state_operand_id_in,
    const std::optional<::webnn::OperandId>& initial_cell_state_operand_id_in,
    bool return_sequence_in,
    RecurrentNetworkDirection direction_in,
    LstmWeightLayout layout_in,
    ::blink::Vector<RecurrentNetworkActivation> activations_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      weight_operand_id(std::move(weight_operand_id_in)),
      recurrent_weight_operand_id(std::move(recurrent_weight_operand_id_in)),
      output_operand_ids(std::move(output_operand_ids_in)),
      steps(std::move(steps_in)),
      hidden_size(std::move(hidden_size_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      recurrent_bias_operand_id(std::move(recurrent_bias_operand_id_in)),
      peephole_weight_operand_id(std::move(peephole_weight_operand_id_in)),
      initial_hidden_state_operand_id(std::move(initial_hidden_state_operand_id_in)),
      initial_cell_state_operand_id(std::move(initial_cell_state_operand_id_in)),
      return_sequence(std::move(return_sequence_in)),
      direction(std::move(direction_in)),
      layout(std::move(layout_in)),
      activations(std::move(activations_in)),
      label(std::move(label_in)) {}

Lstm::~Lstm() = default;

void Lstm::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight_operand_id"), this->weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_weight_operand_id"), this->recurrent_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_ids"), this->output_operand_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "steps"), this->steps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_size"), this->hidden_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_bias_operand_id"), this->recurrent_bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peephole_weight_operand_id"), this->peephole_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_hidden_state_operand_id"), this->initial_hidden_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_cell_state_operand_id"), this->initial_cell_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "return_sequence"), this->return_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "direction"), this->direction,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RecurrentNetworkDirection>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LstmWeightLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activations"), this->activations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<RecurrentNetworkActivation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Lstm::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LstmCell::LstmCell()
    : input_operand_id(),
      weight_operand_id(),
      recurrent_weight_operand_id(),
      hidden_state_operand_id(),
      cell_state_operand_id(),
      output_operand_ids(),
      hidden_size(),
      bias_operand_id(),
      recurrent_bias_operand_id(),
      peephole_weight_operand_id(),
      layout(),
      activations(),
      label() {}

LstmCell::LstmCell(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& weight_operand_id_in,
    const ::webnn::OperandId& recurrent_weight_operand_id_in,
    const ::webnn::OperandId& hidden_state_operand_id_in,
    const ::webnn::OperandId& cell_state_operand_id_in,
    ::blink::Vector<::webnn::OperandId> output_operand_ids_in,
    uint32_t hidden_size_in,
    const std::optional<::webnn::OperandId>& bias_operand_id_in,
    const std::optional<::webnn::OperandId>& recurrent_bias_operand_id_in,
    const std::optional<::webnn::OperandId>& peephole_weight_operand_id_in,
    LstmWeightLayout layout_in,
    ::blink::Vector<RecurrentNetworkActivation> activations_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      weight_operand_id(std::move(weight_operand_id_in)),
      recurrent_weight_operand_id(std::move(recurrent_weight_operand_id_in)),
      hidden_state_operand_id(std::move(hidden_state_operand_id_in)),
      cell_state_operand_id(std::move(cell_state_operand_id_in)),
      output_operand_ids(std::move(output_operand_ids_in)),
      hidden_size(std::move(hidden_size_in)),
      bias_operand_id(std::move(bias_operand_id_in)),
      recurrent_bias_operand_id(std::move(recurrent_bias_operand_id_in)),
      peephole_weight_operand_id(std::move(peephole_weight_operand_id_in)),
      layout(std::move(layout_in)),
      activations(std::move(activations_in)),
      label(std::move(label_in)) {}

LstmCell::~LstmCell() = default;

void LstmCell::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight_operand_id"), this->weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_weight_operand_id"), this->recurrent_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_state_operand_id"), this->hidden_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cell_state_operand_id"), this->cell_state_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_ids"), this->output_operand_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hidden_size"), this->hidden_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bias_operand_id"), this->bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recurrent_bias_operand_id"), this->recurrent_bias_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "peephole_weight_operand_id"), this->peephole_weight_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LstmWeightLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activations"), this->activations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<RecurrentNetworkActivation>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LstmCell::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Prelu::Prelu()
    : input_operand_id(),
      slope_operand_id(),
      output_operand_id(),
      label() {}

Prelu::Prelu(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& slope_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      slope_operand_id(std::move(slope_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Prelu::~Prelu() = default;

void Prelu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slope_operand_id"), this->slope_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Prelu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
QuantizeLinear::QuantizeLinear()
    : input_operand_id(),
      scale_operand_id(),
      zero_point_operand_id(),
      output_operand_id(),
      label() {}

QuantizeLinear::QuantizeLinear(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& scale_operand_id_in,
    const ::webnn::OperandId& zero_point_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      scale_operand_id(std::move(scale_operand_id_in)),
      zero_point_operand_id(std::move(zero_point_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

QuantizeLinear::~QuantizeLinear() = default;

void QuantizeLinear::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scale_operand_id"), this->scale_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zero_point_operand_id"), this->zero_point_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool QuantizeLinear::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Relu::Relu()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Relu::Relu(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Relu::~Relu() = default;

void Relu::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Relu::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Reshape::Reshape()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Reshape::Reshape(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Reshape::~Reshape() = default;

void Reshape::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Reshape::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Reverse::Reverse()
    : input_operand_id(),
      output_operand_id(),
      axes(),
      label() {}

Reverse::Reverse(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<uint32_t> axes_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axes(std::move(axes_in)),
      label(std::move(label_in)) {}

Reverse::~Reverse() = default;

void Reverse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Reverse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScatterElements::ScatterElements()
    : input_operand_id(),
      indices_operand_id(),
      updates_operand_id(),
      output_operand_id(),
      axis(0U),
      label() {}

ScatterElements::ScatterElements(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& indices_operand_id_in,
    const ::webnn::OperandId& updates_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      indices_operand_id(std::move(indices_operand_id_in)),
      updates_operand_id(std::move(updates_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

ScatterElements::~ScatterElements() = default;

void ScatterElements::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indices_operand_id"), this->indices_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates_operand_id"), this->updates_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScatterElements::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScatterND::ScatterND()
    : input_operand_id(),
      indices_operand_id(),
      updates_operand_id(),
      output_operand_id(),
      label() {}

ScatterND::ScatterND(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& indices_operand_id_in,
    const ::webnn::OperandId& updates_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      indices_operand_id(std::move(indices_operand_id_in)),
      updates_operand_id(std::move(updates_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

ScatterND::~ScatterND() = default;

void ScatterND::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "indices_operand_id"), this->indices_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "updates_operand_id"), this->updates_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ScatterND::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Sigmoid::Sigmoid()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Sigmoid::Sigmoid(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Sigmoid::~Sigmoid() = default;

void Sigmoid::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Sigmoid::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Softmax::Softmax()
    : input_operand_id(),
      output_operand_id(),
      axis(),
      label() {}

Softmax::Softmax(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

Softmax::~Softmax() = default;

void Softmax::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Softmax::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Softplus::Softplus()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Softplus::Softplus(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Softplus::~Softplus() = default;

void Softplus::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Softplus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Softsign::Softsign()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Softsign::Softsign(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Softsign::~Softsign() = default;

void Softsign::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Softsign::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Split::Split()
    : input_operand_id(),
      output_operand_ids(),
      axis(0U),
      label() {}

Split::Split(
    const ::webnn::OperandId& input_operand_id_in,
    ::blink::Vector<::webnn::OperandId> output_operand_ids_in,
    uint32_t axis_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_ids(std::move(output_operand_ids_in)),
      axis(std::move(axis_in)),
      label(std::move(label_in)) {}

Split::~Split() = default;

void Split::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_ids"), this->output_operand_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axis"), this->axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Split::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tanh::Tanh()
    : input_operand_id(),
      output_operand_id(),
      label() {}

Tanh::Tanh(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Tanh::~Tanh() = default;

void Tanh::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tanh::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tile::Tile()
    : input_operand_id(),
      output_operand_id(),
      repetitions(),
      label() {}

Tile::Tile(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<uint32_t> repetitions_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      repetitions(std::move(repetitions_in)),
      label(std::move(label_in)) {}

Tile::~Tile() = default;

void Tile::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "repetitions"), this->repetitions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tile::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Transpose::Transpose()
    : input_operand_id(),
      output_operand_id(),
      permutation(),
      label() {}

Transpose::Transpose(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    ::blink::Vector<uint32_t> permutation_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      permutation(std::move(permutation_in)),
      label(std::move(label_in)) {}

Transpose::~Transpose() = default;

void Transpose::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permutation"), this->permutation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Transpose::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Triangular::Triangular()
    : input_operand_id(),
      output_operand_id(),
      upper(),
      diagonal(),
      label() {}

Triangular::Triangular(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    bool upper_in,
    int32_t diagonal_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      upper(std::move(upper_in)),
      diagonal(std::move(diagonal_in)),
      label(std::move(label_in)) {}

Triangular::~Triangular() = default;

void Triangular::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upper"), this->upper,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "diagonal"), this->diagonal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Triangular::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Resample2d::Resample2d()
    : input_operand_id(),
      output_operand_id(),
      mode(),
      scales(),
      axes(),
      label() {}

Resample2d::Resample2d(
    const ::webnn::OperandId& input_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    Resample2d::InterpolationMode mode_in,
    std::optional<::blink::Vector<float>> scales_in,
    ::blink::Vector<uint32_t> axes_in,
    const ::blink::String& label_in)
    : input_operand_id(std::move(input_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      mode(std::move(mode_in)),
      scales(std::move(scales_in)),
      axes(std::move(axes_in)),
      label(std::move(label_in)) {}

Resample2d::~Resample2d() = default;

void Resample2d::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_id"), this->input_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Resample2d::InterpolationMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scales"), this->scales,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<float>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "axes"), this->axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Resample2d::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Where::Where()
    : condition_operand_id(),
      true_value_operand_id(),
      false_value_operand_id(),
      output_operand_id(),
      label() {}

Where::Where(
    const ::webnn::OperandId& condition_operand_id_in,
    const ::webnn::OperandId& true_value_operand_id_in,
    const ::webnn::OperandId& false_value_operand_id_in,
    const ::webnn::OperandId& output_operand_id_in,
    const ::blink::String& label_in)
    : condition_operand_id(std::move(condition_operand_id_in)),
      true_value_operand_id(std::move(true_value_operand_id_in)),
      false_value_operand_id(std::move(false_value_operand_id_in)),
      output_operand_id(std::move(output_operand_id_in)),
      label(std::move(label_in)) {}

Where::~Where() = default;

void Where::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "condition_operand_id"), this->condition_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "true_value_operand_id"), this->true_value_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "false_value_operand_id"), this->false_value_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operand_id"), this->output_operand_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::OperandId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Where::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GraphInfo::GraphInfo()
    : operands(),
      input_operands(),
      output_operands(),
      operations(),
      constant_operand_ids_to_handles(),
      id_to_constant_tensor_operand_map() {}

GraphInfo::GraphInfo(
    ::blink::Vector<OperandPtr> operands_in,
    ::blink::Vector<::webnn::OperandId> input_operands_in,
    ::blink::Vector<::webnn::OperandId> output_operands_in,
    ::blink::Vector<OperationPtr> operations_in,
    const ::blink::HashMap<::webnn::OperandId, ::blink::WebNNPendingConstantToken>& constant_operand_ids_to_handles_in,
    const ::blink::HashMap<::webnn::OperandId, ::blink::WebNNTensorToken>& id_to_constant_tensor_operand_map_in)
    : operands(std::move(operands_in)),
      input_operands(std::move(input_operands_in)),
      output_operands(std::move(output_operands_in)),
      operations(std::move(operations_in)),
      constant_operand_ids_to_handles(std::move(constant_operand_ids_to_handles_in)),
      id_to_constant_tensor_operand_map(std::move(id_to_constant_tensor_operand_map_in)) {}

GraphInfo::~GraphInfo() = default;

void GraphInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operands"), this->operands,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<OperandPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operands"), this->input_operands,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_operands"), this->output_operands,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::webnn::OperandId>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operations"), this->operations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<OperationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constant_operand_ids_to_handles"), this->constant_operand_ids_to_handles,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::webnn::OperandId, ::blink::WebNNPendingConstantToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id_to_constant_tensor_operand_map"), this->id_to_constant_tensor_operand_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::webnn::OperandId, ::blink::WebNNTensorToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GraphInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NumberPtr
Number::NewFloatingPoint(
    double value) {
  return NumberPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFloatingPoint)>,
      std::move(value));
}

NumberPtr
Number::NewSignedInteger(
    int64_t value) {
  return NumberPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSignedInteger)>,
      std::move(value));
}

NumberPtr
Number::NewUnsignedInteger(
    uint64_t value) {
  return NumberPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnsignedInteger)>,
      std::move(value));
}

Number::Number(
    std::in_place_index_t<static_cast<size_t>(Tag::kFloatingPoint)>,
    double value)
    : tag_(Tag::kFloatingPoint),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFloatingPoint)>,
            std::move(value)) {}

Number::Number(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignedInteger)>,
    int64_t value)
    : tag_(Tag::kSignedInteger),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSignedInteger)>,
            std::move(value)) {}

Number::Number(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnsignedInteger)>,
    uint64_t value)
    : tag_(Tag::kUnsignedInteger),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnsignedInteger)>,
            std::move(value)) {}
Number::~Number() {
  DestroyActive();
}

void Number::set_floating_point(double floating_point) {
  if (tag_ != Tag::kFloatingPoint) {
    DestroyActive();
    tag_ = Tag::kFloatingPoint;
  }
  data_.floating_point = floating_point;
}

void Number::set_signed_integer(int64_t signed_integer) {
  if (tag_ != Tag::kSignedInteger) {
    DestroyActive();
    tag_ = Tag::kSignedInteger;
  }
  data_.signed_integer = signed_integer;
}

void Number::set_unsigned_integer(uint64_t unsigned_integer) {
  if (tag_ != Tag::kUnsignedInteger) {
    DestroyActive();
    tag_ = Tag::kUnsignedInteger;
  }
  data_.unsigned_integer = unsigned_integer;
}


Number::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFloatingPoint)>,
    double value)
    : floating_point(std::move(value)) {}

Number::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSignedInteger)>,
    int64_t value)
    : signed_integer(std::move(value)) {}

Number::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnsignedInteger)>,
    uint64_t value)
    : unsigned_integer(std::move(value)) {}

void Number::DestroyActive() {
  switch (tag_) {

    case Tag::kFloatingPoint:
      std::destroy_at(&data_.floating_point);
      break;
    case Tag::kSignedInteger:
      std::destroy_at(&data_.signed_integer);
      break;
    case Tag::kUnsignedInteger:
      std::destroy_at(&data_.unsigned_integer);
      break;
  }
}

bool Number::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
PaddingModePtr
PaddingMode::NewConstant(
    ConstantPaddingPtr value) {
  return PaddingModePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kConstant)>,
      std::move(value));
}

PaddingModePtr
PaddingMode::NewEdge(
    EdgePaddingPtr value) {
  return PaddingModePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kEdge)>,
      std::move(value));
}

PaddingModePtr
PaddingMode::NewReflection(
    ReflectionPaddingPtr value) {
  return PaddingModePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReflection)>,
      std::move(value));
}

PaddingMode::PaddingMode(
    std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
    ConstantPaddingPtr value)
    : tag_(Tag::kConstant),
      data_(std::in_place_index<static_cast<size_t>(Tag::kConstant)>,
            std::move(value)) {}

PaddingMode::PaddingMode(
    std::in_place_index_t<static_cast<size_t>(Tag::kEdge)>,
    EdgePaddingPtr value)
    : tag_(Tag::kEdge),
      data_(std::in_place_index<static_cast<size_t>(Tag::kEdge)>,
            std::move(value)) {}

PaddingMode::PaddingMode(
    std::in_place_index_t<static_cast<size_t>(Tag::kReflection)>,
    ReflectionPaddingPtr value)
    : tag_(Tag::kReflection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReflection)>,
            std::move(value)) {}
PaddingMode::~PaddingMode() {
  DestroyActive();
}

void PaddingMode::set_constant(ConstantPaddingPtr constant) {
  if (tag_ == Tag::kConstant) {
    data_.constant = std::move(constant);
  } else {
    DestroyActive();
    tag_ = Tag::kConstant;
    new (&data_.constant) ConstantPaddingPtr(
        std::move(constant));
  }
}

void PaddingMode::set_edge(EdgePaddingPtr edge) {
  if (tag_ == Tag::kEdge) {
    data_.edge = std::move(edge);
  } else {
    DestroyActive();
    tag_ = Tag::kEdge;
    new (&data_.edge) EdgePaddingPtr(
        std::move(edge));
  }
}

void PaddingMode::set_reflection(ReflectionPaddingPtr reflection) {
  if (tag_ == Tag::kReflection) {
    data_.reflection = std::move(reflection);
  } else {
    DestroyActive();
    tag_ = Tag::kReflection;
    new (&data_.reflection) ReflectionPaddingPtr(
        std::move(reflection));
  }
}


PaddingMode::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kConstant)>,
    ConstantPaddingPtr value)
    : constant(std::move(value)) {}

PaddingMode::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kEdge)>,
    EdgePaddingPtr value)
    : edge(std::move(value)) {}

PaddingMode::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReflection)>,
    ReflectionPaddingPtr value)
    : reflection(std::move(value)) {}

void PaddingMode::DestroyActive() {
  switch (tag_) {

    case Tag::kConstant:
      std::destroy_at(&data_.constant);
      break;
    case Tag::kEdge:
      std::destroy_at(&data_.edge);
      break;
    case Tag::kReflection:
      std::destroy_at(&data_.reflection);
      break;
  }
}

bool PaddingMode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
OperationPtr
Operation::NewArgMinMax(
    ArgMinMaxPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kArgMinMax)>,
      std::move(value));
}

OperationPtr
Operation::NewBatchNormalization(
    BatchNormalizationPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBatchNormalization)>,
      std::move(value));
}

OperationPtr
Operation::NewClamp(
    ClampPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kClamp)>,
      std::move(value));
}

OperationPtr
Operation::NewConcat(
    ConcatPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kConcat)>,
      std::move(value));
}

OperationPtr
Operation::NewConv2d(
    Conv2dPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kConv2d)>,
      std::move(value));
}

OperationPtr
Operation::NewCumulativeSum(
    CumulativeSumPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kCumulativeSum)>,
      std::move(value));
}

OperationPtr
Operation::NewDequantizeLinear(
    DequantizeLinearPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDequantizeLinear)>,
      std::move(value));
}

OperationPtr
Operation::NewElementWiseBinary(
    ElementWiseBinaryPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kElementWiseBinary)>,
      std::move(value));
}

OperationPtr
Operation::NewElu(
    EluPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kElu)>,
      std::move(value));
}

OperationPtr
Operation::NewElementWiseUnary(
    ElementWiseUnaryPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kElementWiseUnary)>,
      std::move(value));
}

OperationPtr
Operation::NewExpand(
    ExpandPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kExpand)>,
      std::move(value));
}

OperationPtr
Operation::NewGather(
    GatherPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGather)>,
      std::move(value));
}

OperationPtr
Operation::NewGatherElements(
    GatherElementsPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGatherElements)>,
      std::move(value));
}

OperationPtr
Operation::NewGatherNd(
    GatherNDPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGatherNd)>,
      std::move(value));
}

OperationPtr
Operation::NewGelu(
    GeluPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGelu)>,
      std::move(value));
}

OperationPtr
Operation::NewGemm(
    GemmPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGemm)>,
      std::move(value));
}

OperationPtr
Operation::NewGru(
    GruPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGru)>,
      std::move(value));
}

OperationPtr
Operation::NewGruCell(
    GruCellPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kGruCell)>,
      std::move(value));
}

OperationPtr
Operation::NewHardSigmoid(
    HardSigmoidPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHardSigmoid)>,
      std::move(value));
}

OperationPtr
Operation::NewHardSwish(
    HardSwishPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHardSwish)>,
      std::move(value));
}

OperationPtr
Operation::NewLayerNormalization(
    LayerNormalizationPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLayerNormalization)>,
      std::move(value));
}

OperationPtr
Operation::NewInstanceNormalization(
    InstanceNormalizationPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kInstanceNormalization)>,
      std::move(value));
}

OperationPtr
Operation::NewLeakyRelu(
    LeakyReluPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLeakyRelu)>,
      std::move(value));
}

OperationPtr
Operation::NewLinear(
    LinearPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLinear)>,
      std::move(value));
}

OperationPtr
Operation::NewLstm(
    LstmPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLstm)>,
      std::move(value));
}

OperationPtr
Operation::NewLstmCell(
    LstmCellPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kLstmCell)>,
      std::move(value));
}

OperationPtr
Operation::NewMatmul(
    MatmulPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kMatmul)>,
      std::move(value));
}

OperationPtr
Operation::NewPad(
    PadPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPad)>,
      std::move(value));
}

OperationPtr
Operation::NewPool2d(
    Pool2dPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPool2d)>,
      std::move(value));
}

OperationPtr
Operation::NewPrelu(
    PreluPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPrelu)>,
      std::move(value));
}

OperationPtr
Operation::NewQuantizeLinear(
    QuantizeLinearPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kQuantizeLinear)>,
      std::move(value));
}

OperationPtr
Operation::NewReduce(
    ReducePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReduce)>,
      std::move(value));
}

OperationPtr
Operation::NewRelu(
    ReluPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRelu)>,
      std::move(value));
}

OperationPtr
Operation::NewResample2d(
    Resample2dPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kResample2d)>,
      std::move(value));
}

OperationPtr
Operation::NewReshape(
    ReshapePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReshape)>,
      std::move(value));
}

OperationPtr
Operation::NewReverse(
    ReversePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kReverse)>,
      std::move(value));
}

OperationPtr
Operation::NewScatterElements(
    ScatterElementsPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScatterElements)>,
      std::move(value));
}

OperationPtr
Operation::NewScatterNd(
    ScatterNDPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScatterNd)>,
      std::move(value));
}

OperationPtr
Operation::NewSigmoid(
    SigmoidPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSigmoid)>,
      std::move(value));
}

OperationPtr
Operation::NewSlice(
    SlicePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSlice)>,
      std::move(value));
}

OperationPtr
Operation::NewSoftmax(
    SoftmaxPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSoftmax)>,
      std::move(value));
}

OperationPtr
Operation::NewSoftplus(
    SoftplusPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSoftplus)>,
      std::move(value));
}

OperationPtr
Operation::NewSoftsign(
    SoftsignPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSoftsign)>,
      std::move(value));
}

OperationPtr
Operation::NewSplit(
    SplitPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSplit)>,
      std::move(value));
}

OperationPtr
Operation::NewTanh(
    TanhPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTanh)>,
      std::move(value));
}

OperationPtr
Operation::NewTile(
    TilePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTile)>,
      std::move(value));
}

OperationPtr
Operation::NewTranspose(
    TransposePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTranspose)>,
      std::move(value));
}

OperationPtr
Operation::NewTriangular(
    TriangularPtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTriangular)>,
      std::move(value));
}

OperationPtr
Operation::NewWhere(
    WherePtr value) {
  return OperationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kWhere)>,
      std::move(value));
}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kArgMinMax)>,
    ArgMinMaxPtr value)
    : tag_(Tag::kArgMinMax),
      data_(std::in_place_index<static_cast<size_t>(Tag::kArgMinMax)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kBatchNormalization)>,
    BatchNormalizationPtr value)
    : tag_(Tag::kBatchNormalization),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBatchNormalization)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kClamp)>,
    ClampPtr value)
    : tag_(Tag::kClamp),
      data_(std::in_place_index<static_cast<size_t>(Tag::kClamp)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kConcat)>,
    ConcatPtr value)
    : tag_(Tag::kConcat),
      data_(std::in_place_index<static_cast<size_t>(Tag::kConcat)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kConv2d)>,
    Conv2dPtr value)
    : tag_(Tag::kConv2d),
      data_(std::in_place_index<static_cast<size_t>(Tag::kConv2d)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kCumulativeSum)>,
    CumulativeSumPtr value)
    : tag_(Tag::kCumulativeSum),
      data_(std::in_place_index<static_cast<size_t>(Tag::kCumulativeSum)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kDequantizeLinear)>,
    DequantizeLinearPtr value)
    : tag_(Tag::kDequantizeLinear),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDequantizeLinear)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseBinary)>,
    ElementWiseBinaryPtr value)
    : tag_(Tag::kElementWiseBinary),
      data_(std::in_place_index<static_cast<size_t>(Tag::kElementWiseBinary)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kElu)>,
    EluPtr value)
    : tag_(Tag::kElu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kElu)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseUnary)>,
    ElementWiseUnaryPtr value)
    : tag_(Tag::kElementWiseUnary),
      data_(std::in_place_index<static_cast<size_t>(Tag::kElementWiseUnary)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kExpand)>,
    ExpandPtr value)
    : tag_(Tag::kExpand),
      data_(std::in_place_index<static_cast<size_t>(Tag::kExpand)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGather)>,
    GatherPtr value)
    : tag_(Tag::kGather),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGather)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGatherElements)>,
    GatherElementsPtr value)
    : tag_(Tag::kGatherElements),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGatherElements)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGatherNd)>,
    GatherNDPtr value)
    : tag_(Tag::kGatherNd),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGatherNd)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGelu)>,
    GeluPtr value)
    : tag_(Tag::kGelu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGelu)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGemm)>,
    GemmPtr value)
    : tag_(Tag::kGemm),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGemm)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGru)>,
    GruPtr value)
    : tag_(Tag::kGru),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGru)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kGruCell)>,
    GruCellPtr value)
    : tag_(Tag::kGruCell),
      data_(std::in_place_index<static_cast<size_t>(Tag::kGruCell)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kHardSigmoid)>,
    HardSigmoidPtr value)
    : tag_(Tag::kHardSigmoid),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHardSigmoid)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kHardSwish)>,
    HardSwishPtr value)
    : tag_(Tag::kHardSwish),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHardSwish)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kLayerNormalization)>,
    LayerNormalizationPtr value)
    : tag_(Tag::kLayerNormalization),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLayerNormalization)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kInstanceNormalization)>,
    InstanceNormalizationPtr value)
    : tag_(Tag::kInstanceNormalization),
      data_(std::in_place_index<static_cast<size_t>(Tag::kInstanceNormalization)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kLeakyRelu)>,
    LeakyReluPtr value)
    : tag_(Tag::kLeakyRelu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLeakyRelu)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
    LinearPtr value)
    : tag_(Tag::kLinear),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLinear)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kLstm)>,
    LstmPtr value)
    : tag_(Tag::kLstm),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLstm)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kLstmCell)>,
    LstmCellPtr value)
    : tag_(Tag::kLstmCell),
      data_(std::in_place_index<static_cast<size_t>(Tag::kLstmCell)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatmul)>,
    MatmulPtr value)
    : tag_(Tag::kMatmul),
      data_(std::in_place_index<static_cast<size_t>(Tag::kMatmul)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kPad)>,
    PadPtr value)
    : tag_(Tag::kPad),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPad)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kPool2d)>,
    Pool2dPtr value)
    : tag_(Tag::kPool2d),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPool2d)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrelu)>,
    PreluPtr value)
    : tag_(Tag::kPrelu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPrelu)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kQuantizeLinear)>,
    QuantizeLinearPtr value)
    : tag_(Tag::kQuantizeLinear),
      data_(std::in_place_index<static_cast<size_t>(Tag::kQuantizeLinear)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kReduce)>,
    ReducePtr value)
    : tag_(Tag::kReduce),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReduce)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kRelu)>,
    ReluPtr value)
    : tag_(Tag::kRelu),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRelu)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kResample2d)>,
    Resample2dPtr value)
    : tag_(Tag::kResample2d),
      data_(std::in_place_index<static_cast<size_t>(Tag::kResample2d)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kReshape)>,
    ReshapePtr value)
    : tag_(Tag::kReshape),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReshape)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kReverse)>,
    ReversePtr value)
    : tag_(Tag::kReverse),
      data_(std::in_place_index<static_cast<size_t>(Tag::kReverse)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kScatterElements)>,
    ScatterElementsPtr value)
    : tag_(Tag::kScatterElements),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScatterElements)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kScatterNd)>,
    ScatterNDPtr value)
    : tag_(Tag::kScatterNd),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScatterNd)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSigmoid)>,
    SigmoidPtr value)
    : tag_(Tag::kSigmoid),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSigmoid)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSlice)>,
    SlicePtr value)
    : tag_(Tag::kSlice),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSlice)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftmax)>,
    SoftmaxPtr value)
    : tag_(Tag::kSoftmax),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSoftmax)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftplus)>,
    SoftplusPtr value)
    : tag_(Tag::kSoftplus),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSoftplus)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftsign)>,
    SoftsignPtr value)
    : tag_(Tag::kSoftsign),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSoftsign)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplit)>,
    SplitPtr value)
    : tag_(Tag::kSplit),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSplit)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kTanh)>,
    TanhPtr value)
    : tag_(Tag::kTanh),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTanh)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kTile)>,
    TilePtr value)
    : tag_(Tag::kTile),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTile)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranspose)>,
    TransposePtr value)
    : tag_(Tag::kTranspose),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTranspose)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kTriangular)>,
    TriangularPtr value)
    : tag_(Tag::kTriangular),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTriangular)>,
            std::move(value)) {}

Operation::Operation(
    std::in_place_index_t<static_cast<size_t>(Tag::kWhere)>,
    WherePtr value)
    : tag_(Tag::kWhere),
      data_(std::in_place_index<static_cast<size_t>(Tag::kWhere)>,
            std::move(value)) {}
Operation::~Operation() {
  DestroyActive();
}

void Operation::set_arg_min_max(ArgMinMaxPtr arg_min_max) {
  if (tag_ == Tag::kArgMinMax) {
    data_.arg_min_max = std::move(arg_min_max);
  } else {
    DestroyActive();
    tag_ = Tag::kArgMinMax;
    new (&data_.arg_min_max) ArgMinMaxPtr(
        std::move(arg_min_max));
  }
}

void Operation::set_batch_normalization(BatchNormalizationPtr batch_normalization) {
  if (tag_ == Tag::kBatchNormalization) {
    data_.batch_normalization = std::move(batch_normalization);
  } else {
    DestroyActive();
    tag_ = Tag::kBatchNormalization;
    new (&data_.batch_normalization) BatchNormalizationPtr(
        std::move(batch_normalization));
  }
}

void Operation::set_clamp(ClampPtr clamp) {
  if (tag_ == Tag::kClamp) {
    data_.clamp = std::move(clamp);
  } else {
    DestroyActive();
    tag_ = Tag::kClamp;
    new (&data_.clamp) ClampPtr(
        std::move(clamp));
  }
}

void Operation::set_concat(ConcatPtr concat) {
  if (tag_ == Tag::kConcat) {
    data_.concat = std::move(concat);
  } else {
    DestroyActive();
    tag_ = Tag::kConcat;
    new (&data_.concat) ConcatPtr(
        std::move(concat));
  }
}

void Operation::set_conv2d(Conv2dPtr conv2d) {
  if (tag_ == Tag::kConv2d) {
    data_.conv2d = std::move(conv2d);
  } else {
    DestroyActive();
    tag_ = Tag::kConv2d;
    new (&data_.conv2d) Conv2dPtr(
        std::move(conv2d));
  }
}

void Operation::set_cumulative_sum(CumulativeSumPtr cumulative_sum) {
  if (tag_ == Tag::kCumulativeSum) {
    data_.cumulative_sum = std::move(cumulative_sum);
  } else {
    DestroyActive();
    tag_ = Tag::kCumulativeSum;
    new (&data_.cumulative_sum) CumulativeSumPtr(
        std::move(cumulative_sum));
  }
}

void Operation::set_dequantize_linear(DequantizeLinearPtr dequantize_linear) {
  if (tag_ == Tag::kDequantizeLinear) {
    data_.dequantize_linear = std::move(dequantize_linear);
  } else {
    DestroyActive();
    tag_ = Tag::kDequantizeLinear;
    new (&data_.dequantize_linear) DequantizeLinearPtr(
        std::move(dequantize_linear));
  }
}

void Operation::set_element_wise_binary(ElementWiseBinaryPtr element_wise_binary) {
  if (tag_ == Tag::kElementWiseBinary) {
    data_.element_wise_binary = std::move(element_wise_binary);
  } else {
    DestroyActive();
    tag_ = Tag::kElementWiseBinary;
    new (&data_.element_wise_binary) ElementWiseBinaryPtr(
        std::move(element_wise_binary));
  }
}

void Operation::set_elu(EluPtr elu) {
  if (tag_ == Tag::kElu) {
    data_.elu = std::move(elu);
  } else {
    DestroyActive();
    tag_ = Tag::kElu;
    new (&data_.elu) EluPtr(
        std::move(elu));
  }
}

void Operation::set_element_wise_unary(ElementWiseUnaryPtr element_wise_unary) {
  if (tag_ == Tag::kElementWiseUnary) {
    data_.element_wise_unary = std::move(element_wise_unary);
  } else {
    DestroyActive();
    tag_ = Tag::kElementWiseUnary;
    new (&data_.element_wise_unary) ElementWiseUnaryPtr(
        std::move(element_wise_unary));
  }
}

void Operation::set_expand(ExpandPtr expand) {
  if (tag_ == Tag::kExpand) {
    data_.expand = std::move(expand);
  } else {
    DestroyActive();
    tag_ = Tag::kExpand;
    new (&data_.expand) ExpandPtr(
        std::move(expand));
  }
}

void Operation::set_gather(GatherPtr gather) {
  if (tag_ == Tag::kGather) {
    data_.gather = std::move(gather);
  } else {
    DestroyActive();
    tag_ = Tag::kGather;
    new (&data_.gather) GatherPtr(
        std::move(gather));
  }
}

void Operation::set_gather_elements(GatherElementsPtr gather_elements) {
  if (tag_ == Tag::kGatherElements) {
    data_.gather_elements = std::move(gather_elements);
  } else {
    DestroyActive();
    tag_ = Tag::kGatherElements;
    new (&data_.gather_elements) GatherElementsPtr(
        std::move(gather_elements));
  }
}

void Operation::set_gather_nd(GatherNDPtr gather_nd) {
  if (tag_ == Tag::kGatherNd) {
    data_.gather_nd = std::move(gather_nd);
  } else {
    DestroyActive();
    tag_ = Tag::kGatherNd;
    new (&data_.gather_nd) GatherNDPtr(
        std::move(gather_nd));
  }
}

void Operation::set_gelu(GeluPtr gelu) {
  if (tag_ == Tag::kGelu) {
    data_.gelu = std::move(gelu);
  } else {
    DestroyActive();
    tag_ = Tag::kGelu;
    new (&data_.gelu) GeluPtr(
        std::move(gelu));
  }
}

void Operation::set_gemm(GemmPtr gemm) {
  if (tag_ == Tag::kGemm) {
    data_.gemm = std::move(gemm);
  } else {
    DestroyActive();
    tag_ = Tag::kGemm;
    new (&data_.gemm) GemmPtr(
        std::move(gemm));
  }
}

void Operation::set_gru(GruPtr gru) {
  if (tag_ == Tag::kGru) {
    data_.gru = std::move(gru);
  } else {
    DestroyActive();
    tag_ = Tag::kGru;
    new (&data_.gru) GruPtr(
        std::move(gru));
  }
}

void Operation::set_gru_cell(GruCellPtr gru_cell) {
  if (tag_ == Tag::kGruCell) {
    data_.gru_cell = std::move(gru_cell);
  } else {
    DestroyActive();
    tag_ = Tag::kGruCell;
    new (&data_.gru_cell) GruCellPtr(
        std::move(gru_cell));
  }
}

void Operation::set_hard_sigmoid(HardSigmoidPtr hard_sigmoid) {
  if (tag_ == Tag::kHardSigmoid) {
    data_.hard_sigmoid = std::move(hard_sigmoid);
  } else {
    DestroyActive();
    tag_ = Tag::kHardSigmoid;
    new (&data_.hard_sigmoid) HardSigmoidPtr(
        std::move(hard_sigmoid));
  }
}

void Operation::set_hard_swish(HardSwishPtr hard_swish) {
  if (tag_ == Tag::kHardSwish) {
    data_.hard_swish = std::move(hard_swish);
  } else {
    DestroyActive();
    tag_ = Tag::kHardSwish;
    new (&data_.hard_swish) HardSwishPtr(
        std::move(hard_swish));
  }
}

void Operation::set_layer_normalization(LayerNormalizationPtr layer_normalization) {
  if (tag_ == Tag::kLayerNormalization) {
    data_.layer_normalization = std::move(layer_normalization);
  } else {
    DestroyActive();
    tag_ = Tag::kLayerNormalization;
    new (&data_.layer_normalization) LayerNormalizationPtr(
        std::move(layer_normalization));
  }
}

void Operation::set_instance_normalization(InstanceNormalizationPtr instance_normalization) {
  if (tag_ == Tag::kInstanceNormalization) {
    data_.instance_normalization = std::move(instance_normalization);
  } else {
    DestroyActive();
    tag_ = Tag::kInstanceNormalization;
    new (&data_.instance_normalization) InstanceNormalizationPtr(
        std::move(instance_normalization));
  }
}

void Operation::set_leaky_relu(LeakyReluPtr leaky_relu) {
  if (tag_ == Tag::kLeakyRelu) {
    data_.leaky_relu = std::move(leaky_relu);
  } else {
    DestroyActive();
    tag_ = Tag::kLeakyRelu;
    new (&data_.leaky_relu) LeakyReluPtr(
        std::move(leaky_relu));
  }
}

void Operation::set_linear(LinearPtr linear) {
  if (tag_ == Tag::kLinear) {
    data_.linear = std::move(linear);
  } else {
    DestroyActive();
    tag_ = Tag::kLinear;
    new (&data_.linear) LinearPtr(
        std::move(linear));
  }
}

void Operation::set_lstm(LstmPtr lstm) {
  if (tag_ == Tag::kLstm) {
    data_.lstm = std::move(lstm);
  } else {
    DestroyActive();
    tag_ = Tag::kLstm;
    new (&data_.lstm) LstmPtr(
        std::move(lstm));
  }
}

void Operation::set_lstm_cell(LstmCellPtr lstm_cell) {
  if (tag_ == Tag::kLstmCell) {
    data_.lstm_cell = std::move(lstm_cell);
  } else {
    DestroyActive();
    tag_ = Tag::kLstmCell;
    new (&data_.lstm_cell) LstmCellPtr(
        std::move(lstm_cell));
  }
}

void Operation::set_matmul(MatmulPtr matmul) {
  if (tag_ == Tag::kMatmul) {
    data_.matmul = std::move(matmul);
  } else {
    DestroyActive();
    tag_ = Tag::kMatmul;
    new (&data_.matmul) MatmulPtr(
        std::move(matmul));
  }
}

void Operation::set_pad(PadPtr pad) {
  if (tag_ == Tag::kPad) {
    data_.pad = std::move(pad);
  } else {
    DestroyActive();
    tag_ = Tag::kPad;
    new (&data_.pad) PadPtr(
        std::move(pad));
  }
}

void Operation::set_pool2d(Pool2dPtr pool2d) {
  if (tag_ == Tag::kPool2d) {
    data_.pool2d = std::move(pool2d);
  } else {
    DestroyActive();
    tag_ = Tag::kPool2d;
    new (&data_.pool2d) Pool2dPtr(
        std::move(pool2d));
  }
}

void Operation::set_prelu(PreluPtr prelu) {
  if (tag_ == Tag::kPrelu) {
    data_.prelu = std::move(prelu);
  } else {
    DestroyActive();
    tag_ = Tag::kPrelu;
    new (&data_.prelu) PreluPtr(
        std::move(prelu));
  }
}

void Operation::set_quantize_linear(QuantizeLinearPtr quantize_linear) {
  if (tag_ == Tag::kQuantizeLinear) {
    data_.quantize_linear = std::move(quantize_linear);
  } else {
    DestroyActive();
    tag_ = Tag::kQuantizeLinear;
    new (&data_.quantize_linear) QuantizeLinearPtr(
        std::move(quantize_linear));
  }
}

void Operation::set_reduce(ReducePtr reduce) {
  if (tag_ == Tag::kReduce) {
    data_.reduce = std::move(reduce);
  } else {
    DestroyActive();
    tag_ = Tag::kReduce;
    new (&data_.reduce) ReducePtr(
        std::move(reduce));
  }
}

void Operation::set_relu(ReluPtr relu) {
  if (tag_ == Tag::kRelu) {
    data_.relu = std::move(relu);
  } else {
    DestroyActive();
    tag_ = Tag::kRelu;
    new (&data_.relu) ReluPtr(
        std::move(relu));
  }
}

void Operation::set_resample2d(Resample2dPtr resample2d) {
  if (tag_ == Tag::kResample2d) {
    data_.resample2d = std::move(resample2d);
  } else {
    DestroyActive();
    tag_ = Tag::kResample2d;
    new (&data_.resample2d) Resample2dPtr(
        std::move(resample2d));
  }
}

void Operation::set_reshape(ReshapePtr reshape) {
  if (tag_ == Tag::kReshape) {
    data_.reshape = std::move(reshape);
  } else {
    DestroyActive();
    tag_ = Tag::kReshape;
    new (&data_.reshape) ReshapePtr(
        std::move(reshape));
  }
}

void Operation::set_reverse(ReversePtr reverse) {
  if (tag_ == Tag::kReverse) {
    data_.reverse = std::move(reverse);
  } else {
    DestroyActive();
    tag_ = Tag::kReverse;
    new (&data_.reverse) ReversePtr(
        std::move(reverse));
  }
}

void Operation::set_scatter_elements(ScatterElementsPtr scatter_elements) {
  if (tag_ == Tag::kScatterElements) {
    data_.scatter_elements = std::move(scatter_elements);
  } else {
    DestroyActive();
    tag_ = Tag::kScatterElements;
    new (&data_.scatter_elements) ScatterElementsPtr(
        std::move(scatter_elements));
  }
}

void Operation::set_scatter_nd(ScatterNDPtr scatter_nd) {
  if (tag_ == Tag::kScatterNd) {
    data_.scatter_nd = std::move(scatter_nd);
  } else {
    DestroyActive();
    tag_ = Tag::kScatterNd;
    new (&data_.scatter_nd) ScatterNDPtr(
        std::move(scatter_nd));
  }
}

void Operation::set_sigmoid(SigmoidPtr sigmoid) {
  if (tag_ == Tag::kSigmoid) {
    data_.sigmoid = std::move(sigmoid);
  } else {
    DestroyActive();
    tag_ = Tag::kSigmoid;
    new (&data_.sigmoid) SigmoidPtr(
        std::move(sigmoid));
  }
}

void Operation::set_slice(SlicePtr slice) {
  if (tag_ == Tag::kSlice) {
    data_.slice = std::move(slice);
  } else {
    DestroyActive();
    tag_ = Tag::kSlice;
    new (&data_.slice) SlicePtr(
        std::move(slice));
  }
}

void Operation::set_softmax(SoftmaxPtr softmax) {
  if (tag_ == Tag::kSoftmax) {
    data_.softmax = std::move(softmax);
  } else {
    DestroyActive();
    tag_ = Tag::kSoftmax;
    new (&data_.softmax) SoftmaxPtr(
        std::move(softmax));
  }
}

void Operation::set_softplus(SoftplusPtr softplus) {
  if (tag_ == Tag::kSoftplus) {
    data_.softplus = std::move(softplus);
  } else {
    DestroyActive();
    tag_ = Tag::kSoftplus;
    new (&data_.softplus) SoftplusPtr(
        std::move(softplus));
  }
}

void Operation::set_softsign(SoftsignPtr softsign) {
  if (tag_ == Tag::kSoftsign) {
    data_.softsign = std::move(softsign);
  } else {
    DestroyActive();
    tag_ = Tag::kSoftsign;
    new (&data_.softsign) SoftsignPtr(
        std::move(softsign));
  }
}

void Operation::set_split(SplitPtr split) {
  if (tag_ == Tag::kSplit) {
    data_.split = std::move(split);
  } else {
    DestroyActive();
    tag_ = Tag::kSplit;
    new (&data_.split) SplitPtr(
        std::move(split));
  }
}

void Operation::set_tanh(TanhPtr tanh) {
  if (tag_ == Tag::kTanh) {
    data_.tanh = std::move(tanh);
  } else {
    DestroyActive();
    tag_ = Tag::kTanh;
    new (&data_.tanh) TanhPtr(
        std::move(tanh));
  }
}

void Operation::set_tile(TilePtr tile) {
  if (tag_ == Tag::kTile) {
    data_.tile = std::move(tile);
  } else {
    DestroyActive();
    tag_ = Tag::kTile;
    new (&data_.tile) TilePtr(
        std::move(tile));
  }
}

void Operation::set_transpose(TransposePtr transpose) {
  if (tag_ == Tag::kTranspose) {
    data_.transpose = std::move(transpose);
  } else {
    DestroyActive();
    tag_ = Tag::kTranspose;
    new (&data_.transpose) TransposePtr(
        std::move(transpose));
  }
}

void Operation::set_triangular(TriangularPtr triangular) {
  if (tag_ == Tag::kTriangular) {
    data_.triangular = std::move(triangular);
  } else {
    DestroyActive();
    tag_ = Tag::kTriangular;
    new (&data_.triangular) TriangularPtr(
        std::move(triangular));
  }
}

void Operation::set_where(WherePtr where) {
  if (tag_ == Tag::kWhere) {
    data_.where = std::move(where);
  } else {
    DestroyActive();
    tag_ = Tag::kWhere;
    new (&data_.where) WherePtr(
        std::move(where));
  }
}


Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kArgMinMax)>,
    ArgMinMaxPtr value)
    : arg_min_max(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBatchNormalization)>,
    BatchNormalizationPtr value)
    : batch_normalization(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kClamp)>,
    ClampPtr value)
    : clamp(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kConcat)>,
    ConcatPtr value)
    : concat(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kConv2d)>,
    Conv2dPtr value)
    : conv2d(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kCumulativeSum)>,
    CumulativeSumPtr value)
    : cumulative_sum(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDequantizeLinear)>,
    DequantizeLinearPtr value)
    : dequantize_linear(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseBinary)>,
    ElementWiseBinaryPtr value)
    : element_wise_binary(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kElu)>,
    EluPtr value)
    : elu(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kElementWiseUnary)>,
    ElementWiseUnaryPtr value)
    : element_wise_unary(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kExpand)>,
    ExpandPtr value)
    : expand(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGather)>,
    GatherPtr value)
    : gather(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGatherElements)>,
    GatherElementsPtr value)
    : gather_elements(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGatherNd)>,
    GatherNDPtr value)
    : gather_nd(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGelu)>,
    GeluPtr value)
    : gelu(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGemm)>,
    GemmPtr value)
    : gemm(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGru)>,
    GruPtr value)
    : gru(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kGruCell)>,
    GruCellPtr value)
    : gru_cell(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHardSigmoid)>,
    HardSigmoidPtr value)
    : hard_sigmoid(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHardSwish)>,
    HardSwishPtr value)
    : hard_swish(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLayerNormalization)>,
    LayerNormalizationPtr value)
    : layer_normalization(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kInstanceNormalization)>,
    InstanceNormalizationPtr value)
    : instance_normalization(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLeakyRelu)>,
    LeakyReluPtr value)
    : leaky_relu(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLinear)>,
    LinearPtr value)
    : linear(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLstm)>,
    LstmPtr value)
    : lstm(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kLstmCell)>,
    LstmCellPtr value)
    : lstm_cell(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kMatmul)>,
    MatmulPtr value)
    : matmul(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPad)>,
    PadPtr value)
    : pad(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPool2d)>,
    Pool2dPtr value)
    : pool2d(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPrelu)>,
    PreluPtr value)
    : prelu(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kQuantizeLinear)>,
    QuantizeLinearPtr value)
    : quantize_linear(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReduce)>,
    ReducePtr value)
    : reduce(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRelu)>,
    ReluPtr value)
    : relu(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kResample2d)>,
    Resample2dPtr value)
    : resample2d(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReshape)>,
    ReshapePtr value)
    : reshape(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kReverse)>,
    ReversePtr value)
    : reverse(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScatterElements)>,
    ScatterElementsPtr value)
    : scatter_elements(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScatterNd)>,
    ScatterNDPtr value)
    : scatter_nd(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSigmoid)>,
    SigmoidPtr value)
    : sigmoid(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSlice)>,
    SlicePtr value)
    : slice(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftmax)>,
    SoftmaxPtr value)
    : softmax(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftplus)>,
    SoftplusPtr value)
    : softplus(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSoftsign)>,
    SoftsignPtr value)
    : softsign(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplit)>,
    SplitPtr value)
    : split(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTanh)>,
    TanhPtr value)
    : tanh(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTile)>,
    TilePtr value)
    : tile(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranspose)>,
    TransposePtr value)
    : transpose(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTriangular)>,
    TriangularPtr value)
    : triangular(std::move(value)) {}

Operation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kWhere)>,
    WherePtr value)
    : where(std::move(value)) {}

void Operation::DestroyActive() {
  switch (tag_) {

    case Tag::kArgMinMax:
      std::destroy_at(&data_.arg_min_max);
      break;
    case Tag::kBatchNormalization:
      std::destroy_at(&data_.batch_normalization);
      break;
    case Tag::kClamp:
      std::destroy_at(&data_.clamp);
      break;
    case Tag::kConcat:
      std::destroy_at(&data_.concat);
      break;
    case Tag::kConv2d:
      std::destroy_at(&data_.conv2d);
      break;
    case Tag::kCumulativeSum:
      std::destroy_at(&data_.cumulative_sum);
      break;
    case Tag::kDequantizeLinear:
      std::destroy_at(&data_.dequantize_linear);
      break;
    case Tag::kElementWiseBinary:
      std::destroy_at(&data_.element_wise_binary);
      break;
    case Tag::kElu:
      std::destroy_at(&data_.elu);
      break;
    case Tag::kElementWiseUnary:
      std::destroy_at(&data_.element_wise_unary);
      break;
    case Tag::kExpand:
      std::destroy_at(&data_.expand);
      break;
    case Tag::kGather:
      std::destroy_at(&data_.gather);
      break;
    case Tag::kGatherElements:
      std::destroy_at(&data_.gather_elements);
      break;
    case Tag::kGatherNd:
      std::destroy_at(&data_.gather_nd);
      break;
    case Tag::kGelu:
      std::destroy_at(&data_.gelu);
      break;
    case Tag::kGemm:
      std::destroy_at(&data_.gemm);
      break;
    case Tag::kGru:
      std::destroy_at(&data_.gru);
      break;
    case Tag::kGruCell:
      std::destroy_at(&data_.gru_cell);
      break;
    case Tag::kHardSigmoid:
      std::destroy_at(&data_.hard_sigmoid);
      break;
    case Tag::kHardSwish:
      std::destroy_at(&data_.hard_swish);
      break;
    case Tag::kLayerNormalization:
      std::destroy_at(&data_.layer_normalization);
      break;
    case Tag::kInstanceNormalization:
      std::destroy_at(&data_.instance_normalization);
      break;
    case Tag::kLeakyRelu:
      std::destroy_at(&data_.leaky_relu);
      break;
    case Tag::kLinear:
      std::destroy_at(&data_.linear);
      break;
    case Tag::kLstm:
      std::destroy_at(&data_.lstm);
      break;
    case Tag::kLstmCell:
      std::destroy_at(&data_.lstm_cell);
      break;
    case Tag::kMatmul:
      std::destroy_at(&data_.matmul);
      break;
    case Tag::kPad:
      std::destroy_at(&data_.pad);
      break;
    case Tag::kPool2d:
      std::destroy_at(&data_.pool2d);
      break;
    case Tag::kPrelu:
      std::destroy_at(&data_.prelu);
      break;
    case Tag::kQuantizeLinear:
      std::destroy_at(&data_.quantize_linear);
      break;
    case Tag::kReduce:
      std::destroy_at(&data_.reduce);
      break;
    case Tag::kRelu:
      std::destroy_at(&data_.relu);
      break;
    case Tag::kResample2d:
      std::destroy_at(&data_.resample2d);
      break;
    case Tag::kReshape:
      std::destroy_at(&data_.reshape);
      break;
    case Tag::kReverse:
      std::destroy_at(&data_.reverse);
      break;
    case Tag::kScatterElements:
      std::destroy_at(&data_.scatter_elements);
      break;
    case Tag::kScatterNd:
      std::destroy_at(&data_.scatter_nd);
      break;
    case Tag::kSigmoid:
      std::destroy_at(&data_.sigmoid);
      break;
    case Tag::kSlice:
      std::destroy_at(&data_.slice);
      break;
    case Tag::kSoftmax:
      std::destroy_at(&data_.softmax);
      break;
    case Tag::kSoftplus:
      std::destroy_at(&data_.softplus);
      break;
    case Tag::kSoftsign:
      std::destroy_at(&data_.softsign);
      break;
    case Tag::kSplit:
      std::destroy_at(&data_.split);
      break;
    case Tag::kTanh:
      std::destroy_at(&data_.tanh);
      break;
    case Tag::kTile:
      std::destroy_at(&data_.tile);
      break;
    case Tag::kTranspose:
      std::destroy_at(&data_.transpose);
      break;
    case Tag::kTriangular:
      std::destroy_at(&data_.triangular);
      break;
    case Tag::kWhere:
      std::destroy_at(&data_.where);
      break;
  }
}

bool Operation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebNNGraph::IPCStableHashFunction WebNNGraph::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebNNGraph>(message.name())) {
    case messages::WebNNGraph::kDispatch: {
      return &WebNNGraph::Dispatch_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebNNGraph::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebNNGraph>(message.name())) {
      case messages::WebNNGraph::kDispatch:
            return "Receive webnn::mojom::WebNNGraph::Dispatch";
    }
  } else {
    switch (static_cast<messages::WebNNGraph>(message.name())) {
      case messages::WebNNGraph::kDispatch:
            return "Receive reply webnn::mojom::WebNNGraph::Dispatch";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebNNGraph::Dispatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2890f1f0;  // IPCStableHash for webnn::mojom::WebNNGraph::Dispatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebNNGraphProxy::WebNNGraphProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebNNGraphProxy::Dispatch(
    const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>& in_named_inputs, const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>& in_named_outputs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNGraph::Dispatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("named_inputs"), in_named_inputs,
                        "<value of type const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("named_outputs"), in_named_outputs,
                        "<value of type const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNGraph::kDispatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNGraph_Dispatch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->named_inputs)::BaseType>
      named_inputs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& named_inputs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::WebNNTensorTokenDataView>>(
    in_named_inputs,
    named_inputs_fragment,
    &named_inputs_validate_params);

  params->named_inputs.Set(
      named_inputs_fragment.is_null() ? nullptr : named_inputs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->named_inputs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null named_inputs in WebNNGraph.Dispatch request");
  mojo::internal::MessageFragment<
      typename decltype(params->named_outputs)::BaseType>
      named_outputs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& named_outputs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::blink::mojom::WebNNTensorTokenDataView>>(
    in_named_outputs,
    named_outputs_fragment,
    &named_outputs_validate_params);

  params->named_outputs.Set(
      named_outputs_fragment.is_null() ? nullptr : named_outputs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->named_outputs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null named_outputs in WebNNGraph.Dispatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNGraph::Name_);
  message.set_method_name("Dispatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebNNGraphStubDispatch::Accept(
    WebNNGraph* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebNNGraph>(message->header()->name)) {
    case messages::WebNNGraph::kDispatch: {
      DCHECK(message->is_serialized());
      internal::WebNNGraph_Dispatch_Params_Data* params =
          reinterpret_cast<internal::WebNNGraph_Dispatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebNNGraph.0
      bool success = true;
      ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken> p_named_inputs{};
      ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken> p_named_outputs{};
      WebNNGraph_Dispatch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamedInputs(&p_named_inputs))
        success = false;
      if (success && !input_data_view.ReadNamedOutputs(&p_named_outputs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNGraph::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Dispatch(        
        std::move(p_named_inputs), 
        std::move(p_named_outputs));
      return true;
    }
  }
  return false;
}

// static
bool WebNNGraphStubDispatch::AcceptWithResponder(
    WebNNGraph* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebNNGraph>(message->header()->name)) {
    case messages::WebNNGraph::kDispatch: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebNNGraphValidationInfo[] = {
    { &internal::WebNNGraph_Dispatch_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebNNGraphRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNGraph::Name_,
    kWebNNGraphValidationInfo);
}



}  // webnn::mojom::blink


namespace mojo {


// static
bool StructTraits<::webnn::mojom::blink::OperandDescriptor::DataView, ::webnn::mojom::blink::OperandDescriptorPtr>::Read(
    ::webnn::mojom::blink::OperandDescriptor::DataView input,
    ::webnn::mojom::blink::OperandDescriptorPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::OperandDescriptorPtr result(::webnn::mojom::blink::OperandDescriptor::New());
  
      if (success && !input.ReadDataType(&result->data_type))
        success = false;
      if (success && !input.ReadShape(&result->shape))
        success = false;
      if (success && !input.ReadPendingPermutation(&result->pending_permutation))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::OperandId::DataView, ::webnn::mojom::blink::OperandIdPtr>::Read(
    ::webnn::mojom::blink::OperandId::DataView input,
    ::webnn::mojom::blink::OperandIdPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::OperandIdPtr result(::webnn::mojom::blink::OperandId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Operand::DataView, ::webnn::mojom::blink::OperandPtr>::Read(
    ::webnn::mojom::blink::Operand::DataView input,
    ::webnn::mojom::blink::OperandPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::OperandPtr result(::webnn::mojom::blink::Operand::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadDescriptor(&result->descriptor))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ArgMinMax::DataView, ::webnn::mojom::blink::ArgMinMaxPtr>::Read(
    ::webnn::mojom::blink::ArgMinMax::DataView input,
    ::webnn::mojom::blink::ArgMinMaxPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ArgMinMaxPtr result(::webnn::mojom::blink::ArgMinMax::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success)
        result->keep_dimensions = input.keep_dimensions();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::BatchNormalization::DataView, ::webnn::mojom::blink::BatchNormalizationPtr>::Read(
    ::webnn::mojom::blink::BatchNormalization::DataView input,
    ::webnn::mojom::blink::BatchNormalizationPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::BatchNormalizationPtr result(::webnn::mojom::blink::BatchNormalization::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadMeanOperandId(&result->mean_operand_id))
        success = false;
      if (success && !input.ReadVarianceOperandId(&result->variance_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadScaleOperandId(&result->scale_operand_id))
        success = false;
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success)
        result->epsilon = input.epsilon();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Clamp::DataView, ::webnn::mojom::blink::ClampPtr>::Read(
    ::webnn::mojom::blink::Clamp::DataView input,
    ::webnn::mojom::blink::ClampPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ClampPtr result(::webnn::mojom::blink::Clamp::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadMinValue(&result->min_value))
        success = false;
      if (success && !input.ReadMaxValue(&result->max_value))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Concat::DataView, ::webnn::mojom::blink::ConcatPtr>::Read(
    ::webnn::mojom::blink::Concat::DataView input,
    ::webnn::mojom::blink::ConcatPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ConcatPtr result(::webnn::mojom::blink::Concat::New());
  
      if (success && !input.ReadInputOperandIds(&result->input_operand_ids))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Size2d::DataView, ::webnn::mojom::blink::Size2dPtr>::Read(
    ::webnn::mojom::blink::Size2d::DataView input,
    ::webnn::mojom::blink::Size2dPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::Size2dPtr result(::webnn::mojom::blink::Size2d::New());
  
      if (success)
        result->height = input.height();
      if (success)
        result->width = input.width();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Padding2d::DataView, ::webnn::mojom::blink::Padding2dPtr>::Read(
    ::webnn::mojom::blink::Padding2d::DataView input,
    ::webnn::mojom::blink::Padding2dPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::Padding2dPtr result(::webnn::mojom::blink::Padding2d::New());
  
      if (success && !input.ReadBeginning(&result->beginning))
        success = false;
      if (success && !input.ReadEnding(&result->ending))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Conv2d::DataView, ::webnn::mojom::blink::Conv2dPtr>::Read(
    ::webnn::mojom::blink::Conv2d::DataView input,
    ::webnn::mojom::blink::Conv2dPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::Conv2dPtr result(::webnn::mojom::blink::Conv2d::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadFilterOperandId(&result->filter_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadPadding(&result->padding))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
      if (success && !input.ReadDilations(&result->dilations))
        success = false;
      if (success)
        result->groups = input.groups();
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::CumulativeSum::DataView, ::webnn::mojom::blink::CumulativeSumPtr>::Read(
    ::webnn::mojom::blink::CumulativeSum::DataView input,
    ::webnn::mojom::blink::CumulativeSumPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::CumulativeSumPtr result(::webnn::mojom::blink::CumulativeSum::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success)
        result->exclusive = input.exclusive();
      if (success)
        result->reversed = input.reversed();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::DequantizeLinear::DataView, ::webnn::mojom::blink::DequantizeLinearPtr>::Read(
    ::webnn::mojom::blink::DequantizeLinear::DataView input,
    ::webnn::mojom::blink::DequantizeLinearPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::DequantizeLinearPtr result(::webnn::mojom::blink::DequantizeLinear::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadScaleOperandId(&result->scale_operand_id))
        success = false;
      if (success && !input.ReadZeroPointOperandId(&result->zero_point_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ElementWiseBinary::DataView, ::webnn::mojom::blink::ElementWiseBinaryPtr>::Read(
    ::webnn::mojom::blink::ElementWiseBinary::DataView input,
    ::webnn::mojom::blink::ElementWiseBinaryPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ElementWiseBinaryPtr result(::webnn::mojom::blink::ElementWiseBinary::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadLhsOperandId(&result->lhs_operand_id))
        success = false;
      if (success && !input.ReadRhsOperandId(&result->rhs_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ElementWiseUnary::DataView, ::webnn::mojom::blink::ElementWiseUnaryPtr>::Read(
    ::webnn::mojom::blink::ElementWiseUnary::DataView input,
    ::webnn::mojom::blink::ElementWiseUnaryPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ElementWiseUnaryPtr result(::webnn::mojom::blink::ElementWiseUnary::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Expand::DataView, ::webnn::mojom::blink::ExpandPtr>::Read(
    ::webnn::mojom::blink::Expand::DataView input,
    ::webnn::mojom::blink::ExpandPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ExpandPtr result(::webnn::mojom::blink::Expand::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ConstantPadding::DataView, ::webnn::mojom::blink::ConstantPaddingPtr>::Read(
    ::webnn::mojom::blink::ConstantPadding::DataView input,
    ::webnn::mojom::blink::ConstantPaddingPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ConstantPaddingPtr result(::webnn::mojom::blink::ConstantPadding::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::EdgePadding::DataView, ::webnn::mojom::blink::EdgePaddingPtr>::Read(
    ::webnn::mojom::blink::EdgePadding::DataView input,
    ::webnn::mojom::blink::EdgePaddingPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::EdgePaddingPtr result(::webnn::mojom::blink::EdgePadding::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ReflectionPadding::DataView, ::webnn::mojom::blink::ReflectionPaddingPtr>::Read(
    ::webnn::mojom::blink::ReflectionPadding::DataView input,
    ::webnn::mojom::blink::ReflectionPaddingPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ReflectionPaddingPtr result(::webnn::mojom::blink::ReflectionPadding::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::InstanceNormalization::DataView, ::webnn::mojom::blink::InstanceNormalizationPtr>::Read(
    ::webnn::mojom::blink::InstanceNormalization::DataView input,
    ::webnn::mojom::blink::InstanceNormalizationPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::InstanceNormalizationPtr result(::webnn::mojom::blink::InstanceNormalization::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadScaleOperandId(&result->scale_operand_id))
        success = false;
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success)
        result->epsilon = input.epsilon();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Matmul::DataView, ::webnn::mojom::blink::MatmulPtr>::Read(
    ::webnn::mojom::blink::Matmul::DataView input,
    ::webnn::mojom::blink::MatmulPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::MatmulPtr result(::webnn::mojom::blink::Matmul::New());
  
      if (success && !input.ReadAOperandId(&result->a_operand_id))
        success = false;
      if (success && !input.ReadBOperandId(&result->b_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Pad::DataView, ::webnn::mojom::blink::PadPtr>::Read(
    ::webnn::mojom::blink::Pad::DataView input,
    ::webnn::mojom::blink::PadPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::PadPtr result(::webnn::mojom::blink::Pad::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadBeginningPadding(&result->beginning_padding))
        success = false;
      if (success && !input.ReadEndingPadding(&result->ending_padding))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Reduce::DataView, ::webnn::mojom::blink::ReducePtr>::Read(
    ::webnn::mojom::blink::Reduce::DataView input,
    ::webnn::mojom::blink::ReducePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ReducePtr result(::webnn::mojom::blink::Reduce::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success)
        result->keep_dimensions = input.keep_dimensions();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Pool2d::DataView, ::webnn::mojom::blink::Pool2dPtr>::Read(
    ::webnn::mojom::blink::Pool2d::DataView input,
    ::webnn::mojom::blink::Pool2dPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::Pool2dPtr result(::webnn::mojom::blink::Pool2d::New());
  
      if (success && !input.ReadKind(&result->kind))
        success = false;
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadWindowDimensions(&result->window_dimensions))
        success = false;
      if (success && !input.ReadPadding(&result->padding))
        success = false;
      if (success && !input.ReadStrides(&result->strides))
        success = false;
      if (success && !input.ReadDilations(&result->dilations))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Range::DataView, ::webnn::mojom::blink::RangePtr>::Read(
    ::webnn::mojom::blink::Range::DataView input,
    ::webnn::mojom::blink::RangePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::RangePtr result(::webnn::mojom::blink::Range::New());
  
      if (success)
        result->start = input.start();
      if (success)
        result->size = input.size();
      if (success)
        result->stride = input.stride();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Slice::DataView, ::webnn::mojom::blink::SlicePtr>::Read(
    ::webnn::mojom::blink::Slice::DataView input,
    ::webnn::mojom::blink::SlicePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SlicePtr result(::webnn::mojom::blink::Slice::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadRanges(&result->ranges))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Elu::DataView, ::webnn::mojom::blink::EluPtr>::Read(
    ::webnn::mojom::blink::Elu::DataView input,
    ::webnn::mojom::blink::EluPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::EluPtr result(::webnn::mojom::blink::Elu::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->alpha = input.alpha();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Gather::DataView, ::webnn::mojom::blink::GatherPtr>::Read(
    ::webnn::mojom::blink::Gather::DataView input,
    ::webnn::mojom::blink::GatherPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GatherPtr result(::webnn::mojom::blink::Gather::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadIndicesOperandId(&result->indices_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::GatherElements::DataView, ::webnn::mojom::blink::GatherElementsPtr>::Read(
    ::webnn::mojom::blink::GatherElements::DataView input,
    ::webnn::mojom::blink::GatherElementsPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GatherElementsPtr result(::webnn::mojom::blink::GatherElements::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadIndicesOperandId(&result->indices_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::GatherND::DataView, ::webnn::mojom::blink::GatherNDPtr>::Read(
    ::webnn::mojom::blink::GatherND::DataView input,
    ::webnn::mojom::blink::GatherNDPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GatherNDPtr result(::webnn::mojom::blink::GatherND::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadIndicesOperandId(&result->indices_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Gelu::DataView, ::webnn::mojom::blink::GeluPtr>::Read(
    ::webnn::mojom::blink::Gelu::DataView input,
    ::webnn::mojom::blink::GeluPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GeluPtr result(::webnn::mojom::blink::Gelu::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Gru::DataView, ::webnn::mojom::blink::GruPtr>::Read(
    ::webnn::mojom::blink::Gru::DataView input,
    ::webnn::mojom::blink::GruPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GruPtr result(::webnn::mojom::blink::Gru::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadWeightOperandId(&result->weight_operand_id))
        success = false;
      if (success && !input.ReadRecurrentWeightOperandId(&result->recurrent_weight_operand_id))
        success = false;
      if (success)
        result->steps = input.steps();
      if (success)
        result->hidden_size = input.hidden_size();
      if (success && !input.ReadOutputOperandIds(&result->output_operand_ids))
        success = false;
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadRecurrentBiasOperandId(&result->recurrent_bias_operand_id))
        success = false;
      if (success && !input.ReadInitialHiddenStateOperandId(&result->initial_hidden_state_operand_id))
        success = false;
      if (success)
        result->reset_after = input.reset_after();
      if (success)
        result->return_sequence = input.return_sequence();
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success && !input.ReadActivations(&result->activations))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::GruCell::DataView, ::webnn::mojom::blink::GruCellPtr>::Read(
    ::webnn::mojom::blink::GruCell::DataView input,
    ::webnn::mojom::blink::GruCellPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GruCellPtr result(::webnn::mojom::blink::GruCell::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadWeightOperandId(&result->weight_operand_id))
        success = false;
      if (success && !input.ReadRecurrentWeightOperandId(&result->recurrent_weight_operand_id))
        success = false;
      if (success && !input.ReadHiddenStateOperandId(&result->hidden_state_operand_id))
        success = false;
      if (success)
        result->hidden_size = input.hidden_size();
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadRecurrentBiasOperandId(&result->recurrent_bias_operand_id))
        success = false;
      if (success)
        result->reset_after = input.reset_after();
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success && !input.ReadActivations(&result->activations))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Gemm::DataView, ::webnn::mojom::blink::GemmPtr>::Read(
    ::webnn::mojom::blink::Gemm::DataView input,
    ::webnn::mojom::blink::GemmPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GemmPtr result(::webnn::mojom::blink::Gemm::New());
  
      if (success && !input.ReadAOperandId(&result->a_operand_id))
        success = false;
      if (success && !input.ReadBOperandId(&result->b_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadCOperandId(&result->c_operand_id))
        success = false;
      if (success)
        result->alpha = input.alpha();
      if (success)
        result->beta = input.beta();
      if (success)
        result->a_transpose = input.a_transpose();
      if (success)
        result->b_transpose = input.b_transpose();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::HardSigmoid::DataView, ::webnn::mojom::blink::HardSigmoidPtr>::Read(
    ::webnn::mojom::blink::HardSigmoid::DataView input,
    ::webnn::mojom::blink::HardSigmoidPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::HardSigmoidPtr result(::webnn::mojom::blink::HardSigmoid::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->alpha = input.alpha();
      if (success)
        result->beta = input.beta();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::HardSwish::DataView, ::webnn::mojom::blink::HardSwishPtr>::Read(
    ::webnn::mojom::blink::HardSwish::DataView input,
    ::webnn::mojom::blink::HardSwishPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::HardSwishPtr result(::webnn::mojom::blink::HardSwish::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::LayerNormalization::DataView, ::webnn::mojom::blink::LayerNormalizationPtr>::Read(
    ::webnn::mojom::blink::LayerNormalization::DataView input,
    ::webnn::mojom::blink::LayerNormalizationPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::LayerNormalizationPtr result(::webnn::mojom::blink::LayerNormalization::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadScaleOperandId(&result->scale_operand_id))
        success = false;
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success)
        result->epsilon = input.epsilon();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::LeakyRelu::DataView, ::webnn::mojom::blink::LeakyReluPtr>::Read(
    ::webnn::mojom::blink::LeakyRelu::DataView input,
    ::webnn::mojom::blink::LeakyReluPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::LeakyReluPtr result(::webnn::mojom::blink::LeakyRelu::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->alpha = input.alpha();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Linear::DataView, ::webnn::mojom::blink::LinearPtr>::Read(
    ::webnn::mojom::blink::Linear::DataView input,
    ::webnn::mojom::blink::LinearPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::LinearPtr result(::webnn::mojom::blink::Linear::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->alpha = input.alpha();
      if (success)
        result->beta = input.beta();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Lstm::DataView, ::webnn::mojom::blink::LstmPtr>::Read(
    ::webnn::mojom::blink::Lstm::DataView input,
    ::webnn::mojom::blink::LstmPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::LstmPtr result(::webnn::mojom::blink::Lstm::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadWeightOperandId(&result->weight_operand_id))
        success = false;
      if (success && !input.ReadRecurrentWeightOperandId(&result->recurrent_weight_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandIds(&result->output_operand_ids))
        success = false;
      if (success)
        result->steps = input.steps();
      if (success)
        result->hidden_size = input.hidden_size();
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadRecurrentBiasOperandId(&result->recurrent_bias_operand_id))
        success = false;
      if (success && !input.ReadPeepholeWeightOperandId(&result->peephole_weight_operand_id))
        success = false;
      if (success && !input.ReadInitialHiddenStateOperandId(&result->initial_hidden_state_operand_id))
        success = false;
      if (success && !input.ReadInitialCellStateOperandId(&result->initial_cell_state_operand_id))
        success = false;
      if (success)
        result->return_sequence = input.return_sequence();
      if (success && !input.ReadDirection(&result->direction))
        success = false;
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success && !input.ReadActivations(&result->activations))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::LstmCell::DataView, ::webnn::mojom::blink::LstmCellPtr>::Read(
    ::webnn::mojom::blink::LstmCell::DataView input,
    ::webnn::mojom::blink::LstmCellPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::LstmCellPtr result(::webnn::mojom::blink::LstmCell::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadWeightOperandId(&result->weight_operand_id))
        success = false;
      if (success && !input.ReadRecurrentWeightOperandId(&result->recurrent_weight_operand_id))
        success = false;
      if (success && !input.ReadHiddenStateOperandId(&result->hidden_state_operand_id))
        success = false;
      if (success && !input.ReadCellStateOperandId(&result->cell_state_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandIds(&result->output_operand_ids))
        success = false;
      if (success)
        result->hidden_size = input.hidden_size();
      if (success && !input.ReadBiasOperandId(&result->bias_operand_id))
        success = false;
      if (success && !input.ReadRecurrentBiasOperandId(&result->recurrent_bias_operand_id))
        success = false;
      if (success && !input.ReadPeepholeWeightOperandId(&result->peephole_weight_operand_id))
        success = false;
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success && !input.ReadActivations(&result->activations))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Prelu::DataView, ::webnn::mojom::blink::PreluPtr>::Read(
    ::webnn::mojom::blink::Prelu::DataView input,
    ::webnn::mojom::blink::PreluPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::PreluPtr result(::webnn::mojom::blink::Prelu::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadSlopeOperandId(&result->slope_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::QuantizeLinear::DataView, ::webnn::mojom::blink::QuantizeLinearPtr>::Read(
    ::webnn::mojom::blink::QuantizeLinear::DataView input,
    ::webnn::mojom::blink::QuantizeLinearPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::QuantizeLinearPtr result(::webnn::mojom::blink::QuantizeLinear::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadScaleOperandId(&result->scale_operand_id))
        success = false;
      if (success && !input.ReadZeroPointOperandId(&result->zero_point_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Relu::DataView, ::webnn::mojom::blink::ReluPtr>::Read(
    ::webnn::mojom::blink::Relu::DataView input,
    ::webnn::mojom::blink::ReluPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ReluPtr result(::webnn::mojom::blink::Relu::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Reshape::DataView, ::webnn::mojom::blink::ReshapePtr>::Read(
    ::webnn::mojom::blink::Reshape::DataView input,
    ::webnn::mojom::blink::ReshapePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ReshapePtr result(::webnn::mojom::blink::Reshape::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Reverse::DataView, ::webnn::mojom::blink::ReversePtr>::Read(
    ::webnn::mojom::blink::Reverse::DataView input,
    ::webnn::mojom::blink::ReversePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ReversePtr result(::webnn::mojom::blink::Reverse::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ScatterElements::DataView, ::webnn::mojom::blink::ScatterElementsPtr>::Read(
    ::webnn::mojom::blink::ScatterElements::DataView input,
    ::webnn::mojom::blink::ScatterElementsPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ScatterElementsPtr result(::webnn::mojom::blink::ScatterElements::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadIndicesOperandId(&result->indices_operand_id))
        success = false;
      if (success && !input.ReadUpdatesOperandId(&result->updates_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::ScatterND::DataView, ::webnn::mojom::blink::ScatterNDPtr>::Read(
    ::webnn::mojom::blink::ScatterND::DataView input,
    ::webnn::mojom::blink::ScatterNDPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::ScatterNDPtr result(::webnn::mojom::blink::ScatterND::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadIndicesOperandId(&result->indices_operand_id))
        success = false;
      if (success && !input.ReadUpdatesOperandId(&result->updates_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Sigmoid::DataView, ::webnn::mojom::blink::SigmoidPtr>::Read(
    ::webnn::mojom::blink::Sigmoid::DataView input,
    ::webnn::mojom::blink::SigmoidPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SigmoidPtr result(::webnn::mojom::blink::Sigmoid::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Softmax::DataView, ::webnn::mojom::blink::SoftmaxPtr>::Read(
    ::webnn::mojom::blink::Softmax::DataView input,
    ::webnn::mojom::blink::SoftmaxPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SoftmaxPtr result(::webnn::mojom::blink::Softmax::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Softplus::DataView, ::webnn::mojom::blink::SoftplusPtr>::Read(
    ::webnn::mojom::blink::Softplus::DataView input,
    ::webnn::mojom::blink::SoftplusPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SoftplusPtr result(::webnn::mojom::blink::Softplus::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Softsign::DataView, ::webnn::mojom::blink::SoftsignPtr>::Read(
    ::webnn::mojom::blink::Softsign::DataView input,
    ::webnn::mojom::blink::SoftsignPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SoftsignPtr result(::webnn::mojom::blink::Softsign::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Split::DataView, ::webnn::mojom::blink::SplitPtr>::Read(
    ::webnn::mojom::blink::Split::DataView input,
    ::webnn::mojom::blink::SplitPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::SplitPtr result(::webnn::mojom::blink::Split::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandIds(&result->output_operand_ids))
        success = false;
      if (success)
        result->axis = input.axis();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Tanh::DataView, ::webnn::mojom::blink::TanhPtr>::Read(
    ::webnn::mojom::blink::Tanh::DataView input,
    ::webnn::mojom::blink::TanhPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TanhPtr result(::webnn::mojom::blink::Tanh::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Tile::DataView, ::webnn::mojom::blink::TilePtr>::Read(
    ::webnn::mojom::blink::Tile::DataView input,
    ::webnn::mojom::blink::TilePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TilePtr result(::webnn::mojom::blink::Tile::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadRepetitions(&result->repetitions))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Transpose::DataView, ::webnn::mojom::blink::TransposePtr>::Read(
    ::webnn::mojom::blink::Transpose::DataView input,
    ::webnn::mojom::blink::TransposePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TransposePtr result(::webnn::mojom::blink::Transpose::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadPermutation(&result->permutation))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Triangular::DataView, ::webnn::mojom::blink::TriangularPtr>::Read(
    ::webnn::mojom::blink::Triangular::DataView input,
    ::webnn::mojom::blink::TriangularPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::TriangularPtr result(::webnn::mojom::blink::Triangular::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success)
        result->upper = input.upper();
      if (success)
        result->diagonal = input.diagonal();
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Resample2d::DataView, ::webnn::mojom::blink::Resample2dPtr>::Read(
    ::webnn::mojom::blink::Resample2d::DataView input,
    ::webnn::mojom::blink::Resample2dPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::Resample2dPtr result(::webnn::mojom::blink::Resample2d::New());
  
      if (success && !input.ReadInputOperandId(&result->input_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadScales(&result->scales))
        success = false;
      if (success && !input.ReadAxes(&result->axes))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::Where::DataView, ::webnn::mojom::blink::WherePtr>::Read(
    ::webnn::mojom::blink::Where::DataView input,
    ::webnn::mojom::blink::WherePtr* output) {
  bool success = true;
  ::webnn::mojom::blink::WherePtr result(::webnn::mojom::blink::Where::New());
  
      if (success && !input.ReadConditionOperandId(&result->condition_operand_id))
        success = false;
      if (success && !input.ReadTrueValueOperandId(&result->true_value_operand_id))
        success = false;
      if (success && !input.ReadFalseValueOperandId(&result->false_value_operand_id))
        success = false;
      if (success && !input.ReadOutputOperandId(&result->output_operand_id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::GraphInfo::DataView, ::webnn::mojom::blink::GraphInfoPtr>::Read(
    ::webnn::mojom::blink::GraphInfo::DataView input,
    ::webnn::mojom::blink::GraphInfoPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::GraphInfoPtr result(::webnn::mojom::blink::GraphInfo::New());
  
      if (success && !input.ReadOperands(&result->operands))
        success = false;
      if (success && !input.ReadInputOperands(&result->input_operands))
        success = false;
      if (success && !input.ReadOutputOperands(&result->output_operands))
        success = false;
      if (success && !input.ReadOperations(&result->operations))
        success = false;
      if (success && !input.ReadConstantOperandIdsToHandles(&result->constant_operand_ids_to_handles))
        success = false;
      if (success && !input.ReadIdToConstantTensorOperandMap(&result->id_to_constant_tensor_operand_map))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::webnn::mojom::blink::Number::DataView, ::webnn::mojom::blink::NumberPtr>::Read(
    ::webnn::mojom::blink::Number::DataView input,
    ::webnn::mojom::blink::NumberPtr* output) {
  using UnionType = ::webnn::mojom::blink::Number;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFloatingPoint: {
      *output = UnionType::NewFloatingPoint(input.floating_point());
      break;
    }
    case Tag::kSignedInteger: {
      *output = UnionType::NewSignedInteger(input.signed_integer());
      break;
    }
    case Tag::kUnsignedInteger: {
      *output = UnionType::NewUnsignedInteger(input.unsigned_integer());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::webnn::mojom::blink::PaddingMode::DataView, ::webnn::mojom::blink::PaddingModePtr>::Read(
    ::webnn::mojom::blink::PaddingMode::DataView input,
    ::webnn::mojom::blink::PaddingModePtr* output) {
  using UnionType = ::webnn::mojom::blink::PaddingMode;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kConstant: {
      ::webnn::mojom::blink::ConstantPaddingPtr result_constant{};
      if (!input.ReadConstant(&result_constant))
        return false;

      *output = UnionType::NewConstant(
          std::move(result_constant));
      break;
    }
    case Tag::kEdge: {
      ::webnn::mojom::blink::EdgePaddingPtr result_edge{};
      if (!input.ReadEdge(&result_edge))
        return false;

      *output = UnionType::NewEdge(
          std::move(result_edge));
      break;
    }
    case Tag::kReflection: {
      ::webnn::mojom::blink::ReflectionPaddingPtr result_reflection{};
      if (!input.ReadReflection(&result_reflection))
        return false;

      *output = UnionType::NewReflection(
          std::move(result_reflection));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::webnn::mojom::blink::Operation::DataView, ::webnn::mojom::blink::OperationPtr>::Read(
    ::webnn::mojom::blink::Operation::DataView input,
    ::webnn::mojom::blink::OperationPtr* output) {
  using UnionType = ::webnn::mojom::blink::Operation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kArgMinMax: {
      ::webnn::mojom::blink::ArgMinMaxPtr result_arg_min_max{};
      if (!input.ReadArgMinMax(&result_arg_min_max))
        return false;

      *output = UnionType::NewArgMinMax(
          std::move(result_arg_min_max));
      break;
    }
    case Tag::kBatchNormalization: {
      ::webnn::mojom::blink::BatchNormalizationPtr result_batch_normalization{};
      if (!input.ReadBatchNormalization(&result_batch_normalization))
        return false;

      *output = UnionType::NewBatchNormalization(
          std::move(result_batch_normalization));
      break;
    }
    case Tag::kClamp: {
      ::webnn::mojom::blink::ClampPtr result_clamp{};
      if (!input.ReadClamp(&result_clamp))
        return false;

      *output = UnionType::NewClamp(
          std::move(result_clamp));
      break;
    }
    case Tag::kConcat: {
      ::webnn::mojom::blink::ConcatPtr result_concat{};
      if (!input.ReadConcat(&result_concat))
        return false;

      *output = UnionType::NewConcat(
          std::move(result_concat));
      break;
    }
    case Tag::kConv2d: {
      ::webnn::mojom::blink::Conv2dPtr result_conv2d{};
      if (!input.ReadConv2d(&result_conv2d))
        return false;

      *output = UnionType::NewConv2d(
          std::move(result_conv2d));
      break;
    }
    case Tag::kCumulativeSum: {
      ::webnn::mojom::blink::CumulativeSumPtr result_cumulative_sum{};
      if (!input.ReadCumulativeSum(&result_cumulative_sum))
        return false;

      *output = UnionType::NewCumulativeSum(
          std::move(result_cumulative_sum));
      break;
    }
    case Tag::kDequantizeLinear: {
      ::webnn::mojom::blink::DequantizeLinearPtr result_dequantize_linear{};
      if (!input.ReadDequantizeLinear(&result_dequantize_linear))
        return false;

      *output = UnionType::NewDequantizeLinear(
          std::move(result_dequantize_linear));
      break;
    }
    case Tag::kElementWiseBinary: {
      ::webnn::mojom::blink::ElementWiseBinaryPtr result_element_wise_binary{};
      if (!input.ReadElementWiseBinary(&result_element_wise_binary))
        return false;

      *output = UnionType::NewElementWiseBinary(
          std::move(result_element_wise_binary));
      break;
    }
    case Tag::kElu: {
      ::webnn::mojom::blink::EluPtr result_elu{};
      if (!input.ReadElu(&result_elu))
        return false;

      *output = UnionType::NewElu(
          std::move(result_elu));
      break;
    }
    case Tag::kElementWiseUnary: {
      ::webnn::mojom::blink::ElementWiseUnaryPtr result_element_wise_unary{};
      if (!input.ReadElementWiseUnary(&result_element_wise_unary))
        return false;

      *output = UnionType::NewElementWiseUnary(
          std::move(result_element_wise_unary));
      break;
    }
    case Tag::kExpand: {
      ::webnn::mojom::blink::ExpandPtr result_expand{};
      if (!input.ReadExpand(&result_expand))
        return false;

      *output = UnionType::NewExpand(
          std::move(result_expand));
      break;
    }
    case Tag::kGather: {
      ::webnn::mojom::blink::GatherPtr result_gather{};
      if (!input.ReadGather(&result_gather))
        return false;

      *output = UnionType::NewGather(
          std::move(result_gather));
      break;
    }
    case Tag::kGatherElements: {
      ::webnn::mojom::blink::GatherElementsPtr result_gather_elements{};
      if (!input.ReadGatherElements(&result_gather_elements))
        return false;

      *output = UnionType::NewGatherElements(
          std::move(result_gather_elements));
      break;
    }
    case Tag::kGatherNd: {
      ::webnn::mojom::blink::GatherNDPtr result_gather_nd{};
      if (!input.ReadGatherNd(&result_gather_nd))
        return false;

      *output = UnionType::NewGatherNd(
          std::move(result_gather_nd));
      break;
    }
    case Tag::kGelu: {
      ::webnn::mojom::blink::GeluPtr result_gelu{};
      if (!input.ReadGelu(&result_gelu))
        return false;

      *output = UnionType::NewGelu(
          std::move(result_gelu));
      break;
    }
    case Tag::kGemm: {
      ::webnn::mojom::blink::GemmPtr result_gemm{};
      if (!input.ReadGemm(&result_gemm))
        return false;

      *output = UnionType::NewGemm(
          std::move(result_gemm));
      break;
    }
    case Tag::kGru: {
      ::webnn::mojom::blink::GruPtr result_gru{};
      if (!input.ReadGru(&result_gru))
        return false;

      *output = UnionType::NewGru(
          std::move(result_gru));
      break;
    }
    case Tag::kGruCell: {
      ::webnn::mojom::blink::GruCellPtr result_gru_cell{};
      if (!input.ReadGruCell(&result_gru_cell))
        return false;

      *output = UnionType::NewGruCell(
          std::move(result_gru_cell));
      break;
    }
    case Tag::kHardSigmoid: {
      ::webnn::mojom::blink::HardSigmoidPtr result_hard_sigmoid{};
      if (!input.ReadHardSigmoid(&result_hard_sigmoid))
        return false;

      *output = UnionType::NewHardSigmoid(
          std::move(result_hard_sigmoid));
      break;
    }
    case Tag::kHardSwish: {
      ::webnn::mojom::blink::HardSwishPtr result_hard_swish{};
      if (!input.ReadHardSwish(&result_hard_swish))
        return false;

      *output = UnionType::NewHardSwish(
          std::move(result_hard_swish));
      break;
    }
    case Tag::kLayerNormalization: {
      ::webnn::mojom::blink::LayerNormalizationPtr result_layer_normalization{};
      if (!input.ReadLayerNormalization(&result_layer_normalization))
        return false;

      *output = UnionType::NewLayerNormalization(
          std::move(result_layer_normalization));
      break;
    }
    case Tag::kInstanceNormalization: {
      ::webnn::mojom::blink::InstanceNormalizationPtr result_instance_normalization{};
      if (!input.ReadInstanceNormalization(&result_instance_normalization))
        return false;

      *output = UnionType::NewInstanceNormalization(
          std::move(result_instance_normalization));
      break;
    }
    case Tag::kLeakyRelu: {
      ::webnn::mojom::blink::LeakyReluPtr result_leaky_relu{};
      if (!input.ReadLeakyRelu(&result_leaky_relu))
        return false;

      *output = UnionType::NewLeakyRelu(
          std::move(result_leaky_relu));
      break;
    }
    case Tag::kLinear: {
      ::webnn::mojom::blink::LinearPtr result_linear{};
      if (!input.ReadLinear(&result_linear))
        return false;

      *output = UnionType::NewLinear(
          std::move(result_linear));
      break;
    }
    case Tag::kLstm: {
      ::webnn::mojom::blink::LstmPtr result_lstm{};
      if (!input.ReadLstm(&result_lstm))
        return false;

      *output = UnionType::NewLstm(
          std::move(result_lstm));
      break;
    }
    case Tag::kLstmCell: {
      ::webnn::mojom::blink::LstmCellPtr result_lstm_cell{};
      if (!input.ReadLstmCell(&result_lstm_cell))
        return false;

      *output = UnionType::NewLstmCell(
          std::move(result_lstm_cell));
      break;
    }
    case Tag::kMatmul: {
      ::webnn::mojom::blink::MatmulPtr result_matmul{};
      if (!input.ReadMatmul(&result_matmul))
        return false;

      *output = UnionType::NewMatmul(
          std::move(result_matmul));
      break;
    }
    case Tag::kPad: {
      ::webnn::mojom::blink::PadPtr result_pad{};
      if (!input.ReadPad(&result_pad))
        return false;

      *output = UnionType::NewPad(
          std::move(result_pad));
      break;
    }
    case Tag::kPool2d: {
      ::webnn::mojom::blink::Pool2dPtr result_pool2d{};
      if (!input.ReadPool2d(&result_pool2d))
        return false;

      *output = UnionType::NewPool2d(
          std::move(result_pool2d));
      break;
    }
    case Tag::kPrelu: {
      ::webnn::mojom::blink::PreluPtr result_prelu{};
      if (!input.ReadPrelu(&result_prelu))
        return false;

      *output = UnionType::NewPrelu(
          std::move(result_prelu));
      break;
    }
    case Tag::kQuantizeLinear: {
      ::webnn::mojom::blink::QuantizeLinearPtr result_quantize_linear{};
      if (!input.ReadQuantizeLinear(&result_quantize_linear))
        return false;

      *output = UnionType::NewQuantizeLinear(
          std::move(result_quantize_linear));
      break;
    }
    case Tag::kReduce: {
      ::webnn::mojom::blink::ReducePtr result_reduce{};
      if (!input.ReadReduce(&result_reduce))
        return false;

      *output = UnionType::NewReduce(
          std::move(result_reduce));
      break;
    }
    case Tag::kRelu: {
      ::webnn::mojom::blink::ReluPtr result_relu{};
      if (!input.ReadRelu(&result_relu))
        return false;

      *output = UnionType::NewRelu(
          std::move(result_relu));
      break;
    }
    case Tag::kResample2d: {
      ::webnn::mojom::blink::Resample2dPtr result_resample2d{};
      if (!input.ReadResample2d(&result_resample2d))
        return false;

      *output = UnionType::NewResample2d(
          std::move(result_resample2d));
      break;
    }
    case Tag::kReshape: {
      ::webnn::mojom::blink::ReshapePtr result_reshape{};
      if (!input.ReadReshape(&result_reshape))
        return false;

      *output = UnionType::NewReshape(
          std::move(result_reshape));
      break;
    }
    case Tag::kReverse: {
      ::webnn::mojom::blink::ReversePtr result_reverse{};
      if (!input.ReadReverse(&result_reverse))
        return false;

      *output = UnionType::NewReverse(
          std::move(result_reverse));
      break;
    }
    case Tag::kScatterElements: {
      ::webnn::mojom::blink::ScatterElementsPtr result_scatter_elements{};
      if (!input.ReadScatterElements(&result_scatter_elements))
        return false;

      *output = UnionType::NewScatterElements(
          std::move(result_scatter_elements));
      break;
    }
    case Tag::kScatterNd: {
      ::webnn::mojom::blink::ScatterNDPtr result_scatter_nd{};
      if (!input.ReadScatterNd(&result_scatter_nd))
        return false;

      *output = UnionType::NewScatterNd(
          std::move(result_scatter_nd));
      break;
    }
    case Tag::kSigmoid: {
      ::webnn::mojom::blink::SigmoidPtr result_sigmoid{};
      if (!input.ReadSigmoid(&result_sigmoid))
        return false;

      *output = UnionType::NewSigmoid(
          std::move(result_sigmoid));
      break;
    }
    case Tag::kSlice: {
      ::webnn::mojom::blink::SlicePtr result_slice{};
      if (!input.ReadSlice(&result_slice))
        return false;

      *output = UnionType::NewSlice(
          std::move(result_slice));
      break;
    }
    case Tag::kSoftmax: {
      ::webnn::mojom::blink::SoftmaxPtr result_softmax{};
      if (!input.ReadSoftmax(&result_softmax))
        return false;

      *output = UnionType::NewSoftmax(
          std::move(result_softmax));
      break;
    }
    case Tag::kSoftplus: {
      ::webnn::mojom::blink::SoftplusPtr result_softplus{};
      if (!input.ReadSoftplus(&result_softplus))
        return false;

      *output = UnionType::NewSoftplus(
          std::move(result_softplus));
      break;
    }
    case Tag::kSoftsign: {
      ::webnn::mojom::blink::SoftsignPtr result_softsign{};
      if (!input.ReadSoftsign(&result_softsign))
        return false;

      *output = UnionType::NewSoftsign(
          std::move(result_softsign));
      break;
    }
    case Tag::kSplit: {
      ::webnn::mojom::blink::SplitPtr result_split{};
      if (!input.ReadSplit(&result_split))
        return false;

      *output = UnionType::NewSplit(
          std::move(result_split));
      break;
    }
    case Tag::kTanh: {
      ::webnn::mojom::blink::TanhPtr result_tanh{};
      if (!input.ReadTanh(&result_tanh))
        return false;

      *output = UnionType::NewTanh(
          std::move(result_tanh));
      break;
    }
    case Tag::kTile: {
      ::webnn::mojom::blink::TilePtr result_tile{};
      if (!input.ReadTile(&result_tile))
        return false;

      *output = UnionType::NewTile(
          std::move(result_tile));
      break;
    }
    case Tag::kTranspose: {
      ::webnn::mojom::blink::TransposePtr result_transpose{};
      if (!input.ReadTranspose(&result_transpose))
        return false;

      *output = UnionType::NewTranspose(
          std::move(result_transpose));
      break;
    }
    case Tag::kTriangular: {
      ::webnn::mojom::blink::TriangularPtr result_triangular{};
      if (!input.ReadTriangular(&result_triangular))
        return false;

      *output = UnionType::NewTriangular(
          std::move(result_triangular));
      break;
    }
    case Tag::kWhere: {
      ::webnn::mojom::blink::WherePtr result_where{};
      if (!input.ReadWhere(&result_where))
        return false;

      *output = UnionType::NewWhere(
          std::move(result_where));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom::blink {


void WebNNGraphInterceptorForTesting::Dispatch(const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>& named_inputs, const ::blink::HashMap<::blink::String, ::blink::WebNNTensorToken>& named_outputs) {
  GetForwardingInterface()->Dispatch(
    std::move(named_inputs)
    , 
    std::move(named_outputs)
    );
}
WebNNGraphAsyncWaiter::WebNNGraphAsyncWaiter(
    WebNNGraph* proxy) : proxy_(proxy) {}

WebNNGraphAsyncWaiter::~WebNNGraphAsyncWaiter() = default;







}  // webnn::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif