// services/webnn/public/mojom/webnn_context_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_context_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_context_provider.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_context_provider.mojom-blink-import-headers.h"
#include "services/webnn/public/mojom/webnn_context_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace webnn::mojom::blink {
CreateContextOptions::CreateContextOptions()
    : device(),
      power_preference() {}

CreateContextOptions::CreateContextOptions(
    ::webnn::mojom::blink::Device device_in,
    CreateContextOptions::PowerPreference power_preference_in)
    : device(std::move(device_in)),
      power_preference(std::move(power_preference_in)) {}

CreateContextOptions::~CreateContextOptions() = default;
size_t CreateContextOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->device);
  seed = mojo::internal::WTFHash(seed, this->power_preference);
  return seed;
}

void CreateContextOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device"), this->device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::webnn::mojom::blink::Device>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_preference"), this->power_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CreateContextOptions::PowerPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateContextOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateContextSuccess::CreateContextSuccess()
    : context_remote(),
      context_properties(mojo::internal::DefaultConstructTag()),
      context_handle(),
      write_tensor_producer(),
      read_tensor_consumer() {}

CreateContextSuccess::CreateContextSuccess(
    ::mojo::PendingRemote<::webnn::mojom::blink::WebNNContext> context_remote_in,
    const ::webnn::ContextProperties& context_properties_in,
    const ::blink::WebNNContextToken& context_handle_in,
    ::mojo::ScopedDataPipeProducerHandle write_tensor_producer_in,
    ::mojo::ScopedDataPipeConsumerHandle read_tensor_consumer_in)
    : context_remote(std::move(context_remote_in)),
      context_properties(std::move(context_properties_in)),
      context_handle(std::move(context_handle_in)),
      write_tensor_producer(std::move(write_tensor_producer_in)),
      read_tensor_consumer(std::move(read_tensor_consumer_in)) {}

CreateContextSuccess::~CreateContextSuccess() = default;

void CreateContextSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_remote"), this->context_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::webnn::mojom::blink::WebNNContext>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_properties"), this->context_properties,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::ContextProperties&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "context_handle"), this->context_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::WebNNContextToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "write_tensor_producer"), this->write_tensor_producer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeProducerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "read_tensor_consumer"), this->read_tensor_consumer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CreateContextSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateContextResultPtr
CreateContextResult::NewSuccess(
    CreateContextSuccessPtr value) {
  return CreateContextResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

CreateContextResultPtr
CreateContextResult::NewError(
    ::webnn::mojom::blink::ErrorPtr value) {
  return CreateContextResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

CreateContextResult::CreateContextResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateContextSuccessPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

CreateContextResult::CreateContextResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
CreateContextResult::~CreateContextResult() {
  DestroyActive();
}

void CreateContextResult::set_success(CreateContextSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) CreateContextSuccessPtr(
        std::move(success));
  }
}

void CreateContextResult::set_error(::webnn::mojom::blink::ErrorPtr error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) ::webnn::mojom::blink::ErrorPtr(
        std::move(error));
  }
}


CreateContextResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    CreateContextSuccessPtr value)
    : success(std::move(value)) {}

CreateContextResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    ::webnn::mojom::blink::ErrorPtr value)
    : error(std::move(value)) {}

void CreateContextResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool CreateContextResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebNNContextProvider::IPCStableHashFunction WebNNContextProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebNNContextProvider>(message.name())) {
    case messages::WebNNContextProvider::kCreateWebNNContext: {
      return &WebNNContextProvider::CreateWebNNContext_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebNNContextProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebNNContextProvider>(message.name())) {
      case messages::WebNNContextProvider::kCreateWebNNContext:
            return "Receive webnn::mojom::WebNNContextProvider::CreateWebNNContext";
    }
  } else {
    switch (static_cast<messages::WebNNContextProvider>(message.name())) {
      case messages::WebNNContextProvider::kCreateWebNNContext:
            return "Receive reply webnn::mojom::WebNNContextProvider::CreateWebNNContext";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebNNContextProvider::CreateWebNNContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20fe6edd;  // IPCStableHash for webnn::mojom::WebNNContextProvider::CreateWebNNContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

// static
bool WebNNContextProvider::RuntimeFeature_IsEnabled_(bool expected) {
  bool enabled = base::FeatureList::IsEnabled(::webnn::mojom::features::kWebMachineLearningNeuralNetwork);
#if DCHECK_IS_ON()
  if (expected) {
    DCHECK(enabled) << "RuntimeFeature ::webnn::mojom::features::kWebMachineLearningNeuralNetwork for WebNNContextProvider is not enabled";
  }
#endif
  return enabled;
}

class WebNNContextProvider_CreateWebNNContext_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebNNContextProvider_CreateWebNNContext_ForwardToCallback(
      WebNNContextProvider::CreateWebNNContextCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebNNContextProvider_CreateWebNNContext_ForwardToCallback(const WebNNContextProvider_CreateWebNNContext_ForwardToCallback&) = delete;
  WebNNContextProvider_CreateWebNNContext_ForwardToCallback& operator=(const WebNNContextProvider_CreateWebNNContext_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebNNContextProvider::CreateWebNNContextCallback callback_;
};

WebNNContextProviderProxy::WebNNContextProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebNNContextProviderProxy::CreateWebNNContext(
    CreateContextOptionsPtr in_options, CreateWebNNContextCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send webnn::mojom::WebNNContextProvider::CreateWebNNContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type CreateContextOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContextProvider::kCreateWebNNContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContextProvider_CreateWebNNContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::webnn::mojom::CreateContextOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in WebNNContextProvider.CreateWebNNContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContextProvider::Name_);
  message.set_method_name("CreateWebNNContext");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebNNContextProvider_CreateWebNNContext_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebNNContextProvider_CreateWebNNContext_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebNNContextProvider::CreateWebNNContextCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebNNContextProvider_CreateWebNNContext_ProxyToResponder> proxy(
        new WebNNContextProvider_CreateWebNNContext_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebNNContextProvider_CreateWebNNContext_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebNNContextProvider_CreateWebNNContext_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebNNContextProvider_CreateWebNNContext_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebNNContextProvider::CreateWebNNContextCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CreateContextResultPtr in_result);
};

bool WebNNContextProvider_CreateWebNNContext_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebNNContextProvider_CreateWebNNContext_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebNNContextProvider_CreateWebNNContext_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebNNContextProvider.0
  bool success = true;
  CreateContextResultPtr p_result{};
  WebNNContextProvider_CreateWebNNContext_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebNNContextProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebNNContextProvider_CreateWebNNContext_ProxyToResponder::Run(
    CreateContextResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply webnn::mojom::WebNNContextProvider::CreateWebNNContext", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateContextResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebNNContextProvider::kCreateWebNNContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::webnn::mojom::internal::WebNNContextProvider_CreateWebNNContext_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::webnn::mojom::CreateContextResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebNNContextProvider::Name_);
  message.set_method_name("CreateWebNNContext");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebNNContextProviderStubDispatch::Accept(
    WebNNContextProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebNNContextProvider>(message->header()->name)) {
    case messages::WebNNContextProvider::kCreateWebNNContext: {
      break;
    }
  }
  return false;
}

// static
bool WebNNContextProviderStubDispatch::AcceptWithResponder(
    WebNNContextProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebNNContextProvider>(message->header()->name)) {
    case messages::WebNNContextProvider::kCreateWebNNContext: {
      internal::WebNNContextProvider_CreateWebNNContext_Params_Data* params =
          reinterpret_cast<
              internal::WebNNContextProvider_CreateWebNNContext_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebNNContextProvider.0
      bool success = true;
      CreateContextOptionsPtr p_options{};
      WebNNContextProvider_CreateWebNNContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebNNContextProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          WebNNContextProvider_CreateWebNNContext_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebNNContext(        
        std::move(p_options), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebNNContextProviderValidationInfo[] = {
    { &internal::WebNNContextProvider_CreateWebNNContext_Params_Data::Validate,
     &internal::WebNNContextProvider_CreateWebNNContext_ResponseParams_Data::Validate},
};

bool WebNNContextProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNContextProvider::Name_,
    kWebNNContextProviderValidationInfo);
}

bool WebNNContextProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::webnn::mojom::blink::WebNNContextProvider::Name_,
    kWebNNContextProviderValidationInfo);
}


}  // webnn::mojom::blink


namespace mojo {


// static
bool StructTraits<::webnn::mojom::blink::CreateContextOptions::DataView, ::webnn::mojom::blink::CreateContextOptionsPtr>::Read(
    ::webnn::mojom::blink::CreateContextOptions::DataView input,
    ::webnn::mojom::blink::CreateContextOptionsPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::CreateContextOptionsPtr result(::webnn::mojom::blink::CreateContextOptions::New());
  
      if (success && !input.ReadDevice(&result->device))
        success = false;
      if (success && !input.ReadPowerPreference(&result->power_preference))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::blink::CreateContextSuccess::DataView, ::webnn::mojom::blink::CreateContextSuccessPtr>::Read(
    ::webnn::mojom::blink::CreateContextSuccess::DataView input,
    ::webnn::mojom::blink::CreateContextSuccessPtr* output) {
  bool success = true;
  ::webnn::mojom::blink::CreateContextSuccessPtr result(::webnn::mojom::blink::CreateContextSuccess::New());
  
      if (success) {
        result->context_remote =
            input.TakeContextRemote<decltype(result->context_remote)>();
      }
      if (success && !input.ReadContextProperties(&result->context_properties))
        success = false;
      if (success && !input.ReadContextHandle(&result->context_handle))
        success = false;
      if (success)
        result->write_tensor_producer = input.TakeWriteTensorProducer();
      if (success)
        result->read_tensor_consumer = input.TakeReadTensorConsumer();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::webnn::mojom::blink::CreateContextResult::DataView, ::webnn::mojom::blink::CreateContextResultPtr>::Read(
    ::webnn::mojom::blink::CreateContextResult::DataView input,
    ::webnn::mojom::blink::CreateContextResultPtr* output) {
  using UnionType = ::webnn::mojom::blink::CreateContextResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::webnn::mojom::blink::CreateContextSuccessPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kError: {
      ::webnn::mojom::blink::ErrorPtr result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom::blink {


void WebNNContextProviderInterceptorForTesting::CreateWebNNContext(CreateContextOptionsPtr options, CreateWebNNContextCallback callback) {
  GetForwardingInterface()->CreateWebNNContext(
    std::move(options)
    , std::move(callback));
}
WebNNContextProviderAsyncWaiter::WebNNContextProviderAsyncWaiter(
    WebNNContextProvider* proxy) : proxy_(proxy) {}

WebNNContextProviderAsyncWaiter::~WebNNContextProviderAsyncWaiter() = default;


void WebNNContextProviderAsyncWaiter::CreateWebNNContext(
    CreateContextOptionsPtr options, CreateContextResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->CreateWebNNContext(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             CreateContextResultPtr* out_result
,
             CreateContextResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CreateContextResultPtr WebNNContextProviderAsyncWaiter::CreateWebNNContext(
    CreateContextOptionsPtr options) {
  CreateContextResultPtr async_wait_result;
  CreateWebNNContext(std::move(options),&async_wait_result);
  return async_wait_result;
}






}  // webnn::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif