// services/webnn/public/mojom/webnn_context_properties.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/webnn/public/mojom/webnn_context_properties.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-params-data.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared-message-ids.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-import-headers.h"
#include "services/webnn/public/mojom/webnn_context_properties.mojom-test-utils.h"


namespace webnn::mojom {
SupportedDataTypes::SupportedDataTypes()
    : float32(),
      float16(),
      int32(),
      uint32(),
      int64(),
      uint64(),
      int8(),
      uint8(),
      int4(),
      uint4() {}

SupportedDataTypes::SupportedDataTypes(
    bool float32_in,
    bool float16_in,
    bool int32_in,
    bool uint32_in,
    bool int64_in,
    bool uint64_in,
    bool int8_in,
    bool uint8_in,
    bool int4_in,
    bool uint4_in)
    : float32(std::move(float32_in)),
      float16(std::move(float16_in)),
      int32(std::move(int32_in)),
      uint32(std::move(uint32_in)),
      int64(std::move(int64_in)),
      uint64(std::move(uint64_in)),
      int8(std::move(int8_in)),
      uint8(std::move(uint8_in)),
      int4(std::move(int4_in)),
      uint4(std::move(uint4_in)) {}

SupportedDataTypes::~SupportedDataTypes() = default;

void SupportedDataTypes::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "float32"), this->float32,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "float16"), this->float16,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "int32"), this->int32,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uint32"), this->uint32,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "int64"), this->int64,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uint64"), this->uint64,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "int8"), this->int8,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uint8"), this->uint8,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "int4"), this->int4,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "uint4"), this->uint4,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedDataTypes::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupportedRanks::SupportedRanks()
    : min(),
      max() {}

SupportedRanks::SupportedRanks(
    uint32_t min_in,
    uint32_t max_in)
    : min(std::move(min_in)),
      max(std::move(max_in)) {}

SupportedRanks::~SupportedRanks() = default;

void SupportedRanks::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min"), this->min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max"), this->max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedRanks::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupportedTensors::SupportedTensors()
    : data_types(),
      ranks() {}

SupportedTensors::SupportedTensors(
    const ::webnn::SupportedDataTypes& data_types_in,
    const ::webnn::SupportedRanks& ranks_in)
    : data_types(std::move(data_types_in)),
      ranks(std::move(ranks_in)) {}

SupportedTensors::~SupportedTensors() = default;

void SupportedTensors::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_types"), this->data_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedDataTypes&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ranks"), this->ranks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedRanks&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedTensors::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataTypeLimits::DataTypeLimits()
    : input(),
      constant(),
      arg_min_max_input(),
      arg_min_max_output(),
      batch_normalization_input(),
      batch_normalization_mean(),
      cast_input(),
      clamp_input(),
      concat_inputs(),
      conv2d_input(),
      conv2d_bias(),
      conv_transpose2d_input(),
      conv_transpose2d_bias(),
      cumulative_sum_input(),
      dequantize_linear_input(),
      dequantize_linear_scale(),
      dequantize_linear_zero_point(),
      add_input(),
      sub_input(),
      mul_input(),
      div_input(),
      max_input(),
      min_input(),
      pow_input(),
      equal_input(),
      greater_input(),
      greater_or_equal_input(),
      lesser_input(),
      lesser_or_equal_input(),
      not_equal_input(),
      logical_and_input(),
      logical_or_input(),
      logical_xor_input(),
      logical_not_input(),
      is_nan_input(),
      is_infinite_input(),
      logical_output(),
      abs_input(),
      ceil_input(),
      cos_input(),
      erf_input(),
      exp_input(),
      floor_input(),
      identity_input(),
      log_input(),
      neg_input(),
      reciprocal_input(),
      round_even_input(),
      sign_input(),
      sin_input(),
      sqrt_input(),
      tan_input(),
      elu_input(),
      expand_input(),
      gather_input(),
      gather_indices(),
      gather_elements_input(),
      gather_elements_indices(),
      gather_nd_input(),
      gather_nd_indices(),
      gelu_input(),
      gemm_a(),
      gemm_c(),
      gru_input(),
      gru_bias(),
      gru_output_sequence(),
      gru_cell_input(),
      gru_cell_bias(),
      hard_sigmoid_input(),
      hard_swish_input(),
      instance_normalization_input(),
      instance_normalization_scale(),
      layer_normalization_input(),
      leaky_relu_input(),
      linear_input(),
      lstm_input(),
      lstm_bias(),
      lstm_output_sequence(),
      lstm_cell_input(),
      lstm_cell_bias(),
      matmul_input(),
      pad_input(),
      average_pool2d_input(),
      l2_pool2d_input(),
      max_pool2d_input(),
      prelu_input(),
      quantize_linear_input(),
      quantize_linear_zero_point(),
      reduce_l1_input(),
      reduce_l2_input(),
      reduce_log_sum_input(),
      reduce_log_sum_exp_input(),
      reduce_max_input(),
      reduce_mean_input(),
      reduce_min_input(),
      reduce_product_input(),
      reduce_sum_input(),
      reduce_sum_square_input(),
      relu_input(),
      resample2d_input(),
      reshape_input(),
      reverse_input(),
      scatter_elements_input(),
      scatter_elements_indices(),
      scatter_nd_input(),
      scatter_nd_indices(),
      scatter_nd_updates(),
      sigmoid_input(),
      slice_input(),
      softmax_input(),
      softplus_input(),
      softsign_input(),
      split_input(),
      tanh_input(),
      tile_input(),
      transpose_input(),
      triangular_input(),
      where_condition(),
      where_value() {}

DataTypeLimits::DataTypeLimits(
    const ::webnn::SupportedTensors& input_in,
    const ::webnn::SupportedTensors& constant_in,
    const ::webnn::SupportedTensors& arg_min_max_input_in,
    const ::webnn::SupportedTensors& arg_min_max_output_in,
    const ::webnn::SupportedTensors& batch_normalization_input_in,
    const ::webnn::SupportedTensors& batch_normalization_mean_in,
    const ::webnn::SupportedTensors& cast_input_in,
    const ::webnn::SupportedTensors& clamp_input_in,
    const ::webnn::SupportedTensors& concat_inputs_in,
    const ::webnn::SupportedTensors& conv2d_input_in,
    const ::webnn::SupportedTensors& conv2d_bias_in,
    const ::webnn::SupportedTensors& conv_transpose2d_input_in,
    const ::webnn::SupportedTensors& conv_transpose2d_bias_in,
    const ::webnn::SupportedTensors& cumulative_sum_input_in,
    const ::webnn::SupportedTensors& dequantize_linear_input_in,
    const ::webnn::SupportedTensors& dequantize_linear_scale_in,
    const ::webnn::SupportedTensors& dequantize_linear_zero_point_in,
    const ::webnn::SupportedTensors& add_input_in,
    const ::webnn::SupportedTensors& sub_input_in,
    const ::webnn::SupportedTensors& mul_input_in,
    const ::webnn::SupportedTensors& div_input_in,
    const ::webnn::SupportedTensors& max_input_in,
    const ::webnn::SupportedTensors& min_input_in,
    const ::webnn::SupportedTensors& pow_input_in,
    const ::webnn::SupportedTensors& equal_input_in,
    const ::webnn::SupportedTensors& greater_input_in,
    const ::webnn::SupportedTensors& greater_or_equal_input_in,
    const ::webnn::SupportedTensors& lesser_input_in,
    const ::webnn::SupportedTensors& lesser_or_equal_input_in,
    const ::webnn::SupportedTensors& not_equal_input_in,
    const ::webnn::SupportedTensors& logical_and_input_in,
    const ::webnn::SupportedTensors& logical_or_input_in,
    const ::webnn::SupportedTensors& logical_xor_input_in,
    const ::webnn::SupportedTensors& logical_not_input_in,
    const ::webnn::SupportedTensors& is_nan_input_in,
    const ::webnn::SupportedTensors& is_infinite_input_in,
    const ::webnn::SupportedDataTypes& logical_output_in,
    const ::webnn::SupportedTensors& abs_input_in,
    const ::webnn::SupportedTensors& ceil_input_in,
    const ::webnn::SupportedTensors& cos_input_in,
    const ::webnn::SupportedTensors& erf_input_in,
    const ::webnn::SupportedTensors& exp_input_in,
    const ::webnn::SupportedTensors& floor_input_in,
    const ::webnn::SupportedTensors& identity_input_in,
    const ::webnn::SupportedTensors& log_input_in,
    const ::webnn::SupportedTensors& neg_input_in,
    const ::webnn::SupportedTensors& reciprocal_input_in,
    const ::webnn::SupportedTensors& round_even_input_in,
    const ::webnn::SupportedTensors& sign_input_in,
    const ::webnn::SupportedTensors& sin_input_in,
    const ::webnn::SupportedTensors& sqrt_input_in,
    const ::webnn::SupportedTensors& tan_input_in,
    const ::webnn::SupportedTensors& elu_input_in,
    const ::webnn::SupportedTensors& expand_input_in,
    const ::webnn::SupportedTensors& gather_input_in,
    const ::webnn::SupportedTensors& gather_indices_in,
    const ::webnn::SupportedTensors& gather_elements_input_in,
    const ::webnn::SupportedTensors& gather_elements_indices_in,
    const ::webnn::SupportedTensors& gather_nd_input_in,
    const ::webnn::SupportedTensors& gather_nd_indices_in,
    const ::webnn::SupportedTensors& gelu_input_in,
    const ::webnn::SupportedTensors& gemm_a_in,
    const ::webnn::SupportedTensors& gemm_c_in,
    const ::webnn::SupportedTensors& gru_input_in,
    const ::webnn::SupportedTensors& gru_bias_in,
    const ::webnn::SupportedTensors& gru_output_sequence_in,
    const ::webnn::SupportedTensors& gru_cell_input_in,
    const ::webnn::SupportedTensors& gru_cell_bias_in,
    const ::webnn::SupportedTensors& hard_sigmoid_input_in,
    const ::webnn::SupportedTensors& hard_swish_input_in,
    const ::webnn::SupportedTensors& instance_normalization_input_in,
    const ::webnn::SupportedTensors& instance_normalization_scale_in,
    const ::webnn::SupportedTensors& layer_normalization_input_in,
    const ::webnn::SupportedTensors& leaky_relu_input_in,
    const ::webnn::SupportedTensors& linear_input_in,
    const ::webnn::SupportedTensors& lstm_input_in,
    const ::webnn::SupportedTensors& lstm_bias_in,
    const ::webnn::SupportedTensors& lstm_output_sequence_in,
    const ::webnn::SupportedTensors& lstm_cell_input_in,
    const ::webnn::SupportedTensors& lstm_cell_bias_in,
    const ::webnn::SupportedTensors& matmul_input_in,
    const ::webnn::SupportedTensors& pad_input_in,
    const ::webnn::SupportedTensors& average_pool2d_input_in,
    const ::webnn::SupportedTensors& l2_pool2d_input_in,
    const ::webnn::SupportedTensors& max_pool2d_input_in,
    const ::webnn::SupportedTensors& prelu_input_in,
    const ::webnn::SupportedTensors& quantize_linear_input_in,
    const ::webnn::SupportedTensors& quantize_linear_zero_point_in,
    const ::webnn::SupportedTensors& reduce_l1_input_in,
    const ::webnn::SupportedTensors& reduce_l2_input_in,
    const ::webnn::SupportedTensors& reduce_log_sum_input_in,
    const ::webnn::SupportedTensors& reduce_log_sum_exp_input_in,
    const ::webnn::SupportedTensors& reduce_max_input_in,
    const ::webnn::SupportedTensors& reduce_mean_input_in,
    const ::webnn::SupportedTensors& reduce_min_input_in,
    const ::webnn::SupportedTensors& reduce_product_input_in,
    const ::webnn::SupportedTensors& reduce_sum_input_in,
    const ::webnn::SupportedTensors& reduce_sum_square_input_in,
    const ::webnn::SupportedTensors& relu_input_in,
    const ::webnn::SupportedTensors& resample2d_input_in,
    const ::webnn::SupportedTensors& reshape_input_in,
    const ::webnn::SupportedTensors& reverse_input_in,
    const ::webnn::SupportedTensors& scatter_elements_input_in,
    const ::webnn::SupportedTensors& scatter_elements_indices_in,
    const ::webnn::SupportedTensors& scatter_nd_input_in,
    const ::webnn::SupportedTensors& scatter_nd_indices_in,
    const ::webnn::SupportedTensors& scatter_nd_updates_in,
    const ::webnn::SupportedTensors& sigmoid_input_in,
    const ::webnn::SupportedTensors& slice_input_in,
    const ::webnn::SupportedTensors& softmax_input_in,
    const ::webnn::SupportedTensors& softplus_input_in,
    const ::webnn::SupportedTensors& softsign_input_in,
    const ::webnn::SupportedTensors& split_input_in,
    const ::webnn::SupportedTensors& tanh_input_in,
    const ::webnn::SupportedTensors& tile_input_in,
    const ::webnn::SupportedTensors& transpose_input_in,
    const ::webnn::SupportedTensors& triangular_input_in,
    const ::webnn::SupportedTensors& where_condition_in,
    const ::webnn::SupportedTensors& where_value_in)
    : input(std::move(input_in)),
      constant(std::move(constant_in)),
      arg_min_max_input(std::move(arg_min_max_input_in)),
      arg_min_max_output(std::move(arg_min_max_output_in)),
      batch_normalization_input(std::move(batch_normalization_input_in)),
      batch_normalization_mean(std::move(batch_normalization_mean_in)),
      cast_input(std::move(cast_input_in)),
      clamp_input(std::move(clamp_input_in)),
      concat_inputs(std::move(concat_inputs_in)),
      conv2d_input(std::move(conv2d_input_in)),
      conv2d_bias(std::move(conv2d_bias_in)),
      conv_transpose2d_input(std::move(conv_transpose2d_input_in)),
      conv_transpose2d_bias(std::move(conv_transpose2d_bias_in)),
      cumulative_sum_input(std::move(cumulative_sum_input_in)),
      dequantize_linear_input(std::move(dequantize_linear_input_in)),
      dequantize_linear_scale(std::move(dequantize_linear_scale_in)),
      dequantize_linear_zero_point(std::move(dequantize_linear_zero_point_in)),
      add_input(std::move(add_input_in)),
      sub_input(std::move(sub_input_in)),
      mul_input(std::move(mul_input_in)),
      div_input(std::move(div_input_in)),
      max_input(std::move(max_input_in)),
      min_input(std::move(min_input_in)),
      pow_input(std::move(pow_input_in)),
      equal_input(std::move(equal_input_in)),
      greater_input(std::move(greater_input_in)),
      greater_or_equal_input(std::move(greater_or_equal_input_in)),
      lesser_input(std::move(lesser_input_in)),
      lesser_or_equal_input(std::move(lesser_or_equal_input_in)),
      not_equal_input(std::move(not_equal_input_in)),
      logical_and_input(std::move(logical_and_input_in)),
      logical_or_input(std::move(logical_or_input_in)),
      logical_xor_input(std::move(logical_xor_input_in)),
      logical_not_input(std::move(logical_not_input_in)),
      is_nan_input(std::move(is_nan_input_in)),
      is_infinite_input(std::move(is_infinite_input_in)),
      logical_output(std::move(logical_output_in)),
      abs_input(std::move(abs_input_in)),
      ceil_input(std::move(ceil_input_in)),
      cos_input(std::move(cos_input_in)),
      erf_input(std::move(erf_input_in)),
      exp_input(std::move(exp_input_in)),
      floor_input(std::move(floor_input_in)),
      identity_input(std::move(identity_input_in)),
      log_input(std::move(log_input_in)),
      neg_input(std::move(neg_input_in)),
      reciprocal_input(std::move(reciprocal_input_in)),
      round_even_input(std::move(round_even_input_in)),
      sign_input(std::move(sign_input_in)),
      sin_input(std::move(sin_input_in)),
      sqrt_input(std::move(sqrt_input_in)),
      tan_input(std::move(tan_input_in)),
      elu_input(std::move(elu_input_in)),
      expand_input(std::move(expand_input_in)),
      gather_input(std::move(gather_input_in)),
      gather_indices(std::move(gather_indices_in)),
      gather_elements_input(std::move(gather_elements_input_in)),
      gather_elements_indices(std::move(gather_elements_indices_in)),
      gather_nd_input(std::move(gather_nd_input_in)),
      gather_nd_indices(std::move(gather_nd_indices_in)),
      gelu_input(std::move(gelu_input_in)),
      gemm_a(std::move(gemm_a_in)),
      gemm_c(std::move(gemm_c_in)),
      gru_input(std::move(gru_input_in)),
      gru_bias(std::move(gru_bias_in)),
      gru_output_sequence(std::move(gru_output_sequence_in)),
      gru_cell_input(std::move(gru_cell_input_in)),
      gru_cell_bias(std::move(gru_cell_bias_in)),
      hard_sigmoid_input(std::move(hard_sigmoid_input_in)),
      hard_swish_input(std::move(hard_swish_input_in)),
      instance_normalization_input(std::move(instance_normalization_input_in)),
      instance_normalization_scale(std::move(instance_normalization_scale_in)),
      layer_normalization_input(std::move(layer_normalization_input_in)),
      leaky_relu_input(std::move(leaky_relu_input_in)),
      linear_input(std::move(linear_input_in)),
      lstm_input(std::move(lstm_input_in)),
      lstm_bias(std::move(lstm_bias_in)),
      lstm_output_sequence(std::move(lstm_output_sequence_in)),
      lstm_cell_input(std::move(lstm_cell_input_in)),
      lstm_cell_bias(std::move(lstm_cell_bias_in)),
      matmul_input(std::move(matmul_input_in)),
      pad_input(std::move(pad_input_in)),
      average_pool2d_input(std::move(average_pool2d_input_in)),
      l2_pool2d_input(std::move(l2_pool2d_input_in)),
      max_pool2d_input(std::move(max_pool2d_input_in)),
      prelu_input(std::move(prelu_input_in)),
      quantize_linear_input(std::move(quantize_linear_input_in)),
      quantize_linear_zero_point(std::move(quantize_linear_zero_point_in)),
      reduce_l1_input(std::move(reduce_l1_input_in)),
      reduce_l2_input(std::move(reduce_l2_input_in)),
      reduce_log_sum_input(std::move(reduce_log_sum_input_in)),
      reduce_log_sum_exp_input(std::move(reduce_log_sum_exp_input_in)),
      reduce_max_input(std::move(reduce_max_input_in)),
      reduce_mean_input(std::move(reduce_mean_input_in)),
      reduce_min_input(std::move(reduce_min_input_in)),
      reduce_product_input(std::move(reduce_product_input_in)),
      reduce_sum_input(std::move(reduce_sum_input_in)),
      reduce_sum_square_input(std::move(reduce_sum_square_input_in)),
      relu_input(std::move(relu_input_in)),
      resample2d_input(std::move(resample2d_input_in)),
      reshape_input(std::move(reshape_input_in)),
      reverse_input(std::move(reverse_input_in)),
      scatter_elements_input(std::move(scatter_elements_input_in)),
      scatter_elements_indices(std::move(scatter_elements_indices_in)),
      scatter_nd_input(std::move(scatter_nd_input_in)),
      scatter_nd_indices(std::move(scatter_nd_indices_in)),
      scatter_nd_updates(std::move(scatter_nd_updates_in)),
      sigmoid_input(std::move(sigmoid_input_in)),
      slice_input(std::move(slice_input_in)),
      softmax_input(std::move(softmax_input_in)),
      softplus_input(std::move(softplus_input_in)),
      softsign_input(std::move(softsign_input_in)),
      split_input(std::move(split_input_in)),
      tanh_input(std::move(tanh_input_in)),
      tile_input(std::move(tile_input_in)),
      transpose_input(std::move(transpose_input_in)),
      triangular_input(std::move(triangular_input_in)),
      where_condition(std::move(where_condition_in)),
      where_value(std::move(where_value_in)) {}

DataTypeLimits::~DataTypeLimits() = default;

void DataTypeLimits::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constant"), this->constant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "arg_min_max_input"), this->arg_min_max_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "arg_min_max_output"), this->arg_min_max_output,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "batch_normalization_input"), this->batch_normalization_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "batch_normalization_mean"), this->batch_normalization_mean,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cast_input"), this->cast_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clamp_input"), this->clamp_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "concat_inputs"), this->concat_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conv2d_input"), this->conv2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conv2d_bias"), this->conv2d_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conv_transpose2d_input"), this->conv_transpose2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "conv_transpose2d_bias"), this->conv_transpose2d_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cumulative_sum_input"), this->cumulative_sum_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dequantize_linear_input"), this->dequantize_linear_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dequantize_linear_scale"), this->dequantize_linear_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dequantize_linear_zero_point"), this->dequantize_linear_zero_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "add_input"), this->add_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sub_input"), this->sub_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mul_input"), this->mul_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "div_input"), this->div_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_input"), this->max_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_input"), this->min_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pow_input"), this->pow_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "equal_input"), this->equal_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "greater_input"), this->greater_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "greater_or_equal_input"), this->greater_or_equal_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lesser_input"), this->lesser_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lesser_or_equal_input"), this->lesser_or_equal_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "not_equal_input"), this->not_equal_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_and_input"), this->logical_and_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_or_input"), this->logical_or_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_xor_input"), this->logical_xor_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_not_input"), this->logical_not_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_nan_input"), this->is_nan_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_infinite_input"), this->is_infinite_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_output"), this->logical_output,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedDataTypes&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "abs_input"), this->abs_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ceil_input"), this->ceil_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cos_input"), this->cos_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "erf_input"), this->erf_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exp_input"), this->exp_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "floor_input"), this->floor_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identity_input"), this->identity_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_input"), this->log_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "neg_input"), this->neg_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reciprocal_input"), this->reciprocal_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "round_even_input"), this->round_even_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sign_input"), this->sign_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sin_input"), this->sin_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sqrt_input"), this->sqrt_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tan_input"), this->tan_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elu_input"), this->elu_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expand_input"), this->expand_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_input"), this->gather_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_indices"), this->gather_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_elements_input"), this->gather_elements_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_elements_indices"), this->gather_elements_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_nd_input"), this->gather_nd_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gather_nd_indices"), this->gather_nd_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gelu_input"), this->gelu_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gemm_a"), this->gemm_a,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gemm_c"), this->gemm_c,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gru_input"), this->gru_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gru_bias"), this->gru_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gru_output_sequence"), this->gru_output_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gru_cell_input"), this->gru_cell_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gru_cell_bias"), this->gru_cell_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hard_sigmoid_input"), this->hard_sigmoid_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hard_swish_input"), this->hard_swish_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_normalization_input"), this->instance_normalization_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_normalization_scale"), this->instance_normalization_scale,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_normalization_input"), this->layer_normalization_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "leaky_relu_input"), this->leaky_relu_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "linear_input"), this->linear_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lstm_input"), this->lstm_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lstm_bias"), this->lstm_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lstm_output_sequence"), this->lstm_output_sequence,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lstm_cell_input"), this->lstm_cell_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lstm_cell_bias"), this->lstm_cell_bias,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matmul_input"), this->matmul_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pad_input"), this->pad_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "average_pool2d_input"), this->average_pool2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "l2_pool2d_input"), this->l2_pool2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_pool2d_input"), this->max_pool2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prelu_input"), this->prelu_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quantize_linear_input"), this->quantize_linear_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quantize_linear_zero_point"), this->quantize_linear_zero_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_l1_input"), this->reduce_l1_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_l2_input"), this->reduce_l2_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_log_sum_input"), this->reduce_log_sum_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_log_sum_exp_input"), this->reduce_log_sum_exp_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_max_input"), this->reduce_max_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_mean_input"), this->reduce_mean_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_min_input"), this->reduce_min_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_product_input"), this->reduce_product_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_sum_input"), this->reduce_sum_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reduce_sum_square_input"), this->reduce_sum_square_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relu_input"), this->relu_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resample2d_input"), this->resample2d_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reshape_input"), this->reshape_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reverse_input"), this->reverse_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scatter_elements_input"), this->scatter_elements_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scatter_elements_indices"), this->scatter_elements_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scatter_nd_input"), this->scatter_nd_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scatter_nd_indices"), this->scatter_nd_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scatter_nd_updates"), this->scatter_nd_updates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sigmoid_input"), this->sigmoid_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "slice_input"), this->slice_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "softmax_input"), this->softmax_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "softplus_input"), this->softplus_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "softsign_input"), this->softsign_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "split_input"), this->split_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tanh_input"), this->tanh_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tile_input"), this->tile_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transpose_input"), this->transpose_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "triangular_input"), this->triangular_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "where_condition"), this->where_condition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "where_value"), this->where_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::SupportedTensors&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataTypeLimits::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ContextProperties::ContextProperties()
    : input_operand_layout(),
      resample_2d_axes(),
      batch_normalization_axis(),
      tensor_byte_length_limit(),
      data_type_limits(mojo::internal::DefaultConstructTag()) {}

ContextProperties::ContextProperties(
    InputOperandLayout input_operand_layout_in,
    Resample2DAxes resample_2d_axes_in,
    BatchNormalizationAxis batch_normalization_axis_in,
    uint64_t tensor_byte_length_limit_in,
    const ::webnn::DataTypeLimits& data_type_limits_in)
    : input_operand_layout(std::move(input_operand_layout_in)),
      resample_2d_axes(std::move(resample_2d_axes_in)),
      batch_normalization_axis(std::move(batch_normalization_axis_in)),
      tensor_byte_length_limit(std::move(tensor_byte_length_limit_in)),
      data_type_limits(std::move(data_type_limits_in)) {}

ContextProperties::~ContextProperties() = default;

void ContextProperties::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_operand_layout"), this->input_operand_layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputOperandLayout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resample_2d_axes"), this->resample_2d_axes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Resample2DAxes>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "batch_normalization_axis"), this->batch_normalization_axis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BatchNormalizationAxis>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tensor_byte_length_limit"), this->tensor_byte_length_limit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_type_limits"), this->data_type_limits,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::webnn::DataTypeLimits&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ContextProperties::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // webnn::mojom


namespace mojo {


// static
bool StructTraits<::webnn::mojom::SupportedDataTypes::DataView, ::webnn::mojom::SupportedDataTypesPtr>::Read(
    ::webnn::mojom::SupportedDataTypes::DataView input,
    ::webnn::mojom::SupportedDataTypesPtr* output) {
  bool success = true;
  ::webnn::mojom::SupportedDataTypesPtr result(::webnn::mojom::SupportedDataTypes::New());
  
      if (success)
        result->float32 = input.float32();
      if (success)
        result->float16 = input.float16();
      if (success)
        result->int32 = input.int32();
      if (success)
        result->uint32 = input.uint32();
      if (success)
        result->int64 = input.int64();
      if (success)
        result->uint64 = input.uint64();
      if (success)
        result->int8 = input.int8();
      if (success)
        result->uint8 = input.uint8();
      if (success)
        result->int4 = input.int4();
      if (success)
        result->uint4 = input.uint4();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::SupportedRanks::DataView, ::webnn::mojom::SupportedRanksPtr>::Read(
    ::webnn::mojom::SupportedRanks::DataView input,
    ::webnn::mojom::SupportedRanksPtr* output) {
  bool success = true;
  ::webnn::mojom::SupportedRanksPtr result(::webnn::mojom::SupportedRanks::New());
  
      if (success)
        result->min = input.min();
      if (success)
        result->max = input.max();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::SupportedTensors::DataView, ::webnn::mojom::SupportedTensorsPtr>::Read(
    ::webnn::mojom::SupportedTensors::DataView input,
    ::webnn::mojom::SupportedTensorsPtr* output) {
  bool success = true;
  ::webnn::mojom::SupportedTensorsPtr result(::webnn::mojom::SupportedTensors::New());
  
      if (success && !input.ReadDataTypes(&result->data_types))
        success = false;
      if (success && !input.ReadRanks(&result->ranks))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::DataTypeLimits::DataView, ::webnn::mojom::DataTypeLimitsPtr>::Read(
    ::webnn::mojom::DataTypeLimits::DataView input,
    ::webnn::mojom::DataTypeLimitsPtr* output) {
  bool success = true;
  ::webnn::mojom::DataTypeLimitsPtr result(::webnn::mojom::DataTypeLimits::New());
  
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success && !input.ReadConstant(&result->constant))
        success = false;
      if (success && !input.ReadArgMinMaxInput(&result->arg_min_max_input))
        success = false;
      if (success && !input.ReadArgMinMaxOutput(&result->arg_min_max_output))
        success = false;
      if (success && !input.ReadBatchNormalizationInput(&result->batch_normalization_input))
        success = false;
      if (success && !input.ReadBatchNormalizationMean(&result->batch_normalization_mean))
        success = false;
      if (success && !input.ReadCastInput(&result->cast_input))
        success = false;
      if (success && !input.ReadClampInput(&result->clamp_input))
        success = false;
      if (success && !input.ReadConcatInputs(&result->concat_inputs))
        success = false;
      if (success && !input.ReadConv2dInput(&result->conv2d_input))
        success = false;
      if (success && !input.ReadConv2dBias(&result->conv2d_bias))
        success = false;
      if (success && !input.ReadConvTranspose2dInput(&result->conv_transpose2d_input))
        success = false;
      if (success && !input.ReadConvTranspose2dBias(&result->conv_transpose2d_bias))
        success = false;
      if (success && !input.ReadCumulativeSumInput(&result->cumulative_sum_input))
        success = false;
      if (success && !input.ReadDequantizeLinearInput(&result->dequantize_linear_input))
        success = false;
      if (success && !input.ReadDequantizeLinearScale(&result->dequantize_linear_scale))
        success = false;
      if (success && !input.ReadDequantizeLinearZeroPoint(&result->dequantize_linear_zero_point))
        success = false;
      if (success && !input.ReadAddInput(&result->add_input))
        success = false;
      if (success && !input.ReadSubInput(&result->sub_input))
        success = false;
      if (success && !input.ReadMulInput(&result->mul_input))
        success = false;
      if (success && !input.ReadDivInput(&result->div_input))
        success = false;
      if (success && !input.ReadMaxInput(&result->max_input))
        success = false;
      if (success && !input.ReadMinInput(&result->min_input))
        success = false;
      if (success && !input.ReadPowInput(&result->pow_input))
        success = false;
      if (success && !input.ReadEqualInput(&result->equal_input))
        success = false;
      if (success && !input.ReadGreaterInput(&result->greater_input))
        success = false;
      if (success && !input.ReadGreaterOrEqualInput(&result->greater_or_equal_input))
        success = false;
      if (success && !input.ReadLesserInput(&result->lesser_input))
        success = false;
      if (success && !input.ReadLesserOrEqualInput(&result->lesser_or_equal_input))
        success = false;
      if (success && !input.ReadNotEqualInput(&result->not_equal_input))
        success = false;
      if (success && !input.ReadLogicalAndInput(&result->logical_and_input))
        success = false;
      if (success && !input.ReadLogicalOrInput(&result->logical_or_input))
        success = false;
      if (success && !input.ReadLogicalXorInput(&result->logical_xor_input))
        success = false;
      if (success && !input.ReadLogicalNotInput(&result->logical_not_input))
        success = false;
      if (success && !input.ReadIsNanInput(&result->is_nan_input))
        success = false;
      if (success && !input.ReadIsInfiniteInput(&result->is_infinite_input))
        success = false;
      if (success && !input.ReadLogicalOutput(&result->logical_output))
        success = false;
      if (success && !input.ReadAbsInput(&result->abs_input))
        success = false;
      if (success && !input.ReadCeilInput(&result->ceil_input))
        success = false;
      if (success && !input.ReadCosInput(&result->cos_input))
        success = false;
      if (success && !input.ReadErfInput(&result->erf_input))
        success = false;
      if (success && !input.ReadExpInput(&result->exp_input))
        success = false;
      if (success && !input.ReadFloorInput(&result->floor_input))
        success = false;
      if (success && !input.ReadIdentityInput(&result->identity_input))
        success = false;
      if (success && !input.ReadLogInput(&result->log_input))
        success = false;
      if (success && !input.ReadNegInput(&result->neg_input))
        success = false;
      if (success && !input.ReadReciprocalInput(&result->reciprocal_input))
        success = false;
      if (success && !input.ReadRoundEvenInput(&result->round_even_input))
        success = false;
      if (success && !input.ReadSignInput(&result->sign_input))
        success = false;
      if (success && !input.ReadSinInput(&result->sin_input))
        success = false;
      if (success && !input.ReadSqrtInput(&result->sqrt_input))
        success = false;
      if (success && !input.ReadTanInput(&result->tan_input))
        success = false;
      if (success && !input.ReadEluInput(&result->elu_input))
        success = false;
      if (success && !input.ReadExpandInput(&result->expand_input))
        success = false;
      if (success && !input.ReadGatherInput(&result->gather_input))
        success = false;
      if (success && !input.ReadGatherIndices(&result->gather_indices))
        success = false;
      if (success && !input.ReadGatherElementsInput(&result->gather_elements_input))
        success = false;
      if (success && !input.ReadGatherElementsIndices(&result->gather_elements_indices))
        success = false;
      if (success && !input.ReadGatherNdInput(&result->gather_nd_input))
        success = false;
      if (success && !input.ReadGatherNdIndices(&result->gather_nd_indices))
        success = false;
      if (success && !input.ReadGeluInput(&result->gelu_input))
        success = false;
      if (success && !input.ReadGemmA(&result->gemm_a))
        success = false;
      if (success && !input.ReadGemmC(&result->gemm_c))
        success = false;
      if (success && !input.ReadGruInput(&result->gru_input))
        success = false;
      if (success && !input.ReadGruBias(&result->gru_bias))
        success = false;
      if (success && !input.ReadGruOutputSequence(&result->gru_output_sequence))
        success = false;
      if (success && !input.ReadGruCellInput(&result->gru_cell_input))
        success = false;
      if (success && !input.ReadGruCellBias(&result->gru_cell_bias))
        success = false;
      if (success && !input.ReadHardSigmoidInput(&result->hard_sigmoid_input))
        success = false;
      if (success && !input.ReadHardSwishInput(&result->hard_swish_input))
        success = false;
      if (success && !input.ReadInstanceNormalizationInput(&result->instance_normalization_input))
        success = false;
      if (success && !input.ReadInstanceNormalizationScale(&result->instance_normalization_scale))
        success = false;
      if (success && !input.ReadLayerNormalizationInput(&result->layer_normalization_input))
        success = false;
      if (success && !input.ReadLeakyReluInput(&result->leaky_relu_input))
        success = false;
      if (success && !input.ReadLinearInput(&result->linear_input))
        success = false;
      if (success && !input.ReadLstmInput(&result->lstm_input))
        success = false;
      if (success && !input.ReadLstmBias(&result->lstm_bias))
        success = false;
      if (success && !input.ReadLstmOutputSequence(&result->lstm_output_sequence))
        success = false;
      if (success && !input.ReadLstmCellInput(&result->lstm_cell_input))
        success = false;
      if (success && !input.ReadLstmCellBias(&result->lstm_cell_bias))
        success = false;
      if (success && !input.ReadMatmulInput(&result->matmul_input))
        success = false;
      if (success && !input.ReadPadInput(&result->pad_input))
        success = false;
      if (success && !input.ReadAveragePool2dInput(&result->average_pool2d_input))
        success = false;
      if (success && !input.ReadL2Pool2dInput(&result->l2_pool2d_input))
        success = false;
      if (success && !input.ReadMaxPool2dInput(&result->max_pool2d_input))
        success = false;
      if (success && !input.ReadPreluInput(&result->prelu_input))
        success = false;
      if (success && !input.ReadQuantizeLinearInput(&result->quantize_linear_input))
        success = false;
      if (success && !input.ReadQuantizeLinearZeroPoint(&result->quantize_linear_zero_point))
        success = false;
      if (success && !input.ReadReduceL1Input(&result->reduce_l1_input))
        success = false;
      if (success && !input.ReadReduceL2Input(&result->reduce_l2_input))
        success = false;
      if (success && !input.ReadReduceLogSumInput(&result->reduce_log_sum_input))
        success = false;
      if (success && !input.ReadReduceLogSumExpInput(&result->reduce_log_sum_exp_input))
        success = false;
      if (success && !input.ReadReduceMaxInput(&result->reduce_max_input))
        success = false;
      if (success && !input.ReadReduceMeanInput(&result->reduce_mean_input))
        success = false;
      if (success && !input.ReadReduceMinInput(&result->reduce_min_input))
        success = false;
      if (success && !input.ReadReduceProductInput(&result->reduce_product_input))
        success = false;
      if (success && !input.ReadReduceSumInput(&result->reduce_sum_input))
        success = false;
      if (success && !input.ReadReduceSumSquareInput(&result->reduce_sum_square_input))
        success = false;
      if (success && !input.ReadReluInput(&result->relu_input))
        success = false;
      if (success && !input.ReadResample2dInput(&result->resample2d_input))
        success = false;
      if (success && !input.ReadReshapeInput(&result->reshape_input))
        success = false;
      if (success && !input.ReadReverseInput(&result->reverse_input))
        success = false;
      if (success && !input.ReadScatterElementsInput(&result->scatter_elements_input))
        success = false;
      if (success && !input.ReadScatterElementsIndices(&result->scatter_elements_indices))
        success = false;
      if (success && !input.ReadScatterNdInput(&result->scatter_nd_input))
        success = false;
      if (success && !input.ReadScatterNdIndices(&result->scatter_nd_indices))
        success = false;
      if (success && !input.ReadScatterNdUpdates(&result->scatter_nd_updates))
        success = false;
      if (success && !input.ReadSigmoidInput(&result->sigmoid_input))
        success = false;
      if (success && !input.ReadSliceInput(&result->slice_input))
        success = false;
      if (success && !input.ReadSoftmaxInput(&result->softmax_input))
        success = false;
      if (success && !input.ReadSoftplusInput(&result->softplus_input))
        success = false;
      if (success && !input.ReadSoftsignInput(&result->softsign_input))
        success = false;
      if (success && !input.ReadSplitInput(&result->split_input))
        success = false;
      if (success && !input.ReadTanhInput(&result->tanh_input))
        success = false;
      if (success && !input.ReadTileInput(&result->tile_input))
        success = false;
      if (success && !input.ReadTransposeInput(&result->transpose_input))
        success = false;
      if (success && !input.ReadTriangularInput(&result->triangular_input))
        success = false;
      if (success && !input.ReadWhereCondition(&result->where_condition))
        success = false;
      if (success && !input.ReadWhereValue(&result->where_value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::webnn::mojom::ContextProperties::DataView, ::webnn::mojom::ContextPropertiesPtr>::Read(
    ::webnn::mojom::ContextProperties::DataView input,
    ::webnn::mojom::ContextPropertiesPtr* output) {
  bool success = true;
  ::webnn::mojom::ContextPropertiesPtr result(::webnn::mojom::ContextProperties::New());
  
      if (success && !input.ReadInputOperandLayout(&result->input_operand_layout))
        success = false;
      if (success && !input.ReadResample2dAxes(&result->resample_2d_axes))
        success = false;
      if (success && !input.ReadBatchNormalizationAxis(&result->batch_normalization_axis))
        success = false;
      if (success)
        result->tensor_byte_length_limit = input.tensor_byte_length_limit();
      if (success && !input.ReadDataTypeLimits(&result->data_type_limits))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace webnn::mojom {




}  // webnn::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif