// services/webnn/public/mojom/webnn_context_properties.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/webnn/public/mojom/webnn_context_properties.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/webnn/public/mojom/webnn_context_properties.mojom-params-data.h"
namespace webnn {
namespace mojom {

NOINLINE static const char* InputOperandLayoutToStringHelper(InputOperandLayout value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InputOperandLayout::kChannelsFirst:
      return "kChannelsFirst";
    case InputOperandLayout::kChannelsLast:
      return "kChannelsLast";
    default:
      return nullptr;
  }
}

std::string InputOperandLayoutToString(InputOperandLayout value) {
  const char *str = InputOperandLayoutToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InputOperandLayout value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InputOperandLayout value) {
  return os << InputOperandLayoutToString(value);
}

NOINLINE static const char* Resample2DAxesToStringHelper(Resample2DAxes value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Resample2DAxes::kAny:
      return "kAny";
    case Resample2DAxes::kChannelsFirst:
      return "kChannelsFirst";
    case Resample2DAxes::kChannelsLast:
      return "kChannelsLast";
    default:
      return nullptr;
  }
}

std::string Resample2DAxesToString(Resample2DAxes value) {
  const char *str = Resample2DAxesToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Resample2DAxes value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Resample2DAxes value) {
  return os << Resample2DAxesToString(value);
}

NOINLINE static const char* BatchNormalizationAxisToStringHelper(BatchNormalizationAxis value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case BatchNormalizationAxis::kAny:
      return "kAny";
    case BatchNormalizationAxis::kChannelsFirst:
      return "kChannelsFirst";
    default:
      return nullptr;
  }
}

std::string BatchNormalizationAxisToString(BatchNormalizationAxis value) {
  const char *str = BatchNormalizationAxisToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown BatchNormalizationAxis value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, BatchNormalizationAxis value) {
  return os << BatchNormalizationAxisToString(value);
}

namespace internal {


// static
bool SupportedDataTypes_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportedDataTypes_Data* object =
      static_cast<const SupportedDataTypes_Data*>(data);

  return true;
}

SupportedDataTypes_Data::SupportedDataTypes_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SupportedRanks_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportedRanks_Data* object =
      static_cast<const SupportedRanks_Data*>(data);

  return true;
}

SupportedRanks_Data::SupportedRanks_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SupportedTensors_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SupportedTensors_Data* object =
      static_cast<const SupportedTensors_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_types, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_types, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ranks, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ranks, validation_context))
    return false;

  return true;
}

SupportedTensors_Data::SupportedTensors_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataTypeLimits_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 960, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataTypeLimits_Data* object =
      static_cast<const DataTypeLimits_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constant, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constant, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arg_min_max_input, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->arg_min_max_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->arg_min_max_output, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->arg_min_max_output, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->batch_normalization_input, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->batch_normalization_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->batch_normalization_mean, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->batch_normalization_mean, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cast_input, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cast_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->clamp_input, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->clamp_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->concat_inputs, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->concat_inputs, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conv2d_input, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conv2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conv2d_bias, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conv2d_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conv_transpose2d_input, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conv_transpose2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->conv_transpose2d_bias, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->conv_transpose2d_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cumulative_sum_input, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cumulative_sum_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dequantize_linear_input, 15, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dequantize_linear_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dequantize_linear_scale, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dequantize_linear_scale, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dequantize_linear_zero_point, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dequantize_linear_zero_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->add_input, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->add_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sub_input, 19, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sub_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mul_input, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mul_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->div_input, 21, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->div_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_input, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->min_input, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->min_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pow_input, 24, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pow_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->equal_input, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->equal_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->greater_input, 26, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->greater_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->greater_or_equal_input, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->greater_or_equal_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lesser_input, 28, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lesser_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lesser_or_equal_input, 29, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lesser_or_equal_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->not_equal_input, 30, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->not_equal_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logical_and_input, 31, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->logical_and_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logical_or_input, 32, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->logical_or_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logical_xor_input, 33, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->logical_xor_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logical_not_input, 34, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->logical_not_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->is_nan_input, 35, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->is_nan_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->is_infinite_input, 36, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->is_infinite_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logical_output, 37, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->logical_output, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->abs_input, 38, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->abs_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ceil_input, 39, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ceil_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cos_input, 40, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cos_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->erf_input, 41, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->erf_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exp_input, 42, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->exp_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->floor_input, 43, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->floor_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity_input, 44, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identity_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_input, 45, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->log_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->neg_input, 46, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->neg_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reciprocal_input, 47, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reciprocal_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->round_even_input, 48, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->round_even_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sign_input, 49, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sign_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sin_input, 50, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sin_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sqrt_input, 51, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sqrt_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tan_input, 52, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tan_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elu_input, 53, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->elu_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expand_input, 54, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expand_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_input, 55, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_indices, 56, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_indices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_elements_input, 57, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_elements_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_elements_indices, 58, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_elements_indices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_nd_input, 59, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_nd_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gather_nd_indices, 60, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gather_nd_indices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gelu_input, 61, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gelu_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gemm_a, 62, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gemm_a, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gemm_c, 63, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gemm_c, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gru_input, 64, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gru_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gru_bias, 65, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gru_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gru_output_sequence, 66, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gru_output_sequence, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gru_cell_input, 67, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gru_cell_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gru_cell_bias, 68, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gru_cell_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hard_sigmoid_input, 69, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hard_sigmoid_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hard_swish_input, 70, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hard_swish_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_normalization_input, 71, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instance_normalization_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->instance_normalization_scale, 72, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->instance_normalization_scale, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->layer_normalization_input, 73, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->layer_normalization_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->leaky_relu_input, 74, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->leaky_relu_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->linear_input, 75, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->linear_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lstm_input, 76, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lstm_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lstm_bias, 77, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lstm_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lstm_output_sequence, 78, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lstm_output_sequence, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lstm_cell_input, 79, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lstm_cell_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lstm_cell_bias, 80, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->lstm_cell_bias, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->matmul_input, 81, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->matmul_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pad_input, 82, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pad_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->average_pool2d_input, 83, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->average_pool2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->l2_pool2d_input, 84, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->l2_pool2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->max_pool2d_input, 85, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->max_pool2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prelu_input, 86, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prelu_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->quantize_linear_input, 87, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->quantize_linear_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->quantize_linear_zero_point, 88, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->quantize_linear_zero_point, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_l1_input, 89, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_l1_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_l2_input, 90, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_l2_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_log_sum_input, 91, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_log_sum_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_log_sum_exp_input, 92, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_log_sum_exp_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_max_input, 93, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_max_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_mean_input, 94, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_mean_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_min_input, 95, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_min_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_product_input, 96, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_product_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_sum_input, 97, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_sum_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduce_sum_square_input, 98, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reduce_sum_square_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relu_input, 99, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->relu_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->resample2d_input, 100, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->resample2d_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reshape_input, 101, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reshape_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reverse_input, 102, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reverse_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scatter_elements_input, 103, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scatter_elements_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scatter_elements_indices, 104, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scatter_elements_indices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scatter_nd_input, 105, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scatter_nd_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scatter_nd_indices, 106, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scatter_nd_indices, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->scatter_nd_updates, 107, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->scatter_nd_updates, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sigmoid_input, 108, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sigmoid_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->slice_input, 109, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->slice_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->softmax_input, 110, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->softmax_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->softplus_input, 111, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->softplus_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->softsign_input, 112, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->softsign_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->split_input, 113, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->split_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tanh_input, 114, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tanh_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tile_input, 115, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tile_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transpose_input, 116, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transpose_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->triangular_input, 117, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->triangular_input, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->where_condition, 118, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->where_condition, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->where_value, 119, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->where_value, validation_context))
    return false;

  return true;
}

DataTypeLimits_Data::DataTypeLimits_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContextProperties_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContextProperties_Data* object =
      static_cast<const ContextProperties_Data*>(data);


  if (!::webnn::mojom::internal::InputOperandLayout_Data
        ::Validate(object->input_operand_layout, validation_context))
    return false;


  if (!::webnn::mojom::internal::Resample2DAxes_Data
        ::Validate(object->resample_2d_axes, validation_context))
    return false;


  if (!::webnn::mojom::internal::BatchNormalizationAxis_Data
        ::Validate(object->batch_normalization_axis, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_type_limits, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_type_limits, validation_context))
    return false;

  return true;
}

ContextProperties_Data::ContextProperties_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace webnn

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::InputOperandLayout>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::InputOperandLayout value) {
  return std::move(context).WriteString(::webnn::mojom::InputOperandLayoutToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::Resample2DAxes>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::Resample2DAxes value) {
  return std::move(context).WriteString(::webnn::mojom::Resample2DAxesToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::webnn::mojom::BatchNormalizationAxis>::WriteIntoTrace(
   perfetto::TracedValue context, ::webnn::mojom::BatchNormalizationAxis value) {
  return std::move(context).WriteString(::webnn::mojom::BatchNormalizationAxisToString(value));
}

} // namespace perfetto