// services/webnn/public/mojom/webnn_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_H_
#define SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/webnn/public/mojom/webnn_context.mojom-features.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context.mojom-shared.h"  // IWYU pragma: export
#include "services/webnn/public/mojom/webnn_context.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/mailbox.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "services/webnn/public/mojom/features.mojom-forward.h"
#include "services/webnn/public/mojom/webnn_tensor.mojom-forward.h"
#include "services/webnn/public/mojom/webnn_error.mojom.h"
#include "services/webnn/public/mojom/webnn_graph_builder.mojom-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace webnn::mojom {

class WebNNContextProxy;

template <typename ImplRefTraits>
class WebNNContextStub;

class WebNNContextRequestValidator;
class WebNNContextResponseValidator;


class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNContext
    : public WebNNContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "webnn.mojom.WebNNContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static bool RuntimeFeature_IsEnabled_(bool expected);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebNNContextInterfaceBase;
  using Proxy_ = WebNNContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebNNContextStub<ImplRefTraits>;

  using RequestValidator_ = WebNNContextRequestValidator;
  using ResponseValidator_ = WebNNContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateGraphBuilderMinVersion = 0,
    kCreateTensorMinVersion = 0,
    kCreateTensorFromMailboxMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateGraphBuilder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateTensorFromMailbox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebNNContext() = default;

  virtual void CreateGraphBuilder(::mojo::PendingAssociatedReceiver<::webnn::mojom::WebNNGraphBuilder> receiver) = 0;

  using CreateTensorCallback = base::OnceCallback<void(CreateTensorResultPtr)>;
  using CreateTensorMojoCallback = base::OnceCallback<void(CreateTensorResultPtr)>;

  virtual void CreateTensor(::webnn::mojom::TensorInfoPtr tensor_info, ::mojo_base::BigBuffer tensor_data, CreateTensorCallback callback) = 0;

  using CreateTensorFromMailboxCallback = base::OnceCallback<void(CreateTensorResultPtr)>;
  using CreateTensorFromMailboxMojoCallback = base::OnceCallback<void(CreateTensorResultPtr)>;

  virtual void CreateTensorFromMailbox(::webnn::mojom::TensorInfoPtr tensor_info, const ::gpu::Mailbox& mailbox, const ::gpu::SyncToken& fence, CreateTensorFromMailboxCallback callback) = 0;
};



class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNContextProxy
    : public WebNNContext {
 public:
  using InterfaceType = WebNNContext;

  explicit WebNNContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateGraphBuilder(::mojo::PendingAssociatedReceiver<::webnn::mojom::WebNNGraphBuilder> receiver) final;
  
  void CreateTensor(::webnn::mojom::TensorInfoPtr tensor_info, ::mojo_base::BigBuffer tensor_data, CreateTensorCallback callback) final;
  
  void CreateTensorFromMailbox(::webnn::mojom::TensorInfoPtr tensor_info, const ::gpu::Mailbox& mailbox, const ::gpu::SyncToken& fence, CreateTensorFromMailboxCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNContextStubDispatch {
 public:
  static bool Accept(WebNNContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebNNContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebNNContext>>
class WebNNContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebNNContextStub() = default;
  ~WebNNContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebNNContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(WEBNN_MOJOM) WebNNContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(WEBNN_MOJOM) CreateTensorResult {
 public:
  using DataView = CreateTensorResultDataView;
  using Data_ = internal::CreateTensorResult_Data;
  using Tag = Data_::CreateTensorResult_Tag;

  template <typename... Args>
  static CreateTensorResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static CreateTensorResultPtr NewSuccess(
      CreateTensorSuccessPtr value);
  // Construct an instance holding |error|.
  static CreateTensorResultPtr NewError(
      ::webnn::mojom::ErrorPtr value);

  template <typename U>
  static CreateTensorResultPtr From(const U& u) {
    return mojo::TypeConverter<CreateTensorResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateTensorResult>::Convert(*this);
  }
  ~CreateTensorResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateTensorResult(const CreateTensorResult& other) = delete;
  CreateTensorResult& operator=(const CreateTensorResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateTensorResultPtr>
  CreateTensorResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateTensorResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateTensorResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const CreateTensorSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  CreateTensorSuccessPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(CreateTensorSuccessPtr success);

  bool is_error() const { return tag_ == Tag::kError; }
  const ::webnn::mojom::ErrorPtr& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  ::webnn::mojom::ErrorPtr& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(::webnn::mojom::ErrorPtr error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateTensorResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateTensorResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        CreateTensorSuccessPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        ::webnn::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreateTensorSuccessPtr success;
    ::webnn::mojom::ErrorPtr error;
  };

  CreateTensorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      CreateTensorSuccessPtr value);
  CreateTensorResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      ::webnn::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class COMPONENT_EXPORT(WEBNN_MOJOM) CreateTensorSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateTensorSuccess, T>::value>;
  using DataView = CreateTensorSuccessDataView;
  using Data_ = internal::CreateTensorSuccess_Data;

  template <typename... Args>
  static CreateTensorSuccessPtr New(Args&&... args) {
    return CreateTensorSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateTensorSuccessPtr From(const U& u) {
    return mojo::TypeConverter<CreateTensorSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateTensorSuccess>::Convert(*this);
  }


  CreateTensorSuccess();

  CreateTensorSuccess(
      ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNTensor> tensor_remote,
      const ::blink::WebNNTensorToken& tensor_handle);

CreateTensorSuccess(const CreateTensorSuccess&) = delete;
CreateTensorSuccess& operator=(const CreateTensorSuccess&) = delete;

  ~CreateTensorSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateTensorSuccessPtr>
  CreateTensorSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateTensorSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateTensorSuccess_UnserializedMessageContext<
            UserType, CreateTensorSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateTensorSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateTensorSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateTensorSuccess_UnserializedMessageContext<
            UserType, CreateTensorSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateTensorSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedRemote<::webnn::mojom::WebNNTensor> tensor_remote;
  
  ::blink::WebNNTensorToken tensor_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateTensorSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CreateTensorResultPtr CreateTensorResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateTensorResult>::value>::type*>
bool CreateTensorResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
CreateTensorSuccessPtr CreateTensorSuccess::Clone() const {
  return New(
      mojo::Clone(tensor_remote),
      mojo::Clone(tensor_handle)
  );
}

template <typename T, CreateTensorSuccess::EnableIfSame<T>*>
bool CreateTensorSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tensor_remote, other_struct.tensor_remote))
    return false;
  if (!mojo::Equals(this->tensor_handle, other_struct.tensor_handle))
    return false;
  return true;
}

template <typename T, CreateTensorSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tensor_remote < rhs.tensor_remote)
    return true;
  if (rhs.tensor_remote < lhs.tensor_remote)
    return false;
  if (lhs.tensor_handle < rhs.tensor_handle)
    return true;
  if (rhs.tensor_handle < lhs.tensor_handle)
    return false;
  return false;
}


}  // webnn::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) StructTraits<::webnn::mojom::CreateTensorSuccess::DataView,
                                         ::webnn::mojom::CreateTensorSuccessPtr> {
  static bool IsNull(const ::webnn::mojom::CreateTensorSuccessPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::CreateTensorSuccessPtr* output) { output->reset(); }

  static  decltype(::webnn::mojom::CreateTensorSuccess::tensor_remote)& tensor_remote(
       ::webnn::mojom::CreateTensorSuccessPtr& input) {
    return input->tensor_remote;
  }

  static const decltype(::webnn::mojom::CreateTensorSuccess::tensor_handle)& tensor_handle(
      const ::webnn::mojom::CreateTensorSuccessPtr& input) {
    return input->tensor_handle;
  }

  static bool Read(::webnn::mojom::CreateTensorSuccess::DataView input, ::webnn::mojom::CreateTensorSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(WEBNN_MOJOM) UnionTraits<::webnn::mojom::CreateTensorResult::DataView,
                                        ::webnn::mojom::CreateTensorResultPtr> {
  static bool IsNull(const ::webnn::mojom::CreateTensorResultPtr& input) { return !input; }
  static void SetToNull(::webnn::mojom::CreateTensorResultPtr* output) { output->reset(); }

  static ::webnn::mojom::CreateTensorResult::Tag GetTag(const ::webnn::mojom::CreateTensorResultPtr& input) {
    return input->which();
  }

  static  ::webnn::mojom::CreateTensorSuccessPtr& success( ::webnn::mojom::CreateTensorResultPtr& input) {
    return input->get_success();
  }

  static const ::webnn::mojom::ErrorPtr& error(const ::webnn::mojom::CreateTensorResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::webnn::mojom::CreateTensorResult::DataView input, ::webnn::mojom::CreateTensorResultPtr* output);
};
namespace internal {
template <>
inline bool GetRuntimeFeature_IsEnabled<::webnn::mojom::WebNNContext>() {
  return ::webnn::mojom::WebNNContext::RuntimeFeature_IsEnabled_(false);
}
template <>
inline bool GetRuntimeFeature_ExpectEnabled<::webnn::mojom::WebNNContext>() {
  return ::webnn::mojom::WebNNContext::RuntimeFeature_IsEnabled_(true);
}template <>
inline constexpr bool kIsRuntimeFeatureGuarded<::webnn::mojom::WebNNContext> = true;
}  // namespace internal

}  // namespace mojo

#endif  // SERVICES_WEBNN_PUBLIC_MOJOM_WEBNN_CONTEXT_MOJOM_H_