// services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }



  function ViewTransitionElementResourceId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionElementResourceId.prototype.initDefaults_ = function() {
    this.transitionToken = null;
    this.localId = 0;
    this.forScopeSnapshot = false;
  };
  ViewTransitionElementResourceId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionElementResourceId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionElementResourceId.transitionToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.ViewTransitionToken, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  ViewTransitionElementResourceId.encodedSize = codec.kStructHeaderSize + 16;

  ViewTransitionElementResourceId.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionElementResourceId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.transitionToken =
        decoder.decodeStructPointer(tokens$.ViewTransitionToken);
    val.localId =
        decoder.decodeStruct(codec.Uint32);
    packed = decoder.readUint8();
    val.forScopeSnapshot = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ViewTransitionElementResourceId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionElementResourceId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.ViewTransitionToken, val.transitionToken);
    encoder.encodeStruct(codec.Uint32, val.localId);
    packed = 0;
    packed |= (val.forScopeSnapshot & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.ViewTransitionElementResourceId = ViewTransitionElementResourceId;
})();