// services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TREES_IN_VIZ_TIMING_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TREES_IN_VIZ_TIMING_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/trees_in_viz_timing.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/viz/public/cpp/compositing/trees_in_viz_timing_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT TreesInVizTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TreesInVizTiming, T>::value>;
  using DataView = TreesInVizTimingDataView;
  using Data_ = internal::TreesInVizTiming_Data;

  template <typename... Args>
  static TreesInVizTimingPtr New(Args&&... args) {
    return TreesInVizTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TreesInVizTimingPtr From(const U& u) {
    return mojo::TypeConverter<TreesInVizTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TreesInVizTiming>::Convert(*this);
  }


  TreesInVizTiming();

  TreesInVizTiming(
      ::base::TimeTicks start_update_display_tree,
      ::base::TimeTicks start_prepare_to_draw,
      ::base::TimeTicks start_draw_layers,
      ::base::TimeTicks submit_compositor_frame);


  ~TreesInVizTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TreesInVizTimingPtr>
  TreesInVizTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TreesInVizTiming::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TreesInVizTiming::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TreesInVizTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TreesInVizTiming_UnserializedMessageContext<
            UserType, TreesInVizTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TreesInVizTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TreesInVizTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TreesInVizTiming_UnserializedMessageContext<
            UserType, TreesInVizTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TreesInVizTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks start_update_display_tree;
  
  ::base::TimeTicks start_prepare_to_draw;
  
  ::base::TimeTicks start_draw_layers;
  
  ::base::TimeTicks submit_compositor_frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TreesInVizTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TreesInVizTimingPtr TreesInVizTiming::Clone() const {
  return New(
      mojo::Clone(start_update_display_tree),
      mojo::Clone(start_prepare_to_draw),
      mojo::Clone(start_draw_layers),
      mojo::Clone(submit_compositor_frame)
  );
}

template <typename T, TreesInVizTiming::EnableIfSame<T>*>
bool TreesInVizTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_update_display_tree, other_struct.start_update_display_tree))
    return false;
  if (!mojo::Equals(this->start_prepare_to_draw, other_struct.start_prepare_to_draw))
    return false;
  if (!mojo::Equals(this->start_draw_layers, other_struct.start_draw_layers))
    return false;
  if (!mojo::Equals(this->submit_compositor_frame, other_struct.submit_compositor_frame))
    return false;
  return true;
}

template <typename T, TreesInVizTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start_update_display_tree < rhs.start_update_display_tree)
    return true;
  if (rhs.start_update_display_tree < lhs.start_update_display_tree)
    return false;
  if (lhs.start_prepare_to_draw < rhs.start_prepare_to_draw)
    return true;
  if (rhs.start_prepare_to_draw < lhs.start_prepare_to_draw)
    return false;
  if (lhs.start_draw_layers < rhs.start_draw_layers)
    return true;
  if (rhs.start_draw_layers < lhs.start_draw_layers)
    return false;
  if (lhs.submit_compositor_frame < rhs.submit_compositor_frame)
    return true;
  if (rhs.submit_compositor_frame < lhs.submit_compositor_frame)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TreesInVizTiming::DataView,
                                         ::viz::mojom::blink::TreesInVizTimingPtr> {
  static bool IsNull(const ::viz::mojom::blink::TreesInVizTimingPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TreesInVizTimingPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::TreesInVizTiming::start_update_display_tree)& start_update_display_tree(
      const ::viz::mojom::blink::TreesInVizTimingPtr& input) {
    return input->start_update_display_tree;
  }

  static const decltype(::viz::mojom::blink::TreesInVizTiming::start_prepare_to_draw)& start_prepare_to_draw(
      const ::viz::mojom::blink::TreesInVizTimingPtr& input) {
    return input->start_prepare_to_draw;
  }

  static const decltype(::viz::mojom::blink::TreesInVizTiming::start_draw_layers)& start_draw_layers(
      const ::viz::mojom::blink::TreesInVizTimingPtr& input) {
    return input->start_draw_layers;
  }

  static const decltype(::viz::mojom::blink::TreesInVizTiming::submit_compositor_frame)& submit_compositor_frame(
      const ::viz::mojom::blink::TreesInVizTimingPtr& input) {
    return input->submit_compositor_frame;
  }

  static bool Read(::viz::mojom::blink::TreesInVizTiming::DataView input, ::viz::mojom::blink::TreesInVizTimingPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_TREES_IN_VIZ_TIMING_MOJOM_BLINK_H_