// services/viz/public/mojom/compositing/tiling.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/tiling.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var transferable_resource$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/transferable_resource.mojom', 'transferable_resource.mojom.js');
  }
  var skcolor4f$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor4f.mojom', '../../../../../skia/public/mojom/skcolor4f.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var missing_tile_reason$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/missing_tile_reason.mojom', '../../../../../cc/mojom/missing_tile_reason.mojom.js');
  }



  function TileResource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TileResource.prototype.initDefaults_ = function() {
    this.resource = null;
    this.isCheckered = false;
  };
  TileResource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TileResource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TileResource.resource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, transferable_resource$.TransferableResource, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TileResource.encodedSize = codec.kStructHeaderSize + 16;

  TileResource.decode = function(decoder) {
    var packed;
    var val = new TileResource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.resource =
        decoder.decodeStructPointer(transferable_resource$.TransferableResource);
    packed = decoder.readUint8();
    val.isCheckered = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  TileResource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TileResource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(transferable_resource$.TransferableResource, val.resource);
    packed = 0;
    packed |= (val.isCheckered & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function Tile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Tile.prototype.initDefaults_ = function() {
    this.columnIndex = 0;
    this.rowIndex = 0;
    this.contents = null;
  };
  Tile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Tile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate Tile.contents
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, TileContents, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Tile.encodedSize = codec.kStructHeaderSize + 24;

  Tile.decode = function(decoder) {
    var packed;
    var val = new Tile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.columnIndex =
        decoder.decodeStruct(codec.Uint32);
    val.rowIndex =
        decoder.decodeStruct(codec.Uint32);
    val.contents =
        decoder.decodeStruct(TileContents);
    return val;
  };

  Tile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Tile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.columnIndex);
    encoder.encodeStruct(codec.Uint32, val.rowIndex);
    encoder.encodeStruct(TileContents, val.contents);
  };
  function Tiling(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Tiling.prototype.initDefaults_ = function() {
    this.layerId = 0;
    this.rasterTranslation = null;
    this.rasterScale = null;
    this.tileSize = null;
    this.tilingRect = null;
    this.tiles = null;
    this.scaleKey = 0;
    this.isDeleted = false;
  };
  Tiling.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Tiling.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Tiling.rasterTranslation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tiling.rasterScale
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tiling.tileSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tiling.tilingRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Tiling.tiles
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(Tile), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  Tiling.encodedSize = codec.kStructHeaderSize + 56;

  Tiling.decode = function(decoder) {
    var packed;
    var val = new Tiling();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.layerId =
        decoder.decodeStruct(codec.Int64);
    val.rasterTranslation =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.rasterScale =
        decoder.decodeStructPointer(geometry$.Vector2dF);
    val.tileSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.tilingRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.tiles =
        decoder.decodeArrayPointer(new codec.PointerTo(Tile));
    val.scaleKey =
        decoder.decodeStruct(codec.Float);
    packed = decoder.readUint8();
    val.isDeleted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  Tiling.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Tiling.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.layerId);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.rasterTranslation);
    encoder.encodeStructPointer(geometry$.Vector2dF, val.rasterScale);
    encoder.encodeStructPointer(geometry$.Size, val.tileSize);
    encoder.encodeStructPointer(geometry$.Rect, val.tilingRect);
    encoder.encodeArrayPointer(new codec.PointerTo(Tile), val.tiles);
    encoder.encodeStruct(codec.Float, val.scaleKey);
    packed = 0;
    packed |= (val.isDeleted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function TileContents(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TileContents.Tags = {
    missingReason: 0,
    resource: 1,
    solidColor: 2,
  };

  TileContents.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TileContents.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "missingReason",
        "resource",
        "solidColor",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TileContents member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TileContents.prototype, "missingReason", {
    get: function() {
      if (this.$tag != TileContents.Tags.missingReason) {
        throw new ReferenceError(
            "TileContents.missingReason is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TileContents.Tags.missingReason;
      this.$data = value;
    }
  });
  Object.defineProperty(TileContents.prototype, "resource", {
    get: function() {
      if (this.$tag != TileContents.Tags.resource) {
        throw new ReferenceError(
            "TileContents.resource is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TileContents.Tags.resource;
      this.$data = value;
    }
  });
  Object.defineProperty(TileContents.prototype, "solidColor", {
    get: function() {
      if (this.$tag != TileContents.Tags.solidColor) {
        throw new ReferenceError(
            "TileContents.solidColor is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TileContents.Tags.solidColor;
      this.$data = value;
    }
  });


    TileContents.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TileContents.Tags.missingReason:
          encoder.encodeStruct(codec.Int32, val.missingReason);
          break;
        case TileContents.Tags.resource:
          encoder.encodeStructPointer(TileResource, val.resource);
          break;
        case TileContents.Tags.solidColor:
          encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.solidColor);
          break;
      }
      encoder.align();
    };


    TileContents.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TileContents();
      var tag = decoder.readUint32();
      switch (tag) {
        case TileContents.Tags.missingReason:
          result.missingReason = decoder.decodeStruct(new codec.Enum(missing_tile_reason$.MissingTileReason));
          break;
        case TileContents.Tags.resource:
          result.resource = decoder.decodeStructPointer(TileResource);
          break;
        case TileContents.Tags.solidColor:
          result.solidColor = decoder.decodeStructPointer(skcolor4f$.SkColor4f);
          break;
      }
      decoder.align();

      return result;
    };


    TileContents.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TileContents.Tags.missingReason:
          

    // validate TileContents.missingReason
    err = messageValidator.validateEnum(data_offset, missing_tile_reason$.MissingTileReason);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TileContents.Tags.resource:
          

    // validate TileContents.resource
    err = messageValidator.validateStructPointer(data_offset, TileResource, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TileContents.Tags.solidColor:
          

    // validate TileContents.solidColor
    err = messageValidator.validateStructPointer(data_offset, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TileContents.encodedSize = 16;
  exports.TileResource = TileResource;
  exports.Tile = Tile;
  exports.Tiling = Tiling;
  exports.TileContents = TileContents;
})();