// services/viz/public/mojom/compositing/subtree_capture_id.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/subtree_capture_id.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/token.mojom', '../../../../../mojo/public/mojom/base/token.mojom.js');
  }



  function SubtreeCaptureId(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SubtreeCaptureId.prototype.initDefaults_ = function() {
    this.subtreeId = null;
  };
  SubtreeCaptureId.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SubtreeCaptureId.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SubtreeCaptureId.subtreeId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, token$.Token, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SubtreeCaptureId.encodedSize = codec.kStructHeaderSize + 8;

  SubtreeCaptureId.decode = function(decoder) {
    var packed;
    var val = new SubtreeCaptureId();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.subtreeId =
        decoder.decodeStructPointer(token$.Token);
    return val;
  };

  SubtreeCaptureId.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SubtreeCaptureId.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(token$.Token, val.subtreeId);
  };
  exports.SubtreeCaptureId = SubtreeCaptureId;
})();