// services/viz/public/mojom/compositing/region_capture_bounds.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/region_capture_bounds.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/token.mojom', '../../../../../mojo/public/mojom/base/token.mojom.js');
  }



  function CropIdBoundsPair(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CropIdBoundsPair.prototype.initDefaults_ = function() {
    this.cropId = null;
    this.bounds = null;
  };
  CropIdBoundsPair.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CropIdBoundsPair.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CropIdBoundsPair.cropId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, token$.Token, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CropIdBoundsPair.bounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CropIdBoundsPair.encodedSize = codec.kStructHeaderSize + 16;

  CropIdBoundsPair.decode = function(decoder) {
    var packed;
    var val = new CropIdBoundsPair();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cropId =
        decoder.decodeStructPointer(token$.Token);
    val.bounds =
        decoder.decodeStructPointer(geometry$.Rect);
    return val;
  };

  CropIdBoundsPair.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CropIdBoundsPair.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(token$.Token, val.cropId);
    encoder.encodeStructPointer(geometry$.Rect, val.bounds);
  };
  function RegionCaptureBounds(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RegionCaptureBounds.prototype.initDefaults_ = function() {
    this.bounds = null;
  };
  RegionCaptureBounds.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RegionCaptureBounds.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RegionCaptureBounds.bounds
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(CropIdBoundsPair), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RegionCaptureBounds.encodedSize = codec.kStructHeaderSize + 8;

  RegionCaptureBounds.decode = function(decoder) {
    var packed;
    var val = new RegionCaptureBounds();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bounds =
        decoder.decodeArrayPointer(new codec.PointerTo(CropIdBoundsPair));
    return val;
  };

  RegionCaptureBounds.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RegionCaptureBounds.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(CropIdBoundsPair), val.bounds);
  };
  exports.CropIdBoundsPair = CropIdBoundsPair;
  exports.RegionCaptureBounds = RegionCaptureBounds;
})();