// services/viz/public/mojom/compositing/layer_context.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/layer_context.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var browser_controls_params$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/browser_controls_params.mojom', '../../../../../cc/mojom/browser_controls_params.mojom.js');
  }
  var browser_controls_offset_tag_modifications$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/browser_controls_offset_tag_modifications.mojom', '../../../../../cc/mojom/browser_controls_offset_tag_modifications.mojom.js');
  }
  var layer_selection_bound$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/layer_selection_bound.mojom', '../../../../../cc/mojom/layer_selection_bound.mojom.js');
  }
  var layer_tree_debug_state$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/layer_tree_debug_state.mojom', '../../../../../cc/mojom/layer_tree_debug_state.mojom.js');
  }
  var ui_resource_id$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/ui_resource_id.mojom', '../../../../../cc/mojom/ui_resource_id.mojom.js');
  }
  var animation$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/animation.mojom', 'animation.mojom.js');
  }
  var begin_frame_args$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/begin_frame_args.mojom', 'begin_frame_args.mojom.js');
  }
  var layer$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/layer.mojom', 'layer.mojom.js');
  }
  var local_surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/local_surface_id.mojom', 'local_surface_id.mojom.js');
  }
  var resource_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/resource_id.mojom', 'resource_id.mojom.js');
  }
  var surface_range$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_range.mojom', 'surface_range.mojom.js');
  }
  var tiling$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/tiling.mojom', 'tiling.mojom.js');
  }
  var transferable_resource$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/transferable_resource.mojom', 'transferable_resource.mojom.js');
  }
  var view_transition_request$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/view_transition_request.mojom', 'view_transition_request.mojom.js');
  }
  var skcolor4f$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor4f.mojom', '../../../../../skia/public/mojom/skcolor4f.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var display_color_spaces$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/display_color_spaces.mojom', '../../../../../ui/gfx/mojom/display_color_spaces.mojom.js');
  }
  var overlay_transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/overlay_transform.mojom', '../../../../../ui/gfx/mojom/overlay_transform.mojom.js');
  }



  function TransferableUIResourceRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  TransferableUIResourceRequest.Type = {};
  TransferableUIResourceRequest.Type.kCreate = 0;
  TransferableUIResourceRequest.Type.kDelete = 1;
  TransferableUIResourceRequest.Type.MIN_VALUE = 0;
  TransferableUIResourceRequest.Type.MAX_VALUE = 1;

  TransferableUIResourceRequest.Type.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  TransferableUIResourceRequest.Type.toKnownEnumValue = function(value) {
    return value;
  };

  TransferableUIResourceRequest.Type.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  TransferableUIResourceRequest.prototype.initDefaults_ = function() {
    this.type = 0;
    this.opaque = false;
    this.uid = null;
    this.transferableResource = null;
  };
  TransferableUIResourceRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TransferableUIResourceRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableUIResourceRequest.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, TransferableUIResourceRequest.Type);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableUIResourceRequest.uid
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ui_resource_id$.UIResourceId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TransferableUIResourceRequest.transferableResource
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, transferable_resource$.TransferableResource, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  TransferableUIResourceRequest.encodedSize = codec.kStructHeaderSize + 24;

  TransferableUIResourceRequest.decode = function(decoder) {
    var packed;
    var val = new TransferableUIResourceRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(TransferableUIResourceRequest.Type));
    packed = decoder.readUint8();
    val.opaque = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.uid =
        decoder.decodeStructPointer(ui_resource_id$.UIResourceId);
    val.transferableResource =
        decoder.decodeStructPointer(transferable_resource$.TransferableResource);
    return val;
  };

  TransferableUIResourceRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TransferableUIResourceRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    packed = 0;
    packed |= (val.opaque & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(ui_resource_id$.UIResourceId, val.uid);
    encoder.encodeStructPointer(transferable_resource$.TransferableResource, val.transferableResource);
  };
  function LayerTreeUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerTreeUpdate.prototype.initDefaults_ = function() {
    this.beginFrameArgs = null;
    this.sourceFrameNumber = 0;
    this.pageScaleFactor = 0;
    this.traceId = 0;
    this.primaryMainFrameItemSequenceNumber = 0;
    this.selection = null;
    this.minPageScaleFactor = 0;
    this.maxPageScaleFactor = 0;
    this.externalPageScaleFactor = 0;
    this.deviceScaleFactor = 0;
    this.deviceViewport = null;
    this.paintedDeviceScaleFactor = 0;
    this.nextFrameToken = 0;
    this.displayColorSpaces = null;
    this.localSurfaceIdFromParent = null;
    this.currentLocalSurfaceId = null;
    this.sendFrameTokenToEmbedder = false;
    this.fullTreeDamaged = false;
    this.overscrollElasticityTransform = 0;
    this.targetLocalSurfaceId = null;
    this.backgroundColor = null;
    this.pageScaleTransform = 0;
    this.innerScroll = 0;
    this.outerClip = 0;
    this.outerScroll = 0;
    this.viewportDamageRect = null;
    this.debugState = null;
    this.displayTransformHint = 0;
    this.maxSafeAreaInsetBottom = 0;
    this.browserControlsParams = null;
    this.browserControlsOffsetTagModifications = null;
    this.topControlsShownRatio = 0;
    this.bottomControlsShownRatio = 0;
    this.uiResourceRequests = null;
    this.layers = null;
    this.layerOrder = null;
    this.transformTreeUpdate = null;
    this.scrollTreeUpdate = null;
    this.transformNodes = null;
    this.clipNodes = null;
    this.effectNodes = null;
    this.scrollNodes = null;
    this.numTransformNodes = 0;
    this.numClipNodes = 0;
    this.numEffectNodes = 0;
    this.numScrollNodes = 0;
    this.tilings = null;
    this.surfaceRanges = null;
    this.viewTransitionRequests = null;
    this.animationTimelines = null;
    this.removedAnimationTimelines = null;
  };
  LayerTreeUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerTreeUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 320}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.beginFrameArgs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, begin_frame_args$.BeginFrameArgs, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate LayerTreeUpdate.selection
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, layer_selection_bound$.LayerSelection, false);
    if (err !== validator.validationError.NONE)
        return err;






    // validate LayerTreeUpdate.deviceViewport
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate LayerTreeUpdate.displayColorSpaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, display_color_spaces$.DisplayColorSpaces, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.localSurfaceIdFromParent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, local_surface_id$.LocalSurfaceId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.currentLocalSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, local_surface_id$.LocalSurfaceId, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate LayerTreeUpdate.targetLocalSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, local_surface_id$.LocalSurfaceId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.backgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate LayerTreeUpdate.viewportDamageRect
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LayerTreeUpdate.debugState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, layer_tree_debug_state$.LayerTreeDebugState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.displayTransformHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 152, overlay_transform$.OverlayTransform);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LayerTreeUpdate.browserControlsParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 160, browser_controls_params$.BrowserControlsParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.browserControlsOffsetTagModifications
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 168, browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate LayerTreeUpdate.uiResourceRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 184, 8, new codec.PointerTo(TransferableUIResourceRequest), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.layers
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 192, 8, new codec.PointerTo(layer$.Layer), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.layerOrder
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 200, 4, codec.Int32, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.transformTreeUpdate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 208, layer$.TransformTreeUpdate, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.scrollTreeUpdate
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, layer$.ScrollTreeUpdate, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.transformNodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 224, 8, new codec.PointerTo(layer$.TransformNode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.clipNodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 232, 8, new codec.PointerTo(layer$.ClipNode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.effectNodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 240, 8, new codec.PointerTo(layer$.EffectNode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.scrollNodes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 248, 8, new codec.PointerTo(layer$.ScrollNode), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;






    // validate LayerTreeUpdate.tilings
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 272, 8, new codec.PointerTo(tiling$.Tiling), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.surfaceRanges
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 280, 8, new codec.PointerTo(surface_range$.SurfaceRange), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.viewTransitionRequests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 288, 8, new codec.PointerTo(view_transition_request$.ViewTransitionRequest), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.animationTimelines
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 296, 8, new codec.PointerTo(animation$.AnimationTimeline), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerTreeUpdate.removedAnimationTimelines
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 304, 4, codec.Int32, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LayerTreeUpdate.encodedSize = codec.kStructHeaderSize + 312;

  LayerTreeUpdate.decode = function(decoder) {
    var packed;
    var val = new LayerTreeUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.beginFrameArgs =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameArgs);
    val.sourceFrameNumber =
        decoder.decodeStruct(codec.Int32);
    val.pageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.traceId =
        decoder.decodeStruct(codec.Uint64);
    val.primaryMainFrameItemSequenceNumber =
        decoder.decodeStruct(codec.Int64);
    val.selection =
        decoder.decodeStructPointer(layer_selection_bound$.LayerSelection);
    val.minPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.maxPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.externalPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.deviceViewport =
        decoder.decodeStructPointer(geometry$.Rect);
    val.paintedDeviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.nextFrameToken =
        decoder.decodeStruct(codec.Uint32);
    val.displayColorSpaces =
        decoder.decodeStructPointer(display_color_spaces$.DisplayColorSpaces);
    val.localSurfaceIdFromParent =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    val.currentLocalSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    packed = decoder.readUint8();
    val.sendFrameTokenToEmbedder = (packed >> 0) & 1 ? true : false;
    val.fullTreeDamaged = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.overscrollElasticityTransform =
        decoder.decodeStruct(codec.Int32);
    val.targetLocalSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    val.backgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.pageScaleTransform =
        decoder.decodeStruct(codec.Int32);
    val.innerScroll =
        decoder.decodeStruct(codec.Int32);
    val.outerClip =
        decoder.decodeStruct(codec.Int32);
    val.outerScroll =
        decoder.decodeStruct(codec.Int32);
    val.viewportDamageRect =
        decoder.decodeStructPointer(geometry$.Rect);
    val.debugState =
        decoder.decodeStructPointer(layer_tree_debug_state$.LayerTreeDebugState);
    val.displayTransformHint =
        decoder.decodeStruct(new codec.Enum(overlay_transform$.OverlayTransform));
    val.maxSafeAreaInsetBottom =
        decoder.decodeStruct(codec.Float);
    val.browserControlsParams =
        decoder.decodeStructPointer(browser_controls_params$.BrowserControlsParams);
    val.browserControlsOffsetTagModifications =
        decoder.decodeStructPointer(browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications);
    val.topControlsShownRatio =
        decoder.decodeStruct(codec.Float);
    val.bottomControlsShownRatio =
        decoder.decodeStruct(codec.Float);
    val.uiResourceRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(TransferableUIResourceRequest));
    val.layers =
        decoder.decodeArrayPointer(new codec.PointerTo(layer$.Layer));
    val.layerOrder =
        decoder.decodeArrayPointer(codec.Int32);
    val.transformTreeUpdate =
        decoder.decodeStructPointer(layer$.TransformTreeUpdate);
    val.scrollTreeUpdate =
        decoder.decodeStructPointer(layer$.ScrollTreeUpdate);
    val.transformNodes =
        decoder.decodeArrayPointer(new codec.PointerTo(layer$.TransformNode));
    val.clipNodes =
        decoder.decodeArrayPointer(new codec.PointerTo(layer$.ClipNode));
    val.effectNodes =
        decoder.decodeArrayPointer(new codec.PointerTo(layer$.EffectNode));
    val.scrollNodes =
        decoder.decodeArrayPointer(new codec.PointerTo(layer$.ScrollNode));
    val.numTransformNodes =
        decoder.decodeStruct(codec.Uint32);
    val.numClipNodes =
        decoder.decodeStruct(codec.Uint32);
    val.numEffectNodes =
        decoder.decodeStruct(codec.Uint32);
    val.numScrollNodes =
        decoder.decodeStruct(codec.Uint32);
    val.tilings =
        decoder.decodeArrayPointer(new codec.PointerTo(tiling$.Tiling));
    val.surfaceRanges =
        decoder.decodeArrayPointer(new codec.PointerTo(surface_range$.SurfaceRange));
    val.viewTransitionRequests =
        decoder.decodeArrayPointer(new codec.PointerTo(view_transition_request$.ViewTransitionRequest));
    val.animationTimelines =
        decoder.decodeArrayPointer(new codec.PointerTo(animation$.AnimationTimeline));
    val.removedAnimationTimelines =
        decoder.decodeArrayPointer(codec.Int32);
    return val;
  };

  LayerTreeUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerTreeUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameArgs, val.beginFrameArgs);
    encoder.encodeStruct(codec.Int32, val.sourceFrameNumber);
    encoder.encodeStruct(codec.Float, val.pageScaleFactor);
    encoder.encodeStruct(codec.Uint64, val.traceId);
    encoder.encodeStruct(codec.Int64, val.primaryMainFrameItemSequenceNumber);
    encoder.encodeStructPointer(layer_selection_bound$.LayerSelection, val.selection);
    encoder.encodeStruct(codec.Float, val.minPageScaleFactor);
    encoder.encodeStruct(codec.Float, val.maxPageScaleFactor);
    encoder.encodeStruct(codec.Float, val.externalPageScaleFactor);
    encoder.encodeStruct(codec.Float, val.deviceScaleFactor);
    encoder.encodeStructPointer(geometry$.Rect, val.deviceViewport);
    encoder.encodeStruct(codec.Float, val.paintedDeviceScaleFactor);
    encoder.encodeStruct(codec.Uint32, val.nextFrameToken);
    encoder.encodeStructPointer(display_color_spaces$.DisplayColorSpaces, val.displayColorSpaces);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.localSurfaceIdFromParent);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.currentLocalSurfaceId);
    packed = 0;
    packed |= (val.sendFrameTokenToEmbedder & 1) << 0
    packed |= (val.fullTreeDamaged & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.overscrollElasticityTransform);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.targetLocalSurfaceId);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.backgroundColor);
    encoder.encodeStruct(codec.Int32, val.pageScaleTransform);
    encoder.encodeStruct(codec.Int32, val.innerScroll);
    encoder.encodeStruct(codec.Int32, val.outerClip);
    encoder.encodeStruct(codec.Int32, val.outerScroll);
    encoder.encodeStructPointer(geometry$.Rect, val.viewportDamageRect);
    encoder.encodeStructPointer(layer_tree_debug_state$.LayerTreeDebugState, val.debugState);
    encoder.encodeStruct(codec.Int32, val.displayTransformHint);
    encoder.encodeStruct(codec.Float, val.maxSafeAreaInsetBottom);
    encoder.encodeStructPointer(browser_controls_params$.BrowserControlsParams, val.browserControlsParams);
    encoder.encodeStructPointer(browser_controls_offset_tag_modifications$.BrowserControlsOffsetTagModifications, val.browserControlsOffsetTagModifications);
    encoder.encodeStruct(codec.Float, val.topControlsShownRatio);
    encoder.encodeStruct(codec.Float, val.bottomControlsShownRatio);
    encoder.encodeArrayPointer(new codec.PointerTo(TransferableUIResourceRequest), val.uiResourceRequests);
    encoder.encodeArrayPointer(new codec.PointerTo(layer$.Layer), val.layers);
    encoder.encodeArrayPointer(codec.Int32, val.layerOrder);
    encoder.encodeStructPointer(layer$.TransformTreeUpdate, val.transformTreeUpdate);
    encoder.encodeStructPointer(layer$.ScrollTreeUpdate, val.scrollTreeUpdate);
    encoder.encodeArrayPointer(new codec.PointerTo(layer$.TransformNode), val.transformNodes);
    encoder.encodeArrayPointer(new codec.PointerTo(layer$.ClipNode), val.clipNodes);
    encoder.encodeArrayPointer(new codec.PointerTo(layer$.EffectNode), val.effectNodes);
    encoder.encodeArrayPointer(new codec.PointerTo(layer$.ScrollNode), val.scrollNodes);
    encoder.encodeStruct(codec.Uint32, val.numTransformNodes);
    encoder.encodeStruct(codec.Uint32, val.numClipNodes);
    encoder.encodeStruct(codec.Uint32, val.numEffectNodes);
    encoder.encodeStruct(codec.Uint32, val.numScrollNodes);
    encoder.encodeArrayPointer(new codec.PointerTo(tiling$.Tiling), val.tilings);
    encoder.encodeArrayPointer(new codec.PointerTo(surface_range$.SurfaceRange), val.surfaceRanges);
    encoder.encodeArrayPointer(new codec.PointerTo(view_transition_request$.ViewTransitionRequest), val.viewTransitionRequests);
    encoder.encodeArrayPointer(new codec.PointerTo(animation$.AnimationTimeline), val.animationTimelines);
    encoder.encodeArrayPointer(codec.Int32, val.removedAnimationTimelines);
  };
  function PendingLayerContext(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PendingLayerContext.prototype.initDefaults_ = function() {
    this.receiver = new associatedBindings.AssociatedInterfaceRequest();
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  PendingLayerContext.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PendingLayerContext.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingLayerContext.receiver
    err = messageValidator.validateAssociatedInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate PendingLayerContext.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PendingLayerContext.encodedSize = codec.kStructHeaderSize + 16;

  PendingLayerContext.decode = function(decoder) {
    var packed;
    var val = new PendingLayerContext();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.AssociatedInterfaceRequest);
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PendingLayerContext.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PendingLayerContext.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.AssociatedInterfaceRequest, val.receiver);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LayerContext_SetVisible_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerContext_SetVisible_Params.prototype.initDefaults_ = function() {
    this.visible = false;
  };
  LayerContext_SetVisible_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerContext_SetVisible_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LayerContext_SetVisible_Params.encodedSize = codec.kStructHeaderSize + 8;

  LayerContext_SetVisible_Params.decode = function(decoder) {
    var packed;
    var val = new LayerContext_SetVisible_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.visible = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LayerContext_SetVisible_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerContext_SetVisible_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.visible & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LayerContext_UpdateDisplayTree_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerContext_UpdateDisplayTree_Params.prototype.initDefaults_ = function() {
    this.update = null;
  };
  LayerContext_UpdateDisplayTree_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerContext_UpdateDisplayTree_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContext_UpdateDisplayTree_Params.update
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, LayerTreeUpdate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LayerContext_UpdateDisplayTree_Params.encodedSize = codec.kStructHeaderSize + 8;

  LayerContext_UpdateDisplayTree_Params.decode = function(decoder) {
    var packed;
    var val = new LayerContext_UpdateDisplayTree_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.update =
        decoder.decodeStructPointer(LayerTreeUpdate);
    return val;
  };

  LayerContext_UpdateDisplayTree_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerContext_UpdateDisplayTree_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(LayerTreeUpdate, val.update);
  };
  function LayerContext_UpdateDisplayTiling_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerContext_UpdateDisplayTiling_Params.prototype.initDefaults_ = function() {
    this.tiling = null;
    this.updateDamage = false;
  };
  LayerContext_UpdateDisplayTiling_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerContext_UpdateDisplayTiling_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContext_UpdateDisplayTiling_Params.tiling
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tiling$.Tiling, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LayerContext_UpdateDisplayTiling_Params.encodedSize = codec.kStructHeaderSize + 16;

  LayerContext_UpdateDisplayTiling_Params.decode = function(decoder) {
    var packed;
    var val = new LayerContext_UpdateDisplayTiling_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tiling =
        decoder.decodeStructPointer(tiling$.Tiling);
    packed = decoder.readUint8();
    val.updateDamage = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LayerContext_UpdateDisplayTiling_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerContext_UpdateDisplayTiling_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tiling$.Tiling, val.tiling);
    packed = 0;
    packed |= (val.updateDamage & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function LayerContextClient_OnRequestCommitForFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayerContextClient_OnRequestCommitForFrame_Params.prototype.initDefaults_ = function() {
    this.args = null;
  };
  LayerContextClient_OnRequestCommitForFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayerContextClient_OnRequestCommitForFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayerContextClient_OnRequestCommitForFrame_Params.args
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, begin_frame_args$.BeginFrameArgs, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LayerContextClient_OnRequestCommitForFrame_Params.encodedSize = codec.kStructHeaderSize + 8;

  LayerContextClient_OnRequestCommitForFrame_Params.decode = function(decoder) {
    var packed;
    var val = new LayerContextClient_OnRequestCommitForFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.args =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameArgs);
    return val;
  };

  LayerContextClient_OnRequestCommitForFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayerContextClient_OnRequestCommitForFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameArgs, val.args);
  };
  var kLayerContext_SetVisible_Name = 0;
  var kLayerContext_UpdateDisplayTree_Name = 1;
  var kLayerContext_UpdateDisplayTiling_Name = 2;

  function LayerContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LayerContext,
                                                   handleOrPtrInfo);
  }

  function LayerContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LayerContext, associatedInterfacePtrInfo);
  }

  LayerContextAssociatedPtr.prototype =
      Object.create(LayerContextPtr.prototype);
  LayerContextAssociatedPtr.prototype.constructor =
      LayerContextAssociatedPtr;

  function LayerContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  LayerContextPtr.prototype.setVisible = function() {
    return LayerContextProxy.prototype.setVisible
        .apply(this.ptr.getProxy(), arguments);
  };

  LayerContextProxy.prototype.setVisible = function(visible) {
    var params_ = new LayerContext_SetVisible_Params();
    params_.visible = visible;
    var builder = new codec.MessageV0Builder(
        kLayerContext_SetVisible_Name,
        codec.align(LayerContext_SetVisible_Params.encodedSize));
    builder.encodeStruct(LayerContext_SetVisible_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LayerContextPtr.prototype.updateDisplayTree = function() {
    return LayerContextProxy.prototype.updateDisplayTree
        .apply(this.ptr.getProxy(), arguments);
  };

  LayerContextProxy.prototype.updateDisplayTree = function(update) {
    var params_ = new LayerContext_UpdateDisplayTree_Params();
    params_.update = update;
    var builder = new codec.MessageV0Builder(
        kLayerContext_UpdateDisplayTree_Name,
        codec.align(LayerContext_UpdateDisplayTree_Params.encodedSize));
    builder.encodeStruct(LayerContext_UpdateDisplayTree_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  LayerContextPtr.prototype.updateDisplayTiling = function() {
    return LayerContextProxy.prototype.updateDisplayTiling
        .apply(this.ptr.getProxy(), arguments);
  };

  LayerContextProxy.prototype.updateDisplayTiling = function(tiling, updateDamage) {
    var params_ = new LayerContext_UpdateDisplayTiling_Params();
    params_.tiling = tiling;
    params_.updateDamage = updateDamage;
    var builder = new codec.MessageV0Builder(
        kLayerContext_UpdateDisplayTiling_Name,
        codec.align(LayerContext_UpdateDisplayTiling_Params.encodedSize));
    builder.encodeStruct(LayerContext_UpdateDisplayTiling_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LayerContextStub(delegate) {
    this.delegate_ = delegate;
  }
  LayerContextStub.prototype.setVisible = function(visible) {
    return this.delegate_ && this.delegate_.setVisible && this.delegate_.setVisible(visible);
  }
  LayerContextStub.prototype.updateDisplayTree = function(update) {
    return this.delegate_ && this.delegate_.updateDisplayTree && this.delegate_.updateDisplayTree(update);
  }
  LayerContextStub.prototype.updateDisplayTiling = function(tiling, updateDamage) {
    return this.delegate_ && this.delegate_.updateDisplayTiling && this.delegate_.updateDisplayTiling(tiling, updateDamage);
  }

  LayerContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLayerContext_SetVisible_Name:
      var params = reader.decodeStruct(LayerContext_SetVisible_Params);
      this.setVisible(params.visible);
      return true;
    case kLayerContext_UpdateDisplayTree_Name:
      var params = reader.decodeStruct(LayerContext_UpdateDisplayTree_Params);
      this.updateDisplayTree(params.update);
      return true;
    case kLayerContext_UpdateDisplayTiling_Name:
      var params = reader.decodeStruct(LayerContext_UpdateDisplayTiling_Params);
      this.updateDisplayTiling(params.tiling, params.updateDamage);
      return true;
    default:
      return false;
    }
  };

  LayerContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateLayerContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLayerContext_SetVisible_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LayerContext_SetVisible_Params;
      break;
      case kLayerContext_UpdateDisplayTree_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LayerContext_UpdateDisplayTree_Params;
      break;
      case kLayerContext_UpdateDisplayTiling_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LayerContext_UpdateDisplayTiling_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLayerContextResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var LayerContext = {
    name: 'viz.mojom.LayerContext',
    kVersion: 0,
    ptrClass: LayerContextPtr,
    proxyClass: LayerContextProxy,
    stubClass: LayerContextStub,
    validateRequest: validateLayerContextRequest,
    validateResponse: null,
  };
  LayerContextStub.prototype.validator = validateLayerContextRequest;
  LayerContextProxy.prototype.validator = null;
  var kLayerContextClient_OnRequestCommitForFrame_Name = 0;

  function LayerContextClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(LayerContextClient,
                                                   handleOrPtrInfo);
  }

  function LayerContextClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        LayerContextClient, associatedInterfacePtrInfo);
  }

  LayerContextClientAssociatedPtr.prototype =
      Object.create(LayerContextClientPtr.prototype);
  LayerContextClientAssociatedPtr.prototype.constructor =
      LayerContextClientAssociatedPtr;

  function LayerContextClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  LayerContextClientPtr.prototype.onRequestCommitForFrame = function() {
    return LayerContextClientProxy.prototype.onRequestCommitForFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  LayerContextClientProxy.prototype.onRequestCommitForFrame = function(args) {
    var params_ = new LayerContextClient_OnRequestCommitForFrame_Params();
    params_.args = args;
    var builder = new codec.MessageV0Builder(
        kLayerContextClient_OnRequestCommitForFrame_Name,
        codec.align(LayerContextClient_OnRequestCommitForFrame_Params.encodedSize));
    builder.encodeStruct(LayerContextClient_OnRequestCommitForFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function LayerContextClientStub(delegate) {
    this.delegate_ = delegate;
  }
  LayerContextClientStub.prototype.onRequestCommitForFrame = function(args) {
    return this.delegate_ && this.delegate_.onRequestCommitForFrame && this.delegate_.onRequestCommitForFrame(args);
  }

  LayerContextClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kLayerContextClient_OnRequestCommitForFrame_Name:
      var params = reader.decodeStruct(LayerContextClient_OnRequestCommitForFrame_Params);
      this.onRequestCommitForFrame(params.args);
      return true;
    default:
      return false;
    }
  };

  LayerContextClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateLayerContextClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kLayerContextClient_OnRequestCommitForFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = LayerContextClient_OnRequestCommitForFrame_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateLayerContextClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var LayerContextClient = {
    name: 'viz.mojom.LayerContextClient',
    kVersion: 0,
    ptrClass: LayerContextClientPtr,
    proxyClass: LayerContextClientProxy,
    stubClass: LayerContextClientStub,
    validateRequest: validateLayerContextClientRequest,
    validateResponse: null,
  };
  LayerContextClientStub.prototype.validator = validateLayerContextClientRequest;
  LayerContextClientProxy.prototype.validator = null;
  exports.TransferableUIResourceRequest = TransferableUIResourceRequest;
  exports.LayerTreeUpdate = LayerTreeUpdate;
  exports.PendingLayerContext = PendingLayerContext;
  exports.LayerContext = LayerContext;
  exports.LayerContextPtr = LayerContextPtr;
  exports.LayerContextAssociatedPtr = LayerContextAssociatedPtr;
  exports.LayerContextClient = LayerContextClient;
  exports.LayerContextClientPtr = LayerContextClientPtr;
  exports.LayerContextClientAssociatedPtr = LayerContextClientAssociatedPtr;
})();