// services/viz/public/mojom/compositing/layer_context.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_params.mojom-shared.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-shared.h"
#include "cc/mojom/layer_selection_bound.mojom-shared.h"
#include "cc/mojom/layer_tree_debug_state.mojom-shared.h"
#include "cc/mojom/ui_resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/animation.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/layer.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-shared.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_request.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/overlay_transform.mojom-shared.h"


namespace viz::mojom {
class TransferableUIResourceRequestDataView;

class LayerTreeUpdateDataView;

class PendingLayerContextDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::TransferableUIResourceRequestDataView> {
  using Data = ::viz::mojom::internal::TransferableUIResourceRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::LayerTreeUpdateDataView> {
  using Data = ::viz::mojom::internal::LayerTreeUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::PendingLayerContextDataView> {
  using Data = ::viz::mojom::internal::PendingLayerContext_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class TransferableUIResourceRequest_Type : int32_t {
  
  kCreate = 0,
  
  kDelete = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TransferableUIResourceRequest_Type value);
inline bool IsKnownEnumValue(TransferableUIResourceRequest_Type value) {
  return internal::TransferableUIResourceRequest_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class LayerContextInterfaceBase {};

using LayerContextPtrDataView =
    mojo::InterfacePtrDataView<LayerContextInterfaceBase>;
using LayerContextRequestDataView =
    mojo::InterfaceRequestDataView<LayerContextInterfaceBase>;
using LayerContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LayerContextInterfaceBase>;
using LayerContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LayerContextInterfaceBase>;
class LayerContextClientInterfaceBase {};

using LayerContextClientPtrDataView =
    mojo::InterfacePtrDataView<LayerContextClientInterfaceBase>;
using LayerContextClientRequestDataView =
    mojo::InterfaceRequestDataView<LayerContextClientInterfaceBase>;
using LayerContextClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LayerContextClientInterfaceBase>;
using LayerContextClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LayerContextClientInterfaceBase>;


class TransferableUIResourceRequestDataView {
 public:
  TransferableUIResourceRequestDataView() = default;

  TransferableUIResourceRequestDataView(
      internal::TransferableUIResourceRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::TransferableUIResourceRequest_Type>(
        data_value, output);
  }
  TransferableUIResourceRequest_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::TransferableUIResourceRequest_Type>(data_->type));
  }
  inline void GetUidDataView(
      ::cc::mojom::UIResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUid(UserType* output) {
    
    auto* pointer = data_->uid.Get();
    return mojo::internal::Deserialize<::cc::mojom::UIResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetTransferableResourceDataView(
      ::viz::mojom::TransferableResourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransferableResource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TransferableResourceDataView, UserType>(),
    "Attempting to read the optional `transferable_resource` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransferableResource` instead "
    "of `ReadTransferableResource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transferable_resource.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransferableResourceDataView>(
        pointer, output, message_);
  }
  bool opaque() const {
    return data_->opaque;
  }
 private:
  internal::TransferableUIResourceRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LayerTreeUpdateDataView {
 public:
  LayerTreeUpdateDataView() = default;

  LayerTreeUpdateDataView(
      internal::LayerTreeUpdate_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBeginFrameArgsDataView(
      ::viz::mojom::BeginFrameArgsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBeginFrameArgs(UserType* output) {
    
    auto* pointer = data_->begin_frame_args.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameArgsDataView>(
        pointer, output, message_);
  }
  int32_t source_frame_number() const {
    return data_->source_frame_number;
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  int64_t primary_main_frame_item_sequence_number() const {
    return data_->primary_main_frame_item_sequence_number;
  }
  inline void GetSelectionDataView(
      ::cc::mojom::LayerSelectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelection(UserType* output) {
    
    auto* pointer = data_->selection.Get();
    return mojo::internal::Deserialize<::cc::mojom::LayerSelectionDataView>(
        pointer, output, message_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float min_page_scale_factor() const {
    return data_->min_page_scale_factor;
  }
  float max_page_scale_factor() const {
    return data_->max_page_scale_factor;
  }
  float external_page_scale_factor() const {
    return data_->external_page_scale_factor;
  }
  inline void GetDeviceViewportDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceViewport(UserType* output) {
    
    auto* pointer = data_->device_viewport.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float painted_device_scale_factor() const {
    return data_->painted_device_scale_factor;
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
  inline void GetLocalSurfaceIdFromParentDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalSurfaceIdFromParent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `local_surface_id_from_parent` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLocalSurfaceIdFromParent` instead "
    "of `ReadLocalSurfaceIdFromParent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->local_surface_id_from_parent.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentLocalSurfaceId(UserType* output) {
    
    auto* pointer = data_->current_local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  uint32_t next_frame_token() const {
    return data_->next_frame_token;
  }
  bool send_frame_token_to_embedder() const {
    return data_->send_frame_token_to_embedder;
  }
  inline void GetTargetLocalSurfaceIdDataView(
      ::viz::mojom::LocalSurfaceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetLocalSurfaceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::LocalSurfaceIdDataView, UserType>(),
    "Attempting to read the optional `target_local_surface_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTargetLocalSurfaceId` instead "
    "of `ReadTargetLocalSurfaceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->target_local_surface_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::LocalSurfaceIdDataView>(
        pointer, output, message_);
  }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColor4fDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColor4fDataView>(
        pointer, output, message_);
  }
  int32_t overscroll_elasticity_transform() const {
    return data_->overscroll_elasticity_transform;
  }
  int32_t page_scale_transform() const {
    return data_->page_scale_transform;
  }
  int32_t inner_scroll() const {
    return data_->inner_scroll;
  }
  int32_t outer_clip() const {
    return data_->outer_clip;
  }
  int32_t outer_scroll() const {
    return data_->outer_scroll;
  }
  inline void GetViewportDamageRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportDamageRect(UserType* output) {
    
    auto* pointer = data_->viewport_damage_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool full_tree_damaged() const {
    return data_->full_tree_damaged;
  }
  inline void GetDebugStateDataView(
      ::cc::mojom::LayerTreeDebugStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugState(UserType* output) {
    
    auto* pointer = data_->debug_state.Get();
    return mojo::internal::Deserialize<::cc::mojom::LayerTreeDebugStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisplayTransformHint(UserType* output) const {
    auto data_value = data_->display_transform_hint;
    return mojo::internal::Deserialize<::gfx::mojom::OverlayTransform>(
        data_value, output);
  }
  ::gfx::mojom::OverlayTransform display_transform_hint() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::OverlayTransform>(data_->display_transform_hint));
  }
  float max_safe_area_inset_bottom() const {
    return data_->max_safe_area_inset_bottom;
  }
  inline void GetBrowserControlsParamsDataView(
      ::cc::mojom::BrowserControlsParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserControlsParams(UserType* output) {
    
    auto* pointer = data_->browser_controls_params.Get();
    return mojo::internal::Deserialize<::cc::mojom::BrowserControlsParamsDataView>(
        pointer, output, message_);
  }
  inline void GetBrowserControlsOffsetTagModificationsDataView(
      ::cc::mojom::BrowserControlsOffsetTagModificationsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowserControlsOffsetTagModifications(UserType* output) {
    
    auto* pointer = data_->browser_controls_offset_tag_modifications.Get();
    return mojo::internal::Deserialize<::cc::mojom::BrowserControlsOffsetTagModificationsDataView>(
        pointer, output, message_);
  }
  float top_controls_shown_ratio() const {
    return data_->top_controls_shown_ratio;
  }
  float bottom_controls_shown_ratio() const {
    return data_->bottom_controls_shown_ratio;
  }
  inline void GetUiResourceRequestsDataView(
      mojo::ArrayDataView<TransferableUIResourceRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUiResourceRequests(UserType* output) {
    
    auto* pointer = data_->ui_resource_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransferableUIResourceRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetLayersDataView(
      mojo::ArrayDataView<::viz::mojom::LayerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayers(UserType* output) {
    
    auto* pointer = data_->layers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::LayerDataView>>(
        pointer, output, message_);
  }
  inline void GetLayerOrderDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerOrder(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<int32_t>, UserType>(),
    "Attempting to read the optional `layer_order` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLayerOrder` instead "
    "of `ReadLayerOrder if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->layer_order.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
  inline void GetTransformTreeUpdateDataView(
      ::viz::mojom::TransformTreeUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformTreeUpdate(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::TransformTreeUpdateDataView, UserType>(),
    "Attempting to read the optional `transform_tree_update` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransformTreeUpdate` instead "
    "of `ReadTransformTreeUpdate if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transform_tree_update.Get();
    return mojo::internal::Deserialize<::viz::mojom::TransformTreeUpdateDataView>(
        pointer, output, message_);
  }
  inline void GetScrollTreeUpdateDataView(
      ::viz::mojom::ScrollTreeUpdateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollTreeUpdate(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::ScrollTreeUpdateDataView, UserType>(),
    "Attempting to read the optional `scroll_tree_update` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollTreeUpdate` instead "
    "of `ReadScrollTreeUpdate if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scroll_tree_update.Get();
    return mojo::internal::Deserialize<::viz::mojom::ScrollTreeUpdateDataView>(
        pointer, output, message_);
  }
  inline void GetTransformNodesDataView(
      mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransformNodes(UserType* output) {
    
    auto* pointer = data_->transform_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TransformNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetClipNodesDataView(
      mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClipNodes(UserType* output) {
    
    auto* pointer = data_->clip_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ClipNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetEffectNodesDataView(
      mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectNodes(UserType* output) {
    
    auto* pointer = data_->effect_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::EffectNodeDataView>>(
        pointer, output, message_);
  }
  inline void GetScrollNodesDataView(
      mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollNodes(UserType* output) {
    
    auto* pointer = data_->scroll_nodes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ScrollNodeDataView>>(
        pointer, output, message_);
  }
  uint32_t num_transform_nodes() const {
    return data_->num_transform_nodes;
  }
  uint32_t num_clip_nodes() const {
    return data_->num_clip_nodes;
  }
  uint32_t num_effect_nodes() const {
    return data_->num_effect_nodes;
  }
  uint32_t num_scroll_nodes() const {
    return data_->num_scroll_nodes;
  }
  inline void GetTilingsDataView(
      mojo::ArrayDataView<::viz::mojom::TilingDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilings(UserType* output) {
    
    auto* pointer = data_->tilings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::TilingDataView>>(
        pointer, output, message_);
  }
  inline void GetSurfaceRangesDataView(
      mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSurfaceRanges(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>, UserType>(),
    "Attempting to read the optional `surface_ranges` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSurfaceRanges` instead "
    "of `ReadSurfaceRanges if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->surface_ranges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::SurfaceRangeDataView>>(
        pointer, output, message_);
  }
  inline void GetViewTransitionRequestsDataView(
      mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionRequests(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>, UserType>(),
    "Attempting to read the optional `view_transition_requests` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewTransitionRequests` instead "
    "of `ReadViewTransitionRequests if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_transition_requests.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ViewTransitionRequestDataView>>(
        pointer, output, message_);
  }
  inline void GetAnimationTimelinesDataView(
      mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnimationTimelines(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>, UserType>(),
    "Attempting to read the optional `animation_timelines` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAnimationTimelines` instead "
    "of `ReadAnimationTimelines if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->animation_timelines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::AnimationTimelineDataView>>(
        pointer, output, message_);
  }
  inline void GetRemovedAnimationTimelinesDataView(
      mojo::ArrayDataView<int32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRemovedAnimationTimelines(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<int32_t>, UserType>(),
    "Attempting to read the optional `removed_animation_timelines` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRemovedAnimationTimelines` instead "
    "of `ReadRemovedAnimationTimelines if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->removed_animation_timelines.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<int32_t>>(
        pointer, output, message_);
  }
 private:
  internal::LayerTreeUpdate_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PendingLayerContextDataView {
 public:
  PendingLayerContextDataView() = default;

  PendingLayerContextDataView(
      internal::PendingLayerContext_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::LayerContextAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::viz::mojom::LayerContextClientAssociatedPtrInfoDataView>(
            &data_->client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PendingLayerContext_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_DATA_VIEW_H_