// services/viz/public/mojom/compositing/layer_context.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/layer_context.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer_context.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/layer_context.mojom-blink-forward.h"  // IWYU pragma: export
#include "cc/mojom/browser_controls_params.mojom-blink.h"
#include "cc/mojom/browser_controls_offset_tag_modifications.mojom-blink.h"
#include "cc/mojom/layer_selection_bound.mojom-blink.h"
#include "cc/mojom/layer_tree_debug_state.mojom-blink.h"
#include "cc/mojom/ui_resource_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/animation.mojom-blink.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-blink.h"
#include "services/viz/public/mojom/compositing/layer.mojom-blink.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-blink.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-blink.h"
#include "services/viz/public/mojom/compositing/tiling.mojom-blink.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-blink.h"
#include "services/viz/public/mojom/compositing/view_transition_request.mojom-blink.h"
#include "skia/public/mojom/skcolor4f.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-blink.h"
#include "ui/gfx/mojom/overlay_transform.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {

class LayerContextProxy;

template <typename ImplRefTraits>
class LayerContextStub;

class LayerContextRequestValidator;


class BLINK_PLATFORM_EXPORT LayerContext
    : public LayerContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.LayerContext";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr bool kSupportsDirectReceiver = true;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerContextInterfaceBase;
  using Proxy_ = LayerContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerContextStub<ImplRefTraits>;

  using RequestValidator_ = LayerContextRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVisibleMinVersion = 0,
    kUpdateDisplayTreeMinVersion = 0,
    kUpdateDisplayTilingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDisplayTree_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDisplayTiling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerContext() = default;

  virtual void SetVisible(bool visible) = 0;

  virtual void UpdateDisplayTree(LayerTreeUpdatePtr update) = 0;

  virtual void UpdateDisplayTiling(::viz::mojom::blink::TilingPtr tiling, bool update_damage) = 0;
};

class LayerContextClientProxy;

template <typename ImplRefTraits>
class LayerContextClientStub;

class LayerContextClientRequestValidator;


class BLINK_PLATFORM_EXPORT LayerContextClient
    : public LayerContextClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.LayerContextClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LayerContextClientInterfaceBase;
  using Proxy_ = LayerContextClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = LayerContextClientStub<ImplRefTraits>;

  using RequestValidator_ = LayerContextClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRequestCommitForFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRequestCommitForFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LayerContextClient() = default;

  virtual void OnRequestCommitForFrame(const ::viz::BeginFrameArgs& args) = 0;
};



class BLINK_PLATFORM_EXPORT LayerContextProxy
    : public LayerContext {
 public:
  using InterfaceType = LayerContext;

  explicit LayerContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVisible(bool visible) final;
  
  void UpdateDisplayTree(LayerTreeUpdatePtr update) final;
  
  void UpdateDisplayTiling(::viz::mojom::blink::TilingPtr tiling, bool update_damage) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT LayerContextClientProxy
    : public LayerContextClient {
 public:
  using InterfaceType = LayerContextClient;

  explicit LayerContextClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRequestCommitForFrame(const ::viz::BeginFrameArgs& args) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT LayerContextStubDispatch {
 public:
  static bool Accept(LayerContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerContext>>
class LayerContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerContextStub() = default;
  ~LayerContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT LayerContextClientStubDispatch {
 public:
  static bool Accept(LayerContextClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LayerContextClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LayerContextClient>>
class LayerContextClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LayerContextClientStub() = default;
  ~LayerContextClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LayerContextClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT LayerContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT LayerContextClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_PLATFORM_EXPORT TransferableUIResourceRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferableUIResourceRequest, T>::value>;
  using DataView = TransferableUIResourceRequestDataView;
  using Data_ = internal::TransferableUIResourceRequest_Data;
  using Type = TransferableUIResourceRequest_Type;

  template <typename... Args>
  static TransferableUIResourceRequestPtr New(Args&&... args) {
    return TransferableUIResourceRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferableUIResourceRequestPtr From(const U& u) {
    return mojo::TypeConverter<TransferableUIResourceRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableUIResourceRequest>::Convert(*this);
  }


  TransferableUIResourceRequest();

  TransferableUIResourceRequest(
      TransferableUIResourceRequest::Type type,
      ::cc::mojom::blink::UIResourceIdPtr uid,
      ::viz::mojom::blink::TransferableResourcePtr transferable_resource,
      bool opaque);

TransferableUIResourceRequest(const TransferableUIResourceRequest&) = delete;
TransferableUIResourceRequest& operator=(const TransferableUIResourceRequest&) = delete;

  ~TransferableUIResourceRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferableUIResourceRequestPtr>
  TransferableUIResourceRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransferableUIResourceRequest::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TransferableUIResourceRequest::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableUIResourceRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferableUIResourceRequest_UnserializedMessageContext<
            UserType, TransferableUIResourceRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransferableUIResourceRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransferableUIResourceRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferableUIResourceRequest_UnserializedMessageContext<
            UserType, TransferableUIResourceRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferableUIResourceRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  TransferableUIResourceRequest::Type type;
  
  ::cc::mojom::blink::UIResourceIdPtr uid;
  
  ::viz::mojom::blink::TransferableResourcePtr transferable_resource;
  
  bool opaque;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferableUIResourceRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT LayerTreeUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LayerTreeUpdate, T>::value>;
  using DataView = LayerTreeUpdateDataView;
  using Data_ = internal::LayerTreeUpdate_Data;

  template <typename... Args>
  static LayerTreeUpdatePtr New(Args&&... args) {
    return LayerTreeUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LayerTreeUpdatePtr From(const U& u) {
    return mojo::TypeConverter<LayerTreeUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LayerTreeUpdate>::Convert(*this);
  }


  LayerTreeUpdate();

  LayerTreeUpdate(
      const ::viz::BeginFrameArgs& begin_frame_args,
      int32_t source_frame_number,
      uint64_t trace_id,
      int64_t primary_main_frame_item_sequence_number,
      ::cc::mojom::blink::LayerSelectionPtr selection,
      float page_scale_factor,
      float min_page_scale_factor,
      float max_page_scale_factor,
      float external_page_scale_factor,
      const ::gfx::Rect& device_viewport,
      float device_scale_factor,
      float painted_device_scale_factor,
      const ::gfx::DisplayColorSpaces& display_color_spaces,
      const std::optional<::viz::LocalSurfaceId>& local_surface_id_from_parent,
      const ::viz::LocalSurfaceId& current_local_surface_id,
      uint32_t next_frame_token,
      bool send_frame_token_to_embedder,
      const std::optional<::viz::LocalSurfaceId>& target_local_surface_id,
      const ::SkColor4f& background_color,
      int32_t overscroll_elasticity_transform,
      int32_t page_scale_transform,
      int32_t inner_scroll,
      int32_t outer_clip,
      int32_t outer_scroll,
      const ::gfx::Rect& viewport_damage_rect,
      bool full_tree_damaged,
      ::cc::mojom::blink::LayerTreeDebugStatePtr debug_state,
      ::gfx::mojom::blink::OverlayTransform display_transform_hint,
      float max_safe_area_inset_bottom,
      const ::cc::BrowserControlsParams& browser_controls_params,
      const ::cc::BrowserControlsOffsetTagModifications& browser_controls_offset_tag_modifications,
      float top_controls_shown_ratio,
      float bottom_controls_shown_ratio,
      ::blink::Vector<TransferableUIResourceRequestPtr> ui_resource_requests,
      ::blink::Vector<::viz::mojom::blink::LayerPtr> layers,
      std::optional<::blink::Vector<int32_t>> layer_order,
      ::viz::mojom::blink::TransformTreeUpdatePtr transform_tree_update,
      ::viz::mojom::blink::ScrollTreeUpdatePtr scroll_tree_update,
      ::blink::Vector<::viz::mojom::blink::TransformNodePtr> transform_nodes,
      ::blink::Vector<::viz::mojom::blink::ClipNodePtr> clip_nodes,
      ::blink::Vector<::viz::mojom::blink::EffectNodePtr> effect_nodes,
      ::blink::Vector<::viz::mojom::blink::ScrollNodePtr> scroll_nodes,
      uint32_t num_transform_nodes,
      uint32_t num_clip_nodes,
      uint32_t num_effect_nodes,
      uint32_t num_scroll_nodes,
      ::blink::Vector<::viz::mojom::blink::TilingPtr> tilings,
      std::optional<::blink::Vector<::viz::SurfaceRange>> surface_ranges,
      std::optional<::blink::Vector<::viz::mojom::blink::ViewTransitionRequestPtr>> view_transition_requests,
      std::optional<::blink::Vector<::viz::mojom::blink::AnimationTimelinePtr>> animation_timelines,
      std::optional<::blink::Vector<int32_t>> removed_animation_timelines);

LayerTreeUpdate(const LayerTreeUpdate&) = delete;
LayerTreeUpdate& operator=(const LayerTreeUpdate&) = delete;

  ~LayerTreeUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LayerTreeUpdatePtr>
  LayerTreeUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LayerTreeUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LayerTreeUpdate_UnserializedMessageContext<
            UserType, LayerTreeUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LayerTreeUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LayerTreeUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LayerTreeUpdate_UnserializedMessageContext<
            UserType, LayerTreeUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LayerTreeUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::BeginFrameArgs begin_frame_args;
  
  int32_t source_frame_number;
  
  uint64_t trace_id;
  
  int64_t primary_main_frame_item_sequence_number;
  
  ::cc::mojom::blink::LayerSelectionPtr selection;
  
  float page_scale_factor;
  
  float min_page_scale_factor;
  
  float max_page_scale_factor;
  
  float external_page_scale_factor;
  
  ::gfx::Rect device_viewport;
  
  float device_scale_factor;
  
  float painted_device_scale_factor;
  
  ::gfx::DisplayColorSpaces display_color_spaces;
  
  std::optional<::viz::LocalSurfaceId> local_surface_id_from_parent;
  
  ::viz::LocalSurfaceId current_local_surface_id;
  
  uint32_t next_frame_token;
  
  bool send_frame_token_to_embedder;
  
  std::optional<::viz::LocalSurfaceId> target_local_surface_id;
  
  ::SkColor4f background_color;
  
  int32_t overscroll_elasticity_transform;
  
  int32_t page_scale_transform;
  
  int32_t inner_scroll;
  
  int32_t outer_clip;
  
  int32_t outer_scroll;
  
  ::gfx::Rect viewport_damage_rect;
  
  bool full_tree_damaged;
  
  ::cc::mojom::blink::LayerTreeDebugStatePtr debug_state;
  
  ::gfx::mojom::blink::OverlayTransform display_transform_hint;
  
  float max_safe_area_inset_bottom;
  
  ::cc::BrowserControlsParams browser_controls_params;
  
  ::cc::BrowserControlsOffsetTagModifications browser_controls_offset_tag_modifications;
  
  float top_controls_shown_ratio;
  
  float bottom_controls_shown_ratio;
  
  ::blink::Vector<TransferableUIResourceRequestPtr> ui_resource_requests;
  
  ::blink::Vector<::viz::mojom::blink::LayerPtr> layers;
  
  std::optional<::blink::Vector<int32_t>> layer_order;
  
  ::viz::mojom::blink::TransformTreeUpdatePtr transform_tree_update;
  
  ::viz::mojom::blink::ScrollTreeUpdatePtr scroll_tree_update;
  
  ::blink::Vector<::viz::mojom::blink::TransformNodePtr> transform_nodes;
  
  ::blink::Vector<::viz::mojom::blink::ClipNodePtr> clip_nodes;
  
  ::blink::Vector<::viz::mojom::blink::EffectNodePtr> effect_nodes;
  
  ::blink::Vector<::viz::mojom::blink::ScrollNodePtr> scroll_nodes;
  
  uint32_t num_transform_nodes;
  
  uint32_t num_clip_nodes;
  
  uint32_t num_effect_nodes;
  
  uint32_t num_scroll_nodes;
  
  ::blink::Vector<::viz::mojom::blink::TilingPtr> tilings;
  
  std::optional<::blink::Vector<::viz::SurfaceRange>> surface_ranges;
  
  std::optional<::blink::Vector<::viz::mojom::blink::ViewTransitionRequestPtr>> view_transition_requests;
  
  std::optional<::blink::Vector<::viz::mojom::blink::AnimationTimelinePtr>> animation_timelines;
  
  std::optional<::blink::Vector<int32_t>> removed_animation_timelines;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT PendingLayerContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PendingLayerContext, T>::value>;
  using DataView = PendingLayerContextDataView;
  using Data_ = internal::PendingLayerContext_Data;

  template <typename... Args>
  static PendingLayerContextPtr New(Args&&... args) {
    return PendingLayerContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PendingLayerContextPtr From(const U& u) {
    return mojo::TypeConverter<PendingLayerContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PendingLayerContext>::Convert(*this);
  }


  PendingLayerContext();

  PendingLayerContext(
      ::mojo::PendingAssociatedReceiver<LayerContext> receiver,
      ::mojo::PendingAssociatedRemote<LayerContextClient> client);

PendingLayerContext(const PendingLayerContext&) = delete;
PendingLayerContext& operator=(const PendingLayerContext&) = delete;

  ~PendingLayerContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PendingLayerContextPtr>
  PendingLayerContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PendingLayerContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PendingLayerContext_UnserializedMessageContext<
            UserType, PendingLayerContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PendingLayerContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PendingLayerContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PendingLayerContext_UnserializedMessageContext<
            UserType, PendingLayerContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PendingLayerContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingAssociatedReceiver<LayerContext> receiver;
  
  ::mojo::PendingAssociatedRemote<LayerContextClient> client;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PendingLayerContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferableUIResourceRequestPtr TransferableUIResourceRequest::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(uid),
      mojo::Clone(transferable_resource),
      mojo::Clone(opaque)
  );
}

template <typename T, TransferableUIResourceRequest::EnableIfSame<T>*>
bool TransferableUIResourceRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->uid, other_struct.uid))
    return false;
  if (!mojo::Equals(this->transferable_resource, other_struct.transferable_resource))
    return false;
  if (!mojo::Equals(this->opaque, other_struct.opaque))
    return false;
  return true;
}

template <typename T, TransferableUIResourceRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.uid < rhs.uid)
    return true;
  if (rhs.uid < lhs.uid)
    return false;
  if (lhs.transferable_resource < rhs.transferable_resource)
    return true;
  if (rhs.transferable_resource < lhs.transferable_resource)
    return false;
  if (lhs.opaque < rhs.opaque)
    return true;
  if (rhs.opaque < lhs.opaque)
    return false;
  return false;
}
template <typename StructPtrType>
LayerTreeUpdatePtr LayerTreeUpdate::Clone() const {
  return New(
      mojo::Clone(begin_frame_args),
      mojo::Clone(source_frame_number),
      mojo::Clone(trace_id),
      mojo::Clone(primary_main_frame_item_sequence_number),
      mojo::Clone(selection),
      mojo::Clone(page_scale_factor),
      mojo::Clone(min_page_scale_factor),
      mojo::Clone(max_page_scale_factor),
      mojo::Clone(external_page_scale_factor),
      mojo::Clone(device_viewport),
      mojo::Clone(device_scale_factor),
      mojo::Clone(painted_device_scale_factor),
      mojo::Clone(display_color_spaces),
      mojo::Clone(local_surface_id_from_parent),
      mojo::Clone(current_local_surface_id),
      mojo::Clone(next_frame_token),
      mojo::Clone(send_frame_token_to_embedder),
      mojo::Clone(target_local_surface_id),
      mojo::Clone(background_color),
      mojo::Clone(overscroll_elasticity_transform),
      mojo::Clone(page_scale_transform),
      mojo::Clone(inner_scroll),
      mojo::Clone(outer_clip),
      mojo::Clone(outer_scroll),
      mojo::Clone(viewport_damage_rect),
      mojo::Clone(full_tree_damaged),
      mojo::Clone(debug_state),
      mojo::Clone(display_transform_hint),
      mojo::Clone(max_safe_area_inset_bottom),
      mojo::Clone(browser_controls_params),
      mojo::Clone(browser_controls_offset_tag_modifications),
      mojo::Clone(top_controls_shown_ratio),
      mojo::Clone(bottom_controls_shown_ratio),
      mojo::Clone(ui_resource_requests),
      mojo::Clone(layers),
      mojo::Clone(layer_order),
      mojo::Clone(transform_tree_update),
      mojo::Clone(scroll_tree_update),
      mojo::Clone(transform_nodes),
      mojo::Clone(clip_nodes),
      mojo::Clone(effect_nodes),
      mojo::Clone(scroll_nodes),
      mojo::Clone(num_transform_nodes),
      mojo::Clone(num_clip_nodes),
      mojo::Clone(num_effect_nodes),
      mojo::Clone(num_scroll_nodes),
      mojo::Clone(tilings),
      mojo::Clone(surface_ranges),
      mojo::Clone(view_transition_requests),
      mojo::Clone(animation_timelines),
      mojo::Clone(removed_animation_timelines)
  );
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>*>
bool LayerTreeUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->begin_frame_args, other_struct.begin_frame_args))
    return false;
  if (!mojo::Equals(this->source_frame_number, other_struct.source_frame_number))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->primary_main_frame_item_sequence_number, other_struct.primary_main_frame_item_sequence_number))
    return false;
  if (!mojo::Equals(this->selection, other_struct.selection))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->min_page_scale_factor, other_struct.min_page_scale_factor))
    return false;
  if (!mojo::Equals(this->max_page_scale_factor, other_struct.max_page_scale_factor))
    return false;
  if (!mojo::Equals(this->external_page_scale_factor, other_struct.external_page_scale_factor))
    return false;
  if (!mojo::Equals(this->device_viewport, other_struct.device_viewport))
    return false;
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->painted_device_scale_factor, other_struct.painted_device_scale_factor))
    return false;
  if (!mojo::Equals(this->display_color_spaces, other_struct.display_color_spaces))
    return false;
  if (!mojo::Equals(this->local_surface_id_from_parent, other_struct.local_surface_id_from_parent))
    return false;
  if (!mojo::Equals(this->current_local_surface_id, other_struct.current_local_surface_id))
    return false;
  if (!mojo::Equals(this->next_frame_token, other_struct.next_frame_token))
    return false;
  if (!mojo::Equals(this->send_frame_token_to_embedder, other_struct.send_frame_token_to_embedder))
    return false;
  if (!mojo::Equals(this->target_local_surface_id, other_struct.target_local_surface_id))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->overscroll_elasticity_transform, other_struct.overscroll_elasticity_transform))
    return false;
  if (!mojo::Equals(this->page_scale_transform, other_struct.page_scale_transform))
    return false;
  if (!mojo::Equals(this->inner_scroll, other_struct.inner_scroll))
    return false;
  if (!mojo::Equals(this->outer_clip, other_struct.outer_clip))
    return false;
  if (!mojo::Equals(this->outer_scroll, other_struct.outer_scroll))
    return false;
  if (!mojo::Equals(this->viewport_damage_rect, other_struct.viewport_damage_rect))
    return false;
  if (!mojo::Equals(this->full_tree_damaged, other_struct.full_tree_damaged))
    return false;
  if (!mojo::Equals(this->debug_state, other_struct.debug_state))
    return false;
  if (!mojo::Equals(this->display_transform_hint, other_struct.display_transform_hint))
    return false;
  if (!mojo::Equals(this->max_safe_area_inset_bottom, other_struct.max_safe_area_inset_bottom))
    return false;
  if (!mojo::Equals(this->browser_controls_params, other_struct.browser_controls_params))
    return false;
  if (!mojo::Equals(this->browser_controls_offset_tag_modifications, other_struct.browser_controls_offset_tag_modifications))
    return false;
  if (!mojo::Equals(this->top_controls_shown_ratio, other_struct.top_controls_shown_ratio))
    return false;
  if (!mojo::Equals(this->bottom_controls_shown_ratio, other_struct.bottom_controls_shown_ratio))
    return false;
  if (!mojo::Equals(this->ui_resource_requests, other_struct.ui_resource_requests))
    return false;
  if (!mojo::Equals(this->layers, other_struct.layers))
    return false;
  if (!mojo::Equals(this->layer_order, other_struct.layer_order))
    return false;
  if (!mojo::Equals(this->transform_tree_update, other_struct.transform_tree_update))
    return false;
  if (!mojo::Equals(this->scroll_tree_update, other_struct.scroll_tree_update))
    return false;
  if (!mojo::Equals(this->transform_nodes, other_struct.transform_nodes))
    return false;
  if (!mojo::Equals(this->clip_nodes, other_struct.clip_nodes))
    return false;
  if (!mojo::Equals(this->effect_nodes, other_struct.effect_nodes))
    return false;
  if (!mojo::Equals(this->scroll_nodes, other_struct.scroll_nodes))
    return false;
  if (!mojo::Equals(this->num_transform_nodes, other_struct.num_transform_nodes))
    return false;
  if (!mojo::Equals(this->num_clip_nodes, other_struct.num_clip_nodes))
    return false;
  if (!mojo::Equals(this->num_effect_nodes, other_struct.num_effect_nodes))
    return false;
  if (!mojo::Equals(this->num_scroll_nodes, other_struct.num_scroll_nodes))
    return false;
  if (!mojo::Equals(this->tilings, other_struct.tilings))
    return false;
  if (!mojo::Equals(this->surface_ranges, other_struct.surface_ranges))
    return false;
  if (!mojo::Equals(this->view_transition_requests, other_struct.view_transition_requests))
    return false;
  if (!mojo::Equals(this->animation_timelines, other_struct.animation_timelines))
    return false;
  if (!mojo::Equals(this->removed_animation_timelines, other_struct.removed_animation_timelines))
    return false;
  return true;
}

template <typename T, LayerTreeUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.begin_frame_args < rhs.begin_frame_args)
    return true;
  if (rhs.begin_frame_args < lhs.begin_frame_args)
    return false;
  if (lhs.source_frame_number < rhs.source_frame_number)
    return true;
  if (rhs.source_frame_number < lhs.source_frame_number)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.primary_main_frame_item_sequence_number < rhs.primary_main_frame_item_sequence_number)
    return true;
  if (rhs.primary_main_frame_item_sequence_number < lhs.primary_main_frame_item_sequence_number)
    return false;
  if (lhs.selection < rhs.selection)
    return true;
  if (rhs.selection < lhs.selection)
    return false;
  if (lhs.page_scale_factor < rhs.page_scale_factor)
    return true;
  if (rhs.page_scale_factor < lhs.page_scale_factor)
    return false;
  if (lhs.min_page_scale_factor < rhs.min_page_scale_factor)
    return true;
  if (rhs.min_page_scale_factor < lhs.min_page_scale_factor)
    return false;
  if (lhs.max_page_scale_factor < rhs.max_page_scale_factor)
    return true;
  if (rhs.max_page_scale_factor < lhs.max_page_scale_factor)
    return false;
  if (lhs.external_page_scale_factor < rhs.external_page_scale_factor)
    return true;
  if (rhs.external_page_scale_factor < lhs.external_page_scale_factor)
    return false;
  if (lhs.device_viewport < rhs.device_viewport)
    return true;
  if (rhs.device_viewport < lhs.device_viewport)
    return false;
  if (lhs.device_scale_factor < rhs.device_scale_factor)
    return true;
  if (rhs.device_scale_factor < lhs.device_scale_factor)
    return false;
  if (lhs.painted_device_scale_factor < rhs.painted_device_scale_factor)
    return true;
  if (rhs.painted_device_scale_factor < lhs.painted_device_scale_factor)
    return false;
  if (lhs.display_color_spaces < rhs.display_color_spaces)
    return true;
  if (rhs.display_color_spaces < lhs.display_color_spaces)
    return false;
  if (lhs.local_surface_id_from_parent < rhs.local_surface_id_from_parent)
    return true;
  if (rhs.local_surface_id_from_parent < lhs.local_surface_id_from_parent)
    return false;
  if (lhs.current_local_surface_id < rhs.current_local_surface_id)
    return true;
  if (rhs.current_local_surface_id < lhs.current_local_surface_id)
    return false;
  if (lhs.next_frame_token < rhs.next_frame_token)
    return true;
  if (rhs.next_frame_token < lhs.next_frame_token)
    return false;
  if (lhs.send_frame_token_to_embedder < rhs.send_frame_token_to_embedder)
    return true;
  if (rhs.send_frame_token_to_embedder < lhs.send_frame_token_to_embedder)
    return false;
  if (lhs.target_local_surface_id < rhs.target_local_surface_id)
    return true;
  if (rhs.target_local_surface_id < lhs.target_local_surface_id)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.overscroll_elasticity_transform < rhs.overscroll_elasticity_transform)
    return true;
  if (rhs.overscroll_elasticity_transform < lhs.overscroll_elasticity_transform)
    return false;
  if (lhs.page_scale_transform < rhs.page_scale_transform)
    return true;
  if (rhs.page_scale_transform < lhs.page_scale_transform)
    return false;
  if (lhs.inner_scroll < rhs.inner_scroll)
    return true;
  if (rhs.inner_scroll < lhs.inner_scroll)
    return false;
  if (lhs.outer_clip < rhs.outer_clip)
    return true;
  if (rhs.outer_clip < lhs.outer_clip)
    return false;
  if (lhs.outer_scroll < rhs.outer_scroll)
    return true;
  if (rhs.outer_scroll < lhs.outer_scroll)
    return false;
  if (lhs.viewport_damage_rect < rhs.viewport_damage_rect)
    return true;
  if (rhs.viewport_damage_rect < lhs.viewport_damage_rect)
    return false;
  if (lhs.full_tree_damaged < rhs.full_tree_damaged)
    return true;
  if (rhs.full_tree_damaged < lhs.full_tree_damaged)
    return false;
  if (lhs.debug_state < rhs.debug_state)
    return true;
  if (rhs.debug_state < lhs.debug_state)
    return false;
  if (lhs.display_transform_hint < rhs.display_transform_hint)
    return true;
  if (rhs.display_transform_hint < lhs.display_transform_hint)
    return false;
  if (lhs.max_safe_area_inset_bottom < rhs.max_safe_area_inset_bottom)
    return true;
  if (rhs.max_safe_area_inset_bottom < lhs.max_safe_area_inset_bottom)
    return false;
  if (lhs.browser_controls_params < rhs.browser_controls_params)
    return true;
  if (rhs.browser_controls_params < lhs.browser_controls_params)
    return false;
  if (lhs.browser_controls_offset_tag_modifications < rhs.browser_controls_offset_tag_modifications)
    return true;
  if (rhs.browser_controls_offset_tag_modifications < lhs.browser_controls_offset_tag_modifications)
    return false;
  if (lhs.top_controls_shown_ratio < rhs.top_controls_shown_ratio)
    return true;
  if (rhs.top_controls_shown_ratio < lhs.top_controls_shown_ratio)
    return false;
  if (lhs.bottom_controls_shown_ratio < rhs.bottom_controls_shown_ratio)
    return true;
  if (rhs.bottom_controls_shown_ratio < lhs.bottom_controls_shown_ratio)
    return false;
  if (lhs.ui_resource_requests < rhs.ui_resource_requests)
    return true;
  if (rhs.ui_resource_requests < lhs.ui_resource_requests)
    return false;
  if (lhs.layers < rhs.layers)
    return true;
  if (rhs.layers < lhs.layers)
    return false;
  if (lhs.layer_order < rhs.layer_order)
    return true;
  if (rhs.layer_order < lhs.layer_order)
    return false;
  if (lhs.transform_tree_update < rhs.transform_tree_update)
    return true;
  if (rhs.transform_tree_update < lhs.transform_tree_update)
    return false;
  if (lhs.scroll_tree_update < rhs.scroll_tree_update)
    return true;
  if (rhs.scroll_tree_update < lhs.scroll_tree_update)
    return false;
  if (lhs.transform_nodes < rhs.transform_nodes)
    return true;
  if (rhs.transform_nodes < lhs.transform_nodes)
    return false;
  if (lhs.clip_nodes < rhs.clip_nodes)
    return true;
  if (rhs.clip_nodes < lhs.clip_nodes)
    return false;
  if (lhs.effect_nodes < rhs.effect_nodes)
    return true;
  if (rhs.effect_nodes < lhs.effect_nodes)
    return false;
  if (lhs.scroll_nodes < rhs.scroll_nodes)
    return true;
  if (rhs.scroll_nodes < lhs.scroll_nodes)
    return false;
  if (lhs.num_transform_nodes < rhs.num_transform_nodes)
    return true;
  if (rhs.num_transform_nodes < lhs.num_transform_nodes)
    return false;
  if (lhs.num_clip_nodes < rhs.num_clip_nodes)
    return true;
  if (rhs.num_clip_nodes < lhs.num_clip_nodes)
    return false;
  if (lhs.num_effect_nodes < rhs.num_effect_nodes)
    return true;
  if (rhs.num_effect_nodes < lhs.num_effect_nodes)
    return false;
  if (lhs.num_scroll_nodes < rhs.num_scroll_nodes)
    return true;
  if (rhs.num_scroll_nodes < lhs.num_scroll_nodes)
    return false;
  if (lhs.tilings < rhs.tilings)
    return true;
  if (rhs.tilings < lhs.tilings)
    return false;
  if (lhs.surface_ranges < rhs.surface_ranges)
    return true;
  if (rhs.surface_ranges < lhs.surface_ranges)
    return false;
  if (lhs.view_transition_requests < rhs.view_transition_requests)
    return true;
  if (rhs.view_transition_requests < lhs.view_transition_requests)
    return false;
  if (lhs.animation_timelines < rhs.animation_timelines)
    return true;
  if (rhs.animation_timelines < lhs.animation_timelines)
    return false;
  if (lhs.removed_animation_timelines < rhs.removed_animation_timelines)
    return true;
  if (rhs.removed_animation_timelines < lhs.removed_animation_timelines)
    return false;
  return false;
}
template <typename StructPtrType>
PendingLayerContextPtr PendingLayerContext::Clone() const {
  return New(
      mojo::Clone(receiver),
      mojo::Clone(client)
  );
}

template <typename T, PendingLayerContext::EnableIfSame<T>*>
bool PendingLayerContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  if (!mojo::Equals(this->client, other_struct.client))
    return false;
  return true;
}

template <typename T, PendingLayerContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  if (lhs.client < rhs.client)
    return true;
  if (rhs.client < lhs.client)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::TransferableUIResourceRequest::DataView,
                                         ::viz::mojom::blink::TransferableUIResourceRequestPtr> {
  static bool IsNull(const ::viz::mojom::blink::TransferableUIResourceRequestPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::TransferableUIResourceRequestPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::TransferableUIResourceRequest::type) type(
      const ::viz::mojom::blink::TransferableUIResourceRequestPtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::blink::TransferableUIResourceRequest::uid)& uid(
      const ::viz::mojom::blink::TransferableUIResourceRequestPtr& input) {
    return input->uid;
  }

  static const decltype(::viz::mojom::blink::TransferableUIResourceRequest::transferable_resource)& transferable_resource(
      const ::viz::mojom::blink::TransferableUIResourceRequestPtr& input) {
    return input->transferable_resource;
  }

  static decltype(::viz::mojom::blink::TransferableUIResourceRequest::opaque) opaque(
      const ::viz::mojom::blink::TransferableUIResourceRequestPtr& input) {
    return input->opaque;
  }

  static bool Read(::viz::mojom::blink::TransferableUIResourceRequest::DataView input, ::viz::mojom::blink::TransferableUIResourceRequestPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::LayerTreeUpdate::DataView,
                                         ::viz::mojom::blink::LayerTreeUpdatePtr> {
  static bool IsNull(const ::viz::mojom::blink::LayerTreeUpdatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::LayerTreeUpdatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::begin_frame_args)& begin_frame_args(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->begin_frame_args;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::source_frame_number) source_frame_number(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->source_frame_number;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::trace_id) trace_id(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->trace_id;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::primary_main_frame_item_sequence_number) primary_main_frame_item_sequence_number(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->primary_main_frame_item_sequence_number;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::selection)& selection(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->selection;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::page_scale_factor) page_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::min_page_scale_factor) min_page_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->min_page_scale_factor;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::max_page_scale_factor) max_page_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->max_page_scale_factor;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::external_page_scale_factor) external_page_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->external_page_scale_factor;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::device_viewport)& device_viewport(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->device_viewport;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::device_scale_factor) device_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->device_scale_factor;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::painted_device_scale_factor) painted_device_scale_factor(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->painted_device_scale_factor;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::display_color_spaces)& display_color_spaces(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->display_color_spaces;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::local_surface_id_from_parent)& local_surface_id_from_parent(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->local_surface_id_from_parent;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::current_local_surface_id)& current_local_surface_id(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->current_local_surface_id;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::next_frame_token) next_frame_token(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->next_frame_token;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::send_frame_token_to_embedder) send_frame_token_to_embedder(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->send_frame_token_to_embedder;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::target_local_surface_id)& target_local_surface_id(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->target_local_surface_id;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::background_color)& background_color(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->background_color;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::overscroll_elasticity_transform) overscroll_elasticity_transform(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->overscroll_elasticity_transform;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::page_scale_transform) page_scale_transform(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->page_scale_transform;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::inner_scroll) inner_scroll(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->inner_scroll;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::outer_clip) outer_clip(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->outer_clip;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::outer_scroll) outer_scroll(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->outer_scroll;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::viewport_damage_rect)& viewport_damage_rect(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->viewport_damage_rect;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::full_tree_damaged) full_tree_damaged(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->full_tree_damaged;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::debug_state)& debug_state(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->debug_state;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::display_transform_hint) display_transform_hint(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->display_transform_hint;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::max_safe_area_inset_bottom) max_safe_area_inset_bottom(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->max_safe_area_inset_bottom;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::browser_controls_params)& browser_controls_params(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->browser_controls_params;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::browser_controls_offset_tag_modifications)& browser_controls_offset_tag_modifications(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->browser_controls_offset_tag_modifications;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::top_controls_shown_ratio) top_controls_shown_ratio(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->top_controls_shown_ratio;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::bottom_controls_shown_ratio) bottom_controls_shown_ratio(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->bottom_controls_shown_ratio;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::ui_resource_requests)& ui_resource_requests(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->ui_resource_requests;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::layers)& layers(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->layers;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::layer_order)& layer_order(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->layer_order;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::transform_tree_update)& transform_tree_update(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->transform_tree_update;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::scroll_tree_update)& scroll_tree_update(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->scroll_tree_update;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::transform_nodes)& transform_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->transform_nodes;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::clip_nodes)& clip_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->clip_nodes;
  }

  static  decltype(::viz::mojom::blink::LayerTreeUpdate::effect_nodes)& effect_nodes(
       ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->effect_nodes;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::scroll_nodes)& scroll_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->scroll_nodes;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::num_transform_nodes) num_transform_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->num_transform_nodes;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::num_clip_nodes) num_clip_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->num_clip_nodes;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::num_effect_nodes) num_effect_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->num_effect_nodes;
  }

  static decltype(::viz::mojom::blink::LayerTreeUpdate::num_scroll_nodes) num_scroll_nodes(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->num_scroll_nodes;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::tilings)& tilings(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->tilings;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::surface_ranges)& surface_ranges(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->surface_ranges;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::view_transition_requests)& view_transition_requests(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->view_transition_requests;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::animation_timelines)& animation_timelines(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->animation_timelines;
  }

  static const decltype(::viz::mojom::blink::LayerTreeUpdate::removed_animation_timelines)& removed_animation_timelines(
      const ::viz::mojom::blink::LayerTreeUpdatePtr& input) {
    return input->removed_animation_timelines;
  }

  static bool Read(::viz::mojom::blink::LayerTreeUpdate::DataView input, ::viz::mojom::blink::LayerTreeUpdatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::PendingLayerContext::DataView,
                                         ::viz::mojom::blink::PendingLayerContextPtr> {
  static bool IsNull(const ::viz::mojom::blink::PendingLayerContextPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::PendingLayerContextPtr* output) { output->reset(); }

  static  decltype(::viz::mojom::blink::PendingLayerContext::receiver)& receiver(
       ::viz::mojom::blink::PendingLayerContextPtr& input) {
    return input->receiver;
  }

  static  decltype(::viz::mojom::blink::PendingLayerContext::client)& client(
       ::viz::mojom::blink::PendingLayerContextPtr& input) {
    return input->client;
  }

  static bool Read(::viz::mojom::blink::PendingLayerContext::DataView input, ::viz::mojom::blink::PendingLayerContextPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_CONTEXT_MOJOM_BLINK_H_