// services/viz/public/mojom/compositing/layer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/layer.mojom-shared-internal.h"
#include "cc/mojom/element_id.mojom-shared.h"
#include "cc/mojom/hit_test_opaqueness.mojom-shared.h"
#include "cc/mojom/layer_type.mojom-shared.h"
#include "cc/mojom/paint_flags.mojom-shared.h"
#include "cc/mojom/render_surface_reason.mojom-shared.h"
#include "cc/mojom/synced_scroll_offset.mojom-shared.h"
#include "cc/mojom/ui_resource_id.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "skia/public/mojom/skpath.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/mask_filter_info.mojom-shared.h"
#include "ui/gfx/mojom/rrect_f.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom-shared.h"
#include "services/viz/public/mojom/compositing/region_capture_bounds.mojom-shared.h"
#include "services/viz/public/mojom/compositing/resource_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"

#include "services/viz/public/mojom/compositing/layer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::RarePropertiesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RarePropertiesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::RareProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::cc::mojom::FilterQuality>(
        Traits::filter_quality(input),
        &fragment->filter_quality);

      decltype(Traits::dynamic_range_limit(input)) in_dynamic_range_limit = Traits::dynamic_range_limit(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dynamic_range_limit)::BaseType> dynamic_range_limit_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::DynamicRangeLimitDataView, send_validation>(
        in_dynamic_range_limit,
        dynamic_range_limit_fragment);

      fragment->dynamic_range_limit.Set(
          dynamic_range_limit_fragment.is_null() ? nullptr : dynamic_range_limit_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dynamic_range_limit.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dynamic_range_limit in RareProperties struct");

      decltype(Traits::capture_bounds(input)) in_capture_bounds = Traits::capture_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->capture_bounds)::BaseType> capture_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::RegionCaptureBoundsDataView, send_validation>(
        in_capture_bounds,
        capture_bounds_fragment);

      fragment->capture_bounds.Set(
          capture_bounds_fragment.is_null() ? nullptr : capture_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->capture_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null capture_bounds in RareProperties struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::MirrorLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::MirrorLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::MirrorLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->mirrored_layer_id = Traits::mirrored_layer_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::SurfaceLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::surface_range(input)) in_surface_range = Traits::surface_range(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->surface_range)::BaseType> surface_range_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::SurfaceRangeDataView, send_validation>(
        in_surface_range,
        surface_range_fragment);

      fragment->surface_range.Set(
          surface_range_fragment.is_null() ? nullptr : surface_range_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->surface_range.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null surface_range in SurfaceLayerExtra struct");
      fragment->deadline_in_frames_$flag = Traits::deadline_in_frames(input).has_value();
      if (Traits::deadline_in_frames(input).has_value()) {
        fragment->deadline_in_frames_$value = Traits::deadline_in_frames(input).value();
      }

      fragment->stretch_content_to_fill_bounds = Traits::stretch_content_to_fill_bounds(input);

      fragment->surface_hit_testable = Traits::surface_hit_testable(input);

      fragment->has_pointer_events_none = Traits::has_pointer_events_none(input);

      fragment->is_reflection = Traits::is_reflection(input);

      fragment->will_draw_needs_reset = Traits::will_draw_needs_reset(input);

      fragment->override_child_paint_flags = Traits::override_child_paint_flags(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TextureLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TextureLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TextureLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->blend_background_color = Traits::blend_background_color(input);

      fragment->force_texture_to_opaque = Traits::force_texture_to_opaque(input);

      decltype(Traits::uv_top_left(input)) in_uv_top_left = Traits::uv_top_left(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_top_left)::BaseType> uv_top_left_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_top_left,
        uv_top_left_fragment);

      fragment->uv_top_left.Set(
          uv_top_left_fragment.is_null() ? nullptr : uv_top_left_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_top_left.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_top_left in TextureLayerExtra struct");

      decltype(Traits::uv_bottom_right(input)) in_uv_bottom_right = Traits::uv_bottom_right(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_bottom_right)::BaseType> uv_bottom_right_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_bottom_right,
        uv_bottom_right_fragment);

      fragment->uv_bottom_right.Set(
          uv_bottom_right_fragment.is_null() ? nullptr : uv_bottom_right_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_bottom_right.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_bottom_right in TextureLayerExtra struct");

      decltype(Traits::transferable_resource(input)) in_transferable_resource = Traits::transferable_resource(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->transferable_resource)::BaseType> transferable_resource_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::TransferableResourceDataView, send_validation>(
        in_transferable_resource,
        transferable_resource_fragment);

      fragment->transferable_resource.Set(
          transferable_resource_fragment.is_null() ? nullptr : transferable_resource_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::UIResourceLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::UIResourceLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::UIResourceLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::ui_resource_id(input)) in_ui_resource_id = Traits::ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ui_resource_id)::BaseType> ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_ui_resource_id,
        ui_resource_id_fragment);

      fragment->ui_resource_id.Set(
          ui_resource_id_fragment.is_null() ? nullptr : ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ui_resource_id in UIResourceLayerExtra struct");

      decltype(Traits::image_bounds(input)) in_image_bounds = Traits::image_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_bounds)::BaseType> image_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_image_bounds,
        image_bounds_fragment);

      fragment->image_bounds.Set(
          image_bounds_fragment.is_null() ? nullptr : image_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_bounds in UIResourceLayerExtra struct");

      decltype(Traits::uv_top_left(input)) in_uv_top_left = Traits::uv_top_left(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_top_left)::BaseType> uv_top_left_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_top_left,
        uv_top_left_fragment);

      fragment->uv_top_left.Set(
          uv_top_left_fragment.is_null() ? nullptr : uv_top_left_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_top_left.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_top_left in UIResourceLayerExtra struct");

      decltype(Traits::uv_bottom_right(input)) in_uv_bottom_right = Traits::uv_bottom_right(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_bottom_right)::BaseType> uv_bottom_right_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_bottom_right,
        uv_bottom_right_fragment);

      fragment->uv_bottom_right.Set(
          uv_bottom_right_fragment.is_null() ? nullptr : uv_bottom_right_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_bottom_right.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_bottom_right in UIResourceLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TileDisplayLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TileDisplayLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TileDisplayLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::solid_color(input)) in_solid_color = Traits::solid_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->solid_color)::BaseType> solid_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_solid_color,
        solid_color_fragment);

      fragment->solid_color.Set(
          solid_color_fragment.is_null() ? nullptr : solid_color_fragment.data());

      fragment->is_backdrop_filter_mask = Traits::is_backdrop_filter_mask(input);

      fragment->is_directly_composited_image = Traits::is_directly_composited_image(input);

      fragment->nearest_neighbor = Traits::nearest_neighbor(input);

      
      mojo::internal::Serialize<::gfx::mojom::ContentColorUsage>(
        Traits::content_color_usage(input),
        &fragment->content_color_usage);

      decltype(Traits::recorded_bounds(input)) in_recorded_bounds = Traits::recorded_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->recorded_bounds)::BaseType> recorded_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_recorded_bounds,
        recorded_bounds_fragment);

      fragment->recorded_bounds.Set(
          recorded_bounds_fragment.is_null() ? nullptr : recorded_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->recorded_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null recorded_bounds in TileDisplayLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ScrollbarLayerBaseExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ScrollbarLayerBaseExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ScrollbarLayerBaseExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scroll_element_id(input)) in_scroll_element_id = Traits::scroll_element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_element_id)::BaseType> scroll_element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_scroll_element_id,
        scroll_element_id_fragment);

      fragment->scroll_element_id.Set(
          scroll_element_id_fragment.is_null() ? nullptr : scroll_element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scroll_element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_element_id in ScrollbarLayerBaseExtra struct");

      fragment->is_overlay_scrollbar = Traits::is_overlay_scrollbar(input);

      fragment->is_web_test = Traits::is_web_test(input);

      fragment->thumb_thickness_scale_factor = Traits::thumb_thickness_scale_factor(input);

      fragment->current_pos = Traits::current_pos(input);

      fragment->clip_layer_length = Traits::clip_layer_length(input);

      fragment->scroll_layer_length = Traits::scroll_layer_length(input);

      fragment->is_horizontal_orientation = Traits::is_horizontal_orientation(input);

      fragment->is_left_side_vertical_scrollbar = Traits::is_left_side_vertical_scrollbar(input);

      fragment->vertical_adjust = Traits::vertical_adjust(input);

      fragment->has_find_in_page_tickmarks = Traits::has_find_in_page_tickmarks(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::NinePatchThumbScrollbarLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::NinePatchThumbScrollbarLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::NinePatchThumbScrollbarLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scrollbar_base_extra(input)) in_scrollbar_base_extra = Traits::scrollbar_base_extra(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_base_extra)::BaseType> scrollbar_base_extra_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ScrollbarLayerBaseExtraDataView, send_validation>(
        in_scrollbar_base_extra,
        scrollbar_base_extra_fragment);

      fragment->scrollbar_base_extra.Set(
          scrollbar_base_extra_fragment.is_null() ? nullptr : scrollbar_base_extra_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_base_extra.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_base_extra in NinePatchThumbScrollbarLayerExtra struct");

      fragment->thumb_thickness = Traits::thumb_thickness(input);

      fragment->thumb_length = Traits::thumb_length(input);

      fragment->track_start = Traits::track_start(input);

      fragment->track_length = Traits::track_length(input);

      decltype(Traits::image_bounds(input)) in_image_bounds = Traits::image_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_bounds)::BaseType> image_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_image_bounds,
        image_bounds_fragment);

      fragment->image_bounds.Set(
          image_bounds_fragment.is_null() ? nullptr : image_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_bounds in NinePatchThumbScrollbarLayerExtra struct");

      decltype(Traits::aperture(input)) in_aperture = Traits::aperture(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->aperture)::BaseType> aperture_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_aperture,
        aperture_fragment);

      fragment->aperture.Set(
          aperture_fragment.is_null() ? nullptr : aperture_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->aperture.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aperture in NinePatchThumbScrollbarLayerExtra struct");

      decltype(Traits::thumb_ui_resource_id(input)) in_thumb_ui_resource_id = Traits::thumb_ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->thumb_ui_resource_id)::BaseType> thumb_ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_thumb_ui_resource_id,
        thumb_ui_resource_id_fragment);

      fragment->thumb_ui_resource_id.Set(
          thumb_ui_resource_id_fragment.is_null() ? nullptr : thumb_ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->thumb_ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null thumb_ui_resource_id in NinePatchThumbScrollbarLayerExtra struct");

      decltype(Traits::track_and_buttons_ui_resource_id(input)) in_track_and_buttons_ui_resource_id = Traits::track_and_buttons_ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_and_buttons_ui_resource_id)::BaseType> track_and_buttons_ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_track_and_buttons_ui_resource_id,
        track_and_buttons_ui_resource_id_fragment);

      fragment->track_and_buttons_ui_resource_id.Set(
          track_and_buttons_ui_resource_id_fragment.is_null() ? nullptr : track_and_buttons_ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_and_buttons_ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_and_buttons_ui_resource_id in NinePatchThumbScrollbarLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::PaintedScrollbarLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::PaintedScrollbarLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::PaintedScrollbarLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scrollbar_base_extra(input)) in_scrollbar_base_extra = Traits::scrollbar_base_extra(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_base_extra)::BaseType> scrollbar_base_extra_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ScrollbarLayerBaseExtraDataView, send_validation>(
        in_scrollbar_base_extra,
        scrollbar_base_extra_fragment);

      fragment->scrollbar_base_extra.Set(
          scrollbar_base_extra_fragment.is_null() ? nullptr : scrollbar_base_extra_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_base_extra.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_base_extra in PaintedScrollbarLayerExtra struct");

      fragment->internal_contents_scale = Traits::internal_contents_scale(input);

      decltype(Traits::internal_content_bounds(input)) in_internal_content_bounds = Traits::internal_content_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->internal_content_bounds)::BaseType> internal_content_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_internal_content_bounds,
        internal_content_bounds_fragment);

      fragment->internal_content_bounds.Set(
          internal_content_bounds_fragment.is_null() ? nullptr : internal_content_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->internal_content_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null internal_content_bounds in PaintedScrollbarLayerExtra struct");

      fragment->jump_on_track_click = Traits::jump_on_track_click(input);

      fragment->supports_drag_snap_back = Traits::supports_drag_snap_back(input);

      fragment->thumb_thickness = Traits::thumb_thickness(input);

      fragment->thumb_length = Traits::thumb_length(input);

      decltype(Traits::back_button_rect(input)) in_back_button_rect = Traits::back_button_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->back_button_rect)::BaseType> back_button_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_back_button_rect,
        back_button_rect_fragment);

      fragment->back_button_rect.Set(
          back_button_rect_fragment.is_null() ? nullptr : back_button_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->back_button_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null back_button_rect in PaintedScrollbarLayerExtra struct");

      decltype(Traits::forward_button_rect(input)) in_forward_button_rect = Traits::forward_button_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->forward_button_rect)::BaseType> forward_button_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_forward_button_rect,
        forward_button_rect_fragment);

      fragment->forward_button_rect.Set(
          forward_button_rect_fragment.is_null() ? nullptr : forward_button_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->forward_button_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null forward_button_rect in PaintedScrollbarLayerExtra struct");

      decltype(Traits::track_rect(input)) in_track_rect = Traits::track_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_rect)::BaseType> track_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_track_rect,
        track_rect_fragment);

      fragment->track_rect.Set(
          track_rect_fragment.is_null() ? nullptr : track_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_rect in PaintedScrollbarLayerExtra struct");

      decltype(Traits::thumb_color(input)) in_thumb_color = Traits::thumb_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->thumb_color)::BaseType> thumb_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_thumb_color,
        thumb_color_fragment);

      fragment->thumb_color.Set(
          thumb_color_fragment.is_null() ? nullptr : thumb_color_fragment.data());

      fragment->uses_nine_patch_track_and_buttons = Traits::uses_nine_patch_track_and_buttons(input);

      decltype(Traits::track_and_buttons_image_bounds(input)) in_track_and_buttons_image_bounds = Traits::track_and_buttons_image_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_and_buttons_image_bounds)::BaseType> track_and_buttons_image_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_track_and_buttons_image_bounds,
        track_and_buttons_image_bounds_fragment);

      fragment->track_and_buttons_image_bounds.Set(
          track_and_buttons_image_bounds_fragment.is_null() ? nullptr : track_and_buttons_image_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_and_buttons_image_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_and_buttons_image_bounds in PaintedScrollbarLayerExtra struct");

      decltype(Traits::track_and_buttons_aperture(input)) in_track_and_buttons_aperture = Traits::track_and_buttons_aperture(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_and_buttons_aperture)::BaseType> track_and_buttons_aperture_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_track_and_buttons_aperture,
        track_and_buttons_aperture_fragment);

      fragment->track_and_buttons_aperture.Set(
          track_and_buttons_aperture_fragment.is_null() ? nullptr : track_and_buttons_aperture_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_and_buttons_aperture.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_and_buttons_aperture in PaintedScrollbarLayerExtra struct");

      fragment->painted_opacity = Traits::painted_opacity(input);

      decltype(Traits::track_and_buttons_ui_resource_id(input)) in_track_and_buttons_ui_resource_id = Traits::track_and_buttons_ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->track_and_buttons_ui_resource_id)::BaseType> track_and_buttons_ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_track_and_buttons_ui_resource_id,
        track_and_buttons_ui_resource_id_fragment);

      fragment->track_and_buttons_ui_resource_id.Set(
          track_and_buttons_ui_resource_id_fragment.is_null() ? nullptr : track_and_buttons_ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->track_and_buttons_ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null track_and_buttons_ui_resource_id in PaintedScrollbarLayerExtra struct");

      decltype(Traits::thumb_ui_resource_id(input)) in_thumb_ui_resource_id = Traits::thumb_ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->thumb_ui_resource_id)::BaseType> thumb_ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_thumb_ui_resource_id,
        thumb_ui_resource_id_fragment);

      fragment->thumb_ui_resource_id.Set(
          thumb_ui_resource_id_fragment.is_null() ? nullptr : thumb_ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->thumb_ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null thumb_ui_resource_id in PaintedScrollbarLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::SolidColorScrollbarLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SolidColorScrollbarLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SolidColorScrollbarLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::scrollbar_base_extra(input)) in_scrollbar_base_extra = Traits::scrollbar_base_extra(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrollbar_base_extra)::BaseType> scrollbar_base_extra_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ScrollbarLayerBaseExtraDataView, send_validation>(
        in_scrollbar_base_extra,
        scrollbar_base_extra_fragment);

      fragment->scrollbar_base_extra.Set(
          scrollbar_base_extra_fragment.is_null() ? nullptr : scrollbar_base_extra_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrollbar_base_extra.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollbar_base_extra in SolidColorScrollbarLayerExtra struct");

      fragment->thumb_thickness = Traits::thumb_thickness(input);

      fragment->track_start = Traits::track_start(input);

      decltype(Traits::color(input)) in_color = Traits::color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color)::BaseType> color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_color,
        color_fragment);

      fragment->color.Set(
          color_fragment.is_null() ? nullptr : color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color in SolidColorScrollbarLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ViewTransitionContentLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ViewTransitionContentLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ViewTransitionContentLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::resource_id(input)) in_resource_id = Traits::resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->resource_id)::BaseType> resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView, send_validation>(
        in_resource_id,
        resource_id_fragment);

      fragment->resource_id.Set(
          resource_id_fragment.is_null() ? nullptr : resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resource_id in ViewTransitionContentLayerExtra struct");

      fragment->is_live_content_layer = Traits::is_live_content_layer(input);

      decltype(Traits::max_extents_rect(input)) in_max_extents_rect = Traits::max_extents_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->max_extents_rect)::BaseType> max_extents_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_max_extents_rect,
        max_extents_rect_fragment);

      fragment->max_extents_rect.Set(
          max_extents_rect_fragment.is_null() ? nullptr : max_extents_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->max_extents_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_extents_rect in ViewTransitionContentLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::NinePatchLayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::NinePatchLayerExtraDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::NinePatchLayerExtra_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::image_aperture(input)) in_image_aperture = Traits::image_aperture(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_aperture)::BaseType> image_aperture_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_image_aperture,
        image_aperture_fragment);

      fragment->image_aperture.Set(
          image_aperture_fragment.is_null() ? nullptr : image_aperture_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_aperture.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_aperture in NinePatchLayerExtra struct");

      decltype(Traits::border(input)) in_border = Traits::border(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->border)::BaseType> border_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_border,
        border_fragment);

      fragment->border.Set(
          border_fragment.is_null() ? nullptr : border_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->border.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null border in NinePatchLayerExtra struct");

      decltype(Traits::layer_occlusion(input)) in_layer_occlusion = Traits::layer_occlusion(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->layer_occlusion)::BaseType> layer_occlusion_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_layer_occlusion,
        layer_occlusion_fragment);

      fragment->layer_occlusion.Set(
          layer_occlusion_fragment.is_null() ? nullptr : layer_occlusion_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->layer_occlusion.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layer_occlusion in NinePatchLayerExtra struct");

      fragment->fill_center = Traits::fill_center(input);

      decltype(Traits::ui_resource_id(input)) in_ui_resource_id = Traits::ui_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ui_resource_id)::BaseType> ui_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::UIResourceIdDataView, send_validation>(
        in_ui_resource_id,
        ui_resource_id_fragment);

      fragment->ui_resource_id.Set(
          ui_resource_id_fragment.is_null() ? nullptr : ui_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ui_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ui_resource_id in NinePatchLayerExtra struct");

      decltype(Traits::image_bounds(input)) in_image_bounds = Traits::image_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_bounds)::BaseType> image_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_image_bounds,
        image_bounds_fragment);

      fragment->image_bounds.Set(
          image_bounds_fragment.is_null() ? nullptr : image_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_bounds in NinePatchLayerExtra struct");

      decltype(Traits::uv_top_left(input)) in_uv_top_left = Traits::uv_top_left(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_top_left)::BaseType> uv_top_left_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_top_left,
        uv_top_left_fragment);

      fragment->uv_top_left.Set(
          uv_top_left_fragment.is_null() ? nullptr : uv_top_left_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_top_left.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_top_left in NinePatchLayerExtra struct");

      decltype(Traits::uv_bottom_right(input)) in_uv_bottom_right = Traits::uv_bottom_right(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->uv_bottom_right)::BaseType> uv_bottom_right_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_uv_bottom_right,
        uv_bottom_right_fragment);

      fragment->uv_bottom_right.Set(
          uv_bottom_right_fragment.is_null() ? nullptr : uv_bottom_right_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->uv_bottom_right.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null uv_bottom_right in NinePatchLayerExtra struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::LayerDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::LayerDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::Layer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      
      mojo::internal::Serialize<::cc::mojom::LayerType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in Layer struct");

      fragment->contents_opaque = Traits::contents_opaque(input);

      fragment->contents_opaque_for_text = Traits::contents_opaque_for_text(input);

      fragment->is_drawable = Traits::is_drawable(input);

      fragment->layer_property_changed_not_from_property_trees = Traits::layer_property_changed_not_from_property_trees(input);

      fragment->layer_property_changed_from_property_trees = Traits::layer_property_changed_from_property_trees(input);

      
      mojo::internal::Serialize<::cc::mojom::HitTestOpaqueness>(
        Traits::hit_test_opaqueness(input),
        &fragment->hit_test_opaqueness);

      decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->background_color)::BaseType> background_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_background_color,
        background_color_fragment);

      fragment->background_color.Set(
          background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->background_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null background_color in Layer struct");

      decltype(Traits::safe_opaque_background_color(input)) in_safe_opaque_background_color = Traits::safe_opaque_background_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->safe_opaque_background_color)::BaseType> safe_opaque_background_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_safe_opaque_background_color,
        safe_opaque_background_color_fragment);

      fragment->safe_opaque_background_color.Set(
          safe_opaque_background_color_fragment.is_null() ? nullptr : safe_opaque_background_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->safe_opaque_background_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null safe_opaque_background_color in Layer struct");

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in Layer struct");

      decltype(Traits::update_rect(input)) in_update_rect = Traits::update_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->update_rect)::BaseType> update_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_update_rect,
        update_rect_fragment);

      fragment->update_rect.Set(
          update_rect_fragment.is_null() ? nullptr : update_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->update_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null update_rect in Layer struct");

      decltype(Traits::offset_to_transform_parent(input)) in_offset_to_transform_parent = Traits::offset_to_transform_parent(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->offset_to_transform_parent)::BaseType> offset_to_transform_parent_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_offset_to_transform_parent,
        offset_to_transform_parent_fragment);

      fragment->offset_to_transform_parent.Set(
          offset_to_transform_parent_fragment.is_null() ? nullptr : offset_to_transform_parent_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->offset_to_transform_parent.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset_to_transform_parent in Layer struct");

      fragment->transform_tree_index = Traits::transform_tree_index(input);

      fragment->clip_tree_index = Traits::clip_tree_index(input);

      fragment->effect_tree_index = Traits::effect_tree_index(input);

      fragment->scroll_tree_index = Traits::scroll_tree_index(input);

      fragment->should_check_backface_visibility = Traits::should_check_backface_visibility(input);

      decltype(Traits::rare_properties(input)) in_rare_properties = Traits::rare_properties(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rare_properties)::BaseType> rare_properties_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::RarePropertiesDataView, send_validation>(
        in_rare_properties,
        rare_properties_fragment);

      fragment->rare_properties.Set(
          rare_properties_fragment.is_null() ? nullptr : rare_properties_fragment.data());

      decltype(Traits::layer_extra(input)) in_layer_extra = Traits::layer_extra(input);
      mojo::internal::MessageFragment<decltype(fragment->layer_extra)>
          layer_extra_fragment(fragment.message());
      layer_extra_fragment.Claim(&fragment->layer_extra);
      
      mojo::internal::Serialize<::viz::mojom::LayerExtraDataView, send_validation>(
        in_layer_extra,
        layer_extra_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::AnchorPositionScrollDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::AnchorPositionScrollDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::AnchorPositionScrollData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::adjustment_container_ids(input)) in_adjustment_container_ids = Traits::adjustment_container_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->adjustment_container_ids)::BaseType>
          adjustment_container_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& adjustment_container_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cc::mojom::ElementIdDataView>, send_validation>(
        in_adjustment_container_ids,
        adjustment_container_ids_fragment,
        &adjustment_container_ids_validate_params);

      fragment->adjustment_container_ids.Set(
          adjustment_container_ids_fragment.is_null() ? nullptr : adjustment_container_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->adjustment_container_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null adjustment_container_ids in AnchorPositionScrollData struct");

      decltype(Traits::accumulated_scroll_origin(input)) in_accumulated_scroll_origin = Traits::accumulated_scroll_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->accumulated_scroll_origin)::BaseType> accumulated_scroll_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dDataView, send_validation>(
        in_accumulated_scroll_origin,
        accumulated_scroll_origin_fragment);

      fragment->accumulated_scroll_origin.Set(
          accumulated_scroll_origin_fragment.is_null() ? nullptr : accumulated_scroll_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->accumulated_scroll_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accumulated_scroll_origin in AnchorPositionScrollData struct");

      fragment->needs_scroll_adjustment_in_x = Traits::needs_scroll_adjustment_in_x(input);

      fragment->needs_scroll_adjustment_in_y = Traits::needs_scroll_adjustment_in_y(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::StickyPositionNodeDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::StickyPositionNodeDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::StickyPositionNodeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->scroll_ancestor = Traits::scroll_ancestor(input);

      fragment->is_anchored_left = Traits::is_anchored_left(input);

      fragment->is_anchored_right = Traits::is_anchored_right(input);

      fragment->is_anchored_top = Traits::is_anchored_top(input);

      fragment->is_anchored_bottom = Traits::is_anchored_bottom(input);

      fragment->left_offset = Traits::left_offset(input);

      fragment->right_offset = Traits::right_offset(input);

      fragment->top_offset = Traits::top_offset(input);

      fragment->bottom_offset = Traits::bottom_offset(input);

      decltype(Traits::constraint_box_rect(input)) in_constraint_box_rect = Traits::constraint_box_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->constraint_box_rect)::BaseType> constraint_box_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_constraint_box_rect,
        constraint_box_rect_fragment);

      fragment->constraint_box_rect.Set(
          constraint_box_rect_fragment.is_null() ? nullptr : constraint_box_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->constraint_box_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null constraint_box_rect in StickyPositionNodeData struct");

      decltype(Traits::scroll_container_relative_sticky_box_rect(input)) in_scroll_container_relative_sticky_box_rect = Traits::scroll_container_relative_sticky_box_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_container_relative_sticky_box_rect)::BaseType> scroll_container_relative_sticky_box_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_scroll_container_relative_sticky_box_rect,
        scroll_container_relative_sticky_box_rect_fragment);

      fragment->scroll_container_relative_sticky_box_rect.Set(
          scroll_container_relative_sticky_box_rect_fragment.is_null() ? nullptr : scroll_container_relative_sticky_box_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scroll_container_relative_sticky_box_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_container_relative_sticky_box_rect in StickyPositionNodeData struct");

      decltype(Traits::scroll_container_relative_containing_block_rect(input)) in_scroll_container_relative_containing_block_rect = Traits::scroll_container_relative_containing_block_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_container_relative_containing_block_rect)::BaseType> scroll_container_relative_containing_block_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_scroll_container_relative_containing_block_rect,
        scroll_container_relative_containing_block_rect_fragment);

      fragment->scroll_container_relative_containing_block_rect.Set(
          scroll_container_relative_containing_block_rect_fragment.is_null() ? nullptr : scroll_container_relative_containing_block_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scroll_container_relative_containing_block_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_container_relative_containing_block_rect in StickyPositionNodeData struct");

      decltype(Traits::pixel_snap_offset(input)) in_pixel_snap_offset = Traits::pixel_snap_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pixel_snap_offset)::BaseType> pixel_snap_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_pixel_snap_offset,
        pixel_snap_offset_fragment);

      fragment->pixel_snap_offset.Set(
          pixel_snap_offset_fragment.is_null() ? nullptr : pixel_snap_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pixel_snap_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_snap_offset in StickyPositionNodeData struct");

      fragment->nearest_node_shifting_sticky_box = Traits::nearest_node_shifting_sticky_box(input);

      fragment->nearest_node_shifting_containing_block = Traits::nearest_node_shifting_containing_block(input);

      decltype(Traits::total_sticky_box_sticky_offset(input)) in_total_sticky_box_sticky_offset = Traits::total_sticky_box_sticky_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total_sticky_box_sticky_offset)::BaseType> total_sticky_box_sticky_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_total_sticky_box_sticky_offset,
        total_sticky_box_sticky_offset_fragment);

      fragment->total_sticky_box_sticky_offset.Set(
          total_sticky_box_sticky_offset_fragment.is_null() ? nullptr : total_sticky_box_sticky_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->total_sticky_box_sticky_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_sticky_box_sticky_offset in StickyPositionNodeData struct");

      decltype(Traits::total_containing_block_sticky_offset(input)) in_total_containing_block_sticky_offset = Traits::total_containing_block_sticky_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->total_containing_block_sticky_offset)::BaseType> total_containing_block_sticky_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_total_containing_block_sticky_offset,
        total_containing_block_sticky_offset_fragment);

      fragment->total_containing_block_sticky_offset.Set(
          total_containing_block_sticky_offset_fragment.is_null() ? nullptr : total_containing_block_sticky_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->total_containing_block_sticky_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_containing_block_sticky_offset in StickyPositionNodeData struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TransformTreeUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransformTreeUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransformTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->page_scale_factor = Traits::page_scale_factor(input);

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      fragment->device_transform_scale_factor = Traits::device_transform_scale_factor(input);

      decltype(Traits::nodes_affected_by_outer_viewport_bounds_delta(input)) in_nodes_affected_by_outer_viewport_bounds_delta = Traits::nodes_affected_by_outer_viewport_bounds_delta(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nodes_affected_by_outer_viewport_bounds_delta)::BaseType>
          nodes_affected_by_outer_viewport_bounds_delta_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_outer_viewport_bounds_delta_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_nodes_affected_by_outer_viewport_bounds_delta,
        nodes_affected_by_outer_viewport_bounds_delta_fragment,
        &nodes_affected_by_outer_viewport_bounds_delta_validate_params);

      fragment->nodes_affected_by_outer_viewport_bounds_delta.Set(
          nodes_affected_by_outer_viewport_bounds_delta_fragment.is_null() ? nullptr : nodes_affected_by_outer_viewport_bounds_delta_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->nodes_affected_by_outer_viewport_bounds_delta.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes_affected_by_outer_viewport_bounds_delta in TransformTreeUpdate struct");

      decltype(Traits::nodes_affected_by_safe_area_bottom(input)) in_nodes_affected_by_safe_area_bottom = Traits::nodes_affected_by_safe_area_bottom(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nodes_affected_by_safe_area_bottom)::BaseType>
          nodes_affected_by_safe_area_bottom_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& nodes_affected_by_safe_area_bottom_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<int32_t>, send_validation>(
        in_nodes_affected_by_safe_area_bottom,
        nodes_affected_by_safe_area_bottom_fragment,
        &nodes_affected_by_safe_area_bottom_validate_params);

      fragment->nodes_affected_by_safe_area_bottom.Set(
          nodes_affected_by_safe_area_bottom_fragment.is_null() ? nullptr : nodes_affected_by_safe_area_bottom_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->nodes_affected_by_safe_area_bottom.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null nodes_affected_by_safe_area_bottom in TransformTreeUpdate struct");

      decltype(Traits::sticky_position_data(input)) in_sticky_position_data = Traits::sticky_position_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sticky_position_data)::BaseType>
          sticky_position_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sticky_position_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::StickyPositionNodeDataDataView>, send_validation>(
        in_sticky_position_data,
        sticky_position_data_fragment,
        &sticky_position_data_validate_params);

      fragment->sticky_position_data.Set(
          sticky_position_data_fragment.is_null() ? nullptr : sticky_position_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sticky_position_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sticky_position_data in TransformTreeUpdate struct");

      decltype(Traits::anchor_position_scroll_data(input)) in_anchor_position_scroll_data = Traits::anchor_position_scroll_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->anchor_position_scroll_data)::BaseType>
          anchor_position_scroll_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& anchor_position_scroll_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::AnchorPositionScrollDataDataView>, send_validation>(
        in_anchor_position_scroll_data,
        anchor_position_scroll_data_fragment,
        &anchor_position_scroll_data_validate_params);

      fragment->anchor_position_scroll_data.Set(
          anchor_position_scroll_data_fragment.is_null() ? nullptr : anchor_position_scroll_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->anchor_position_scroll_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null anchor_position_scroll_data in TransformTreeUpdate struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::TransformNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::TransformNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::TransformNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->parent_id = Traits::parent_id(input);

      fragment->parent_frame_id = Traits::parent_frame_id(input);

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in TransformNode struct");

      decltype(Traits::local(input)) in_local = Traits::local(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->local)::BaseType> local_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_local,
        local_fragment);

      fragment->local.Set(
          local_fragment.is_null() ? nullptr : local_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->local.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local in TransformNode struct");

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Point3FDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TransformNode struct");

      decltype(Traits::post_translation(input)) in_post_translation = Traits::post_translation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->post_translation)::BaseType> post_translation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_post_translation,
        post_translation_fragment);

      fragment->post_translation.Set(
          post_translation_fragment.is_null() ? nullptr : post_translation_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->post_translation.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null post_translation in TransformNode struct");

      decltype(Traits::to_parent(input)) in_to_parent = Traits::to_parent(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->to_parent)::BaseType> to_parent_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::TransformDataView, send_validation>(
        in_to_parent,
        to_parent_fragment);

      fragment->to_parent.Set(
          to_parent_fragment.is_null() ? nullptr : to_parent_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->to_parent.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null to_parent in TransformNode struct");

      decltype(Traits::scroll_offset(input)) in_scroll_offset = Traits::scroll_offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scroll_offset)::BaseType> scroll_offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointFDataView, send_validation>(
        in_scroll_offset,
        scroll_offset_fragment);

      fragment->scroll_offset.Set(
          scroll_offset_fragment.is_null() ? nullptr : scroll_offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scroll_offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offset in TransformNode struct");

      decltype(Traits::snap_amount(input)) in_snap_amount = Traits::snap_amount(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->snap_amount)::BaseType> snap_amount_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_snap_amount,
        snap_amount_fragment);

      fragment->snap_amount.Set(
          snap_amount_fragment.is_null() ? nullptr : snap_amount_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->snap_amount.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null snap_amount in TransformNode struct");
      fragment->sticky_position_constraint_id_$flag = Traits::sticky_position_constraint_id(input).has_value();
      if (Traits::sticky_position_constraint_id(input).has_value()) {
        fragment->sticky_position_constraint_id_$value = Traits::sticky_position_constraint_id(input).value();
      }
      fragment->anchor_position_scroll_data_id_$flag = Traits::anchor_position_scroll_data_id(input).has_value();
      if (Traits::anchor_position_scroll_data_id(input).has_value()) {
        fragment->anchor_position_scroll_data_id_$value = Traits::anchor_position_scroll_data_id(input).value();
      }

      fragment->sorting_context_id = Traits::sorting_context_id(input);

      fragment->has_potential_animation = Traits::has_potential_animation(input);

      fragment->is_currently_animating = Traits::is_currently_animating(input);

      fragment->flattens_inherited_transform = Traits::flattens_inherited_transform(input);

      fragment->scrolls = Traits::scrolls(input);

      fragment->should_undo_overscroll = Traits::should_undo_overscroll(input);

      fragment->should_be_snapped = Traits::should_be_snapped(input);

      fragment->moved_by_outer_viewport_bounds_delta_y = Traits::moved_by_outer_viewport_bounds_delta_y(input);

      fragment->in_subtree_of_page_scale_layer = Traits::in_subtree_of_page_scale_layer(input);

      fragment->transform_changed = Traits::transform_changed(input);

      fragment->delegates_to_parent_for_backface = Traits::delegates_to_parent_for_backface(input);

      fragment->will_change_transform = Traits::will_change_transform(input);

      fragment->maximum_animation_scale = Traits::maximum_animation_scale(input);

      fragment->node_and_ancestors_are_animated_or_invertible = Traits::node_and_ancestors_are_animated_or_invertible(input);

      fragment->is_invertible = Traits::is_invertible(input);

      fragment->ancestors_are_invertible = Traits::ancestors_are_invertible(input);

      fragment->node_and_ancestors_are_flat = Traits::node_and_ancestors_are_flat(input);

      fragment->node_or_ancestors_will_change_transform = Traits::node_or_ancestors_will_change_transform(input);

      decltype(Traits::visible_frame_element_id(input)) in_visible_frame_element_id = Traits::visible_frame_element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->visible_frame_element_id)::BaseType> visible_frame_element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_visible_frame_element_id,
        visible_frame_element_id_fragment);

      fragment->visible_frame_element_id.Set(
          visible_frame_element_id_fragment.is_null() ? nullptr : visible_frame_element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->visible_frame_element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_frame_element_id in TransformNode struct");

      fragment->damage_reasons_bit_mask = Traits::damage_reasons_bit_mask(input);

      fragment->moved_by_safe_area_bottom = Traits::moved_by_safe_area_bottom(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ClipNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ClipNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ClipNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->parent_id = Traits::parent_id(input);

      fragment->transform_id = Traits::transform_id(input);

      decltype(Traits::clip(input)) in_clip = Traits::clip(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->clip)::BaseType> clip_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectFDataView, send_validation>(
        in_clip,
        clip_fragment);

      fragment->clip.Set(
          clip_fragment.is_null() ? nullptr : clip_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->clip.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip in ClipNode struct");

      fragment->pixel_moving_filter_id = Traits::pixel_moving_filter_id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::EffectNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::EffectNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::EffectNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->parent_id = Traits::parent_id(input);

      fragment->transform_id = Traits::transform_id(input);

      fragment->clip_id = Traits::clip_id(input);

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in EffectNode struct");

      fragment->opacity = Traits::opacity(input);

      
      mojo::internal::Serialize<::cc::mojom::RenderSurfaceReason>(
        Traits::render_surface_reason(input),
        &fragment->render_surface_reason);

      decltype(Traits::surface_contents_scale(input)) in_surface_contents_scale = Traits::surface_contents_scale(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->surface_contents_scale)::BaseType> surface_contents_scale_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView, send_validation>(
        in_surface_contents_scale,
        surface_contents_scale_fragment);

      fragment->surface_contents_scale.Set(
          surface_contents_scale_fragment.is_null() ? nullptr : surface_contents_scale_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->surface_contents_scale.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null surface_contents_scale in EffectNode struct");

      decltype(Traits::subtree_capture_id(input)) in_subtree_capture_id = Traits::subtree_capture_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subtree_capture_id)::BaseType> subtree_capture_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView, send_validation>(
        in_subtree_capture_id,
        subtree_capture_id_fragment);

      fragment->subtree_capture_id.Set(
          subtree_capture_id_fragment.is_null() ? nullptr : subtree_capture_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subtree_capture_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subtree_capture_id in EffectNode struct");

      decltype(Traits::subtree_size(input)) in_subtree_size = Traits::subtree_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->subtree_size)::BaseType> subtree_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_subtree_size,
        subtree_size_fragment);

      fragment->subtree_size.Set(
          subtree_size_fragment.is_null() ? nullptr : subtree_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->subtree_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subtree_size in EffectNode struct");

      fragment->blend_mode = Traits::blend_mode(input);

      fragment->target_id = Traits::target_id(input);

      fragment->view_transition_target_id = Traits::view_transition_target_id(input);

      fragment->closest_ancestor_with_cached_render_surface_id = Traits::closest_ancestor_with_cached_render_surface_id(input);

      fragment->closest_ancestor_with_copy_request_id = Traits::closest_ancestor_with_copy_request_id(input);

      fragment->closest_ancestor_being_captured_id = Traits::closest_ancestor_being_captured_id(input);

      fragment->closest_ancestor_with_shared_element_id = Traits::closest_ancestor_with_shared_element_id(input);

      decltype(Traits::view_transition_element_resource_id(input)) in_view_transition_element_resource_id = Traits::view_transition_element_resource_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_transition_element_resource_id)::BaseType> view_transition_element_resource_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView, send_validation>(
        in_view_transition_element_resource_id,
        view_transition_element_resource_id_fragment);

      fragment->view_transition_element_resource_id.Set(
          view_transition_element_resource_id_fragment.is_null() ? nullptr : view_transition_element_resource_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->view_transition_element_resource_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_transition_element_resource_id in EffectNode struct");

      decltype(Traits::filters(input)) in_filters = Traits::filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->filters)::BaseType> filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView, send_validation>(
        in_filters,
        filters_fragment);

      fragment->filters.Set(
          filters_fragment.is_null() ? nullptr : filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filters in EffectNode struct");

      decltype(Traits::backdrop_filters(input)) in_backdrop_filters = Traits::backdrop_filters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->backdrop_filters)::BaseType> backdrop_filters_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FilterOperationsDataView, send_validation>(
        in_backdrop_filters,
        backdrop_filters_fragment);

      fragment->backdrop_filters.Set(
          backdrop_filters_fragment.is_null() ? nullptr : backdrop_filters_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->backdrop_filters.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null backdrop_filters in EffectNode struct");

      decltype(Traits::backdrop_filter_bounds(input)) in_backdrop_filter_bounds = Traits::backdrop_filter_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->backdrop_filter_bounds)::BaseType> backdrop_filter_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkPathDataView, send_validation>(
        in_backdrop_filter_bounds,
        backdrop_filter_bounds_fragment);

      fragment->backdrop_filter_bounds.Set(
          backdrop_filter_bounds_fragment.is_null() ? nullptr : backdrop_filter_bounds_fragment.data());

      fragment->backdrop_filter_quality = Traits::backdrop_filter_quality(input);

      decltype(Traits::backdrop_mask_element_id(input)) in_backdrop_mask_element_id = Traits::backdrop_mask_element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->backdrop_mask_element_id)::BaseType> backdrop_mask_element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_backdrop_mask_element_id,
        backdrop_mask_element_id_fragment);

      fragment->backdrop_mask_element_id.Set(
          backdrop_mask_element_id_fragment.is_null() ? nullptr : backdrop_mask_element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->backdrop_mask_element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null backdrop_mask_element_id in EffectNode struct");

      decltype(Traits::mask_filter_info(input)) in_mask_filter_info = Traits::mask_filter_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mask_filter_info)::BaseType> mask_filter_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::MaskFilterInfoDataView, send_validation>(
        in_mask_filter_info,
        mask_filter_info_fragment);

      fragment->mask_filter_info.Set(
          mask_filter_info_fragment.is_null() ? nullptr : mask_filter_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mask_filter_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mask_filter_info in EffectNode struct");

      fragment->cache_render_surface = Traits::cache_render_surface(input);

      fragment->double_sided = Traits::double_sided(input);

      fragment->trilinear_filtering = Traits::trilinear_filtering(input);

      fragment->subtree_hidden = Traits::subtree_hidden(input);

      fragment->has_potential_filter_animation = Traits::has_potential_filter_animation(input);

      fragment->has_potential_backdrop_filter_animation = Traits::has_potential_backdrop_filter_animation(input);

      fragment->has_potential_opacity_animation = Traits::has_potential_opacity_animation(input);

      fragment->subtree_has_copy_request = Traits::subtree_has_copy_request(input);

      fragment->is_fast_rounded_corner = Traits::is_fast_rounded_corner(input);

      fragment->may_have_backdrop_effect = Traits::may_have_backdrop_effect(input);

      fragment->needs_effect_for_2d_scale_transform = Traits::needs_effect_for_2d_scale_transform(input);

      decltype(Traits::copy_output_requests(input)) in_copy_output_requests = Traits::copy_output_requests(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->copy_output_requests)::BaseType>
          copy_output_requests_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& copy_output_requests_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CopyOutputRequestDataView>, send_validation>(
        in_copy_output_requests,
        copy_output_requests_fragment,
        &copy_output_requests_validate_params);

      fragment->copy_output_requests.Set(
          copy_output_requests_fragment.is_null() ? nullptr : copy_output_requests_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->copy_output_requests.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null copy_output_requests in EffectNode struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ScrollTreeUpdateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ScrollTreeUpdateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ScrollTreeUpdate_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::synced_scroll_offsets(input)) in_synced_scroll_offsets = Traits::synced_scroll_offsets(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->synced_scroll_offsets)::BaseType>
          synced_scroll_offsets_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& synced_scroll_offsets_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::cc::mojom::SyncedScrollOffsetDataView>, send_validation>(
        in_synced_scroll_offsets,
        synced_scroll_offsets_fragment,
        &synced_scroll_offsets_validate_params);

      fragment->synced_scroll_offsets.Set(
          synced_scroll_offsets_fragment.is_null() ? nullptr : synced_scroll_offsets_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->synced_scroll_offsets.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null synced_scroll_offsets in ScrollTreeUpdate struct");

      decltype(Traits::scrolling_contents_cull_rects(input)) in_scrolling_contents_cull_rects = Traits::scrolling_contents_cull_rects(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->scrolling_contents_cull_rects)::BaseType>
          scrolling_contents_cull_rects_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& scrolling_contents_cull_rects_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::RectDataView>, send_validation>(
        in_scrolling_contents_cull_rects,
        scrolling_contents_cull_rects_fragment,
        &scrolling_contents_cull_rects_validate_params);

      fragment->scrolling_contents_cull_rects.Set(
          scrolling_contents_cull_rects_fragment.is_null() ? nullptr : scrolling_contents_cull_rects_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->scrolling_contents_cull_rects.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrolling_contents_cull_rects in ScrollTreeUpdate struct");

      decltype(Traits::elastic_overscroll(input)) in_elastic_overscroll = Traits::elastic_overscroll(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->elastic_overscroll)::BaseType>
          elastic_overscroll_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& elastic_overscroll_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::cc::mojom::ElementIdDataView, ::gfx::mojom::Vector2dFDataView>, send_validation>(
        in_elastic_overscroll,
        elastic_overscroll_fragment,
        &elastic_overscroll_validate_params);

      fragment->elastic_overscroll.Set(
          elastic_overscroll_fragment.is_null() ? nullptr : elastic_overscroll_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->elastic_overscroll.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elastic_overscroll in ScrollTreeUpdate struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::ScrollNodeDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ScrollNodeDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ScrollNode_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      fragment->parent_id = Traits::parent_id(input);

      fragment->transform_id = Traits::transform_id(input);

      decltype(Traits::container_bounds(input)) in_container_bounds = Traits::container_bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->container_bounds)::BaseType> container_bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_container_bounds,
        container_bounds_fragment);

      fragment->container_bounds.Set(
          container_bounds_fragment.is_null() ? nullptr : container_bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->container_bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null container_bounds in ScrollNode struct");

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in ScrollNode struct");

      decltype(Traits::element_id(input)) in_element_id = Traits::element_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_id)::BaseType> element_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cc::mojom::ElementIdDataView, send_validation>(
        in_element_id,
        element_id_fragment);

      fragment->element_id.Set(
          element_id_fragment.is_null() ? nullptr : element_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_id in ScrollNode struct");

      fragment->max_scroll_offset_affected_by_page_scale = Traits::max_scroll_offset_affected_by_page_scale(input);

      fragment->scrolls_inner_viewport = Traits::scrolls_inner_viewport(input);

      fragment->scrolls_outer_viewport = Traits::scrolls_outer_viewport(input);

      fragment->prevent_viewport_scrolling_from_inner = Traits::prevent_viewport_scrolling_from_inner(input);

      fragment->user_scrollable_horizontal = Traits::user_scrollable_horizontal(input);

      fragment->user_scrollable_vertical = Traits::user_scrollable_vertical(input);

      fragment->is_composited = Traits::is_composited(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::LayerExtraDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::LayerExtraDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::LayerExtra_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::LayerExtraDataView::Tag::kMirrorLayerExtra: {
    decltype(Traits::mirror_layer_extra(input))
    in_mirror_layer_extra = Traits::mirror_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_mirror_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::MirrorLayerExtraDataView, send_validation>(
  in_mirror_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null mirror_layer_extra in LayerExtra union");
    fragment->data.f_mirror_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kNinePatchThumbScrollbarLayerExtra: {
    decltype(Traits::nine_patch_thumb_scrollbar_layer_extra(input))
    in_nine_patch_thumb_scrollbar_layer_extra = Traits::nine_patch_thumb_scrollbar_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_nine_patch_thumb_scrollbar_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::NinePatchThumbScrollbarLayerExtraDataView, send_validation>(
  in_nine_patch_thumb_scrollbar_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null nine_patch_thumb_scrollbar_layer_extra in LayerExtra union");
    fragment->data.f_nine_patch_thumb_scrollbar_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kPaintedScrollbarLayerExtra: {
    decltype(Traits::painted_scrollbar_layer_extra(input))
    in_painted_scrollbar_layer_extra = Traits::painted_scrollbar_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_painted_scrollbar_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::PaintedScrollbarLayerExtraDataView, send_validation>(
  in_painted_scrollbar_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null painted_scrollbar_layer_extra in LayerExtra union");
    fragment->data.f_painted_scrollbar_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kSolidColorScrollbarLayerExtra: {
    decltype(Traits::solid_color_scrollbar_layer_extra(input))
    in_solid_color_scrollbar_layer_extra = Traits::solid_color_scrollbar_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_solid_color_scrollbar_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SolidColorScrollbarLayerExtraDataView, send_validation>(
  in_solid_color_scrollbar_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null solid_color_scrollbar_layer_extra in LayerExtra union");
    fragment->data.f_solid_color_scrollbar_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kSurfaceLayerExtra: {
    decltype(Traits::surface_layer_extra(input))
    in_surface_layer_extra = Traits::surface_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_surface_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SurfaceLayerExtraDataView, send_validation>(
  in_surface_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null surface_layer_extra in LayerExtra union");
    fragment->data.f_surface_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kTextureLayerExtra: {
    decltype(Traits::texture_layer_extra(input))
    in_texture_layer_extra = Traits::texture_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_texture_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TextureLayerExtraDataView, send_validation>(
  in_texture_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null texture_layer_extra in LayerExtra union");
    fragment->data.f_texture_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kUiResourceLayerExtra: {
    decltype(Traits::ui_resource_layer_extra(input))
    in_ui_resource_layer_extra = Traits::ui_resource_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_ui_resource_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::UIResourceLayerExtraDataView, send_validation>(
  in_ui_resource_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null ui_resource_layer_extra in LayerExtra union");
    fragment->data.f_ui_resource_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kTileDisplayLayerExtra: {
    decltype(Traits::tile_display_layer_extra(input))
    in_tile_display_layer_extra = Traits::tile_display_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tile_display_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::TileDisplayLayerExtraDataView, send_validation>(
  in_tile_display_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tile_display_layer_extra in LayerExtra union");
    fragment->data.f_tile_display_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kViewTransitionContentLayerExtra: {
    decltype(Traits::view_transition_content_layer_extra(input))
    in_view_transition_content_layer_extra = Traits::view_transition_content_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_view_transition_content_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::ViewTransitionContentLayerExtraDataView, send_validation>(
  in_view_transition_content_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null view_transition_content_layer_extra in LayerExtra union");
    fragment->data.f_view_transition_content_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::LayerExtraDataView::Tag::kNinePatchLayerExtra: {
    decltype(Traits::nine_patch_layer_extra(input))
    in_nine_patch_layer_extra = Traits::nine_patch_layer_extra(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_nine_patch_layer_extra)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::NinePatchLayerExtraDataView, send_validation>(
  in_nine_patch_layer_extra,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null nine_patch_layer_extra in LayerExtra union");
    fragment->data.f_nine_patch_layer_extra.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_LAYER_MOJOM_SEND_VALIDATION_H_