// services/viz/public/mojom/compositing/frame_sink_bundle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom-forward.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom.h"
#include "services/viz/public/mojom/compositing/thread.mojom-forward.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"




namespace viz { class CompositorFrame; }


namespace viz::mojom {

class FrameSinkBundleProxy;

template <typename ImplRefTraits>
class FrameSinkBundleStub;

class FrameSinkBundleRequestValidator;


class FrameSinkBundle
    : public FrameSinkBundleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkBundle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr bool kSupportsDirectReceiver = true;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkBundleInterfaceBase;
  using Proxy_ = FrameSinkBundleProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkBundleStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkBundleRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetNeedsBeginFrameMinVersion = 0,
    kSubmitMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetNeedsBeginFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Submit_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkBundle() = default;

  virtual void SetNeedsBeginFrame(uint32_t sink_id, bool needs_begin_frame) = 0;

  virtual void Submit(std::vector<BundledFrameSubmissionPtr> submissions) = 0;
};

class FrameSinkBundleClientProxy;

template <typename ImplRefTraits>
class FrameSinkBundleClientStub;

class FrameSinkBundleClientRequestValidator;


class FrameSinkBundleClient
    : public FrameSinkBundleClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkBundleClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkBundleClientInterfaceBase;
  using Proxy_ = FrameSinkBundleClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkBundleClientStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkBundleClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFlushNotificationsMinVersion = 0,
    kOnBeginFramePausedChangedMinVersion = 0,
    kOnCompositorFrameTransitionDirectiveProcessedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FlushNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBeginFramePausedChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCompositorFrameTransitionDirectiveProcessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkBundleClient() = default;

  virtual void FlushNotifications(std::vector<BundledReturnedResourcesPtr> acks, std::vector<BeginFrameInfoPtr> begin_frames, std::vector<BundledReturnedResourcesPtr> reclaimed_resources) = 0;

  virtual void OnBeginFramePausedChanged(uint32_t sink_id, bool paused) = 0;

  virtual void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sink_id, uint32_t sequence_id) = 0;
};



class  FrameSinkBundleProxy
    : public FrameSinkBundle {
 public:
  using InterfaceType = FrameSinkBundle;

  explicit FrameSinkBundleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetNeedsBeginFrame(uint32_t sink_id, bool needs_begin_frame) final;
  
  void Submit(std::vector<BundledFrameSubmissionPtr> submissions) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkBundleClientProxy
    : public FrameSinkBundleClient {
 public:
  using InterfaceType = FrameSinkBundleClient;

  explicit FrameSinkBundleClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FlushNotifications(std::vector<BundledReturnedResourcesPtr> acks, std::vector<BeginFrameInfoPtr> begin_frames, std::vector<BundledReturnedResourcesPtr> reclaimed_resources) final;
  
  void OnBeginFramePausedChanged(uint32_t sink_id, bool paused) final;
  
  void OnCompositorFrameTransitionDirectiveProcessed(uint32_t sink_id, uint32_t sequence_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkBundleStubDispatch {
 public:
  static bool Accept(FrameSinkBundle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkBundle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkBundle>>
class FrameSinkBundleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkBundleStub() = default;
  ~FrameSinkBundleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkBundleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkBundleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkBundleClientStubDispatch {
 public:
  static bool Accept(FrameSinkBundleClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkBundleClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkBundleClient>>
class FrameSinkBundleClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkBundleClientStub() = default;
  ~FrameSinkBundleClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkBundleClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkBundleClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkBundleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkBundleClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  BundledFrameSubmissionData {
 public:
  using DataView = BundledFrameSubmissionDataDataView;
  using Data_ = internal::BundledFrameSubmissionData_Data;
  using Tag = Data_::BundledFrameSubmissionData_Tag;

  template <typename... Args>
  static BundledFrameSubmissionDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |frame|.
  static BundledFrameSubmissionDataPtr NewFrame(
      BundledCompositorFramePtr value);
  // Construct an instance holding |did_not_produce_frame|.
  static BundledFrameSubmissionDataPtr NewDidNotProduceFrame(
      const ::viz::BeginFrameAck& value);

  template <typename U>
  static BundledFrameSubmissionDataPtr From(const U& u) {
    return mojo::TypeConverter<BundledFrameSubmissionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundledFrameSubmissionData>::Convert(*this);
  }
  ~BundledFrameSubmissionData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  BundledFrameSubmissionData(const BundledFrameSubmissionData& other) = delete;
  BundledFrameSubmissionData& operator=(const BundledFrameSubmissionData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = BundledFrameSubmissionDataPtr>
  BundledFrameSubmissionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, BundledFrameSubmissionData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, BundledFrameSubmissionData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_frame() const { return tag_ == Tag::kFrame; }
  const BundledCompositorFramePtr& get_frame() const {
    CHECK(tag_ == Tag::kFrame);
    return data_.frame;
  }
  BundledCompositorFramePtr& get_frame() {
    CHECK(tag_ == Tag::kFrame);
    return data_.frame;
  }
  void set_frame(BundledCompositorFramePtr frame);

  bool is_did_not_produce_frame() const { return tag_ == Tag::kDidNotProduceFrame; }
  const ::viz::BeginFrameAck& get_did_not_produce_frame() const {
    CHECK(tag_ == Tag::kDidNotProduceFrame);
    return data_.did_not_produce_frame;
  }
  ::viz::BeginFrameAck& get_did_not_produce_frame() {
    CHECK(tag_ == Tag::kDidNotProduceFrame);
    return data_.did_not_produce_frame;
  }
  void set_did_not_produce_frame(const ::viz::BeginFrameAck& did_not_produce_frame);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundledFrameSubmissionData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<BundledFrameSubmissionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
        BundledCompositorFramePtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDidNotProduceFrame)>,
        const ::viz::BeginFrameAck& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    BundledCompositorFramePtr frame;
    ::viz::BeginFrameAck did_not_produce_frame;
  };

  BundledFrameSubmissionData(
      std::in_place_index_t<static_cast<size_t>(Tag::kFrame)>,
      BundledCompositorFramePtr value);
  BundledFrameSubmissionData(
      std::in_place_index_t<static_cast<size_t>(Tag::kDidNotProduceFrame)>,
      const ::viz::BeginFrameAck& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  BundledFrameSubmission {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundledFrameSubmission, T>::value>;
  using DataView = BundledFrameSubmissionDataView;
  using Data_ = internal::BundledFrameSubmission_Data;

  template <typename... Args>
  static BundledFrameSubmissionPtr New(Args&&... args) {
    return BundledFrameSubmissionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundledFrameSubmissionPtr From(const U& u) {
    return mojo::TypeConverter<BundledFrameSubmissionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundledFrameSubmission>::Convert(*this);
  }


  BundledFrameSubmission();

  BundledFrameSubmission(
      uint32_t sink_id,
      BundledFrameSubmissionDataPtr data);

BundledFrameSubmission(const BundledFrameSubmission&) = delete;
BundledFrameSubmission& operator=(const BundledFrameSubmission&) = delete;

  ~BundledFrameSubmission();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundledFrameSubmissionPtr>
  BundledFrameSubmissionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundledFrameSubmission::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundledFrameSubmission_UnserializedMessageContext<
            UserType, BundledFrameSubmission::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundledFrameSubmission::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundledFrameSubmission::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundledFrameSubmission_UnserializedMessageContext<
            UserType, BundledFrameSubmission::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundledFrameSubmission::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t sink_id;
  
  BundledFrameSubmissionDataPtr data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundledFrameSubmission::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundledCompositorFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundledCompositorFrame, T>::value>;
  using DataView = BundledCompositorFrameDataView;
  using Data_ = internal::BundledCompositorFrame_Data;

  template <typename... Args>
  static BundledCompositorFramePtr New(Args&&... args) {
    return BundledCompositorFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundledCompositorFramePtr From(const U& u) {
    return mojo::TypeConverter<BundledCompositorFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundledCompositorFrame>::Convert(*this);
  }


  BundledCompositorFrame();

  BundledCompositorFrame(
      const ::viz::LocalSurfaceId& local_surface_id,
      ::viz::CompositorFrame frame,
      std::optional<::viz::HitTestRegionList> hit_test_region_list,
      uint64_t submit_time);

BundledCompositorFrame(const BundledCompositorFrame&) = delete;
BundledCompositorFrame& operator=(const BundledCompositorFrame&) = delete;

  ~BundledCompositorFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundledCompositorFramePtr>
  BundledCompositorFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundledCompositorFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundledCompositorFrame_UnserializedMessageContext<
            UserType, BundledCompositorFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundledCompositorFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundledCompositorFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundledCompositorFrame_UnserializedMessageContext<
            UserType, BundledCompositorFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundledCompositorFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::LocalSurfaceId local_surface_id;
  
  ::viz::CompositorFrame frame;
  
  std::optional<::viz::HitTestRegionList> hit_test_region_list;
  
  uint64_t submit_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundledCompositorFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BundledReturnedResources {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BundledReturnedResources, T>::value>;
  using DataView = BundledReturnedResourcesDataView;
  using Data_ = internal::BundledReturnedResources_Data;

  template <typename... Args>
  static BundledReturnedResourcesPtr New(Args&&... args) {
    return BundledReturnedResourcesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BundledReturnedResourcesPtr From(const U& u) {
    return mojo::TypeConverter<BundledReturnedResourcesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BundledReturnedResources>::Convert(*this);
  }


  BundledReturnedResources();

  BundledReturnedResources(
      uint32_t sink_id,
      std::vector<::viz::ReturnedResource> resources);

BundledReturnedResources(const BundledReturnedResources&) = delete;
BundledReturnedResources& operator=(const BundledReturnedResources&) = delete;

  ~BundledReturnedResources();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BundledReturnedResourcesPtr>
  BundledReturnedResourcesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BundledReturnedResources::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BundledReturnedResources_UnserializedMessageContext<
            UserType, BundledReturnedResources::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BundledReturnedResources::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BundledReturnedResources::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BundledReturnedResources_UnserializedMessageContext<
            UserType, BundledReturnedResources::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BundledReturnedResources::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t sink_id;
  
  std::vector<::viz::ReturnedResource> resources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BundledReturnedResources::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BeginFrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BeginFrameInfo, T>::value>;
  using DataView = BeginFrameInfoDataView;
  using Data_ = internal::BeginFrameInfo_Data;

  template <typename... Args>
  static BeginFrameInfoPtr New(Args&&... args) {
    return BeginFrameInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BeginFrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<BeginFrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BeginFrameInfo>::Convert(*this);
  }


  BeginFrameInfo();

  BeginFrameInfo(
      uint32_t sink_id,
      const ::viz::BeginFrameArgs& args,
      const base::flat_map<uint32_t, ::viz::FrameTimingDetails>& details,
      std::vector<::viz::ReturnedResource> resources);

BeginFrameInfo(const BeginFrameInfo&) = delete;
BeginFrameInfo& operator=(const BeginFrameInfo&) = delete;

  ~BeginFrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BeginFrameInfoPtr>
  BeginFrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BeginFrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BeginFrameInfo_UnserializedMessageContext<
            UserType, BeginFrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BeginFrameInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BeginFrameInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BeginFrameInfo_UnserializedMessageContext<
            UserType, BeginFrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BeginFrameInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t sink_id;
  
  ::viz::BeginFrameArgs args;
  
  base::flat_map<uint32_t, ::viz::FrameTimingDetails> details;
  
  std::vector<::viz::ReturnedResource> resources;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BeginFrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
BundledFrameSubmissionDataPtr BundledFrameSubmissionData::Clone() const {
  switch (tag_) {
    case Tag::kFrame:
      return NewFrame(
          mojo::Clone(data_.frame));
    case Tag::kDidNotProduceFrame:
      return NewDidNotProduceFrame(
          mojo::Clone(data_.did_not_produce_frame));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, BundledFrameSubmissionData>::value>::type*>
bool BundledFrameSubmissionData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFrame:
      return mojo::Equals(data_.frame, other.data_.frame);
    case Tag::kDidNotProduceFrame:
      return mojo::Equals(data_.did_not_produce_frame, other.data_.did_not_produce_frame);
  }

  return false;
}
template <typename StructPtrType>
BundledFrameSubmissionPtr BundledFrameSubmission::Clone() const {
  return New(
      mojo::Clone(sink_id),
      mojo::Clone(data)
  );
}

template <typename T, BundledFrameSubmission::EnableIfSame<T>*>
bool BundledFrameSubmission::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, BundledFrameSubmission::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
BundledCompositorFramePtr BundledCompositorFrame::Clone() const {
  return New(
      mojo::Clone(local_surface_id),
      mojo::Clone(frame),
      mojo::Clone(hit_test_region_list),
      mojo::Clone(submit_time)
  );
}

template <typename T, BundledCompositorFrame::EnableIfSame<T>*>
bool BundledCompositorFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_surface_id, other_struct.local_surface_id))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  if (!mojo::Equals(this->hit_test_region_list, other_struct.hit_test_region_list))
    return false;
  if (!mojo::Equals(this->submit_time, other_struct.submit_time))
    return false;
  return true;
}

template <typename T, BundledCompositorFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.local_surface_id < rhs.local_surface_id)
    return true;
  if (rhs.local_surface_id < lhs.local_surface_id)
    return false;
  if (lhs.frame < rhs.frame)
    return true;
  if (rhs.frame < lhs.frame)
    return false;
  if (lhs.hit_test_region_list < rhs.hit_test_region_list)
    return true;
  if (rhs.hit_test_region_list < lhs.hit_test_region_list)
    return false;
  if (lhs.submit_time < rhs.submit_time)
    return true;
  if (rhs.submit_time < lhs.submit_time)
    return false;
  return false;
}
template <typename StructPtrType>
BundledReturnedResourcesPtr BundledReturnedResources::Clone() const {
  return New(
      mojo::Clone(sink_id),
      mojo::Clone(resources)
  );
}

template <typename T, BundledReturnedResources::EnableIfSame<T>*>
bool BundledReturnedResources::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->resources, other_struct.resources))
    return false;
  return true;
}

template <typename T, BundledReturnedResources::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.resources < rhs.resources)
    return true;
  if (rhs.resources < lhs.resources)
    return false;
  return false;
}
template <typename StructPtrType>
BeginFrameInfoPtr BeginFrameInfo::Clone() const {
  return New(
      mojo::Clone(sink_id),
      mojo::Clone(args),
      mojo::Clone(details),
      mojo::Clone(resources)
  );
}

template <typename T, BeginFrameInfo::EnableIfSame<T>*>
bool BeginFrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sink_id, other_struct.sink_id))
    return false;
  if (!mojo::Equals(this->args, other_struct.args))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  if (!mojo::Equals(this->resources, other_struct.resources))
    return false;
  return true;
}

template <typename T, BeginFrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sink_id < rhs.sink_id)
    return true;
  if (rhs.sink_id < lhs.sink_id)
    return false;
  if (lhs.args < rhs.args)
    return true;
  if (rhs.args < lhs.args)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  if (lhs.resources < rhs.resources)
    return true;
  if (rhs.resources < lhs.resources)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::BundledFrameSubmission::DataView,
                                         ::viz::mojom::BundledFrameSubmissionPtr> {
  static bool IsNull(const ::viz::mojom::BundledFrameSubmissionPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BundledFrameSubmissionPtr* output) { output->reset(); }

  static decltype(::viz::mojom::BundledFrameSubmission::sink_id) sink_id(
      const ::viz::mojom::BundledFrameSubmissionPtr& input) {
    return input->sink_id;
  }

  static  decltype(::viz::mojom::BundledFrameSubmission::data)& data(
       ::viz::mojom::BundledFrameSubmissionPtr& input) {
    return input->data;
  }

  static bool Read(::viz::mojom::BundledFrameSubmission::DataView input, ::viz::mojom::BundledFrameSubmissionPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::BundledCompositorFrame::DataView,
                                         ::viz::mojom::BundledCompositorFramePtr> {
  static bool IsNull(const ::viz::mojom::BundledCompositorFramePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BundledCompositorFramePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::BundledCompositorFrame::local_surface_id)& local_surface_id(
      const ::viz::mojom::BundledCompositorFramePtr& input) {
    return input->local_surface_id;
  }

  static  decltype(::viz::mojom::BundledCompositorFrame::frame)& frame(
       ::viz::mojom::BundledCompositorFramePtr& input) {
    return input->frame;
  }

  static const decltype(::viz::mojom::BundledCompositorFrame::hit_test_region_list)& hit_test_region_list(
      const ::viz::mojom::BundledCompositorFramePtr& input) {
    return input->hit_test_region_list;
  }

  static decltype(::viz::mojom::BundledCompositorFrame::submit_time) submit_time(
      const ::viz::mojom::BundledCompositorFramePtr& input) {
    return input->submit_time;
  }

  static bool Read(::viz::mojom::BundledCompositorFrame::DataView input, ::viz::mojom::BundledCompositorFramePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::BundledReturnedResources::DataView,
                                         ::viz::mojom::BundledReturnedResourcesPtr> {
  static bool IsNull(const ::viz::mojom::BundledReturnedResourcesPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BundledReturnedResourcesPtr* output) { output->reset(); }

  static decltype(::viz::mojom::BundledReturnedResources::sink_id) sink_id(
      const ::viz::mojom::BundledReturnedResourcesPtr& input) {
    return input->sink_id;
  }

  static  decltype(::viz::mojom::BundledReturnedResources::resources)& resources(
       ::viz::mojom::BundledReturnedResourcesPtr& input) {
    return input->resources;
  }

  static bool Read(::viz::mojom::BundledReturnedResources::DataView input, ::viz::mojom::BundledReturnedResourcesPtr* output);
};


template <>
struct  StructTraits<::viz::mojom::BeginFrameInfo::DataView,
                                         ::viz::mojom::BeginFrameInfoPtr> {
  static bool IsNull(const ::viz::mojom::BeginFrameInfoPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BeginFrameInfoPtr* output) { output->reset(); }

  static decltype(::viz::mojom::BeginFrameInfo::sink_id) sink_id(
      const ::viz::mojom::BeginFrameInfoPtr& input) {
    return input->sink_id;
  }

  static const decltype(::viz::mojom::BeginFrameInfo::args)& args(
      const ::viz::mojom::BeginFrameInfoPtr& input) {
    return input->args;
  }

  static const decltype(::viz::mojom::BeginFrameInfo::details)& details(
      const ::viz::mojom::BeginFrameInfoPtr& input) {
    return input->details;
  }

  static  decltype(::viz::mojom::BeginFrameInfo::resources)& resources(
       ::viz::mojom::BeginFrameInfoPtr& input) {
    return input->resources;
  }

  static bool Read(::viz::mojom::BeginFrameInfo::DataView input, ::viz::mojom::BeginFrameInfoPtr* output);
};


template <>
struct  UnionTraits<::viz::mojom::BundledFrameSubmissionData::DataView,
                                        ::viz::mojom::BundledFrameSubmissionDataPtr> {
  static bool IsNull(const ::viz::mojom::BundledFrameSubmissionDataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::BundledFrameSubmissionDataPtr* output) { output->reset(); }

  static ::viz::mojom::BundledFrameSubmissionData::Tag GetTag(const ::viz::mojom::BundledFrameSubmissionDataPtr& input) {
    return input->which();
  }

  static  ::viz::mojom::BundledCompositorFramePtr& frame( ::viz::mojom::BundledFrameSubmissionDataPtr& input) {
    return input->get_frame();
  }

  static const ::viz::BeginFrameAck& did_not_produce_frame(const ::viz::mojom::BundledFrameSubmissionDataPtr& input) {
    return input->get_did_not_produce_frame();
  }

  static bool Read(::viz::mojom::BundledFrameSubmissionData::DataView input, ::viz::mojom::BundledFrameSubmissionDataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_SINK_BUNDLE_MOJOM_H_