// services/viz/public/mojom/compositing/filter_operation.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SEND_VALIDATION_H_

#include "services/viz/public/mojom/compositing/filter_operation.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/paint_filter.mojom-shared.h"
#include "skia/public/mojom/tile_mode.mojom-shared.h"
#include "skia/public/mojom/skcolor4f.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/viz/public/mojom/compositing/filter_operation.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::FilterType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::FilterOperationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FilterOperationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FilterOperation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::viz::mojom::FilterType>(
        Traits::type(input),
        &fragment->type);

      fragment->amount = Traits::amount(input);

      decltype(Traits::offset(input)) in_offset = Traits::offset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->offset)::BaseType> offset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_offset,
        offset_fragment);

      fragment->offset.Set(
          offset_fragment.is_null() ? nullptr : offset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->offset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset in FilterOperation struct");

      decltype(Traits::drop_shadow_color(input)) in_drop_shadow_color = Traits::drop_shadow_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->drop_shadow_color)::BaseType> drop_shadow_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColor4fDataView, send_validation>(
        in_drop_shadow_color,
        drop_shadow_color_fragment);

      fragment->drop_shadow_color.Set(
          drop_shadow_color_fragment.is_null() ? nullptr : drop_shadow_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->drop_shadow_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null drop_shadow_color in FilterOperation struct");

      decltype(Traits::image_filter(input)) in_image_filter = Traits::image_filter(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->image_filter)::BaseType> image_filter_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::PaintFilterDataView, send_validation>(
        in_image_filter,
        image_filter_fragment);

      fragment->image_filter.Set(
          image_filter_fragment.is_null() ? nullptr : image_filter_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->image_filter.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_filter in FilterOperation struct");

      decltype(Traits::matrix(input)) in_matrix = Traits::matrix(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->matrix)::BaseType>
          matrix_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& matrix_validate_params =
          mojo::internal::GetArrayValidator<20, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<float>, send_validation>(
        in_matrix,
        matrix_fragment,
        &matrix_validate_params);

      fragment->matrix.Set(
          matrix_fragment.is_null() ? nullptr : matrix_fragment.data());

      fragment->zoom_inset = Traits::zoom_inset(input);

      
      mojo::internal::Serialize<::skia::mojom::TileMode>(
        Traits::blur_tile_mode(input),
        &fragment->blur_tile_mode);

      decltype(Traits::shape(input)) in_shape = Traits::shape(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->shape)::BaseType>
          shape_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& shape_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>, send_validation>(
        in_shape,
        shape_fragment,
        &shape_validate_params);

      fragment->shape.Set(
          shape_fragment.is_null() ? nullptr : shape_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FILTER_OPERATION_MOJOM_SEND_VALIDATION_H_