// services/viz/public/mojom/compositing/copy_output_request.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('viz.mojom.CopyOutputResultDestination');
goog.require('viz.mojom.CopyOutputResultFormat');
goog.require('viz.mojom.BlitRequest');
goog.require('viz.mojom.CopyOutputResult');
goog.require('gfx.mojom.Rect');
goog.require('mojoBase.mojom.TimeDelta');
goog.require('mojoBase.mojom.UnguessableToken');
goog.require('gfx.mojom.Vector2d');






goog.provide('viz.mojom.CopyOutputResultSender');
goog.provide('viz.mojom.CopyOutputResultSenderReceiver');
goog.provide('viz.mojom.CopyOutputResultSenderCallbackRouter');
goog.provide('viz.mojom.CopyOutputResultSenderInterface');
goog.provide('viz.mojom.CopyOutputResultSenderRemote');
goog.provide('viz.mojom.CopyOutputResultSenderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
viz.mojom.CopyOutputResultSenderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        viz.mojom.CopyOutputResultSender.$interfaceName,
        scope);
  }
};

/** @interface */
viz.mojom.CopyOutputResultSenderInterface = class {
  
  /**
   * @param { !viz.mojom.CopyOutputResult } result
   */

  sendResult(result) {}
};

/**
 * @export
 * @implements { viz.mojom.CopyOutputResultSenderInterface }
 */
viz.mojom.CopyOutputResultSenderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!viz.mojom.CopyOutputResultSenderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          viz.mojom.CopyOutputResultSenderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!viz.mojom.CopyOutputResultSenderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !viz.mojom.CopyOutputResult } result
   */

  sendResult(
      result) {
    this.proxy.sendMessage(
        0,
        viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CopyOutputResultSender
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
viz.mojom.CopyOutputResultSenderReceiver = class {
  /**
   * @param {!viz.mojom.CopyOutputResultSenderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!viz.mojom.CopyOutputResultSenderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        viz.mojom.CopyOutputResultSenderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CopyOutputResultSenderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        impl.sendResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
viz.mojom.CopyOutputResultSender = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "viz.mojom.CopyOutputResultSender";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!viz.mojom.CopyOutputResultSenderRemote}
   * @export
   */
  static getRemote() {
    let remote = new viz.mojom.CopyOutputResultSenderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CopyOutputResultSender
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
viz.mojom.CopyOutputResultSenderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      viz.mojom.CopyOutputResultSenderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!viz.mojom.CopyOutputResultSenderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec.$,
        null,
        this.sendResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('viz.mojom.CopyOutputRequestSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CopyOutputRequestSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    viz.mojom.CopyOutputRequestSpec.$,
    'CopyOutputRequest',
    [
      mojo.internal.StructField(
        'resultFormat', 0,
        0,
        viz.mojom.CopyOutputResultFormatSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultDestination', 4,
        0,
        viz.mojom.CopyOutputResultDestinationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendResultDelay', 8,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scaleFrom', 16,
        0,
        gfx.mojom.Vector2dSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'scaleTo', 24,
        0,
        gfx.mojom.Vector2dSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 32,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'area', 40,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultSelection', 48,
        0,
        gfx.mojom.RectSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blitRequest', 56,
        0,
        viz.mojom.BlitRequestSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'resultSender', 64,
        0,
        mojo.internal.InterfaceProxy(viz.mojom.CopyOutputResultSenderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('viz.mojom.CopyOutputRequest');

/** @record */
viz.mojom.CopyOutputRequest = class {
  constructor() {
    /** @export { !viz.mojom.CopyOutputResultFormat } */
    this.resultFormat;
    /** @export { !viz.mojom.CopyOutputResultDestination } */
    this.resultDestination;
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.sendResultDelay;
    /** @export { !gfx.mojom.Vector2d } */
    this.scaleFrom;
    /** @export { !gfx.mojom.Vector2d } */
    this.scaleTo;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.source;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.area;
    /** @export { (gfx.mojom.Rect|undefined) } */
    this.resultSelection;
    /** @export { (viz.mojom.BlitRequest|undefined) } */
    this.blitRequest;
    /** @export { !viz.mojom.CopyOutputResultSenderRemote } */
    this.resultSender;
  }
};



mojo.internal.Struct(
    viz.mojom.CopyOutputResultSender_SendResult_ParamsSpec.$,
    'CopyOutputResultSender_SendResult_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        viz.mojom.CopyOutputResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('viz.mojom.CopyOutputResultSender_SendResult_Params');

/** @record */
viz.mojom.CopyOutputResultSender_SendResult_Params = class {
  constructor() {
    /** @export { !viz.mojom.CopyOutputResult } */
    this.result;
  }
};

