// services/viz/public/mojom/compositing/blit_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/blit_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/blit_request.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* LetterboxingBehaviorToStringHelper(LetterboxingBehavior value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LetterboxingBehavior::kDoNotLetterbox:
      return "kDoNotLetterbox";
    case LetterboxingBehavior::kLetterbox:
      return "kLetterbox";
    default:
      return nullptr;
  }
}

std::string LetterboxingBehaviorToString(LetterboxingBehavior value) {
  const char *str = LetterboxingBehaviorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LetterboxingBehavior value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LetterboxingBehavior value) {
  return os << LetterboxingBehaviorToString(value);
}

namespace internal {


// static
bool BlitRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BlitRequest_Data* object =
      static_cast<const BlitRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->destination_region_offset, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->destination_region_offset, validation_context))
    return false;


  if (!::viz::mojom::internal::LetterboxingBehavior_Data
        ::Validate(object->letterboxing_behavior, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_image, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

BlitRequest_Data::BlitRequest_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::LetterboxingBehavior>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::LetterboxingBehavior value) {
  return std::move(context).WriteString(::viz::mojom::LetterboxingBehaviorToString(value));
}

} // namespace perfetto