// services/viz/public/mojom/compositing/animation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ElementId as cc_mojom_ElementId,
  ElementIdSpec as cc_mojom_ElementIdSpec
} from '../../../../../cc/mojom/element_id.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  SkColor as skia_mojom_SkColor,
  SkColorSpec as skia_mojom_SkColorSpec
} from '../../../../../skia/public/mojom/skcolor.mojom.m.js';

import {
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec,
  SizeF as gfx_mojom_SizeF,
  SizeFSpec as gfx_mojom_SizeFSpec,
  Vector2dF as gfx_mojom_Vector2dF,
  Vector2dFSpec as gfx_mojom_Vector2dFSpec,
  Vector3dF as gfx_mojom_Vector3dF,
  Vector3dFSpec as gfx_mojom_Vector3dFSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Transform as gfx_mojom_Transform,
  TransformSpec as gfx_mojom_TransformSpec
} from '../../../../../ui/gfx/mojom/transform.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const TimingStepPositionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const TimingStepPosition = {
  
  kStart: 0,
  kEnd: 1,
  kJumpBoth: 2,
  kJumpEnd: 3,
  kJumpNone: 4,
  kJumpStart: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AnimationDirectionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AnimationDirection = {
  
  kNormal: 0,
  kReverse: 1,
  kAlternateNormal: 2,
  kAlternateReverse: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AnimationFillModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AnimationFillMode = {
  
  kNone: 0,
  kForwards: 1,
  kBackwards: 2,
  kBoth: 3,
  kAuto: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CubicBezierTimingFunctionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StepsTimingFunctionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const LinearEasingPointSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AxisAngleSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnimationKeyframeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnimationKeyframeModelSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnimationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AnimationTimelineSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TimingFunctionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TransformOperationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AnimationKeyframeValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CubicBezierTimingFunctionSpec.$,
    'CubicBezierTimingFunction',
    [
      mojo.internal.StructField(
        'x1', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'y1', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'x2', 16,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'y2', 24,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CubicBezierTimingFunction {
  constructor() {
    /** @type { !number } */
    this.x1;
    /** @type { !number } */
    this.y1;
    /** @type { !number } */
    this.x2;
    /** @type { !number } */
    this.y2;
  }
}



mojo.internal.Struct(
    StepsTimingFunctionSpec.$,
    'StepsTimingFunction',
    [
      mojo.internal.StructField(
        'numSteps', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stepPosition', 4,
        0,
        TimingStepPositionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StepsTimingFunction {
  constructor() {
    /** @type { !number } */
    this.numSteps;
    /** @type { !TimingStepPosition } */
    this.stepPosition;
  }
}



mojo.internal.Struct(
    LinearEasingPointSpec.$,
    'LinearEasingPoint',
    [
      mojo.internal.StructField(
        'in', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'out', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class LinearEasingPoint {
  constructor() {
    /** @type { !number } */
    this.in;
    /** @type { !number } */
    this.out;
  }
}



mojo.internal.Struct(
    AxisAngleSpec.$,
    'AxisAngle',
    [
      mojo.internal.StructField(
        'axis', 0,
        0,
        gfx_mojom_Vector3dFSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'angle', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AxisAngle {
  constructor() {
    /** @type { !gfx_mojom_Vector3dF } */
    this.axis;
    /** @type { !number } */
    this.angle;
  }
}



mojo.internal.Struct(
    AnimationKeyframeSpec.$,
    'AnimationKeyframe',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        AnimationKeyframeValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTime', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingFunction', 24,
        0,
        TimingFunctionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class AnimationKeyframe {
  constructor() {
    /** @type { !AnimationKeyframeValue } */
    this.value;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.startTime;
    /** @type { (TimingFunction|undefined) } */
    this.timingFunction;
  }
}



mojo.internal.Struct(
    AnimationKeyframeModelSpec.$,
    'AnimationKeyframeModel',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetPropertyType', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'elementId', 16,
        0,
        cc_mojom_ElementIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timingFunction', 24,
        0,
        TimingFunctionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyframes', 40,
        0,
        mojo.internal.Array(AnimationKeyframeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scaledDuration', 48,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'direction', 12,
        0,
        AnimationDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fillMode', 56,
        0,
        AnimationFillModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'playbackRate', 64,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iterations', 72,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'iterationStart', 80,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'timeOffset', 88,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 104],]);



/**
 * @record
 */
export class AnimationKeyframeModel {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !number } */
    this.groupId;
    /** @type { !number } */
    this.targetPropertyType;
    /** @type { !cc_mojom_ElementId } */
    this.elementId;
    /** @type { !TimingFunction } */
    this.timingFunction;
    /** @type { !Array<!AnimationKeyframe> } */
    this.keyframes;
    /** @type { !number } */
    this.scaledDuration;
    /** @type { !AnimationDirection } */
    this.direction;
    /** @type { !AnimationFillMode } */
    this.fillMode;
    /** @type { !number } */
    this.playbackRate;
    /** @type { !number } */
    this.iterations;
    /** @type { !number } */
    this.iterationStart;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timeOffset;
  }
}



mojo.internal.Struct(
    AnimationSpec.$,
    'Animation',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'elementId', 8,
        0,
        cc_mojom_ElementIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keyframeModels', 16,
        0,
        mojo.internal.Array(AnimationKeyframeModelSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Animation {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !cc_mojom_ElementId } */
    this.elementId;
    /** @type { !Array<!AnimationKeyframeModel> } */
    this.keyframeModels;
  }
}



mojo.internal.Struct(
    AnimationTimelineSpec.$,
    'AnimationTimeline',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newAnimations', 8,
        0,
        mojo.internal.Array(AnimationSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'removedAnimations', 16,
        0,
        mojo.internal.Array(mojo.internal.Int32, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AnimationTimeline {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !Array<!Animation> } */
    this.newAnimations;
    /** @type { !Array<!number> } */
    this.removedAnimations;
  }
}

mojo.internal.Union(
    TimingFunctionSpec.$, 'TimingFunction',
    {
      'cubicBezier': {
        'ordinal': 0,
        'type': CubicBezierTimingFunctionSpec.$,
      },
      'steps': {
        'ordinal': 1,
        'type': StepsTimingFunctionSpec.$,
      },
      'linear': {
        'ordinal': 2,
        'type': mojo.internal.Array(LinearEasingPointSpec.$, false),
      },
    });

/**
 * @typedef { {
 *   cubicBezier: (!CubicBezierTimingFunction|undefined),
 *   steps: (!StepsTimingFunction|undefined),
 *   linear: (!Array<!LinearEasingPoint>|undefined),
 * } }
 */
export const TimingFunction = {};
mojo.internal.Union(
    TransformOperationSpec.$, 'TransformOperation',
    {
      'identity': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'perspectiveDepth': {
        'ordinal': 1,
        'type': mojo.internal.Float,
      },
      'skew': {
        'ordinal': 2,
        'type': gfx_mojom_Vector2dFSpec.$,
      },
      'scale': {
        'ordinal': 3,
        'type': gfx_mojom_Vector3dFSpec.$,
      },
      'translate': {
        'ordinal': 4,
        'type': gfx_mojom_Vector3dFSpec.$,
      },
      'rotate': {
        'ordinal': 5,
        'type': AxisAngleSpec.$,
      },
      'matrix': {
        'ordinal': 6,
        'type': gfx_mojom_TransformSpec.$,
      },
    });

/**
 * @typedef { {
 *   identity: (!boolean|undefined),
 *   perspectiveDepth: (!number|undefined),
 *   skew: (!gfx_mojom_Vector2dF|undefined),
 *   scale: (!gfx_mojom_Vector3dF|undefined),
 *   translate: (!gfx_mojom_Vector3dF|undefined),
 *   rotate: (!AxisAngle|undefined),
 *   matrix: (!gfx_mojom_Transform|undefined),
 * } }
 */
export const TransformOperation = {};
mojo.internal.Union(
    AnimationKeyframeValueSpec.$, 'AnimationKeyframeValue',
    {
      'scalar': {
        'ordinal': 0,
        'type': mojo.internal.Float,
      },
      'color': {
        'ordinal': 1,
        'type': skia_mojom_SkColorSpec.$,
      },
      'size': {
        'ordinal': 2,
        'type': gfx_mojom_SizeFSpec.$,
      },
      'rect': {
        'ordinal': 3,
        'type': gfx_mojom_RectSpec.$,
      },
      'transform': {
        'ordinal': 4,
        'type': mojo.internal.Array(TransformOperationSpec.$, false),
      },
    });

/**
 * @typedef { {
 *   scalar: (!number|undefined),
 *   color: (!skia_mojom_SkColor|undefined),
 *   size: (!gfx_mojom_SizeF|undefined),
 *   rect: (!gfx_mojom_Rect|undefined),
 *   transform: (!Array<!TransformOperation>|undefined),
 * } }
 */
export const AnimationKeyframeValue = {};
