// services/viz/privileged/mojom/gl/gpu_host.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/gl/gpu_host.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_disk_cache_type.mojom.h"
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "gpu/ipc/common/gpu_info.mojom.h"
#include "gpu/ipc/common/surface_handle.mojom-forward.h"
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "services/viz/privileged/mojom/gl/context_lost_reason.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "ui/gfx/mojom/gpu_extra_info.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace viz::mojom {

class GpuHostProxy;

template <typename ImplRefTraits>
class GpuHostStub;

class GpuHostRequestValidator;
class GpuHostResponseValidator;


class GpuHost
    : public GpuHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.GpuHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GpuHostInterfaceBase;
  using Proxy_ = GpuHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuHostStub<ImplRefTraits>;

  using RequestValidator_ = GpuHostRequestValidator;
  using ResponseValidator_ = GpuHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDidInitializeMinVersion = 0,
    kDidFailInitializeMinVersion = 0,
    kDidCreateContextSuccessfullyMinVersion = 0,
    kDidCreateOffscreenContextMinVersion = 0,
    kDidDestroyOffscreenContextMinVersion = 0,
    kDidDestroyChannelMinVersion = 0,
    kDidDestroyAllChannelsMinVersion = 0,
    kDidLoseContextMinVersion = 0,
    kDidUpdateGPUInfoMinVersion = 0,
    kDisableGpuCompositingMinVersion = 0,
    kGetIsolationKeyMinVersion = 0,
    kStoreBlobToDiskMinVersion = 0,
    kClearGrShaderDiskCacheMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidInitialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidFailInitialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCreateContextSuccessfully_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidCreateOffscreenContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDestroyOffscreenContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDestroyChannel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidDestroyAllChannels_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidLoseContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidUpdateGPUInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableGpuCompositing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetIsolationKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StoreBlobToDisk_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearGrShaderDiskCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuHost() = default;

  virtual void DidInitialize(const ::gpu::GPUInfo& gpu_info, const ::gpu::GpuFeatureInfo& gpu_feature_info, const std::optional<::gpu::GPUInfo>& gpu_info_for_hardware_gpu, const std::optional<::gpu::GpuFeatureInfo>& gpu_feature_info_for_hardware_gpu, const ::gfx::GpuExtraInfo& gpu_extra_info) = 0;

  virtual void DidFailInitialize() = 0;

  virtual void DidCreateContextSuccessfully() = 0;

  virtual void DidCreateOffscreenContext(const ::GURL& url) = 0;

  virtual void DidDestroyOffscreenContext(const ::GURL& url) = 0;

  virtual void DidDestroyChannel(int32_t client_id) = 0;

  virtual void DidDestroyAllChannels() = 0;

  virtual void DidLoseContext(::gpu::error::ContextLostReason reason, const ::GURL& active_url) = 0;

  virtual void DidUpdateGPUInfo(const ::gpu::GPUInfo& gpu_info) = 0;

  virtual void DisableGpuCompositing() = 0;

  using GetIsolationKeyCallback = base::OnceCallback<void(const std::string&)>;
  using GetIsolationKeyMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetIsolationKey(int32_t client_id, const ::blink::WebGPUExecutionContextToken& wgpu_context_token, GetIsolationKeyCallback callback) = 0;

  virtual void StoreBlobToDisk(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& blob) = 0;

  virtual void ClearGrShaderDiskCache() = 0;
};



class  GpuHostProxy
    : public GpuHost {
 public:
  using InterfaceType = GpuHost;

  explicit GpuHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidInitialize(const ::gpu::GPUInfo& gpu_info, const ::gpu::GpuFeatureInfo& gpu_feature_info, const std::optional<::gpu::GPUInfo>& gpu_info_for_hardware_gpu, const std::optional<::gpu::GpuFeatureInfo>& gpu_feature_info_for_hardware_gpu, const ::gfx::GpuExtraInfo& gpu_extra_info) final;
  
  void DidFailInitialize() final;
  
  void DidCreateContextSuccessfully() final;
  
  void DidCreateOffscreenContext(const ::GURL& url) final;
  
  void DidDestroyOffscreenContext(const ::GURL& url) final;
  
  void DidDestroyChannel(int32_t client_id) final;
  
  void DidDestroyAllChannels() final;
  
  void DidLoseContext(::gpu::error::ContextLostReason reason, const ::GURL& active_url) final;
  
  void DidUpdateGPUInfo(const ::gpu::GPUInfo& gpu_info) final;
  
  void DisableGpuCompositing() final;
  
  void GetIsolationKey(int32_t client_id, const ::blink::WebGPUExecutionContextToken& wgpu_context_token, GetIsolationKeyCallback callback) final;
  
  void StoreBlobToDisk(const ::gpu::GpuDiskCacheHandle& cache_handle, const std::string& key, const std::string& blob) final;
  
  void ClearGrShaderDiskCache() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GpuHostStubDispatch {
 public:
  static bool Accept(GpuHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuHost>>
class GpuHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuHostStub() = default;
  ~GpuHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GpuHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // viz::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_H_