// services/video_capture/public/mojom/video_capture_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/video_capture_service.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_capture_service.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/video_capture_service.mojom-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "services/video_capture/public/mojom/testing_controls.mojom-forward.h"
#include "services/video_capture/public/mojom/video_source_provider.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"





constexpr ::sandbox::mojom::Sandbox kVideoCaptureSandbox = ::sandbox::mojom::Sandbox::kNoSandbox;


namespace video_capture::mojom {

class VideoCaptureServiceProxy;

template <typename ImplRefTraits>
class VideoCaptureServiceStub;

class VideoCaptureServiceRequestValidator;


class VideoCaptureService
    : public VideoCaptureServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "video_capture.mojom.VideoCaptureService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoCaptureServiceInterfaceBase;
  using Proxy_ = VideoCaptureServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoCaptureServiceStub<ImplRefTraits>;

  using RequestValidator_ = VideoCaptureServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kConnectToVideoSourceProviderMinVersion = 0,
    kBindControlsForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ConnectToVideoSourceProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindControlsForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoCaptureService() = default;

  virtual void ConnectToVideoSourceProvider(::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> receiver) = 0;

  virtual void BindControlsForTesting(::mojo::PendingReceiver<::video_capture::mojom::TestingControls> receiver) = 0;
};



class  VideoCaptureServiceProxy
    : public VideoCaptureService {
 public:
  using InterfaceType = VideoCaptureService;

  explicit VideoCaptureServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ConnectToVideoSourceProvider(::mojo::PendingReceiver<::video_capture::mojom::VideoSourceProvider> receiver) final;
  
  void BindControlsForTesting(::mojo::PendingReceiver<::video_capture::mojom::TestingControls> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoCaptureServiceStubDispatch {
 public:
  static bool Accept(VideoCaptureService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoCaptureService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoCaptureService>>
class VideoCaptureServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoCaptureServiceStub() = default;
  ~VideoCaptureServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoCaptureServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoCaptureServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_CAPTURE_SERVICE_MOJOM_H_