// services/tracing/public/mojom/traced_process.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/tracing/public/mojom/traced_process.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/tracing/public/mojom/traced_process.mojom-params-data.h"
#include "services/tracing/public/mojom/traced_process.mojom-shared-message-ids.h"

#include "services/tracing/public/mojom/traced_process.mojom-import-headers.h"
#include "services/tracing/public/mojom/traced_process.mojom-test-utils.h"


namespace tracing::mojom {
ConnectToTracingRequest::ConnectToTracingRequest()
    : perfetto_service() {}

ConnectToTracingRequest::ConnectToTracingRequest(
    ::mojo::PendingRemote<::tracing::mojom::PerfettoService> perfetto_service_in)
    : perfetto_service(std::move(perfetto_service_in)) {}

ConnectToTracingRequest::~ConnectToTracingRequest() = default;

void ConnectToTracingRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "perfetto_service"), this->perfetto_service,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::tracing::mojom::PerfettoService>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectToTracingRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TracedProcess::IPCStableHashFunction TracedProcess::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TracedProcess>(message.name())) {
    case messages::TracedProcess::kConnectToTracingService: {
      return &TracedProcess::ConnectToTracingService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TracedProcess::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TracedProcess>(message.name())) {
      case messages::TracedProcess::kConnectToTracingService:
            return "Receive tracing::mojom::TracedProcess::ConnectToTracingService";
    }
  } else {
    switch (static_cast<messages::TracedProcess>(message.name())) {
      case messages::TracedProcess::kConnectToTracingService:
            return "Receive reply tracing::mojom::TracedProcess::ConnectToTracingService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TracedProcess::ConnectToTracingService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef28ed59;  // IPCStableHash for tracing::mojom::TracedProcess::ConnectToTracingService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TracedProcess_ConnectToTracingService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TracedProcess_ConnectToTracingService_ForwardToCallback(
      TracedProcess::ConnectToTracingServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  TracedProcess_ConnectToTracingService_ForwardToCallback(const TracedProcess_ConnectToTracingService_ForwardToCallback&) = delete;
  TracedProcess_ConnectToTracingService_ForwardToCallback& operator=(const TracedProcess_ConnectToTracingService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TracedProcess::ConnectToTracingServiceCallback callback_;
};

TracedProcessProxy::TracedProcessProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TracedProcessProxy::ConnectToTracingService(
    ConnectToTracingRequestPtr in_request, ConnectToTracingServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tracing::mojom::TracedProcess::ConnectToTracingService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request"), in_request,
                        "<value of type ConnectToTracingRequestPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TracedProcess::kConnectToTracingService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracedProcess_ConnectToTracingService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->request)::BaseType> request_fragment(
          params.message());
  
  mojo::internal::Serialize<::tracing::mojom::ConnectToTracingRequestDataView>(
    in_request,
    request_fragment);

  params->request.Set(
      request_fragment.is_null() ? nullptr : request_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->request.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null request in TracedProcess.ConnectToTracingService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracedProcess::Name_);
  message.set_method_name("ConnectToTracingService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TracedProcess_ConnectToTracingService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TracedProcess_ConnectToTracingService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TracedProcess::ConnectToTracingServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TracedProcess_ConnectToTracingService_ProxyToResponder> proxy(
        new TracedProcess_ConnectToTracingService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TracedProcess_ConnectToTracingService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TracedProcess_ConnectToTracingService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TracedProcess_ConnectToTracingService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TracedProcess::ConnectToTracingServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool TracedProcess_ConnectToTracingService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TracedProcess_ConnectToTracingService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TracedProcess_ConnectToTracingService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TracedProcess.0
  bool success = true;
  TracedProcess_ConnectToTracingService_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TracedProcess::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void TracedProcess_ConnectToTracingService_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply tracing::mojom::TracedProcess::ConnectToTracingService");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TracedProcess::kConnectToTracingService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tracing::mojom::internal::TracedProcess_ConnectToTracingService_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TracedProcess::Name_);
  message.set_method_name("ConnectToTracingService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TracedProcessStubDispatch::Accept(
    TracedProcess* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TracedProcess>(message->header()->name)) {
    case messages::TracedProcess::kConnectToTracingService: {
      break;
    }
  }
  return false;
}

// static
bool TracedProcessStubDispatch::AcceptWithResponder(
    TracedProcess* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TracedProcess>(message->header()->name)) {
    case messages::TracedProcess::kConnectToTracingService: {
      internal::TracedProcess_ConnectToTracingService_Params_Data* params =
          reinterpret_cast<
              internal::TracedProcess_ConnectToTracingService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TracedProcess.0
      bool success = true;
      ConnectToTracingRequestPtr p_request{};
      TracedProcess_ConnectToTracingService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TracedProcess::Name_, 0, false);
        return false;
      }
      auto callback =
          TracedProcess_ConnectToTracingService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToTracingService(        
        std::move(p_request), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTracedProcessValidationInfo[] = {
    { &internal::TracedProcess_ConnectToTracingService_Params_Data::Validate,
     &internal::TracedProcess_ConnectToTracingService_ResponseParams_Data::Validate},
};

bool TracedProcessRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tracing::mojom::TracedProcess::Name_,
    kTracedProcessValidationInfo);
}

bool TracedProcessResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tracing::mojom::TracedProcess::Name_,
    kTracedProcessValidationInfo);
}


}  // tracing::mojom


namespace mojo {


// static
bool StructTraits<::tracing::mojom::ConnectToTracingRequest::DataView, ::tracing::mojom::ConnectToTracingRequestPtr>::Read(
    ::tracing::mojom::ConnectToTracingRequest::DataView input,
    ::tracing::mojom::ConnectToTracingRequestPtr* output) {
  bool success = true;
  ::tracing::mojom::ConnectToTracingRequestPtr result(::tracing::mojom::ConnectToTracingRequest::New());
  
      if (success) {
        result->perfetto_service =
            input.TakePerfettoService<decltype(result->perfetto_service)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tracing::mojom {


void TracedProcessInterceptorForTesting::ConnectToTracingService(ConnectToTracingRequestPtr request, ConnectToTracingServiceCallback callback) {
  GetForwardingInterface()->ConnectToTracingService(
    std::move(request)
    , std::move(callback));
}
TracedProcessAsyncWaiter::TracedProcessAsyncWaiter(
    TracedProcess* proxy) : proxy_(proxy) {}

TracedProcessAsyncWaiter::~TracedProcessAsyncWaiter() = default;


void TracedProcessAsyncWaiter::ConnectToTracingService(
    ConnectToTracingRequestPtr request) {
  base::RunLoop loop;
  proxy_->ConnectToTracingService(
      std::move(request),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // tracing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif