// services/service_manager/public/mojom/service_control.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/service_control.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/service_control.mojom-params-data.h"
#include "services/service_manager/public/mojom/service_control.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/service_control.mojom-blink-import-headers.h"
#include "services/service_manager/public/mojom/service_control.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace service_manager::mojom::blink {
// The declaration includes the definition on other builds.

ServiceControl::IPCStableHashFunction ServiceControl::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceControl>(message.name())) {
    case messages::ServiceControl::kRequestQuit: {
      return &ServiceControl::RequestQuit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceControl::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceControl>(message.name())) {
      case messages::ServiceControl::kRequestQuit:
            return "Receive service_manager::mojom::ServiceControl::RequestQuit";
    }
  } else {
    switch (static_cast<messages::ServiceControl>(message.name())) {
      case messages::ServiceControl::kRequestQuit:
            return "Receive reply service_manager::mojom::ServiceControl::RequestQuit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceControl::RequestQuit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde7107c8;  // IPCStableHash for service_manager::mojom::ServiceControl::RequestQuit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceControlProxy::ServiceControlProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceControlProxy::RequestQuit(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send service_manager::mojom::ServiceControl::RequestQuit");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceControl::kRequestQuit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ServiceControl_RequestQuit_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceControl::Name_);
  message.set_method_name("RequestQuit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceControlStubDispatch::Accept(
    ServiceControl* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceControl>(message->header()->name)) {
    case messages::ServiceControl::kRequestQuit: {
      DCHECK(message->is_serialized());
      internal::ServiceControl_RequestQuit_Params_Data* params =
          reinterpret_cast<internal::ServiceControl_RequestQuit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceControl.0
      bool success = true;
      ServiceControl_RequestQuit_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceControl::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestQuit(        );
      return true;
    }
  }
  return false;
}

// static
bool ServiceControlStubDispatch::AcceptWithResponder(
    ServiceControl* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceControl>(message->header()->name)) {
    case messages::ServiceControl::kRequestQuit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceControlValidationInfo[] = {
    { &internal::ServiceControl_RequestQuit_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceControlRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::ServiceControl::Name_,
    kServiceControlValidationInfo);
}



}  // service_manager::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace service_manager::mojom::blink {


void ServiceControlInterceptorForTesting::RequestQuit() {
  GetForwardingInterface()->RequestQuit();
}
ServiceControlAsyncWaiter::ServiceControlAsyncWaiter(
    ServiceControl* proxy) : proxy_(proxy) {}

ServiceControlAsyncWaiter::~ServiceControlAsyncWaiter() = default;







}  // service_manager::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif