// services/service_manager/public/mojom/service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/service.mojom-params-data.h"
#include "services/service_manager/public/mojom/service.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/service.mojom-blink-import-headers.h"
#include "services/service_manager/public/mojom/service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace service_manager::mojom::blink {
BindSourceInfo::BindSourceInfo()
    : identity(),
      required_capabilities() {}

BindSourceInfo::BindSourceInfo(
    ::service_manager::mojom::blink::IdentityPtr identity_in,
    ::service_manager::mojom::blink::CapabilitySetPtr required_capabilities_in)
    : identity(std::move(identity_in)),
      required_capabilities(std::move(required_capabilities_in)) {}

BindSourceInfo::~BindSourceInfo() = default;

void BindSourceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identity"), this->identity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::service_manager::mojom::blink::IdentityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "required_capabilities"), this->required_capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::service_manager::mojom::blink::CapabilitySetPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BindSourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

Service::IPCStableHashFunction Service::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Service>(message.name())) {
    case messages::Service::kOnStart: {
      return &Service::OnStart_Sym::IPCStableHash;
    }
    case messages::Service::kOnBindInterface: {
      return &Service::OnBindInterface_Sym::IPCStableHash;
    }
    case messages::Service::kCreatePackagedServiceInstance: {
      return &Service::CreatePackagedServiceInstance_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Service::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Service>(message.name())) {
      case messages::Service::kOnStart:
            return "Receive service_manager::mojom::Service::OnStart";
      case messages::Service::kOnBindInterface:
            return "Receive service_manager::mojom::Service::OnBindInterface";
      case messages::Service::kCreatePackagedServiceInstance:
            return "Receive service_manager::mojom::Service::CreatePackagedServiceInstance";
    }
  } else {
    switch (static_cast<messages::Service>(message.name())) {
      case messages::Service::kOnStart:
            return "Receive reply service_manager::mojom::Service::OnStart";
      case messages::Service::kOnBindInterface:
            return "Receive reply service_manager::mojom::Service::OnBindInterface";
      case messages::Service::kCreatePackagedServiceInstance:
            return "Receive reply service_manager::mojom::Service::CreatePackagedServiceInstance";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Service::OnStart_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x980d9d3a;  // IPCStableHash for service_manager::mojom::Service::OnStart
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Service::OnBindInterface_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x109bc3fb;  // IPCStableHash for service_manager::mojom::Service::OnBindInterface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Service::CreatePackagedServiceInstance_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf82b5ea8;  // IPCStableHash for service_manager::mojom::Service::CreatePackagedServiceInstance
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Service_OnStart_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Service_OnStart_ForwardToCallback(
      Service::OnStartCallback callback
      ) : callback_(std::move(callback)) {
  }

  Service_OnStart_ForwardToCallback(const Service_OnStart_ForwardToCallback&) = delete;
  Service_OnStart_ForwardToCallback& operator=(const Service_OnStart_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Service::OnStartCallback callback_;
};

class Service_OnBindInterface_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Service_OnBindInterface_ForwardToCallback(
      Service::OnBindInterfaceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Service_OnBindInterface_ForwardToCallback(const Service_OnBindInterface_ForwardToCallback&) = delete;
  Service_OnBindInterface_ForwardToCallback& operator=(const Service_OnBindInterface_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Service::OnBindInterfaceCallback callback_;
};

ServiceProxy::ServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceProxy::OnStart(
    ::service_manager::mojom::blink::IdentityPtr in_identity, OnStartCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Service::OnStart", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Service::kOnStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Service_OnStart_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in Service.OnStart request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnStart");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Service_OnStart_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceProxy::OnBindInterface(
    BindSourceInfoPtr in_source, const ::blink::String& in_interface_name, ::mojo::ScopedMessagePipeHandle in_interface_pipe, OnBindInterfaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Service::OnBindInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type BindSourceInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_pipe"), in_interface_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Service::kOnBindInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Service_OnBindInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source)::BaseType> source_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::BindSourceInfoDataView>(
    in_source,
    source_fragment);

  params->source.Set(
      source_fragment.is_null() ? nullptr : source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source in Service.OnBindInterface request");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_interface_name,
    interface_name_fragment);

  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interface_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interface_name in Service.OnBindInterface request");

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_interface_pipe,
    &params->interface_pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->interface_pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid interface_pipe in Service.OnBindInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnBindInterface");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Service_OnBindInterface_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ServiceProxy::CreatePackagedServiceInstance(
    ::service_manager::mojom::blink::IdentityPtr in_identity, ::mojo::PendingReceiver<Service> in_receiver, ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Service::CreatePackagedServiceInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type ::service_manager::mojom::blink::IdentityPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Service>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Service::kCreatePackagedServiceInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Service_CreatePackagedServiceInstance_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in Service.CreatePackagedServiceInstance request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ServiceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Service.CreatePackagedServiceInstance request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::service_manager::mojom::ProcessMetadataInterfaceBase>>(
    in_metadata,
    &params->metadata,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->metadata)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid metadata in Service.CreatePackagedServiceInstance request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("CreatePackagedServiceInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Service_OnStart_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Service::OnStartCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Service_OnStart_ProxyToResponder> proxy(
        new Service_OnStart_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Service_OnStart_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Service_OnStart_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Service_OnStart_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Service::OnStartCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector> in_connector_receiver, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl> in_control_receiver);
};

bool Service_OnStart_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Service_OnStart_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Service_OnStart_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Service.0
  bool success = true;
  ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector> p_connector_receiver{};
  ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl> p_control_receiver{};
  Service_OnStart_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_connector_receiver =
        input_data_view.TakeConnectorReceiver<decltype(p_connector_receiver)>();
  }
  if (success) {
    p_control_receiver =
        input_data_view.TakeControlReceiver<decltype(p_control_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Service::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_connector_receiver), 
std::move(p_control_receiver));
  }
  return true;
}

void Service_OnStart_ProxyToResponder::Run(
    ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector> in_connector_receiver, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl> in_control_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply service_manager::mojom::Service::OnStart", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connector_receiver"), in_connector_receiver,
                        "<value of type ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("control_receiver"), in_control_receiver,
                        "<value of type ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Service::kOnStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Service_OnStart_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ConnectorInterfaceBase>>(
    in_connector_receiver,
    &params->connector_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->connector_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid connector_receiver in ");

  
  mojo::internal::Serialize<::service_manager::mojom::ServiceControlAssociatedRequestDataView>(
    in_control_receiver,
    &params->control_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->control_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid control_receiver in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnStart");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Service_OnBindInterface_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Service::OnBindInterfaceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Service_OnBindInterface_ProxyToResponder> proxy(
        new Service_OnBindInterface_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Service_OnBindInterface_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Service_OnBindInterface_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Service_OnBindInterface_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Service::OnBindInterfaceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Service_OnBindInterface_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Service_OnBindInterface_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Service_OnBindInterface_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Service.1
  bool success = true;
  Service_OnBindInterface_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Service::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Service_OnBindInterface_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply service_manager::mojom::Service::OnBindInterface");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Service::kOnBindInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Service_OnBindInterface_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnBindInterface");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceStubDispatch::Accept(
    Service* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Service>(message->header()->name)) {
    case messages::Service::kOnStart: {
      break;
    }
    case messages::Service::kOnBindInterface: {
      break;
    }
    case messages::Service::kCreatePackagedServiceInstance: {
      DCHECK(message->is_serialized());
      internal::Service_CreatePackagedServiceInstance_Params_Data* params =
          reinterpret_cast<internal::Service_CreatePackagedServiceInstance_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Service.2
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      ::mojo::PendingReceiver<Service> p_receiver{};
      ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata> p_metadata{};
      Service_CreatePackagedServiceInstance_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_metadata =
            input_data_view.TakeMetadata<decltype(p_metadata)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePackagedServiceInstance(        
        std::move(p_identity), 
        std::move(p_receiver), 
        std::move(p_metadata));
      return true;
    }
  }
  return false;
}

// static
bool ServiceStubDispatch::AcceptWithResponder(
    Service* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Service>(message->header()->name)) {
    case messages::Service::kOnStart: {
      internal::Service_OnStart_Params_Data* params =
          reinterpret_cast<
              internal::Service_OnStart_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Service.0
      bool success = true;
      ::service_manager::mojom::blink::IdentityPtr p_identity{};
      Service_OnStart_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 0, false);
        return false;
      }
      auto callback =
          Service_OnStart_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStart(        
        std::move(p_identity), std::move(callback));
      return true;
    }
    case messages::Service::kOnBindInterface: {
      internal::Service_OnBindInterface_Params_Data* params =
          reinterpret_cast<
              internal::Service_OnBindInterface_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Service.1
      bool success = true;
      BindSourceInfoPtr p_source{};
      ::blink::String p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_interface_pipe{};
      Service_OnBindInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_interface_pipe = input_data_view.TakeInterfacePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 1, false);
        return false;
      }
      auto callback =
          Service_OnBindInterface_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBindInterface(        
        std::move(p_source), 
        std::move(p_interface_name), 
        std::move(p_interface_pipe), std::move(callback));
      return true;
    }
    case messages::Service::kCreatePackagedServiceInstance: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceValidationInfo[] = {
    { &internal::Service_OnStart_Params_Data::Validate,
     &internal::Service_OnStart_ResponseParams_Data::Validate},
    { &internal::Service_OnBindInterface_Params_Data::Validate,
     &internal::Service_OnBindInterface_ResponseParams_Data::Validate},
    { &internal::Service_CreatePackagedServiceInstance_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::Service::Name_,
    kServiceValidationInfo);
}

bool ServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::service_manager::mojom::blink::Service::Name_,
    kServiceValidationInfo);
}


}  // service_manager::mojom::blink


namespace mojo {


// static
bool StructTraits<::service_manager::mojom::blink::BindSourceInfo::DataView, ::service_manager::mojom::blink::BindSourceInfoPtr>::Read(
    ::service_manager::mojom::blink::BindSourceInfo::DataView input,
    ::service_manager::mojom::blink::BindSourceInfoPtr* output) {
  bool success = true;
  ::service_manager::mojom::blink::BindSourceInfoPtr result(::service_manager::mojom::blink::BindSourceInfo::New());
  
      if (success && !input.ReadIdentity(&result->identity))
        success = false;
      if (success && !input.ReadRequiredCapabilities(&result->required_capabilities))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace service_manager::mojom::blink {


void ServiceInterceptorForTesting::OnStart(::service_manager::mojom::blink::IdentityPtr identity, OnStartCallback callback) {
  GetForwardingInterface()->OnStart(
    std::move(identity)
    , std::move(callback));
}
void ServiceInterceptorForTesting::OnBindInterface(BindSourceInfoPtr source, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback) {
  GetForwardingInterface()->OnBindInterface(
    std::move(source)
    , 
    std::move(interface_name)
    , 
    std::move(interface_pipe)
    , std::move(callback));
}
void ServiceInterceptorForTesting::CreatePackagedServiceInstance(::service_manager::mojom::blink::IdentityPtr identity, ::mojo::PendingReceiver<Service> receiver, ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata> metadata) {
  GetForwardingInterface()->CreatePackagedServiceInstance(
    std::move(identity)
    , 
    std::move(receiver)
    , 
    std::move(metadata)
    );
}
ServiceAsyncWaiter::ServiceAsyncWaiter(
    Service* proxy) : proxy_(proxy) {}

ServiceAsyncWaiter::~ServiceAsyncWaiter() = default;


void ServiceAsyncWaiter::OnStart(
    ::service_manager::mojom::blink::IdentityPtr identity, ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector>* out_connector_receiver, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl>* out_control_receiver) {
  base::RunLoop loop;
  proxy_->OnStart(
      std::move(identity),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector>* out_connector_receiver
,
             ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl>* out_control_receiver
,
             ::mojo::PendingReceiver<::service_manager::mojom::blink::Connector> connector_receiver,
             ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl> control_receiver) {*out_connector_receiver = std::move(connector_receiver);*out_control_receiver = std::move(control_receiver);
            loop->Quit();
          },
          &loop,
          out_connector_receiver,
          out_control_receiver));
  loop.Run();
}



void ServiceAsyncWaiter::OnBindInterface(
    BindSourceInfoPtr source, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe) {
  base::RunLoop loop;
  proxy_->OnBindInterface(
      std::move(source),
      std::move(interface_name),
      std::move(interface_pipe),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // service_manager::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif