// services/screen_ai/public/mojom/screen_ai_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/accessibility/ax_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::screen_ai::mojom::Direction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::screen_ai::mojom::OcrClientType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::screen_ai::mojom::MceClientType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::screen_ai::mojom::VisualAnnotationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::VisualAnnotationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::VisualAnnotation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::lines(input)) in_lines = Traits::lines(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->lines)::BaseType>
          lines_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::screen_ai::mojom::LineBoxDataView>, send_validation>(
        in_lines,
        lines_fragment,
        &lines_validate_params);

      fragment->lines.Set(
          lines_fragment.is_null() ? nullptr : lines_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->lines.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lines in VisualAnnotation struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::screen_ai::mojom::LineBoxDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::LineBoxDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::LineBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::words(input)) in_words = Traits::words(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->words)::BaseType>
          words_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::screen_ai::mojom::WordBoxDataView>, send_validation>(
        in_words,
        words_fragment,
        &words_validate_params);

      fragment->words.Set(
          words_fragment.is_null() ? nullptr : words_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->words.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null words in LineBox struct");

      decltype(Traits::text_line(input)) in_text_line = Traits::text_line(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_line)::BaseType> text_line_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_line,
        text_line_fragment);

      fragment->text_line.Set(
          text_line_fragment.is_null() ? nullptr : text_line_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_line.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_line in LineBox struct");

      decltype(Traits::language(input)) in_language = Traits::language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language)::BaseType> language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_language,
        language_fragment);

      fragment->language.Set(
          language_fragment.is_null() ? nullptr : language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in LineBox struct");

      fragment->block_id = Traits::block_id(input);

      fragment->paragraph_id = Traits::paragraph_id(input);

      decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounding_box,
        bounding_box_fragment);

      fragment->bounding_box.Set(
          bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounding_box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounding_box in LineBox struct");

      fragment->bounding_box_angle = Traits::bounding_box_angle(input);

      fragment->confidence = Traits::confidence(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::screen_ai::mojom::WordBoxDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::screen_ai::mojom::WordBoxDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::screen_ai::mojom::internal::WordBox_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::word(input)) in_word = Traits::word(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->word)::BaseType> word_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_word,
        word_fragment);

      fragment->word.Set(
          word_fragment.is_null() ? nullptr : word_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->word.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null word in WordBox struct");

      decltype(Traits::language(input)) in_language = Traits::language(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->language)::BaseType> language_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_language,
        language_fragment);

      fragment->language.Set(
          language_fragment.is_null() ? nullptr : language_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->language.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in WordBox struct");

      decltype(Traits::bounding_box(input)) in_bounding_box = Traits::bounding_box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounding_box)::BaseType> bounding_box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounding_box,
        bounding_box_fragment);

      fragment->bounding_box.Set(
          bounding_box_fragment.is_null() ? nullptr : bounding_box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounding_box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounding_box in WordBox struct");

      fragment->bounding_box_angle = Traits::bounding_box_angle(input);

      
      mojo::internal::Serialize<::screen_ai::mojom::Direction>(
        Traits::direction(input),
        &fragment->direction);

      decltype(Traits::whitespace_bounding_box(input)) in_whitespace_bounding_box = Traits::whitespace_bounding_box(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->whitespace_bounding_box)::BaseType> whitespace_bounding_box_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_whitespace_bounding_box,
        whitespace_bounding_box_fragment);

      fragment->whitespace_bounding_box.Set(
          whitespace_bounding_box_fragment.is_null() ? nullptr : whitespace_bounding_box_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->whitespace_bounding_box.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null whitespace_bounding_box in WordBox struct");

      fragment->whitespace_bounding_box_angle = Traits::whitespace_bounding_box_angle(input);

      fragment->confidence = Traits::confidence(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_SEND_VALIDATION_H_