// services/proxy_resolver/public/mojom/proxy_resolver.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SEND_VALIDATION_H_

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::proxy_resolver::mojom::HostResolveOperation, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::proxy_resolver::mojom::ProxyInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::proxy_resolver::mojom::ProxyInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::proxy_resolver::mojom::internal::ProxyInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::proxy_chains(input)) in_proxy_chains = Traits::proxy_chains(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxy_chains)::BaseType>
          proxy_chains_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& proxy_chains_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyChainDataView>, send_validation>(
        in_proxy_chains,
        proxy_chains_fragment,
        &proxy_chains_validate_params);

      fragment->proxy_chains.Set(
          proxy_chains_fragment.is_null() ? nullptr : proxy_chains_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxy_chains.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_chains in ProxyInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::proxy_resolver::mojom::SystemProxyResolutionStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::proxy_resolver::mojom::SystemProxyResolutionStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::proxy_resolver::mojom::internal::SystemProxyResolutionStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_success = Traits::is_success(input);

      fragment->os_error = Traits::os_error(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_PROXY_RESOLVER_PUBLIC_MOJOM_PROXY_RESOLVER_MOJOM_SEND_VALIDATION_H_