// services/preferences/public/mojom/tracked_preference_validation_delegate.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-params-data.h"
#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-shared-message-ids.h"

#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-import-headers.h"
#include "services/preferences/public/mojom/tracked_preference_validation_delegate.mojom-test-utils.h"


namespace prefs::mojom {
// The declaration includes the definition on other builds.

TrackedPreferenceValidationDelegate::IPCStableHashFunction TrackedPreferenceValidationDelegate::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrackedPreferenceValidationDelegate>(message.name())) {
    case messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation: {
      return &TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation_Sym::IPCStableHash;
    }
    case messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation: {
      return &TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrackedPreferenceValidationDelegate::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrackedPreferenceValidationDelegate>(message.name())) {
      case messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation:
            return "Receive prefs::mojom::TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation";
      case messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation:
            return "Receive prefs::mojom::TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation";
    }
  } else {
    switch (static_cast<messages::TrackedPreferenceValidationDelegate>(message.name())) {
      case messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation:
            return "Receive reply prefs::mojom::TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation";
      case messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation:
            return "Receive reply prefs::mojom::TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbb6a76fb;  // IPCStableHash for prefs::mojom::TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5fa2700e;  // IPCStableHash for prefs::mojom::TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrackedPreferenceValidationDelegateProxy::TrackedPreferenceValidationDelegateProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrackedPreferenceValidationDelegateProxy::OnAtomicPreferenceValidation(
    const std::string& in_pref_path, std::optional<::base::Value> in_value, TrackedPreferenceValidationDelegate::ValueState in_value_state, TrackedPreferenceValidationDelegate::ValueState in_external_validation_value_state, bool in_is_personal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send prefs::mojom::TrackedPreferenceValidationDelegate::OnAtomicPreferenceValidation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pref_path"), in_pref_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type std::optional<::base::Value>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value_state"), in_value_state,
                        "<value of type TrackedPreferenceValidationDelegate::ValueState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("external_validation_value_state"), in_external_validation_value_state,
                        "<value of type TrackedPreferenceValidationDelegate::ValueState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_personal"), in_is_personal,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::prefs::mojom::internal::TrackedPreferenceValidationDelegate_OnAtomicPreferenceValidation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pref_path)::BaseType> pref_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_pref_path,
    pref_path_fragment);

  params->pref_path.Set(
      pref_path_fragment.is_null() ? nullptr : pref_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pref_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pref_path in TrackedPreferenceValidationDelegate.OnAtomicPreferenceValidation request");
  mojo::internal::MessageFragment<decltype(params->value)>
      value_fragment(params.message());
  value_fragment.Claim(&params->value);
  
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
    in_value,
    value_fragment,
    true);

  
  mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceValidationDelegate_ValueState>(
    in_value_state,
    &params->value_state);

  
  mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceValidationDelegate_ValueState>(
    in_external_validation_value_state,
    &params->external_validation_value_state);

  params->is_personal = in_is_personal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrackedPreferenceValidationDelegate::Name_);
  message.set_method_name("OnAtomicPreferenceValidation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrackedPreferenceValidationDelegateProxy::OnSplitPreferenceValidation(
    const std::string& in_pref_path, const std::vector<std::string>& in_invalid_keys, const std::vector<std::string>& in_external_validation_invalid_keys, TrackedPreferenceValidationDelegate::ValueState in_value_state, TrackedPreferenceValidationDelegate::ValueState in_external_validation_value_state, bool in_is_personal) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send prefs::mojom::TrackedPreferenceValidationDelegate::OnSplitPreferenceValidation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pref_path"), in_pref_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("invalid_keys"), in_invalid_keys,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("external_validation_invalid_keys"), in_external_validation_invalid_keys,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value_state"), in_value_state,
                        "<value of type TrackedPreferenceValidationDelegate::ValueState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("external_validation_value_state"), in_external_validation_value_state,
                        "<value of type TrackedPreferenceValidationDelegate::ValueState>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_personal"), in_is_personal,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::prefs::mojom::internal::TrackedPreferenceValidationDelegate_OnSplitPreferenceValidation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pref_path)::BaseType> pref_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_pref_path,
    pref_path_fragment);

  params->pref_path.Set(
      pref_path_fragment.is_null() ? nullptr : pref_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pref_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pref_path in TrackedPreferenceValidationDelegate.OnSplitPreferenceValidation request");
  mojo::internal::MessageFragment<
      typename decltype(params->invalid_keys)::BaseType>
      invalid_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& invalid_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_invalid_keys,
    invalid_keys_fragment,
    &invalid_keys_validate_params);

  params->invalid_keys.Set(
      invalid_keys_fragment.is_null() ? nullptr : invalid_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->invalid_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null invalid_keys in TrackedPreferenceValidationDelegate.OnSplitPreferenceValidation request");
  mojo::internal::MessageFragment<
      typename decltype(params->external_validation_invalid_keys)::BaseType>
      external_validation_invalid_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& external_validation_invalid_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_external_validation_invalid_keys,
    external_validation_invalid_keys_fragment,
    &external_validation_invalid_keys_validate_params);

  params->external_validation_invalid_keys.Set(
      external_validation_invalid_keys_fragment.is_null() ? nullptr : external_validation_invalid_keys_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->external_validation_invalid_keys.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null external_validation_invalid_keys in TrackedPreferenceValidationDelegate.OnSplitPreferenceValidation request");

  
  mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceValidationDelegate_ValueState>(
    in_value_state,
    &params->value_state);

  
  mojo::internal::Serialize<::prefs::mojom::TrackedPreferenceValidationDelegate_ValueState>(
    in_external_validation_value_state,
    &params->external_validation_value_state);

  params->is_personal = in_is_personal;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrackedPreferenceValidationDelegate::Name_);
  message.set_method_name("OnSplitPreferenceValidation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrackedPreferenceValidationDelegateStubDispatch::Accept(
    TrackedPreferenceValidationDelegate* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrackedPreferenceValidationDelegate>(message->header()->name)) {
    case messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation: {
      DCHECK(message->is_serialized());
      internal::TrackedPreferenceValidationDelegate_OnAtomicPreferenceValidation_Params_Data* params =
          reinterpret_cast<internal::TrackedPreferenceValidationDelegate_OnAtomicPreferenceValidation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrackedPreferenceValidationDelegate.0
      bool success = true;
      std::string p_pref_path{};
      std::optional<::base::Value> p_value{};
      TrackedPreferenceValidationDelegate::ValueState p_value_state{};
      TrackedPreferenceValidationDelegate::ValueState p_external_validation_value_state{};
      bool p_is_personal{};
      TrackedPreferenceValidationDelegate_OnAtomicPreferenceValidation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefPath(&p_pref_path))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (success && !input_data_view.ReadValueState(&p_value_state))
        success = false;
      if (success && !input_data_view.ReadExternalValidationValueState(&p_external_validation_value_state))
        success = false;
      if (success)
        p_is_personal = input_data_view.is_personal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrackedPreferenceValidationDelegate::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAtomicPreferenceValidation(        
        std::move(p_pref_path), 
        std::move(p_value), 
        std::move(p_value_state), 
        std::move(p_external_validation_value_state), 
        std::move(p_is_personal));
      return true;
    }
    case messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation: {
      DCHECK(message->is_serialized());
      internal::TrackedPreferenceValidationDelegate_OnSplitPreferenceValidation_Params_Data* params =
          reinterpret_cast<internal::TrackedPreferenceValidationDelegate_OnSplitPreferenceValidation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrackedPreferenceValidationDelegate.1
      bool success = true;
      std::string p_pref_path{};
      std::vector<std::string> p_invalid_keys{};
      std::vector<std::string> p_external_validation_invalid_keys{};
      TrackedPreferenceValidationDelegate::ValueState p_value_state{};
      TrackedPreferenceValidationDelegate::ValueState p_external_validation_value_state{};
      bool p_is_personal{};
      TrackedPreferenceValidationDelegate_OnSplitPreferenceValidation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPrefPath(&p_pref_path))
        success = false;
      if (success && !input_data_view.ReadInvalidKeys(&p_invalid_keys))
        success = false;
      if (success && !input_data_view.ReadExternalValidationInvalidKeys(&p_external_validation_invalid_keys))
        success = false;
      if (success && !input_data_view.ReadValueState(&p_value_state))
        success = false;
      if (success && !input_data_view.ReadExternalValidationValueState(&p_external_validation_value_state))
        success = false;
      if (success)
        p_is_personal = input_data_view.is_personal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrackedPreferenceValidationDelegate::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSplitPreferenceValidation(        
        std::move(p_pref_path), 
        std::move(p_invalid_keys), 
        std::move(p_external_validation_invalid_keys), 
        std::move(p_value_state), 
        std::move(p_external_validation_value_state), 
        std::move(p_is_personal));
      return true;
    }
  }
  return false;
}

// static
bool TrackedPreferenceValidationDelegateStubDispatch::AcceptWithResponder(
    TrackedPreferenceValidationDelegate* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrackedPreferenceValidationDelegate>(message->header()->name)) {
    case messages::TrackedPreferenceValidationDelegate::kOnAtomicPreferenceValidation: {
      break;
    }
    case messages::TrackedPreferenceValidationDelegate::kOnSplitPreferenceValidation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTrackedPreferenceValidationDelegateValidationInfo[] = {
    { &internal::TrackedPreferenceValidationDelegate_OnAtomicPreferenceValidation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TrackedPreferenceValidationDelegate_OnSplitPreferenceValidation_Params_Data::Validate,
     nullptr /* no response */},
};

bool TrackedPreferenceValidationDelegateRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::prefs::mojom::TrackedPreferenceValidationDelegate::Name_,
    kTrackedPreferenceValidationDelegateValidationInfo);
}



}  // prefs::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace prefs::mojom {


void TrackedPreferenceValidationDelegateInterceptorForTesting::OnAtomicPreferenceValidation(const std::string& pref_path, std::optional<::base::Value> value, TrackedPreferenceValidationDelegate::ValueState value_state, TrackedPreferenceValidationDelegate::ValueState external_validation_value_state, bool is_personal) {
  GetForwardingInterface()->OnAtomicPreferenceValidation(
    std::move(pref_path)
    , 
    std::move(value)
    , 
    std::move(value_state)
    , 
    std::move(external_validation_value_state)
    , 
    std::move(is_personal)
    );
}
void TrackedPreferenceValidationDelegateInterceptorForTesting::OnSplitPreferenceValidation(const std::string& pref_path, const std::vector<std::string>& invalid_keys, const std::vector<std::string>& external_validation_invalid_keys, TrackedPreferenceValidationDelegate::ValueState value_state, TrackedPreferenceValidationDelegate::ValueState external_validation_value_state, bool is_personal) {
  GetForwardingInterface()->OnSplitPreferenceValidation(
    std::move(pref_path)
    , 
    std::move(invalid_keys)
    , 
    std::move(external_validation_invalid_keys)
    , 
    std::move(value_state)
    , 
    std::move(external_validation_value_state)
    , 
    std::move(is_personal)
    );
}
TrackedPreferenceValidationDelegateAsyncWaiter::TrackedPreferenceValidationDelegateAsyncWaiter(
    TrackedPreferenceValidationDelegate* proxy) : proxy_(proxy) {}

TrackedPreferenceValidationDelegateAsyncWaiter::~TrackedPreferenceValidationDelegateAsyncWaiter() = default;







}  // prefs::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif