// services/on_device_model/public/mojom/on_device_model.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/on_device_model/public/mojom/on_device_model.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-params-data.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-shared-message-ids.h"

#include "services/on_device_model/public/mojom/on_device_model.mojom-blink-import-headers.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace on_device_model::mojom::blink {
AdaptationAssets::AdaptationAssets()
    : weights(),
      weights_path() {}

AdaptationAssets::AdaptationAssets(
    ::base::File weights_in,
    const std::optional<::base::FilePath>& weights_path_in)
    : weights(std::move(weights_in)),
      weights_path(std::move(weights_path_in)) {}

AdaptationAssets::~AdaptationAssets() = default;

void AdaptationAssets::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weights"), this->weights,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::File>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weights_path"), this->weights_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdaptationAssets::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LanguageDetectionResult::LanguageDetectionResult()
    : code(),
      reliability() {}

LanguageDetectionResult::LanguageDetectionResult(
    const ::blink::String& code_in,
    float reliability_in)
    : code(std::move(code_in)),
      reliability(std::move(reliability_in)) {}

LanguageDetectionResult::~LanguageDetectionResult() = default;
size_t LanguageDetectionResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->code);
  seed = mojo::internal::WTFHash(seed, this->reliability);
  return seed;
}

void LanguageDetectionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reliability"), this->reliability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LanguageDetectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SafetyInfo::SafetyInfo()
    : class_scores(),
      language() {}

SafetyInfo::SafetyInfo(
    ::blink::Vector<float> class_scores_in,
    LanguageDetectionResultPtr language_in)
    : class_scores(std::move(class_scores_in)),
      language(std::move(language_in)) {}

SafetyInfo::~SafetyInfo() = default;

void SafetyInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "class_scores"), this->class_scores,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "language"), this->language,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LanguageDetectionResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SafetyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResponseChunk::ResponseChunk()
    : text(),
      safety_info() {}

ResponseChunk::ResponseChunk(
    const ::blink::String& text_in,
    SafetyInfoPtr safety_info_in)
    : text(std::move(text_in)),
      safety_info(std::move(safety_info_in)) {}

ResponseChunk::~ResponseChunk() = default;

void ResponseChunk::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safety_info"), this->safety_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SafetyInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResponseChunk::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResponseSummary::ResponseSummary()
    : safety_info(),
      output_token_count() {}

ResponseSummary::ResponseSummary(
    SafetyInfoPtr safety_info_in,
    uint32_t output_token_count_in)
    : safety_info(std::move(safety_info_in)),
      output_token_count(std::move(output_token_count_in)) {}

ResponseSummary::~ResponseSummary() = default;

void ResponseSummary::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "safety_info"), this->safety_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SafetyInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_token_count"), this->output_token_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResponseSummary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoadAdaptationParams::LoadAdaptationParams()
    : assets() {}

LoadAdaptationParams::LoadAdaptationParams(
    AdaptationAssetsPtr assets_in)
    : assets(std::move(assets_in)) {}

LoadAdaptationParams::~LoadAdaptationParams() = default;

void LoadAdaptationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "assets"), this->assets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AdaptationAssetsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoadAdaptationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Capabilities::Capabilities()
    : image_input(false),
      audio_input(false) {}

Capabilities::Capabilities(
    bool image_input_in,
    bool audio_input_in)
    : image_input(std::move(image_input_in)),
      audio_input(std::move(audio_input_in)) {}

Capabilities::~Capabilities() = default;
size_t Capabilities::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->image_input);
  seed = mojo::internal::WTFHash(seed, this->audio_input);
  return seed;
}

void Capabilities::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_input"), this->image_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_input"), this->audio_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Capabilities::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SessionParams::SessionParams()
    : max_tokens(0U),
      capabilities(),
      top_k(),
      temperature() {}

SessionParams::SessionParams(
    uint32_t max_tokens_in,
    CapabilitiesPtr capabilities_in)
    : max_tokens(std::move(max_tokens_in)),
      capabilities(std::move(capabilities_in)),
      top_k(),
      temperature() {}

SessionParams::SessionParams(
    uint32_t max_tokens_in,
    CapabilitiesPtr capabilities_in,
    uint32_t top_k_in,
    float temperature_in)
    : max_tokens(std::move(max_tokens_in)),
      capabilities(std::move(capabilities_in)),
      top_k(std::move(top_k_in)),
      temperature(std::move(temperature_in)) {}

SessionParams::~SessionParams() = default;
size_t SessionParams::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->max_tokens);
  seed = mojo::internal::WTFHash(seed, this->capabilities);
  seed = mojo::internal::WTFHash(seed, this->top_k);
  seed = mojo::internal::WTFHash(seed, this->temperature);
  return seed;
}

void SessionParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_tokens"), this->max_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capabilities"), this->capabilities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CapabilitiesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_k"), this->top_k,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "temperature"), this->temperature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SessionParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Input::Input()
    : pieces() {}

Input::Input(
    ::blink::Vector<InputPiecePtr> pieces_in)
    : pieces(std::move(pieces_in)) {}

Input::~Input() = default;

void Input::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pieces"), this->pieces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<InputPiecePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Input::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AppendOptions::AppendOptions()
    : input(),
      max_tokens(0U) {}

AppendOptions::AppendOptions(
    InputPtr input_in,
    uint32_t max_tokens_in)
    : input(std::move(input_in)),
      max_tokens(std::move(max_tokens_in)) {}

AppendOptions::~AppendOptions() = default;

void AppendOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InputPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_tokens"), this->max_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppendOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GenerateOptions::GenerateOptions()
    : max_output_tokens(0U),
      constraint() {}

GenerateOptions::GenerateOptions(
    uint32_t max_output_tokens_in)
    : max_output_tokens(std::move(max_output_tokens_in)),
      constraint() {}

GenerateOptions::GenerateOptions(
    uint32_t max_output_tokens_in,
    ResponseConstraintPtr constraint_in)
    : max_output_tokens(std::move(max_output_tokens_in)),
      constraint(std::move(constraint_in)) {}

GenerateOptions::~GenerateOptions() = default;

void GenerateOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_output_tokens"), this->max_output_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "constraint"), this->constraint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResponseConstraintPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GenerateOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AudioData::AudioData()
    : channel_count(),
      sample_rate(),
      frame_count(),
      data() {}

AudioData::AudioData(
    int32_t channel_count_in,
    int32_t sample_rate_in,
    int32_t frame_count_in,
    ::blink::Vector<float> data_in)
    : channel_count(std::move(channel_count_in)),
      sample_rate(std::move(sample_rate_in)),
      frame_count(std::move(frame_count_in)),
      data(std::move(data_in)) {}

AudioData::~AudioData() = default;

void AudioData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel_count"), this->channel_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate"), this->sample_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_count"), this->frame_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AudioData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpeechRecognitionResult::SpeechRecognitionResult()
    : transcript(),
      is_final() {}

SpeechRecognitionResult::SpeechRecognitionResult(
    const ::blink::String& transcript_in,
    bool is_final_in)
    : transcript(std::move(transcript_in)),
      is_final(std::move(is_final_in)) {}

SpeechRecognitionResult::~SpeechRecognitionResult() = default;
size_t SpeechRecognitionResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->transcript);
  seed = mojo::internal::WTFHash(seed, this->is_final);
  return seed;
}

void SpeechRecognitionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transcript"), this->transcript,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_final"), this->is_final,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SpeechRecognitionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AsrStreamOptions::AsrStreamOptions()
    : sample_rate_hz(0U) {}

AsrStreamOptions::AsrStreamOptions(
    uint32_t sample_rate_hz_in)
    : sample_rate_hz(std::move(sample_rate_hz_in)) {}

AsrStreamOptions::~AsrStreamOptions() = default;
size_t AsrStreamOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->sample_rate_hz);
  return seed;
}

void AsrStreamOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sample_rate_hz"), this->sample_rate_hz,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AsrStreamOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DevicePerformanceInfo::DevicePerformanceInfo()
    : performance_class(),
      vram_mb() {}

DevicePerformanceInfo::DevicePerformanceInfo(
    PerformanceClass performance_class_in,
    uint64_t vram_mb_in)
    : performance_class(std::move(performance_class_in)),
      vram_mb(std::move(vram_mb_in)) {}

DevicePerformanceInfo::~DevicePerformanceInfo() = default;
size_t DevicePerformanceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->performance_class);
  seed = mojo::internal::WTFHash(seed, this->vram_mb);
  return seed;
}

void DevicePerformanceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "performance_class"), this->performance_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PerformanceClass>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vram_mb"), this->vram_mb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DevicePerformanceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceInfo::DeviceInfo()
    : vendor_id(),
      device_id(),
      driver_version(),
      supports_fp16() {}

DeviceInfo::DeviceInfo(
    int32_t vendor_id_in,
    int32_t device_id_in,
    const ::blink::String& driver_version_in,
    bool supports_fp16_in)
    : vendor_id(std::move(vendor_id_in)),
      device_id(std::move(device_id_in)),
      driver_version(std::move(driver_version_in)),
      supports_fp16(std::move(supports_fp16_in)) {}

DeviceInfo::~DeviceInfo() = default;
size_t DeviceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->vendor_id);
  seed = mojo::internal::WTFHash(seed, this->device_id);
  seed = mojo::internal::WTFHash(seed, this->driver_version);
  seed = mojo::internal::WTFHash(seed, this->supports_fp16);
  return seed;
}

void DeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "driver_version"), this->driver_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_fp16"), this->supports_fp16,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InputPiecePtr
InputPiece::NewToken(
    Token value) {
  return InputPiecePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kToken)>,
      std::move(value));
}

InputPiecePtr
InputPiece::NewText(
    const ::blink::String& value) {
  return InputPiecePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kText)>,
      std::move(value));
}

InputPiecePtr
InputPiece::NewBitmap(
    const ::SkBitmap& value) {
  return InputPiecePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
      std::move(value));
}

InputPiecePtr
InputPiece::NewUnknownType(
    bool value) {
  return InputPiecePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnknownType)>,
      std::move(value));
}

InputPiecePtr
InputPiece::NewAudio(
    AudioDataPtr value) {
  return InputPiecePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAudio)>,
      std::move(value));
}

InputPiece::InputPiece(
    std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
    Token value)
    : tag_(Tag::kToken),
      data_(std::in_place_index<static_cast<size_t>(Tag::kToken)>,
            std::move(value)) {}

InputPiece::InputPiece(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const ::blink::String& value)
    : tag_(Tag::kText),
      data_(std::in_place_index<static_cast<size_t>(Tag::kText)>,
            std::move(value)) {}

InputPiece::InputPiece(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : tag_(Tag::kBitmap),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBitmap)>,
            std::move(value)) {}

InputPiece::InputPiece(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
    bool value)
    : tag_(Tag::kUnknownType),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnknownType)>,
            std::move(value)) {}

InputPiece::InputPiece(
    std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
    AudioDataPtr value)
    : tag_(Tag::kAudio),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAudio)>,
            std::move(value)) {}
InputPiece::~InputPiece() {
  DestroyActive();
}

void InputPiece::set_token(Token token) {
  if (tag_ != Tag::kToken) {
    DestroyActive();
    tag_ = Tag::kToken;
  }
  data_.token = token;
}

void InputPiece::set_text(const ::blink::String& text) {
  if (tag_ == Tag::kText) {
    data_.text = std::move(text);
  } else {
    DestroyActive();
    tag_ = Tag::kText;
    new (&data_.text) ::blink::String(
        std::move(text));
  }
}

void InputPiece::set_bitmap(const ::SkBitmap& bitmap) {
  if (tag_ == Tag::kBitmap) {
    data_.bitmap = std::move(bitmap);
  } else {
    DestroyActive();
    tag_ = Tag::kBitmap;
    new (&data_.bitmap) ::SkBitmap(
        std::move(bitmap));
  }
}

void InputPiece::set_unknown_type(bool unknown_type) {
  if (tag_ != Tag::kUnknownType) {
    DestroyActive();
    tag_ = Tag::kUnknownType;
  }
  data_.unknown_type = unknown_type;
}

void InputPiece::set_audio(AudioDataPtr audio) {
  if (tag_ == Tag::kAudio) {
    data_.audio = std::move(audio);
  } else {
    DestroyActive();
    tag_ = Tag::kAudio;
    new (&data_.audio) AudioDataPtr(
        std::move(audio));
  }
}


InputPiece::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kToken)>,
    Token value)
    : token(std::move(value)) {}

InputPiece::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
    const ::blink::String& value)
    : text(std::move(value)) {}

InputPiece::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
    const ::SkBitmap& value)
    : bitmap(std::move(value)) {}

InputPiece::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
    bool value)
    : unknown_type(std::move(value)) {}

InputPiece::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAudio)>,
    AudioDataPtr value)
    : audio(std::move(value)) {}

void InputPiece::DestroyActive() {
  switch (tag_) {

    case Tag::kToken:
      std::destroy_at(&data_.token);
      break;
    case Tag::kText:
      std::destroy_at(&data_.text);
      break;
    case Tag::kBitmap:
      std::destroy_at(&data_.bitmap);
      break;
    case Tag::kUnknownType:
      std::destroy_at(&data_.unknown_type);
      break;
    case Tag::kAudio:
      std::destroy_at(&data_.audio);
      break;
  }
}

bool InputPiece::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ResponseConstraintPtr
ResponseConstraint::NewJsonSchema(
    const ::blink::String& value) {
  return ResponseConstraintPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kJsonSchema)>,
      std::move(value));
}

ResponseConstraintPtr
ResponseConstraint::NewRegex(
    const ::blink::String& value) {
  return ResponseConstraintPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRegex)>,
      std::move(value));
}

ResponseConstraintPtr
ResponseConstraint::NewUnknownType(
    bool value) {
  return ResponseConstraintPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnknownType)>,
      std::move(value));
}

ResponseConstraint::ResponseConstraint(
    std::in_place_index_t<static_cast<size_t>(Tag::kJsonSchema)>,
    const ::blink::String& value)
    : tag_(Tag::kJsonSchema),
      data_(std::in_place_index<static_cast<size_t>(Tag::kJsonSchema)>,
            std::move(value)) {}

ResponseConstraint::ResponseConstraint(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegex)>,
    const ::blink::String& value)
    : tag_(Tag::kRegex),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRegex)>,
            std::move(value)) {}

ResponseConstraint::ResponseConstraint(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
    bool value)
    : tag_(Tag::kUnknownType),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnknownType)>,
            std::move(value)) {}
ResponseConstraint::~ResponseConstraint() {
  DestroyActive();
}

void ResponseConstraint::set_json_schema(const ::blink::String& json_schema) {
  if (tag_ == Tag::kJsonSchema) {
    data_.json_schema = std::move(json_schema);
  } else {
    DestroyActive();
    tag_ = Tag::kJsonSchema;
    new (&data_.json_schema) ::blink::String(
        std::move(json_schema));
  }
}

void ResponseConstraint::set_regex(const ::blink::String& regex) {
  if (tag_ == Tag::kRegex) {
    data_.regex = std::move(regex);
  } else {
    DestroyActive();
    tag_ = Tag::kRegex;
    new (&data_.regex) ::blink::String(
        std::move(regex));
  }
}

void ResponseConstraint::set_unknown_type(bool unknown_type) {
  if (tag_ != Tag::kUnknownType) {
    DestroyActive();
    tag_ = Tag::kUnknownType;
  }
  data_.unknown_type = unknown_type;
}


ResponseConstraint::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kJsonSchema)>,
    const ::blink::String& value)
    : json_schema(std::move(value)) {}

ResponseConstraint::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRegex)>,
    const ::blink::String& value)
    : regex(std::move(value)) {}

ResponseConstraint::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnknownType)>,
    bool value)
    : unknown_type(std::move(value)) {}

void ResponseConstraint::DestroyActive() {
  switch (tag_) {

    case Tag::kJsonSchema:
      std::destroy_at(&data_.json_schema);
      break;
    case Tag::kRegex:
      std::destroy_at(&data_.regex);
      break;
    case Tag::kUnknownType:
      std::destroy_at(&data_.unknown_type);
      break;
  }
}
size_t ResponseConstraint::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kJsonSchema:
      return mojo::internal::WTFHash(seed, data_.json_schema);
    case Tag::kRegex:
      return mojo::internal::WTFHash(seed, data_.regex);
    case Tag::kUnknownType:
      return mojo::internal::WTFHash(seed, data_.unknown_type);
    default:
      NOTREACHED();
  }
}

bool ResponseConstraint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

StreamingResponder::IPCStableHashFunction StreamingResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::StreamingResponder>(message.name())) {
    case messages::StreamingResponder::kOnResponse: {
      return &StreamingResponder::OnResponse_Sym::IPCStableHash;
    }
    case messages::StreamingResponder::kOnComplete: {
      return &StreamingResponder::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* StreamingResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::StreamingResponder>(message.name())) {
      case messages::StreamingResponder::kOnResponse:
            return "Receive on_device_model::mojom::StreamingResponder::OnResponse";
      case messages::StreamingResponder::kOnComplete:
            return "Receive on_device_model::mojom::StreamingResponder::OnComplete";
    }
  } else {
    switch (static_cast<messages::StreamingResponder>(message.name())) {
      case messages::StreamingResponder::kOnResponse:
            return "Receive reply on_device_model::mojom::StreamingResponder::OnResponse";
      case messages::StreamingResponder::kOnComplete:
            return "Receive reply on_device_model::mojom::StreamingResponder::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t StreamingResponder::OnResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x21bf4d26;  // IPCStableHash for on_device_model::mojom::StreamingResponder::OnResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t StreamingResponder::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaaa09757;  // IPCStableHash for on_device_model::mojom::StreamingResponder::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

StreamingResponderProxy::StreamingResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void StreamingResponderProxy::OnResponse(
    ResponseChunkPtr in_chunk) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::StreamingResponder::OnResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("chunk"), in_chunk,
                        "<value of type ResponseChunkPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StreamingResponder::kOnResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::StreamingResponder_OnResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->chunk)::BaseType> chunk_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::ResponseChunkDataView>(
    in_chunk,
    chunk_fragment);

  params->chunk.Set(
      chunk_fragment.is_null() ? nullptr : chunk_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->chunk.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null chunk in StreamingResponder.OnResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamingResponder::Name_);
  message.set_method_name("OnResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void StreamingResponderProxy::OnComplete(
    ResponseSummaryPtr in_summary) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::StreamingResponder::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("summary"), in_summary,
                        "<value of type ResponseSummaryPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::StreamingResponder::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::StreamingResponder_OnComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->summary)::BaseType> summary_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::ResponseSummaryDataView>(
    in_summary,
    summary_fragment);

  params->summary.Set(
      summary_fragment.is_null() ? nullptr : summary_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->summary.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null summary in StreamingResponder.OnComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(StreamingResponder::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool StreamingResponderStubDispatch::Accept(
    StreamingResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::StreamingResponder>(message->header()->name)) {
    case messages::StreamingResponder::kOnResponse: {
      DCHECK(message->is_serialized());
      internal::StreamingResponder_OnResponse_Params_Data* params =
          reinterpret_cast<internal::StreamingResponder_OnResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StreamingResponder.0
      bool success = true;
      ResponseChunkPtr p_chunk{};
      StreamingResponder_OnResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChunk(&p_chunk))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamingResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponse(        
        std::move(p_chunk));
      return true;
    }
    case messages::StreamingResponder::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::StreamingResponder_OnComplete_Params_Data* params =
          reinterpret_cast<internal::StreamingResponder_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for StreamingResponder.1
      bool success = true;
      ResponseSummaryPtr p_summary{};
      StreamingResponder_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSummary(&p_summary))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            StreamingResponder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_summary));
      return true;
    }
  }
  return false;
}

// static
bool StreamingResponderStubDispatch::AcceptWithResponder(
    StreamingResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::StreamingResponder>(message->header()->name)) {
    case messages::StreamingResponder::kOnResponse: {
      break;
    }
    case messages::StreamingResponder::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kStreamingResponderValidationInfo[] = {
    { &internal::StreamingResponder_OnResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::StreamingResponder_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool StreamingResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::StreamingResponder::Name_,
    kStreamingResponderValidationInfo);
}

// The declaration includes the definition on other builds.

ContextClient::IPCStableHashFunction ContextClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContextClient>(message.name())) {
    case messages::ContextClient::kOnComplete: {
      return &ContextClient::OnComplete_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContextClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContextClient>(message.name())) {
      case messages::ContextClient::kOnComplete:
            return "Receive on_device_model::mojom::ContextClient::OnComplete";
    }
  } else {
    switch (static_cast<messages::ContextClient>(message.name())) {
      case messages::ContextClient::kOnComplete:
            return "Receive reply on_device_model::mojom::ContextClient::OnComplete";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContextClient::OnComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb36a50d7;  // IPCStableHash for on_device_model::mojom::ContextClient::OnComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContextClientProxy::ContextClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextClientProxy::OnComplete(
    uint32_t in_tokens_processed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::ContextClient::OnComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tokens_processed"), in_tokens_processed,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextClient::kOnComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::ContextClient_OnComplete_Params_Data> params(
          message);
  params.Allocate();

  params->tokens_processed = in_tokens_processed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContextClientStubDispatch::Accept(
    ContextClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContextClient>(message->header()->name)) {
    case messages::ContextClient::kOnComplete: {
      DCHECK(message->is_serialized());
      internal::ContextClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::ContextClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContextClient.0
      bool success = true;
      uint32_t p_tokens_processed{};
      ContextClient_OnComplete_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tokens_processed = input_data_view.tokens_processed();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete(        
        std::move(p_tokens_processed));
      return true;
    }
  }
  return false;
}

// static
bool ContextClientStubDispatch::AcceptWithResponder(
    ContextClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContextClient>(message->header()->name)) {
    case messages::ContextClient::kOnComplete: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContextClientValidationInfo[] = {
    { &internal::ContextClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContextClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::ContextClient::Name_,
    kContextClientValidationInfo);
}

// The declaration includes the definition on other builds.

Session::IPCStableHashFunction Session::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Session>(message.name())) {
    case messages::Session::kAppend: {
      return &Session::Append_Sym::IPCStableHash;
    }
    case messages::Session::kGenerate: {
      return &Session::Generate_Sym::IPCStableHash;
    }
    case messages::Session::kGetSizeInTokens: {
      return &Session::GetSizeInTokens_Sym::IPCStableHash;
    }
    case messages::Session::kScore: {
      return &Session::Score_Sym::IPCStableHash;
    }
    case messages::Session::kClone: {
      return &Session::Clone_Sym::IPCStableHash;
    }
    case messages::Session::kGetProbabilitiesBlocking: {
      return &Session::GetProbabilitiesBlocking_Sym::IPCStableHash;
    }
    case messages::Session::kSetPriority: {
      return &Session::SetPriority_Sym::IPCStableHash;
    }
    case messages::Session::kAsrStream: {
      return &Session::AsrStream_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Session::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Session>(message.name())) {
      case messages::Session::kAppend:
            return "Receive on_device_model::mojom::Session::Append";
      case messages::Session::kGenerate:
            return "Receive on_device_model::mojom::Session::Generate";
      case messages::Session::kGetSizeInTokens:
            return "Receive on_device_model::mojom::Session::GetSizeInTokens";
      case messages::Session::kScore:
            return "Receive on_device_model::mojom::Session::Score";
      case messages::Session::kClone:
            return "Receive on_device_model::mojom::Session::Clone";
      case messages::Session::kGetProbabilitiesBlocking:
            return "Receive on_device_model::mojom::Session::GetProbabilitiesBlocking";
      case messages::Session::kSetPriority:
            return "Receive on_device_model::mojom::Session::SetPriority";
      case messages::Session::kAsrStream:
            return "Receive on_device_model::mojom::Session::AsrStream";
    }
  } else {
    switch (static_cast<messages::Session>(message.name())) {
      case messages::Session::kAppend:
            return "Receive reply on_device_model::mojom::Session::Append";
      case messages::Session::kGenerate:
            return "Receive reply on_device_model::mojom::Session::Generate";
      case messages::Session::kGetSizeInTokens:
            return "Receive reply on_device_model::mojom::Session::GetSizeInTokens";
      case messages::Session::kScore:
            return "Receive reply on_device_model::mojom::Session::Score";
      case messages::Session::kClone:
            return "Receive reply on_device_model::mojom::Session::Clone";
      case messages::Session::kGetProbabilitiesBlocking:
            return "Receive reply on_device_model::mojom::Session::GetProbabilitiesBlocking";
      case messages::Session::kSetPriority:
            return "Receive reply on_device_model::mojom::Session::SetPriority";
      case messages::Session::kAsrStream:
            return "Receive reply on_device_model::mojom::Session::AsrStream";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Session::Append_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50056f1a;  // IPCStableHash for on_device_model::mojom::Session::Append
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::Generate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0366be3c;  // IPCStableHash for on_device_model::mojom::Session::Generate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::GetSizeInTokens_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x502640db;  // IPCStableHash for on_device_model::mojom::Session::GetSizeInTokens
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::Score_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x172fb4fa;  // IPCStableHash for on_device_model::mojom::Session::Score
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc376cde1;  // IPCStableHash for on_device_model::mojom::Session::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::GetProbabilitiesBlocking_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xefa7224b;  // IPCStableHash for on_device_model::mojom::Session::GetProbabilitiesBlocking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::SetPriority_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8bdec568;  // IPCStableHash for on_device_model::mojom::Session::SetPriority
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Session::AsrStream_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78af2b62;  // IPCStableHash for on_device_model::mojom::Session::AsrStream
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Session_GetSizeInTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Session_GetSizeInTokens_ForwardToCallback(
      Session::GetSizeInTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  Session_GetSizeInTokens_ForwardToCallback(const Session_GetSizeInTokens_ForwardToCallback&) = delete;
  Session_GetSizeInTokens_ForwardToCallback& operator=(const Session_GetSizeInTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Session::GetSizeInTokensCallback callback_;
};

class Session_Score_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Session_Score_ForwardToCallback(
      Session::ScoreCallback callback
      ) : callback_(std::move(callback)) {
  }

  Session_Score_ForwardToCallback(const Session_Score_ForwardToCallback&) = delete;
  Session_Score_ForwardToCallback& operator=(const Session_Score_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Session::ScoreCallback callback_;
};

class Session_GetProbabilitiesBlocking_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Session_GetProbabilitiesBlocking_ForwardToCallback(
      Session::GetProbabilitiesBlockingCallback callback
      ) : callback_(std::move(callback)) {
  }

  Session_GetProbabilitiesBlocking_ForwardToCallback(const Session_GetProbabilitiesBlocking_ForwardToCallback&) = delete;
  Session_GetProbabilitiesBlocking_ForwardToCallback& operator=(const Session_GetProbabilitiesBlocking_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Session::GetProbabilitiesBlockingCallback callback_;
};

SessionProxy::SessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionProxy::Append(
    AppendOptionsPtr in_options, ::mojo::PendingRemote<ContextClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::Append", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type AppendOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ContextClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kAppend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_Append_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::AppendOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in Session.Append request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_model::mojom::ContextClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Append");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::Generate(
    GenerateOptionsPtr in_options, ::mojo::PendingRemote<StreamingResponder> in_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::Generate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type GenerateOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("responder"), in_responder,
                        "<value of type ::mojo::PendingRemote<StreamingResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kGenerate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_Generate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::GenerateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in Session.Generate request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_model::mojom::StreamingResponderInterfaceBase>>(
    in_responder,
    &params->responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid responder in Session.Generate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Generate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::GetSizeInTokens(
    InputPtr in_input, GetSizeInTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::GetSizeInTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input"), in_input,
                        "<value of type InputPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kGetSizeInTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_GetSizeInTokens_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input)::BaseType> input_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::InputDataView>(
    in_input,
    input_fragment);

  params->input.Set(
      input_fragment.is_null() ? nullptr : input_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input in Session.GetSizeInTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("GetSizeInTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Session_GetSizeInTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionProxy::Score(
    const ::blink::String& in_text, ScoreCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::Score", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_Score_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in Session.Score request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Score");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Session_Score_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionProxy::Clone(
    ::mojo::PendingReceiver<Session> in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<Session>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::SessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in Session.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::GetProbabilitiesBlocking(
    const ::blink::String& in_text, GetProbabilitiesBlockingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::GetProbabilitiesBlocking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kGetProbabilitiesBlocking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_GetProbabilitiesBlocking_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in Session.GetProbabilitiesBlocking request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("GetProbabilitiesBlocking");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Session_GetProbabilitiesBlocking_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SessionProxy::SetPriority(
    Priority in_priority) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::SetPriority", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type Priority>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kSetPriority), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_SetPriority_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::Priority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("SetPriority");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SessionProxy::AsrStream(
    AsrStreamOptionsPtr in_options, ::mojo::PendingReceiver<AsrStreamInput> in_stream, ::mojo::PendingRemote<AsrStreamResponder> in_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::Session::AsrStream", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type AsrStreamOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::PendingReceiver<AsrStreamInput>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("responder"), in_responder,
                        "<value of type ::mojo::PendingRemote<AsrStreamResponder>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kAsrStream), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_AsrStream_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::AsrStreamOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in Session.AsrStream request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::AsrStreamInputInterfaceBase>>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in Session.AsrStream request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_model::mojom::AsrStreamResponderInterfaceBase>>(
    in_responder,
    &params->responder,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->responder)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid responder in Session.AsrStream request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("AsrStream");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Session_GetSizeInTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Session::GetSizeInTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Session_GetSizeInTokens_ProxyToResponder> proxy(
        new Session_GetSizeInTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Session_GetSizeInTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Session_GetSizeInTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Session_GetSizeInTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Session::GetSizeInTokensCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint32_t in_size);
};

bool Session_GetSizeInTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Session_GetSizeInTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Session_GetSizeInTokens_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Session.5
  bool success = true;
  uint32_t p_size{};
  Session_GetSizeInTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_size = input_data_view.size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Session::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_size));
  }
  return true;
}

void Session_GetSizeInTokens_ProxyToResponder::Run(
    uint32_t in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::Session::GetSizeInTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kGetSizeInTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_GetSizeInTokens_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("GetSizeInTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Session_Score_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Session::ScoreCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Session_Score_ProxyToResponder> proxy(
        new Session_Score_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Session_Score_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Session_Score_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Session_Score_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Session::ScoreCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      float in_probability);
};

bool Session_Score_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Session_Score_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Session_Score_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Session.3
  bool success = true;
  float p_probability{};
  Session_Score_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_probability = input_data_view.probability();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Session::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_probability));
  }
  return true;
}

void Session_Score_ProxyToResponder::Run(
    float in_probability) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::Session::Score", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("probability"), in_probability,
                        "<value of type float>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kScore), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_Score_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->probability = in_probability;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("Score");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Session_GetProbabilitiesBlocking_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Session::GetProbabilitiesBlockingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Session_GetProbabilitiesBlocking_ProxyToResponder> proxy(
        new Session_GetProbabilitiesBlocking_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Session_GetProbabilitiesBlocking_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Session_GetProbabilitiesBlocking_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Session_GetProbabilitiesBlocking_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Session::GetProbabilitiesBlockingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::Vector<float>& in_probabilities);
};

bool Session_GetProbabilitiesBlocking_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Session_GetProbabilitiesBlocking_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Session_GetProbabilitiesBlocking_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Session.8
  bool success = true;
  ::blink::Vector<float> p_probabilities{};
  Session_GetProbabilitiesBlocking_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProbabilities(&p_probabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Session::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_probabilities));
  }
  return true;
}

void Session_GetProbabilitiesBlocking_ProxyToResponder::Run(
    const ::blink::Vector<float>& in_probabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::Session::GetProbabilitiesBlocking", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("probabilities"), in_probabilities,
                        "<value of type const ::blink::Vector<float>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Session::kGetProbabilitiesBlocking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::Session_GetProbabilitiesBlocking_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->probabilities)::BaseType>
      probabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& probabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<float>>(
    in_probabilities,
    probabilities_fragment,
    &probabilities_validate_params);

  params->probabilities.Set(
      probabilities_fragment.is_null() ? nullptr : probabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->probabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null probabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Session::Name_);
  message.set_method_name("GetProbabilitiesBlocking");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SessionStubDispatch::Accept(
    Session* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Session>(message->header()->name)) {
    case messages::Session::kAppend: {
      DCHECK(message->is_serialized());
      internal::Session_Append_Params_Data* params =
          reinterpret_cast<internal::Session_Append_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.6
      bool success = true;
      AppendOptionsPtr p_options{};
      ::mojo::PendingRemote<ContextClient> p_client{};
      Session_Append_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Append(        
        std::move(p_options), 
        std::move(p_client));
      return true;
    }
    case messages::Session::kGenerate: {
      DCHECK(message->is_serialized());
      internal::Session_Generate_Params_Data* params =
          reinterpret_cast<internal::Session_Generate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.7
      bool success = true;
      GenerateOptionsPtr p_options{};
      ::mojo::PendingRemote<StreamingResponder> p_responder{};
      Session_Generate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_responder =
            input_data_view.TakeResponder<decltype(p_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Generate(        
        std::move(p_options), 
        std::move(p_responder));
      return true;
    }
    case messages::Session::kGetSizeInTokens: {
      break;
    }
    case messages::Session::kScore: {
      break;
    }
    case messages::Session::kClone: {
      DCHECK(message->is_serialized());
      internal::Session_Clone_Params_Data* params =
          reinterpret_cast<internal::Session_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.4
      bool success = true;
      ::mojo::PendingReceiver<Session> p_session{};
      Session_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_session));
      return true;
    }
    case messages::Session::kGetProbabilitiesBlocking: {
      break;
    }
    case messages::Session::kSetPriority: {
      DCHECK(message->is_serialized());
      internal::Session_SetPriority_Params_Data* params =
          reinterpret_cast<internal::Session_SetPriority_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.9
      bool success = true;
      Priority p_priority{};
      Session_SetPriority_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPriority(        
        std::move(p_priority));
      return true;
    }
    case messages::Session::kAsrStream: {
      DCHECK(message->is_serialized());
      internal::Session_AsrStream_Params_Data* params =
          reinterpret_cast<internal::Session_AsrStream_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Session.10
      bool success = true;
      AsrStreamOptionsPtr p_options{};
      ::mojo::PendingReceiver<AsrStreamInput> p_stream{};
      ::mojo::PendingRemote<AsrStreamResponder> p_responder{};
      Session_AsrStream_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success) {
        p_stream =
            input_data_view.TakeStream<decltype(p_stream)>();
      }
      if (success) {
        p_responder =
            input_data_view.TakeResponder<decltype(p_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsrStream(        
        std::move(p_options), 
        std::move(p_stream), 
        std::move(p_responder));
      return true;
    }
  }
  return false;
}

// static
bool SessionStubDispatch::AcceptWithResponder(
    Session* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Session>(message->header()->name)) {
    case messages::Session::kAppend: {
      break;
    }
    case messages::Session::kGenerate: {
      break;
    }
    case messages::Session::kGetSizeInTokens: {
      internal::Session_GetSizeInTokens_Params_Data* params =
          reinterpret_cast<
              internal::Session_GetSizeInTokens_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Session.5
      bool success = true;
      InputPtr p_input{};
      Session_GetSizeInTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 5, false);
        return false;
      }
      auto callback =
          Session_GetSizeInTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSizeInTokens(        
        std::move(p_input), std::move(callback));
      return true;
    }
    case messages::Session::kScore: {
      internal::Session_Score_Params_Data* params =
          reinterpret_cast<
              internal::Session_Score_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Session.3
      bool success = true;
      ::blink::String p_text{};
      Session_Score_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 3, false);
        return false;
      }
      auto callback =
          Session_Score_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Score(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::Session::kClone: {
      break;
    }
    case messages::Session::kGetProbabilitiesBlocking: {
      internal::Session_GetProbabilitiesBlocking_Params_Data* params =
          reinterpret_cast<
              internal::Session_GetProbabilitiesBlocking_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Session.8
      bool success = true;
      ::blink::String p_text{};
      Session_GetProbabilitiesBlocking_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Session::Name_, 8, false);
        return false;
      }
      auto callback =
          Session_GetProbabilitiesBlocking_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProbabilitiesBlocking(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::Session::kSetPriority: {
      break;
    }
    case messages::Session::kAsrStream: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSessionValidationInfo[] = {
    {nullptr, nullptr},  // nonexistent
    {nullptr, nullptr},  // nonexistent
    {nullptr, nullptr},  // nonexistent
    { &internal::Session_Score_Params_Data::Validate,
     &internal::Session_Score_ResponseParams_Data::Validate},
    { &internal::Session_Clone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_GetSizeInTokens_Params_Data::Validate,
     &internal::Session_GetSizeInTokens_ResponseParams_Data::Validate},
    { &internal::Session_Append_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_Generate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_GetProbabilitiesBlocking_Params_Data::Validate,
     &internal::Session_GetProbabilitiesBlocking_ResponseParams_Data::Validate},
    { &internal::Session_SetPriority_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Session_AsrStream_Params_Data::Validate,
     nullptr /* no response */},
};

bool SessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::Session::Name_,
    kSessionValidationInfo);
}

bool SessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_model::mojom::blink::Session::Name_,
    kSessionValidationInfo);
}
// The declaration includes the definition on other builds.

OnDeviceModel::IPCStableHashFunction OnDeviceModel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OnDeviceModel>(message.name())) {
    case messages::OnDeviceModel::kStartSession: {
      return &OnDeviceModel::StartSession_Sym::IPCStableHash;
    }
    case messages::OnDeviceModel::kClassifyTextSafety: {
      return &OnDeviceModel::ClassifyTextSafety_Sym::IPCStableHash;
    }
    case messages::OnDeviceModel::kDetectLanguage: {
      return &OnDeviceModel::DetectLanguage_Sym::IPCStableHash;
    }
    case messages::OnDeviceModel::kLoadAdaptation: {
      return &OnDeviceModel::LoadAdaptation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OnDeviceModel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OnDeviceModel>(message.name())) {
      case messages::OnDeviceModel::kStartSession:
            return "Receive on_device_model::mojom::OnDeviceModel::StartSession";
      case messages::OnDeviceModel::kClassifyTextSafety:
            return "Receive on_device_model::mojom::OnDeviceModel::ClassifyTextSafety";
      case messages::OnDeviceModel::kDetectLanguage:
            return "Receive on_device_model::mojom::OnDeviceModel::DetectLanguage";
      case messages::OnDeviceModel::kLoadAdaptation:
            return "Receive on_device_model::mojom::OnDeviceModel::LoadAdaptation";
    }
  } else {
    switch (static_cast<messages::OnDeviceModel>(message.name())) {
      case messages::OnDeviceModel::kStartSession:
            return "Receive reply on_device_model::mojom::OnDeviceModel::StartSession";
      case messages::OnDeviceModel::kClassifyTextSafety:
            return "Receive reply on_device_model::mojom::OnDeviceModel::ClassifyTextSafety";
      case messages::OnDeviceModel::kDetectLanguage:
            return "Receive reply on_device_model::mojom::OnDeviceModel::DetectLanguage";
      case messages::OnDeviceModel::kLoadAdaptation:
            return "Receive reply on_device_model::mojom::OnDeviceModel::LoadAdaptation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OnDeviceModel::StartSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf6dc7e73;  // IPCStableHash for on_device_model::mojom::OnDeviceModel::StartSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModel::ClassifyTextSafety_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2abd41a0;  // IPCStableHash for on_device_model::mojom::OnDeviceModel::ClassifyTextSafety
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModel::DetectLanguage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x03b281c1;  // IPCStableHash for on_device_model::mojom::OnDeviceModel::DetectLanguage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OnDeviceModel::LoadAdaptation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7eebf1e6;  // IPCStableHash for on_device_model::mojom::OnDeviceModel::LoadAdaptation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OnDeviceModel_ClassifyTextSafety_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModel_ClassifyTextSafety_ForwardToCallback(
      OnDeviceModel::ClassifyTextSafetyCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModel_ClassifyTextSafety_ForwardToCallback(const OnDeviceModel_ClassifyTextSafety_ForwardToCallback&) = delete;
  OnDeviceModel_ClassifyTextSafety_ForwardToCallback& operator=(const OnDeviceModel_ClassifyTextSafety_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModel::ClassifyTextSafetyCallback callback_;
};

class OnDeviceModel_DetectLanguage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModel_DetectLanguage_ForwardToCallback(
      OnDeviceModel::DetectLanguageCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModel_DetectLanguage_ForwardToCallback(const OnDeviceModel_DetectLanguage_ForwardToCallback&) = delete;
  OnDeviceModel_DetectLanguage_ForwardToCallback& operator=(const OnDeviceModel_DetectLanguage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModel::DetectLanguageCallback callback_;
};

class OnDeviceModel_LoadAdaptation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OnDeviceModel_LoadAdaptation_ForwardToCallback(
      OnDeviceModel::LoadAdaptationCallback callback
      ) : callback_(std::move(callback)) {
  }

  OnDeviceModel_LoadAdaptation_ForwardToCallback(const OnDeviceModel_LoadAdaptation_ForwardToCallback&) = delete;
  OnDeviceModel_LoadAdaptation_ForwardToCallback& operator=(const OnDeviceModel_LoadAdaptation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OnDeviceModel::LoadAdaptationCallback callback_;
};

OnDeviceModelProxy::OnDeviceModelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OnDeviceModelProxy::StartSession(
    ::mojo::PendingReceiver<Session> in_session, SessionParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModel::StartSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<Session>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type SessionParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kStartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_StartSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::SessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in OnDeviceModel.StartSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::SessionParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("StartSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OnDeviceModelProxy::ClassifyTextSafety(
    const ::blink::String& in_text, ClassifyTextSafetyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModel::ClassifyTextSafety", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kClassifyTextSafety), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_ClassifyTextSafety_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in OnDeviceModel.ClassifyTextSafety request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("ClassifyTextSafety");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModel_ClassifyTextSafety_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelProxy::DetectLanguage(
    const ::blink::String& in_text, DetectLanguageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModel::DetectLanguage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kDetectLanguage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_DetectLanguage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in OnDeviceModel.DetectLanguage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("DetectLanguage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModel_DetectLanguage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OnDeviceModelProxy::LoadAdaptation(
    LoadAdaptationParamsPtr in_params, ::mojo::PendingReceiver<OnDeviceModel> in_model, LoadAdaptationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::OnDeviceModel::LoadAdaptation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type LoadAdaptationParamsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<OnDeviceModel>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kLoadAdaptation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_LoadAdaptation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::LoadAdaptationParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in OnDeviceModel.LoadAdaptation request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in OnDeviceModel.LoadAdaptation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("LoadAdaptation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OnDeviceModel_LoadAdaptation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OnDeviceModel_ClassifyTextSafety_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModel::ClassifyTextSafetyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModel_ClassifyTextSafety_ProxyToResponder> proxy(
        new OnDeviceModel_ClassifyTextSafety_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModel_ClassifyTextSafety_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModel_ClassifyTextSafety_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModel_ClassifyTextSafety_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModel::ClassifyTextSafetyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SafetyInfoPtr in_safety_info);
};

bool OnDeviceModel_ClassifyTextSafety_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModel_ClassifyTextSafety_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModel_ClassifyTextSafety_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModel.1
  bool success = true;
  SafetyInfoPtr p_safety_info{};
  OnDeviceModel_ClassifyTextSafety_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSafetyInfo(&p_safety_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModel::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_safety_info));
  }
  return true;
}

void OnDeviceModel_ClassifyTextSafety_ProxyToResponder::Run(
    SafetyInfoPtr in_safety_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModel::ClassifyTextSafety", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safety_info"), in_safety_info,
                        "<value of type SafetyInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kClassifyTextSafety), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_ClassifyTextSafety_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->safety_info)::BaseType> safety_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView>(
    in_safety_info,
    safety_info_fragment);

  params->safety_info.Set(
      safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("ClassifyTextSafety");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModel_DetectLanguage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModel::DetectLanguageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModel_DetectLanguage_ProxyToResponder> proxy(
        new OnDeviceModel_DetectLanguage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModel_DetectLanguage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModel_DetectLanguage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModel_DetectLanguage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModel::DetectLanguageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LanguageDetectionResultPtr in_result);
};

bool OnDeviceModel_DetectLanguage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModel_DetectLanguage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModel_DetectLanguage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModel.2
  bool success = true;
  LanguageDetectionResultPtr p_result{};
  OnDeviceModel_DetectLanguage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModel::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModel_DetectLanguage_ProxyToResponder::Run(
    LanguageDetectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModel::DetectLanguage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type LanguageDetectionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kDetectLanguage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_DetectLanguage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::LanguageDetectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("DetectLanguage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OnDeviceModel_LoadAdaptation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OnDeviceModel::LoadAdaptationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OnDeviceModel_LoadAdaptation_ProxyToResponder> proxy(
        new OnDeviceModel_LoadAdaptation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OnDeviceModel_LoadAdaptation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OnDeviceModel_LoadAdaptation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OnDeviceModel_LoadAdaptation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OnDeviceModel::LoadAdaptationCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LoadModelResult in_result);
};

bool OnDeviceModel_LoadAdaptation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OnDeviceModel_LoadAdaptation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OnDeviceModel_LoadAdaptation_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OnDeviceModel.3
  bool success = true;
  LoadModelResult p_result{};
  OnDeviceModel_LoadAdaptation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OnDeviceModel::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void OnDeviceModel_LoadAdaptation_ProxyToResponder::Run(
    LoadModelResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::OnDeviceModel::LoadAdaptation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type LoadModelResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OnDeviceModel::kLoadAdaptation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::OnDeviceModel_LoadAdaptation_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OnDeviceModel::Name_);
  message.set_method_name("LoadAdaptation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OnDeviceModelStubDispatch::Accept(
    OnDeviceModel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OnDeviceModel>(message->header()->name)) {
    case messages::OnDeviceModel::kStartSession: {
      DCHECK(message->is_serialized());
      internal::OnDeviceModel_StartSession_Params_Data* params =
          reinterpret_cast<internal::OnDeviceModel_StartSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OnDeviceModel.0
      bool success = true;
      ::mojo::PendingReceiver<Session> p_session{};
      SessionParamsPtr p_params{};
      OnDeviceModel_StartSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSession(        
        std::move(p_session), 
        std::move(p_params));
      return true;
    }
    case messages::OnDeviceModel::kClassifyTextSafety: {
      break;
    }
    case messages::OnDeviceModel::kDetectLanguage: {
      break;
    }
    case messages::OnDeviceModel::kLoadAdaptation: {
      break;
    }
  }
  return false;
}

// static
bool OnDeviceModelStubDispatch::AcceptWithResponder(
    OnDeviceModel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OnDeviceModel>(message->header()->name)) {
    case messages::OnDeviceModel::kStartSession: {
      break;
    }
    case messages::OnDeviceModel::kClassifyTextSafety: {
      internal::OnDeviceModel_ClassifyTextSafety_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModel_ClassifyTextSafety_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModel.1
      bool success = true;
      ::blink::String p_text{};
      OnDeviceModel_ClassifyTextSafety_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModel::Name_, 1, false);
        return false;
      }
      auto callback =
          OnDeviceModel_ClassifyTextSafety_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClassifyTextSafety(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::OnDeviceModel::kDetectLanguage: {
      internal::OnDeviceModel_DetectLanguage_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModel_DetectLanguage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModel.2
      bool success = true;
      ::blink::String p_text{};
      OnDeviceModel_DetectLanguage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModel::Name_, 2, false);
        return false;
      }
      auto callback =
          OnDeviceModel_DetectLanguage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetectLanguage(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::OnDeviceModel::kLoadAdaptation: {
      internal::OnDeviceModel_LoadAdaptation_Params_Data* params =
          reinterpret_cast<
              internal::OnDeviceModel_LoadAdaptation_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OnDeviceModel.3
      bool success = true;
      LoadAdaptationParamsPtr p_params{};
      ::mojo::PendingReceiver<OnDeviceModel> p_model{};
      OnDeviceModel_LoadAdaptation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OnDeviceModel::Name_, 3, false);
        return false;
      }
      auto callback =
          OnDeviceModel_LoadAdaptation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadAdaptation(        
        std::move(p_params), 
        std::move(p_model), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOnDeviceModelValidationInfo[] = {
    { &internal::OnDeviceModel_StartSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OnDeviceModel_ClassifyTextSafety_Params_Data::Validate,
     &internal::OnDeviceModel_ClassifyTextSafety_ResponseParams_Data::Validate},
    { &internal::OnDeviceModel_DetectLanguage_Params_Data::Validate,
     &internal::OnDeviceModel_DetectLanguage_ResponseParams_Data::Validate},
    { &internal::OnDeviceModel_LoadAdaptation_Params_Data::Validate,
     &internal::OnDeviceModel_LoadAdaptation_ResponseParams_Data::Validate},
};

bool OnDeviceModelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::OnDeviceModel::Name_,
    kOnDeviceModelValidationInfo);
}

bool OnDeviceModelResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_model::mojom::blink::OnDeviceModel::Name_,
    kOnDeviceModelValidationInfo);
}
// The declaration includes the definition on other builds.

TextSafetySession::IPCStableHashFunction TextSafetySession::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextSafetySession>(message.name())) {
    case messages::TextSafetySession::kClassifyTextSafety: {
      return &TextSafetySession::ClassifyTextSafety_Sym::IPCStableHash;
    }
    case messages::TextSafetySession::kDetectLanguage: {
      return &TextSafetySession::DetectLanguage_Sym::IPCStableHash;
    }
    case messages::TextSafetySession::kClone: {
      return &TextSafetySession::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextSafetySession::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextSafetySession>(message.name())) {
      case messages::TextSafetySession::kClassifyTextSafety:
            return "Receive on_device_model::mojom::TextSafetySession::ClassifyTextSafety";
      case messages::TextSafetySession::kDetectLanguage:
            return "Receive on_device_model::mojom::TextSafetySession::DetectLanguage";
      case messages::TextSafetySession::kClone:
            return "Receive on_device_model::mojom::TextSafetySession::Clone";
    }
  } else {
    switch (static_cast<messages::TextSafetySession>(message.name())) {
      case messages::TextSafetySession::kClassifyTextSafety:
            return "Receive reply on_device_model::mojom::TextSafetySession::ClassifyTextSafety";
      case messages::TextSafetySession::kDetectLanguage:
            return "Receive reply on_device_model::mojom::TextSafetySession::DetectLanguage";
      case messages::TextSafetySession::kClone:
            return "Receive reply on_device_model::mojom::TextSafetySession::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextSafetySession::ClassifyTextSafety_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x845ea413;  // IPCStableHash for on_device_model::mojom::TextSafetySession::ClassifyTextSafety
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSafetySession::DetectLanguage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54978217;  // IPCStableHash for on_device_model::mojom::TextSafetySession::DetectLanguage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TextSafetySession::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeed2d658;  // IPCStableHash for on_device_model::mojom::TextSafetySession::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TextSafetySession_ClassifyTextSafety_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextSafetySession_ClassifyTextSafety_ForwardToCallback(
      TextSafetySession::ClassifyTextSafetyCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextSafetySession_ClassifyTextSafety_ForwardToCallback(const TextSafetySession_ClassifyTextSafety_ForwardToCallback&) = delete;
  TextSafetySession_ClassifyTextSafety_ForwardToCallback& operator=(const TextSafetySession_ClassifyTextSafety_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextSafetySession::ClassifyTextSafetyCallback callback_;
};

class TextSafetySession_DetectLanguage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TextSafetySession_DetectLanguage_ForwardToCallback(
      TextSafetySession::DetectLanguageCallback callback
      ) : callback_(std::move(callback)) {
  }

  TextSafetySession_DetectLanguage_ForwardToCallback(const TextSafetySession_DetectLanguage_ForwardToCallback&) = delete;
  TextSafetySession_DetectLanguage_ForwardToCallback& operator=(const TextSafetySession_DetectLanguage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TextSafetySession::DetectLanguageCallback callback_;
};

TextSafetySessionProxy::TextSafetySessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextSafetySessionProxy::ClassifyTextSafety(
    const ::blink::String& in_text, ClassifyTextSafetyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::TextSafetySession::ClassifyTextSafety", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetySession::kClassifyTextSafety), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetySession_ClassifyTextSafety_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in TextSafetySession.ClassifyTextSafety request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetySession::Name_);
  message.set_method_name("ClassifyTextSafety");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextSafetySession_ClassifyTextSafety_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextSafetySessionProxy::DetectLanguage(
    const ::blink::String& in_text, DetectLanguageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::TextSafetySession::DetectLanguage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text"), in_text,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetySession::kDetectLanguage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetySession_DetectLanguage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->text)::BaseType> text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_text,
    text_fragment);

  params->text.Set(
      text_fragment.is_null() ? nullptr : text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null text in TextSafetySession.DetectLanguage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetySession::Name_);
  message.set_method_name("DetectLanguage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TextSafetySession_DetectLanguage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TextSafetySessionProxy::Clone(
    ::mojo::PendingReceiver<TextSafetySession> in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::TextSafetySession::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<TextSafetySession>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetySession::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetySession_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::TextSafetySessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in TextSafetySession.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetySession::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class TextSafetySession_ClassifyTextSafety_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextSafetySession::ClassifyTextSafetyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextSafetySession_ClassifyTextSafety_ProxyToResponder> proxy(
        new TextSafetySession_ClassifyTextSafety_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextSafetySession_ClassifyTextSafety_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextSafetySession_ClassifyTextSafety_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextSafetySession_ClassifyTextSafety_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextSafetySession::ClassifyTextSafetyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SafetyInfoPtr in_safety_info);
};

bool TextSafetySession_ClassifyTextSafety_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextSafetySession_ClassifyTextSafety_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextSafetySession_ClassifyTextSafety_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextSafetySession.1
  bool success = true;
  SafetyInfoPtr p_safety_info{};
  TextSafetySession_ClassifyTextSafety_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSafetyInfo(&p_safety_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextSafetySession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_safety_info));
  }
  return true;
}

void TextSafetySession_ClassifyTextSafety_ProxyToResponder::Run(
    SafetyInfoPtr in_safety_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::TextSafetySession::ClassifyTextSafety", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("safety_info"), in_safety_info,
                        "<value of type SafetyInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetySession::kClassifyTextSafety), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetySession_ClassifyTextSafety_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->safety_info)::BaseType> safety_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::SafetyInfoDataView>(
    in_safety_info,
    safety_info_fragment);

  params->safety_info.Set(
      safety_info_fragment.is_null() ? nullptr : safety_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetySession::Name_);
  message.set_method_name("ClassifyTextSafety");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TextSafetySession_DetectLanguage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TextSafetySession::DetectLanguageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TextSafetySession_DetectLanguage_ProxyToResponder> proxy(
        new TextSafetySession_DetectLanguage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TextSafetySession_DetectLanguage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TextSafetySession_DetectLanguage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TextSafetySession_DetectLanguage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TextSafetySession::DetectLanguageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LanguageDetectionResultPtr in_result);
};

bool TextSafetySession_DetectLanguage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TextSafetySession_DetectLanguage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TextSafetySession_DetectLanguage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TextSafetySession.2
  bool success = true;
  LanguageDetectionResultPtr p_result{};
  TextSafetySession_DetectLanguage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TextSafetySession::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void TextSafetySession_DetectLanguage_ProxyToResponder::Run(
    LanguageDetectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_model::mojom::TextSafetySession::DetectLanguage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type LanguageDetectionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetySession::kDetectLanguage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetySession_DetectLanguage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::LanguageDetectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetySession::Name_);
  message.set_method_name("DetectLanguage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TextSafetySessionStubDispatch::Accept(
    TextSafetySession* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextSafetySession>(message->header()->name)) {
    case messages::TextSafetySession::kClassifyTextSafety: {
      break;
    }
    case messages::TextSafetySession::kDetectLanguage: {
      break;
    }
    case messages::TextSafetySession::kClone: {
      DCHECK(message->is_serialized());
      internal::TextSafetySession_Clone_Params_Data* params =
          reinterpret_cast<internal::TextSafetySession_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSafetySession.3
      bool success = true;
      ::mojo::PendingReceiver<TextSafetySession> p_session{};
      TextSafetySession_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSafetySession::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_session));
      return true;
    }
  }
  return false;
}

// static
bool TextSafetySessionStubDispatch::AcceptWithResponder(
    TextSafetySession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextSafetySession>(message->header()->name)) {
    case messages::TextSafetySession::kClassifyTextSafety: {
      internal::TextSafetySession_ClassifyTextSafety_Params_Data* params =
          reinterpret_cast<
              internal::TextSafetySession_ClassifyTextSafety_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextSafetySession.1
      bool success = true;
      ::blink::String p_text{};
      TextSafetySession_ClassifyTextSafety_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSafetySession::Name_, 1, false);
        return false;
      }
      auto callback =
          TextSafetySession_ClassifyTextSafety_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClassifyTextSafety(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::TextSafetySession::kDetectLanguage: {
      internal::TextSafetySession_DetectLanguage_Params_Data* params =
          reinterpret_cast<
              internal::TextSafetySession_DetectLanguage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TextSafetySession.2
      bool success = true;
      ::blink::String p_text{};
      TextSafetySession_DetectLanguage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadText(&p_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSafetySession::Name_, 2, false);
        return false;
      }
      auto callback =
          TextSafetySession_DetectLanguage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DetectLanguage(        
        std::move(p_text), std::move(callback));
      return true;
    }
    case messages::TextSafetySession::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextSafetySessionValidationInfo[] = {
    {nullptr, nullptr},  // nonexistent
    { &internal::TextSafetySession_ClassifyTextSafety_Params_Data::Validate,
     &internal::TextSafetySession_ClassifyTextSafety_ResponseParams_Data::Validate},
    { &internal::TextSafetySession_DetectLanguage_Params_Data::Validate,
     &internal::TextSafetySession_DetectLanguage_ResponseParams_Data::Validate},
    { &internal::TextSafetySession_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextSafetySessionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::TextSafetySession::Name_,
    kTextSafetySessionValidationInfo);
}

bool TextSafetySessionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_model::mojom::blink::TextSafetySession::Name_,
    kTextSafetySessionValidationInfo);
}
// The declaration includes the definition on other builds.

TextSafetyModel::IPCStableHashFunction TextSafetyModel::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TextSafetyModel>(message.name())) {
    case messages::TextSafetyModel::kStartSession: {
      return &TextSafetyModel::StartSession_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TextSafetyModel::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TextSafetyModel>(message.name())) {
      case messages::TextSafetyModel::kStartSession:
            return "Receive on_device_model::mojom::TextSafetyModel::StartSession";
    }
  } else {
    switch (static_cast<messages::TextSafetyModel>(message.name())) {
      case messages::TextSafetyModel::kStartSession:
            return "Receive reply on_device_model::mojom::TextSafetyModel::StartSession";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TextSafetyModel::StartSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd6153386;  // IPCStableHash for on_device_model::mojom::TextSafetyModel::StartSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TextSafetyModelProxy::TextSafetyModelProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TextSafetyModelProxy::StartSession(
    ::mojo::PendingReceiver<TextSafetySession> in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::TextSafetyModel::StartSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type ::mojo::PendingReceiver<TextSafetySession>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TextSafetyModel::kStartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::TextSafetyModel_StartSession_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::TextSafetySessionInterfaceBase>>(
    in_session,
    &params->session,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session in TextSafetyModel.StartSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TextSafetyModel::Name_);
  message.set_method_name("StartSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TextSafetyModelStubDispatch::Accept(
    TextSafetyModel* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TextSafetyModel>(message->header()->name)) {
    case messages::TextSafetyModel::kStartSession: {
      DCHECK(message->is_serialized());
      internal::TextSafetyModel_StartSession_Params_Data* params =
          reinterpret_cast<internal::TextSafetyModel_StartSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TextSafetyModel.0
      bool success = true;
      ::mojo::PendingReceiver<TextSafetySession> p_session{};
      TextSafetyModel_StartSession_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_session =
            input_data_view.TakeSession<decltype(p_session)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TextSafetyModel::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSession(        
        std::move(p_session));
      return true;
    }
  }
  return false;
}

// static
bool TextSafetyModelStubDispatch::AcceptWithResponder(
    TextSafetyModel* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TextSafetyModel>(message->header()->name)) {
    case messages::TextSafetyModel::kStartSession: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTextSafetyModelValidationInfo[] = {
    { &internal::TextSafetyModel_StartSession_Params_Data::Validate,
     nullptr /* no response */},
};

bool TextSafetyModelRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::TextSafetyModel::Name_,
    kTextSafetyModelValidationInfo);
}

// The declaration includes the definition on other builds.

AsrStreamResponder::IPCStableHashFunction AsrStreamResponder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AsrStreamResponder>(message.name())) {
    case messages::AsrStreamResponder::kOnResponse: {
      return &AsrStreamResponder::OnResponse_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AsrStreamResponder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AsrStreamResponder>(message.name())) {
      case messages::AsrStreamResponder::kOnResponse:
            return "Receive on_device_model::mojom::AsrStreamResponder::OnResponse";
    }
  } else {
    switch (static_cast<messages::AsrStreamResponder>(message.name())) {
      case messages::AsrStreamResponder::kOnResponse:
            return "Receive reply on_device_model::mojom::AsrStreamResponder::OnResponse";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AsrStreamResponder::OnResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49656466;  // IPCStableHash for on_device_model::mojom::AsrStreamResponder::OnResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AsrStreamResponderProxy::AsrStreamResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AsrStreamResponderProxy::OnResponse(
    ::blink::Vector<SpeechRecognitionResultPtr> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::AsrStreamResponder::OnResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::Vector<SpeechRecognitionResultPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AsrStreamResponder::kOnResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::AsrStreamResponder_OnResponse_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::on_device_model::mojom::SpeechRecognitionResultDataView>>(
    in_result,
    result_fragment,
    &result_validate_params);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in AsrStreamResponder.OnResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AsrStreamResponder::Name_);
  message.set_method_name("OnResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AsrStreamResponderStubDispatch::Accept(
    AsrStreamResponder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AsrStreamResponder>(message->header()->name)) {
    case messages::AsrStreamResponder::kOnResponse: {
      DCHECK(message->is_serialized());
      internal::AsrStreamResponder_OnResponse_Params_Data* params =
          reinterpret_cast<internal::AsrStreamResponder_OnResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AsrStreamResponder.0
      bool success = true;
      ::blink::Vector<SpeechRecognitionResultPtr> p_result{};
      AsrStreamResponder_OnResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AsrStreamResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResponse(        
        std::move(p_result));
      return true;
    }
  }
  return false;
}

// static
bool AsrStreamResponderStubDispatch::AcceptWithResponder(
    AsrStreamResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AsrStreamResponder>(message->header()->name)) {
    case messages::AsrStreamResponder::kOnResponse: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAsrStreamResponderValidationInfo[] = {
    { &internal::AsrStreamResponder_OnResponse_Params_Data::Validate,
     nullptr /* no response */},
};

bool AsrStreamResponderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::AsrStreamResponder::Name_,
    kAsrStreamResponderValidationInfo);
}

// The declaration includes the definition on other builds.

AsrStreamInput::IPCStableHashFunction AsrStreamInput::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AsrStreamInput>(message.name())) {
    case messages::AsrStreamInput::kAddAudioChunk: {
      return &AsrStreamInput::AddAudioChunk_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AsrStreamInput::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AsrStreamInput>(message.name())) {
      case messages::AsrStreamInput::kAddAudioChunk:
            return "Receive on_device_model::mojom::AsrStreamInput::AddAudioChunk";
    }
  } else {
    switch (static_cast<messages::AsrStreamInput>(message.name())) {
      case messages::AsrStreamInput::kAddAudioChunk:
            return "Receive reply on_device_model::mojom::AsrStreamInput::AddAudioChunk";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AsrStreamInput::AddAudioChunk_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x465b0475;  // IPCStableHash for on_device_model::mojom::AsrStreamInput::AddAudioChunk
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

AsrStreamInputProxy::AsrStreamInputProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AsrStreamInputProxy::AddAudioChunk(
    AudioDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_model::mojom::AsrStreamInput::AddAudioChunk", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type AudioDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AsrStreamInput::kAddAudioChunk), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_model::mojom::internal::AsrStreamInput_AddAudioChunk_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::AudioDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in AsrStreamInput.AddAudioChunk request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AsrStreamInput::Name_);
  message.set_method_name("AddAudioChunk");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool AsrStreamInputStubDispatch::Accept(
    AsrStreamInput* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AsrStreamInput>(message->header()->name)) {
    case messages::AsrStreamInput::kAddAudioChunk: {
      DCHECK(message->is_serialized());
      internal::AsrStreamInput_AddAudioChunk_Params_Data* params =
          reinterpret_cast<internal::AsrStreamInput_AddAudioChunk_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AsrStreamInput.0
      bool success = true;
      AudioDataPtr p_data{};
      AsrStreamInput_AddAudioChunk_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AsrStreamInput::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAudioChunk(        
        std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool AsrStreamInputStubDispatch::AcceptWithResponder(
    AsrStreamInput* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AsrStreamInput>(message->header()->name)) {
    case messages::AsrStreamInput::kAddAudioChunk: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAsrStreamInputValidationInfo[] = {
    { &internal::AsrStreamInput_AddAudioChunk_Params_Data::Validate,
     nullptr /* no response */},
};

bool AsrStreamInputRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_model::mojom::blink::AsrStreamInput::Name_,
    kAsrStreamInputValidationInfo);
}



}  // on_device_model::mojom::blink


namespace mojo {


// static
bool StructTraits<::on_device_model::mojom::blink::AdaptationAssets::DataView, ::on_device_model::mojom::blink::AdaptationAssetsPtr>::Read(
    ::on_device_model::mojom::blink::AdaptationAssets::DataView input,
    ::on_device_model::mojom::blink::AdaptationAssetsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::AdaptationAssetsPtr result(::on_device_model::mojom::blink::AdaptationAssets::New());
  
      if (success && !input.ReadWeights(&result->weights))
        success = false;
      if (success && !input.ReadWeightsPath(&result->weights_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::LanguageDetectionResult::DataView, ::on_device_model::mojom::blink::LanguageDetectionResultPtr>::Read(
    ::on_device_model::mojom::blink::LanguageDetectionResult::DataView input,
    ::on_device_model::mojom::blink::LanguageDetectionResultPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::LanguageDetectionResultPtr result(::on_device_model::mojom::blink::LanguageDetectionResult::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success)
        result->reliability = input.reliability();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::SafetyInfo::DataView, ::on_device_model::mojom::blink::SafetyInfoPtr>::Read(
    ::on_device_model::mojom::blink::SafetyInfo::DataView input,
    ::on_device_model::mojom::blink::SafetyInfoPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::SafetyInfoPtr result(::on_device_model::mojom::blink::SafetyInfo::New());
  
      if (success && !input.ReadClassScores(&result->class_scores))
        success = false;
      if (success && !input.ReadLanguage(&result->language))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::ResponseChunk::DataView, ::on_device_model::mojom::blink::ResponseChunkPtr>::Read(
    ::on_device_model::mojom::blink::ResponseChunk::DataView input,
    ::on_device_model::mojom::blink::ResponseChunkPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::ResponseChunkPtr result(::on_device_model::mojom::blink::ResponseChunk::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadSafetyInfo(&result->safety_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::ResponseSummary::DataView, ::on_device_model::mojom::blink::ResponseSummaryPtr>::Read(
    ::on_device_model::mojom::blink::ResponseSummary::DataView input,
    ::on_device_model::mojom::blink::ResponseSummaryPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::ResponseSummaryPtr result(::on_device_model::mojom::blink::ResponseSummary::New());
  
      if (success && !input.ReadSafetyInfo(&result->safety_info))
        success = false;
      if (success)
        result->output_token_count = input.output_token_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::LoadAdaptationParams::DataView, ::on_device_model::mojom::blink::LoadAdaptationParamsPtr>::Read(
    ::on_device_model::mojom::blink::LoadAdaptationParams::DataView input,
    ::on_device_model::mojom::blink::LoadAdaptationParamsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::LoadAdaptationParamsPtr result(::on_device_model::mojom::blink::LoadAdaptationParams::New());
  
      if (success && !input.ReadAssets(&result->assets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::Capabilities::DataView, ::on_device_model::mojom::blink::CapabilitiesPtr>::Read(
    ::on_device_model::mojom::blink::Capabilities::DataView input,
    ::on_device_model::mojom::blink::CapabilitiesPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::CapabilitiesPtr result(::on_device_model::mojom::blink::Capabilities::New());
  
      if (success)
        result->image_input = input.image_input();
      if (success)
        result->audio_input = input.audio_input();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::SessionParams::DataView, ::on_device_model::mojom::blink::SessionParamsPtr>::Read(
    ::on_device_model::mojom::blink::SessionParams::DataView input,
    ::on_device_model::mojom::blink::SessionParamsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::SessionParamsPtr result(::on_device_model::mojom::blink::SessionParams::New());
  
      if (success)
        result->max_tokens = input.max_tokens();
      if (success && !input.ReadCapabilities(&result->capabilities))
        success = false;
      if (success)
        result->top_k = input.top_k();
      if (success)
        result->temperature = input.temperature();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::Input::DataView, ::on_device_model::mojom::blink::InputPtr>::Read(
    ::on_device_model::mojom::blink::Input::DataView input,
    ::on_device_model::mojom::blink::InputPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::InputPtr result(::on_device_model::mojom::blink::Input::New());
  
      if (success && !input.ReadPieces(&result->pieces))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::AppendOptions::DataView, ::on_device_model::mojom::blink::AppendOptionsPtr>::Read(
    ::on_device_model::mojom::blink::AppendOptions::DataView input,
    ::on_device_model::mojom::blink::AppendOptionsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::AppendOptionsPtr result(::on_device_model::mojom::blink::AppendOptions::New());
  
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success)
        result->max_tokens = input.max_tokens();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::GenerateOptions::DataView, ::on_device_model::mojom::blink::GenerateOptionsPtr>::Read(
    ::on_device_model::mojom::blink::GenerateOptions::DataView input,
    ::on_device_model::mojom::blink::GenerateOptionsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::GenerateOptionsPtr result(::on_device_model::mojom::blink::GenerateOptions::New());
  
      if (success)
        result->max_output_tokens = input.max_output_tokens();
      if (success && !input.ReadConstraint(&result->constraint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::AudioData::DataView, ::on_device_model::mojom::blink::AudioDataPtr>::Read(
    ::on_device_model::mojom::blink::AudioData::DataView input,
    ::on_device_model::mojom::blink::AudioDataPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::AudioDataPtr result(::on_device_model::mojom::blink::AudioData::New());
  
      if (success)
        result->channel_count = input.channel_count();
      if (success)
        result->sample_rate = input.sample_rate();
      if (success)
        result->frame_count = input.frame_count();
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::SpeechRecognitionResult::DataView, ::on_device_model::mojom::blink::SpeechRecognitionResultPtr>::Read(
    ::on_device_model::mojom::blink::SpeechRecognitionResult::DataView input,
    ::on_device_model::mojom::blink::SpeechRecognitionResultPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::SpeechRecognitionResultPtr result(::on_device_model::mojom::blink::SpeechRecognitionResult::New());
  
      if (success && !input.ReadTranscript(&result->transcript))
        success = false;
      if (success)
        result->is_final = input.is_final();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::AsrStreamOptions::DataView, ::on_device_model::mojom::blink::AsrStreamOptionsPtr>::Read(
    ::on_device_model::mojom::blink::AsrStreamOptions::DataView input,
    ::on_device_model::mojom::blink::AsrStreamOptionsPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::AsrStreamOptionsPtr result(::on_device_model::mojom::blink::AsrStreamOptions::New());
  
      if (success)
        result->sample_rate_hz = input.sample_rate_hz();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::DevicePerformanceInfo::DataView, ::on_device_model::mojom::blink::DevicePerformanceInfoPtr>::Read(
    ::on_device_model::mojom::blink::DevicePerformanceInfo::DataView input,
    ::on_device_model::mojom::blink::DevicePerformanceInfoPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::DevicePerformanceInfoPtr result(::on_device_model::mojom::blink::DevicePerformanceInfo::New());
  
      if (success && !input.ReadPerformanceClass(&result->performance_class))
        success = false;
      if (success)
        result->vram_mb = input.vram_mb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_model::mojom::blink::DeviceInfo::DataView, ::on_device_model::mojom::blink::DeviceInfoPtr>::Read(
    ::on_device_model::mojom::blink::DeviceInfo::DataView input,
    ::on_device_model::mojom::blink::DeviceInfoPtr* output) {
  bool success = true;
  ::on_device_model::mojom::blink::DeviceInfoPtr result(::on_device_model::mojom::blink::DeviceInfo::New());
  
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->device_id = input.device_id();
      if (success && !input.ReadDriverVersion(&result->driver_version))
        success = false;
      if (success)
        result->supports_fp16 = input.supports_fp16();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::on_device_model::mojom::blink::InputPiece::DataView, ::on_device_model::mojom::blink::InputPiecePtr>::Read(
    ::on_device_model::mojom::blink::InputPiece::DataView input,
    ::on_device_model::mojom::blink::InputPiecePtr* output) {
  using UnionType = ::on_device_model::mojom::blink::InputPiece;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kToken: {
      ::on_device_model::mojom::blink::Token result_token;
      if (!input.ReadToken(&result_token))
        return false;

      *output = UnionType::NewToken(result_token);
      break;
    }
    case Tag::kText: {
      ::blink::String result_text{};
      if (!input.ReadText(&result_text))
        return false;

      *output = UnionType::NewText(
          std::move(result_text));
      break;
    }
    case Tag::kBitmap: {
      ::SkBitmap result_bitmap{};
      if (!input.ReadBitmap(&result_bitmap))
        return false;

      *output = UnionType::NewBitmap(
          std::move(result_bitmap));
      break;
    }
    case Tag::kUnknownType: {
      *output = UnionType::NewUnknownType(input.unknown_type());
      break;
    }
    case Tag::kAudio: {
      ::on_device_model::mojom::blink::AudioDataPtr result_audio{};
      if (!input.ReadAudio(&result_audio))
        return false;

      *output = UnionType::NewAudio(
          std::move(result_audio));
      break;
    }
    default:

      *output = UnionType::NewUnknownType({});
      return true;
  }
  return true;
}

// static
bool UnionTraits<::on_device_model::mojom::blink::ResponseConstraint::DataView, ::on_device_model::mojom::blink::ResponseConstraintPtr>::Read(
    ::on_device_model::mojom::blink::ResponseConstraint::DataView input,
    ::on_device_model::mojom::blink::ResponseConstraintPtr* output) {
  using UnionType = ::on_device_model::mojom::blink::ResponseConstraint;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kJsonSchema: {
      ::blink::String result_json_schema{};
      if (!input.ReadJsonSchema(&result_json_schema))
        return false;

      *output = UnionType::NewJsonSchema(
          std::move(result_json_schema));
      break;
    }
    case Tag::kRegex: {
      ::blink::String result_regex{};
      if (!input.ReadRegex(&result_regex))
        return false;

      *output = UnionType::NewRegex(
          std::move(result_regex));
      break;
    }
    case Tag::kUnknownType: {
      *output = UnionType::NewUnknownType(input.unknown_type());
      break;
    }
    default:

      *output = UnionType::NewUnknownType({});
      return true;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace on_device_model::mojom::blink {


void StreamingResponderInterceptorForTesting::OnResponse(ResponseChunkPtr chunk) {
  GetForwardingInterface()->OnResponse(
    std::move(chunk)
    );
}
void StreamingResponderInterceptorForTesting::OnComplete(ResponseSummaryPtr summary) {
  GetForwardingInterface()->OnComplete(
    std::move(summary)
    );
}
StreamingResponderAsyncWaiter::StreamingResponderAsyncWaiter(
    StreamingResponder* proxy) : proxy_(proxy) {}

StreamingResponderAsyncWaiter::~StreamingResponderAsyncWaiter() = default;





void ContextClientInterceptorForTesting::OnComplete(uint32_t tokens_processed) {
  GetForwardingInterface()->OnComplete(
    std::move(tokens_processed)
    );
}
ContextClientAsyncWaiter::ContextClientAsyncWaiter(
    ContextClient* proxy) : proxy_(proxy) {}

ContextClientAsyncWaiter::~ContextClientAsyncWaiter() = default;





void SessionInterceptorForTesting::Append(AppendOptionsPtr options, ::mojo::PendingRemote<ContextClient> client) {
  GetForwardingInterface()->Append(
    std::move(options)
    , 
    std::move(client)
    );
}
void SessionInterceptorForTesting::Generate(GenerateOptionsPtr options, ::mojo::PendingRemote<StreamingResponder> responder) {
  GetForwardingInterface()->Generate(
    std::move(options)
    , 
    std::move(responder)
    );
}
void SessionInterceptorForTesting::GetSizeInTokens(InputPtr input, GetSizeInTokensCallback callback) {
  GetForwardingInterface()->GetSizeInTokens(
    std::move(input)
    , std::move(callback));
}
void SessionInterceptorForTesting::Score(const ::blink::String& text, ScoreCallback callback) {
  GetForwardingInterface()->Score(
    std::move(text)
    , std::move(callback));
}
void SessionInterceptorForTesting::Clone(::mojo::PendingReceiver<Session> session) {
  GetForwardingInterface()->Clone(
    std::move(session)
    );
}
void SessionInterceptorForTesting::GetProbabilitiesBlocking(const ::blink::String& text, GetProbabilitiesBlockingCallback callback) {
  GetForwardingInterface()->GetProbabilitiesBlocking(
    std::move(text)
    , std::move(callback));
}
void SessionInterceptorForTesting::SetPriority(Priority priority) {
  GetForwardingInterface()->SetPriority(
    std::move(priority)
    );
}
void SessionInterceptorForTesting::AsrStream(AsrStreamOptionsPtr options, ::mojo::PendingReceiver<AsrStreamInput> stream, ::mojo::PendingRemote<AsrStreamResponder> responder) {
  GetForwardingInterface()->AsrStream(
    std::move(options)
    , 
    std::move(stream)
    , 
    std::move(responder)
    );
}
SessionAsyncWaiter::SessionAsyncWaiter(
    Session* proxy) : proxy_(proxy) {}

SessionAsyncWaiter::~SessionAsyncWaiter() = default;


void SessionAsyncWaiter::GetSizeInTokens(
    InputPtr input, uint32_t* out_size) {
  base::RunLoop loop;
  proxy_->GetSizeInTokens(
      std::move(input),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint32_t* out_size
,
             uint32_t size) {*out_size = std::move(size);
            loop->Quit();
          },
          &loop,
          out_size));
  loop.Run();
}

uint32_t SessionAsyncWaiter::GetSizeInTokens(
    InputPtr input) {
  uint32_t async_wait_result;
  GetSizeInTokens(std::move(input),&async_wait_result);
  return async_wait_result;
}

void SessionAsyncWaiter::Score(
    const ::blink::String& text, float* out_probability) {
  base::RunLoop loop;
  proxy_->Score(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             float* out_probability
,
             float probability) {*out_probability = std::move(probability);
            loop->Quit();
          },
          &loop,
          out_probability));
  loop.Run();
}

float SessionAsyncWaiter::Score(
    const ::blink::String& text) {
  float async_wait_result;
  Score(std::move(text),&async_wait_result);
  return async_wait_result;
}

void SessionAsyncWaiter::GetProbabilitiesBlocking(
    const ::blink::String& text, ::blink::Vector<float>* out_probabilities) {
  base::RunLoop loop;
  proxy_->GetProbabilitiesBlocking(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<float>* out_probabilities
,
             const ::blink::Vector<float>& probabilities) {*out_probabilities = std::move(probabilities);
            loop->Quit();
          },
          &loop,
          out_probabilities));
  loop.Run();
}

::blink::Vector<float> SessionAsyncWaiter::GetProbabilitiesBlocking(
    const ::blink::String& text) {
  ::blink::Vector<float> async_wait_result;
  GetProbabilitiesBlocking(std::move(text),&async_wait_result);
  return async_wait_result;
}




void OnDeviceModelInterceptorForTesting::StartSession(::mojo::PendingReceiver<Session> session, SessionParamsPtr params) {
  GetForwardingInterface()->StartSession(
    std::move(session)
    , 
    std::move(params)
    );
}
void OnDeviceModelInterceptorForTesting::ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) {
  GetForwardingInterface()->ClassifyTextSafety(
    std::move(text)
    , std::move(callback));
}
void OnDeviceModelInterceptorForTesting::DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) {
  GetForwardingInterface()->DetectLanguage(
    std::move(text)
    , std::move(callback));
}
void OnDeviceModelInterceptorForTesting::LoadAdaptation(LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadAdaptationCallback callback) {
  GetForwardingInterface()->LoadAdaptation(
    std::move(params)
    , 
    std::move(model)
    , std::move(callback));
}
OnDeviceModelAsyncWaiter::OnDeviceModelAsyncWaiter(
    OnDeviceModel* proxy) : proxy_(proxy) {}

OnDeviceModelAsyncWaiter::~OnDeviceModelAsyncWaiter() = default;


void OnDeviceModelAsyncWaiter::ClassifyTextSafety(
    const ::blink::String& text, SafetyInfoPtr* out_safety_info) {
  base::RunLoop loop;
  proxy_->ClassifyTextSafety(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             SafetyInfoPtr* out_safety_info
,
             SafetyInfoPtr safety_info) {*out_safety_info = std::move(safety_info);
            loop->Quit();
          },
          &loop,
          out_safety_info));
  loop.Run();
}

SafetyInfoPtr OnDeviceModelAsyncWaiter::ClassifyTextSafety(
    const ::blink::String& text) {
  SafetyInfoPtr async_wait_result;
  ClassifyTextSafety(std::move(text),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelAsyncWaiter::DetectLanguage(
    const ::blink::String& text, LanguageDetectionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->DetectLanguage(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             LanguageDetectionResultPtr* out_result
,
             LanguageDetectionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

LanguageDetectionResultPtr OnDeviceModelAsyncWaiter::DetectLanguage(
    const ::blink::String& text) {
  LanguageDetectionResultPtr async_wait_result;
  DetectLanguage(std::move(text),&async_wait_result);
  return async_wait_result;
}

void OnDeviceModelAsyncWaiter::LoadAdaptation(
    LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model, LoadModelResult* out_result) {
  base::RunLoop loop;
  proxy_->LoadAdaptation(
      std::move(params),
      std::move(model),
      base::BindOnce(
          [](base::RunLoop* loop,
             LoadModelResult* out_result
,
             LoadModelResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

LoadModelResult OnDeviceModelAsyncWaiter::LoadAdaptation(
    LoadAdaptationParamsPtr params, ::mojo::PendingReceiver<OnDeviceModel> model) {
  LoadModelResult async_wait_result;
  LoadAdaptation(std::move(params),std::move(model),&async_wait_result);
  return async_wait_result;
}




void TextSafetySessionInterceptorForTesting::ClassifyTextSafety(const ::blink::String& text, ClassifyTextSafetyCallback callback) {
  GetForwardingInterface()->ClassifyTextSafety(
    std::move(text)
    , std::move(callback));
}
void TextSafetySessionInterceptorForTesting::DetectLanguage(const ::blink::String& text, DetectLanguageCallback callback) {
  GetForwardingInterface()->DetectLanguage(
    std::move(text)
    , std::move(callback));
}
void TextSafetySessionInterceptorForTesting::Clone(::mojo::PendingReceiver<TextSafetySession> session) {
  GetForwardingInterface()->Clone(
    std::move(session)
    );
}
TextSafetySessionAsyncWaiter::TextSafetySessionAsyncWaiter(
    TextSafetySession* proxy) : proxy_(proxy) {}

TextSafetySessionAsyncWaiter::~TextSafetySessionAsyncWaiter() = default;


void TextSafetySessionAsyncWaiter::ClassifyTextSafety(
    const ::blink::String& text, SafetyInfoPtr* out_safety_info) {
  base::RunLoop loop;
  proxy_->ClassifyTextSafety(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             SafetyInfoPtr* out_safety_info
,
             SafetyInfoPtr safety_info) {*out_safety_info = std::move(safety_info);
            loop->Quit();
          },
          &loop,
          out_safety_info));
  loop.Run();
}

SafetyInfoPtr TextSafetySessionAsyncWaiter::ClassifyTextSafety(
    const ::blink::String& text) {
  SafetyInfoPtr async_wait_result;
  ClassifyTextSafety(std::move(text),&async_wait_result);
  return async_wait_result;
}

void TextSafetySessionAsyncWaiter::DetectLanguage(
    const ::blink::String& text, LanguageDetectionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->DetectLanguage(
      std::move(text),
      base::BindOnce(
          [](base::RunLoop* loop,
             LanguageDetectionResultPtr* out_result
,
             LanguageDetectionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

LanguageDetectionResultPtr TextSafetySessionAsyncWaiter::DetectLanguage(
    const ::blink::String& text) {
  LanguageDetectionResultPtr async_wait_result;
  DetectLanguage(std::move(text),&async_wait_result);
  return async_wait_result;
}




void TextSafetyModelInterceptorForTesting::StartSession(::mojo::PendingReceiver<TextSafetySession> session) {
  GetForwardingInterface()->StartSession(
    std::move(session)
    );
}
TextSafetyModelAsyncWaiter::TextSafetyModelAsyncWaiter(
    TextSafetyModel* proxy) : proxy_(proxy) {}

TextSafetyModelAsyncWaiter::~TextSafetyModelAsyncWaiter() = default;





void AsrStreamResponderInterceptorForTesting::OnResponse(::blink::Vector<SpeechRecognitionResultPtr> result) {
  GetForwardingInterface()->OnResponse(
    std::move(result)
    );
}
AsrStreamResponderAsyncWaiter::AsrStreamResponderAsyncWaiter(
    AsrStreamResponder* proxy) : proxy_(proxy) {}

AsrStreamResponderAsyncWaiter::~AsrStreamResponderAsyncWaiter() = default;





void AsrStreamInputInterceptorForTesting::AddAudioChunk(AudioDataPtr data) {
  GetForwardingInterface()->AddAudioChunk(
    std::move(data)
    );
}
AsrStreamInputAsyncWaiter::AsrStreamInputAsyncWaiter(
    AsrStreamInput* proxy) : proxy_(proxy) {}

AsrStreamInputAsyncWaiter::~AsrStreamInputAsyncWaiter() = default;







}  // on_device_model::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif