// services/network/public/mojom/url_response_head.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/url_response_head.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var alternate_protocol_usage$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/alternate_protocol_usage.mojom', 'alternate_protocol_usage.mojom.js');
  }
  var attribution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/attribution.mojom', 'attribution.mojom.js');
  }
  var cors$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cors.mojom', 'cors.mojom.js');
  }
  var device_bound_sessions$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/device_bound_sessions.mojom', 'device_bound_sessions.mojom.js');
  }
  var encoded_body_length$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/encoded_body_length.mojom', 'encoded_body_length.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', 'fetch_api.mojom.js');
  }
  var http_request_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/http_request_headers.mojom', 'http_request_headers.mojom.js');
  }
  var ip_address_space$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_address_space.mojom', 'ip_address_space.mojom.js');
  }
  var ip_endpoint$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/ip_endpoint.mojom', 'ip_endpoint.mojom.js');
  }
  var load_timing_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/load_timing_info.mojom', 'load_timing_info.mojom.js');
  }
  var load_timing_internal_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/load_timing_internal_info.mojom', 'load_timing_internal_info.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var network_types$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_types.mojom', 'network_types.mojom.js');
  }
  var parsed_headers$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/parsed_headers.mojom', 'parsed_headers.mojom.js');
  }
  var parsed_request_cookie$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/parsed_request_cookie.mojom', 'parsed_request_cookie.mojom.js');
  }
  var service_worker_router_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/service_worker_router_info.mojom', 'service_worker_router_info.mojom.js');
  }
  var source_type$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_type.mojom', 'source_type.mojom.js');
  }
  var unencoded_digest$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/unencoded_digest.mojom', 'unencoded_digest.mojom.js');
  }
  var proxy_resolver$ =
      mojo.internal.exposeNamespace('proxyResolver.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/proxy_resolver/public/mojom/proxy_resolver.mojom', '../../../proxy_resolver/public/mojom/proxy_resolver.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }


  var NavigationDeliveryType = {};
  NavigationDeliveryType.kDefault = 0;
  NavigationDeliveryType.kNavigationalPrefetch = 1;
  NavigationDeliveryType.MIN_VALUE = 0;
  NavigationDeliveryType.MAX_VALUE = 1;

  NavigationDeliveryType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  NavigationDeliveryType.toKnownEnumValue = function(value) {
    return value;
  };

  NavigationDeliveryType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function URLResponseHead(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  URLResponseHead.prototype.initDefaults_ = function() {
    this.requestTime = null;
    this.responseTime = null;
    this.originalResponseTime = null;
    this.headers = null;
    this.mimeType = null;
    this.charset = null;
    this.contentLength = -1;
    this.encodedDataLength = -1;
    this.encodedBodyLength = null;
    this.networkAccessed = false;
    this.emittedExtraInfo = false;
    this.wasFetchedViaSpdy = false;
    this.wasAlpnNegotiated = false;
    this.wasAlternateProtocolAvailable = false;
    this.isValidated = false;
    this.wasFetchedViaCache = false;
    this.wasFetchedViaServiceWorker = false;
    this.initial_service_worker_status_$flag = false;
    this.didServiceWorkerNavigationPreload = false;
    this.asyncRevalidationRequested = false;
    this.didMimeSniff = false;
    this.isSignedExchangeInnerResponse = false;
    this.isWebBundleInnerResponse = false;
    this.wasInPrefetchCache = false;
    this.isPrefetchWithCrossSiteContamination = false;
    this.wasCookieInRequest = false;
    this.interceptedByPlugin = false;
    this.hasRangeRequested = false;
    this.timingAllowPassed = false;
    this.hasAuthorizationCoveredByWildcardOnPreflight = false;
    this.requestIncludeCredentials = true;
    this.shouldUseSourceHashForJsCodeCache = false;
    this.didUseSharedDictionary = false;
    this.loadWithStorageAccess = false;
    this.fromSyntheticResponse = false;
    this.bypassRedirectChecks = false;
    this.didUseServerHttpAuth = false;
    this.connectionInfo = 0;
    this.loadTiming = null;
    this.loadTimingInternalInfo = null;
    this.alpnNegotiatedProtocol = null;
    this.alternateProtocolUsage = 0;
    this.clientAddressSpace = ip_address_space$.IPAddressSpace.kUnknown;
    this.remoteEndpoint = null;
    this.responseAddressSpace = ip_address_space$.IPAddressSpace.kUnknown;
    this.navigationDeliveryType = NavigationDeliveryType.kDefault;
    this.proxyChain = null;
    this.serviceWorkerResponseSource = fetch_api$.FetchResponseSource.kUnspecified;
    this.initial_service_worker_status_$value = 0;
    this.urlListViaServiceWorker = null;
    this.serviceWorkerRouterInfo = null;
    this.responseType = fetch_api$.FetchResponseType.kDefault;
    this.certStatus = 0;
    this.padding = 0;
    this.cacheStorageCacheName = null;
    this.sslInfo = null;
    this.requestCookies = null;
    this.corsExposedHeaderNames = null;
    this.authChallengeInfo = null;
    this.requestStart = null;
    this.responseStart = null;
    this.parsedHeaders = null;
    this.recursivePrefetchToken = null;
    this.dnsAliases = null;
    this.privateNetworkAccessPreflightResult = cors$.PrivateNetworkAccessPreflightResult.kNone;
    this.deviceBoundSessionUsage = device_bound_sessions$.DeviceBoundSessionUsage.kUnknown;
    this.clientSideContentDecodingTypes = null;
    this.unencodedDigests = null;
  };
  URLResponseHead.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  URLResponseHead.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 288}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.requestTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.responseTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.originalResponseTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.charset
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLResponseHead.encodedBodyLength
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, encoded_body_length$.EncodedBodyLength, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHead.loadTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, load_timing_info$.LoadTimingInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.loadTimingInternalInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, load_timing_internal_info$.LoadTimingInternalInfo, true);
    if (err !== validator.validationError.NONE)
        return err;






    // validate URLResponseHead.connectionInfo
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 76, network_types$.ConnectionInfo);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.alpnNegotiatedProtocol
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 96, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.alternateProtocolUsage
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 104, alternate_protocol_usage$.AlternateProtocolUsage);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.remoteEndpoint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, ip_endpoint$.IPEndPoint, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.clientAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 108, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.responseAddressSpace
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 120, ip_address_space$.IPAddressSpace);
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLResponseHead.navigationDeliveryType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 124, NavigationDeliveryType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.proxyChain
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, network_param$.ProxyChain, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHead.serviceWorkerResponseSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 136, fetch_api$.FetchResponseSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.urlListViaServiceWorker
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHead.initial_service_worker_status_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 140, service_worker_router_info$.ServiceWorkerStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.serviceWorkerRouterInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, service_worker_router_info$.ServiceWorkerRouterInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.responseType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 160, fetch_api$.FetchResponseType);
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHead.cacheStorageCacheName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 176, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate URLResponseHead.sslInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 184, network_param$.SSLInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.requestCookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 192, 8, new codec.PointerTo(parsed_request_cookie$.ParsedRequestCookie), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.corsExposedHeaderNames
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 200, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;













    // validate URLResponseHead.authChallengeInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 208, network_param$.AuthChallengeInfo, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.requestStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.responseStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 224, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.parsedHeaders
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 232, parsed_headers$.ParsedHeaders, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.recursivePrefetchToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 240, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.dnsAliases
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 248, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;





    // validate URLResponseHead.privateNetworkAccessPreflightResult
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 256, cors$.PrivateNetworkAccessPreflightResult);
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLResponseHead.clientSideContentDecodingTypes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 264, 4, new codec.Enum(source_type$.SourceType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate URLResponseHead.deviceBoundSessionUsage
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 260, device_bound_sessions$.DeviceBoundSessionUsage);
    if (err !== validator.validationError.NONE)
        return err;




    // validate URLResponseHead.unencodedDigests
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 272, unencoded_digest$.UnencodedDigests, true);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  URLResponseHead.encodedSize = codec.kStructHeaderSize + 280;

  URLResponseHead.decode = function(decoder) {
    var packed;
    var val = new URLResponseHead();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestTime =
        decoder.decodeStructPointer(time$.Time);
    val.responseTime =
        decoder.decodeStructPointer(time$.Time);
    val.originalResponseTime =
        decoder.decodeStructPointer(time$.Time);
    val.headers =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.mimeType =
        decoder.decodeStruct(codec.String);
    val.charset =
        decoder.decodeStruct(codec.String);
    val.contentLength =
        decoder.decodeStruct(codec.Int64);
    val.encodedDataLength =
        decoder.decodeStruct(codec.Int64);
    val.encodedBodyLength =
        decoder.decodeStructPointer(encoded_body_length$.EncodedBodyLength);
    packed = decoder.readUint8();
    val.networkAccessed = (packed >> 0) & 1 ? true : false;
    val.emittedExtraInfo = (packed >> 1) & 1 ? true : false;
    val.wasFetchedViaSpdy = (packed >> 2) & 1 ? true : false;
    val.wasAlpnNegotiated = (packed >> 3) & 1 ? true : false;
    val.wasAlternateProtocolAvailable = (packed >> 4) & 1 ? true : false;
    val.isValidated = (packed >> 5) & 1 ? true : false;
    val.wasFetchedViaCache = (packed >> 6) & 1 ? true : false;
    val.wasFetchedViaServiceWorker = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.initial_service_worker_status_$flag = (packed >> 0) & 1 ? true : false;
    val.didServiceWorkerNavigationPreload = (packed >> 1) & 1 ? true : false;
    val.asyncRevalidationRequested = (packed >> 2) & 1 ? true : false;
    val.didMimeSniff = (packed >> 3) & 1 ? true : false;
    val.isSignedExchangeInnerResponse = (packed >> 4) & 1 ? true : false;
    val.isWebBundleInnerResponse = (packed >> 5) & 1 ? true : false;
    val.wasInPrefetchCache = (packed >> 6) & 1 ? true : false;
    val.isPrefetchWithCrossSiteContamination = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.wasCookieInRequest = (packed >> 0) & 1 ? true : false;
    val.interceptedByPlugin = (packed >> 1) & 1 ? true : false;
    val.hasRangeRequested = (packed >> 2) & 1 ? true : false;
    val.timingAllowPassed = (packed >> 3) & 1 ? true : false;
    val.hasAuthorizationCoveredByWildcardOnPreflight = (packed >> 4) & 1 ? true : false;
    val.requestIncludeCredentials = (packed >> 5) & 1 ? true : false;
    val.shouldUseSourceHashForJsCodeCache = (packed >> 6) & 1 ? true : false;
    val.didUseSharedDictionary = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.loadWithStorageAccess = (packed >> 0) & 1 ? true : false;
    val.fromSyntheticResponse = (packed >> 1) & 1 ? true : false;
    val.bypassRedirectChecks = (packed >> 2) & 1 ? true : false;
    val.didUseServerHttpAuth = (packed >> 3) & 1 ? true : false;
    val.connectionInfo =
        decoder.decodeStruct(new codec.Enum(network_types$.ConnectionInfo));
    val.loadTiming =
        decoder.decodeStructPointer(load_timing_info$.LoadTimingInfo);
    val.loadTimingInternalInfo =
        decoder.decodeStructPointer(load_timing_internal_info$.LoadTimingInternalInfo);
    val.alpnNegotiatedProtocol =
        decoder.decodeStruct(codec.String);
    val.alternateProtocolUsage =
        decoder.decodeStruct(new codec.Enum(alternate_protocol_usage$.AlternateProtocolUsage));
    val.clientAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.remoteEndpoint =
        decoder.decodeStructPointer(ip_endpoint$.IPEndPoint);
    val.responseAddressSpace =
        decoder.decodeStruct(new codec.Enum(ip_address_space$.IPAddressSpace));
    val.navigationDeliveryType =
        decoder.decodeStruct(new codec.Enum(NavigationDeliveryType));
    val.proxyChain =
        decoder.decodeStructPointer(network_param$.ProxyChain);
    val.serviceWorkerResponseSource =
        decoder.decodeStruct(new codec.Enum(fetch_api$.FetchResponseSource));
    val.initial_service_worker_status_$value =
        decoder.decodeStruct(new codec.Enum(service_worker_router_info$.ServiceWorkerStatus));
    val.urlListViaServiceWorker =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.serviceWorkerRouterInfo =
        decoder.decodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo);
    val.responseType =
        decoder.decodeStruct(new codec.Enum(fetch_api$.FetchResponseType));
    val.certStatus =
        decoder.decodeStruct(codec.Uint32);
    val.padding =
        decoder.decodeStruct(codec.Int64);
    val.cacheStorageCacheName =
        decoder.decodeStruct(codec.String);
    val.sslInfo =
        decoder.decodeStructPointer(network_param$.SSLInfo);
    val.requestCookies =
        decoder.decodeArrayPointer(new codec.PointerTo(parsed_request_cookie$.ParsedRequestCookie));
    val.corsExposedHeaderNames =
        decoder.decodeArrayPointer(codec.String);
    val.authChallengeInfo =
        decoder.decodeStructPointer(network_param$.AuthChallengeInfo);
    val.requestStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.responseStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.parsedHeaders =
        decoder.decodeStructPointer(parsed_headers$.ParsedHeaders);
    val.recursivePrefetchToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.dnsAliases =
        decoder.decodeArrayPointer(codec.String);
    val.privateNetworkAccessPreflightResult =
        decoder.decodeStruct(new codec.Enum(cors$.PrivateNetworkAccessPreflightResult));
    val.deviceBoundSessionUsage =
        decoder.decodeStruct(new codec.Enum(device_bound_sessions$.DeviceBoundSessionUsage));
    val.clientSideContentDecodingTypes =
        decoder.decodeArrayPointer(new codec.Enum(source_type$.SourceType));
    val.unencodedDigests =
        decoder.decodeStructPointer(unencoded_digest$.UnencodedDigests);
    return val;
  };

  URLResponseHead.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(URLResponseHead.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.requestTime);
    encoder.encodeStructPointer(time$.Time, val.responseTime);
    encoder.encodeStructPointer(time$.Time, val.originalResponseTime);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headers);
    encoder.encodeStruct(codec.String, val.mimeType);
    encoder.encodeStruct(codec.String, val.charset);
    encoder.encodeStruct(codec.Int64, val.contentLength);
    encoder.encodeStruct(codec.Int64, val.encodedDataLength);
    encoder.encodeStructPointer(encoded_body_length$.EncodedBodyLength, val.encodedBodyLength);
    packed = 0;
    packed |= (val.networkAccessed & 1) << 0
    packed |= (val.emittedExtraInfo & 1) << 1
    packed |= (val.wasFetchedViaSpdy & 1) << 2
    packed |= (val.wasAlpnNegotiated & 1) << 3
    packed |= (val.wasAlternateProtocolAvailable & 1) << 4
    packed |= (val.isValidated & 1) << 5
    packed |= (val.wasFetchedViaCache & 1) << 6
    packed |= (val.wasFetchedViaServiceWorker & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.initial_service_worker_status_$flag & 1) << 0
    packed |= (val.didServiceWorkerNavigationPreload & 1) << 1
    packed |= (val.asyncRevalidationRequested & 1) << 2
    packed |= (val.didMimeSniff & 1) << 3
    packed |= (val.isSignedExchangeInnerResponse & 1) << 4
    packed |= (val.isWebBundleInnerResponse & 1) << 5
    packed |= (val.wasInPrefetchCache & 1) << 6
    packed |= (val.isPrefetchWithCrossSiteContamination & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.wasCookieInRequest & 1) << 0
    packed |= (val.interceptedByPlugin & 1) << 1
    packed |= (val.hasRangeRequested & 1) << 2
    packed |= (val.timingAllowPassed & 1) << 3
    packed |= (val.hasAuthorizationCoveredByWildcardOnPreflight & 1) << 4
    packed |= (val.requestIncludeCredentials & 1) << 5
    packed |= (val.shouldUseSourceHashForJsCodeCache & 1) << 6
    packed |= (val.didUseSharedDictionary & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.loadWithStorageAccess & 1) << 0
    packed |= (val.fromSyntheticResponse & 1) << 1
    packed |= (val.bypassRedirectChecks & 1) << 2
    packed |= (val.didUseServerHttpAuth & 1) << 3
    encoder.writeUint8(packed);
    encoder.encodeStruct(codec.Int32, val.connectionInfo);
    encoder.encodeStructPointer(load_timing_info$.LoadTimingInfo, val.loadTiming);
    encoder.encodeStructPointer(load_timing_internal_info$.LoadTimingInternalInfo, val.loadTimingInternalInfo);
    encoder.encodeStruct(codec.String, val.alpnNegotiatedProtocol);
    encoder.encodeStruct(codec.Int32, val.alternateProtocolUsage);
    encoder.encodeStruct(codec.Int32, val.clientAddressSpace);
    encoder.encodeStructPointer(ip_endpoint$.IPEndPoint, val.remoteEndpoint);
    encoder.encodeStruct(codec.Int32, val.responseAddressSpace);
    encoder.encodeStruct(codec.Int32, val.navigationDeliveryType);
    encoder.encodeStructPointer(network_param$.ProxyChain, val.proxyChain);
    encoder.encodeStruct(codec.Int32, val.serviceWorkerResponseSource);
    encoder.encodeStruct(codec.Int32, val.initial_service_worker_status_$value);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.urlListViaServiceWorker);
    encoder.encodeStructPointer(service_worker_router_info$.ServiceWorkerRouterInfo, val.serviceWorkerRouterInfo);
    encoder.encodeStruct(codec.Int32, val.responseType);
    encoder.encodeStruct(codec.Uint32, val.certStatus);
    encoder.encodeStruct(codec.Int64, val.padding);
    encoder.encodeStruct(codec.String, val.cacheStorageCacheName);
    encoder.encodeStructPointer(network_param$.SSLInfo, val.sslInfo);
    encoder.encodeArrayPointer(new codec.PointerTo(parsed_request_cookie$.ParsedRequestCookie), val.requestCookies);
    encoder.encodeArrayPointer(codec.String, val.corsExposedHeaderNames);
    encoder.encodeStructPointer(network_param$.AuthChallengeInfo, val.authChallengeInfo);
    encoder.encodeStructPointer(time$.TimeTicks, val.requestStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.responseStart);
    encoder.encodeStructPointer(parsed_headers$.ParsedHeaders, val.parsedHeaders);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.recursivePrefetchToken);
    encoder.encodeArrayPointer(codec.String, val.dnsAliases);
    encoder.encodeStruct(codec.Int32, val.privateNetworkAccessPreflightResult);
    encoder.encodeStruct(codec.Int32, val.deviceBoundSessionUsage);
    encoder.encodeArrayPointer(new codec.Enum(source_type$.SourceType), val.clientSideContentDecodingTypes);
    encoder.encodeStructPointer(unencoded_digest$.UnencodedDigests, val.unencodedDigests);
  };
  exports.NavigationDeliveryType = NavigationDeliveryType;
  exports.URLResponseHead = URLResponseHead;
})();