// services/network/public/mojom/tls_socket.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/tls_socket.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/tls_socket.mojom-params-data.h"
#include "services/network/public/mojom/tls_socket.mojom-shared-message-ids.h"

#include "services/network/public/mojom/tls_socket.mojom-import-headers.h"
#include "services/network/public/mojom/tls_socket.mojom-test-utils.h"


namespace network::mojom {
TLSClientSocketOptions::TLSClientSocketOptions()
    : version_min(::network::mojom::SSLVersion::kTLS12),
      version_max(::network::mojom::SSLVersion::kTLS13),
      send_ssl_info(false),
      unsafely_skip_cert_verification(false) {}

TLSClientSocketOptions::TLSClientSocketOptions(
    ::network::mojom::SSLVersion version_min_in,
    ::network::mojom::SSLVersion version_max_in,
    bool send_ssl_info_in,
    bool unsafely_skip_cert_verification_in)
    : version_min(std::move(version_min_in)),
      version_max(std::move(version_max_in)),
      send_ssl_info(std::move(send_ssl_info_in)),
      unsafely_skip_cert_verification(std::move(unsafely_skip_cert_verification_in)) {}

TLSClientSocketOptions::~TLSClientSocketOptions() = default;
size_t TLSClientSocketOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->version_min);
  seed = mojo::internal::Hash(seed, this->version_max);
  seed = mojo::internal::Hash(seed, this->send_ssl_info);
  seed = mojo::internal::Hash(seed, this->unsafely_skip_cert_verification);
  return seed;
}

void TLSClientSocketOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_min"), this->version_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_max"), this->version_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::SSLVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "send_ssl_info"), this->send_ssl_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unsafely_skip_cert_verification"), this->unsafely_skip_cert_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TLSClientSocketOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

TLSClientSocket::IPCStableHashFunction TLSClientSocket::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TLSClientSocket::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

TLSClientSocketProxy::TLSClientSocketProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool TLSClientSocketStubDispatch::Accept(
    TLSClientSocket* impl,
    mojo::Message* message) {
  return false;
}

// static
bool TLSClientSocketStubDispatch::AcceptWithResponder(
    TLSClientSocket* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool TLSClientSocketRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::TLSClientSocket::Name_,
    {});
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::TLSClientSocketOptions::DataView, ::network::mojom::TLSClientSocketOptionsPtr>::Read(
    ::network::mojom::TLSClientSocketOptions::DataView input,
    ::network::mojom::TLSClientSocketOptionsPtr* output) {
  bool success = true;
  ::network::mojom::TLSClientSocketOptionsPtr result(::network::mojom::TLSClientSocketOptions::New());
  
      if (success && !input.ReadVersionMin(&result->version_min))
        success = false;
      if (success && !input.ReadVersionMax(&result->version_max))
        success = false;
      if (success)
        result->send_ssl_info = input.send_ssl_info();
      if (success)
        result->unsafely_skip_cert_verification = input.unsafely_skip_cert_verification();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


TLSClientSocketAsyncWaiter::TLSClientSocketAsyncWaiter(
    TLSClientSocket* proxy) : proxy_(proxy) {}

TLSClientSocketAsyncWaiter::~TLSClientSocketAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif