// services/network/public/mojom/tcp_socket.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.TLSClientSocket');
goog.require('network.mojom.AddressList');
goog.require('network.mojom.HostPortPair');
goog.require('network.mojom.IPEndPoint');
goog.require('network.mojom.MutableNetworkTrafficAnnotationTag');
goog.require('network.mojom.SSLInfo');
goog.require('network.mojom.TLSClientSocketOptions');






goog.provide('network.mojom.TCPBoundSocket');
goog.provide('network.mojom.TCPBoundSocketReceiver');
goog.provide('network.mojom.TCPBoundSocketCallbackRouter');
goog.provide('network.mojom.TCPBoundSocketInterface');
goog.provide('network.mojom.TCPBoundSocketRemote');
goog.provide('network.mojom.TCPBoundSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TCPBoundSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TCPBoundSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TCPBoundSocketInterface = class {
  
  /**
   * @param { !number } backlog
   * @param { !network.mojom.TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  listen(backlog, socket) {}
  
  /**
   * @param { !network.mojom.AddressList } remoteAddrList
   * @param { ?network.mojom.TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network.mojom.TCPConnectedSocketPendingReceiver } socket
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  connect(remoteAddrList, tcpConnectedSocketOptions, socket, observer) {}
};

/**
 * @export
 * @implements { network.mojom.TCPBoundSocketInterface }
 */
network.mojom.TCPBoundSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TCPBoundSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TCPBoundSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TCPBoundSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } backlog
   * @param { !network.mojom.TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  listen(
      backlog,
      socket) {
    return this.proxy.sendMessage(
        0,
        network.mojom.TCPBoundSocket_Listen_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec.$,
        [
          backlog,
          socket
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.AddressList } remoteAddrList
   * @param { ?network.mojom.TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !network.mojom.TCPConnectedSocketPendingReceiver } socket
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        localAddr: ?network.mojom.IPEndPoint,
        peerAddr: ?network.mojom.IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  connect(
      remoteAddrList,
      tcpConnectedSocketOptions,
      socket,
      observer) {
    return this.proxy.sendMessage(
        1,
        network.mojom.TCPBoundSocket_Connect_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec.$,
        [
          remoteAddrList,
          tcpConnectedSocketOptions,
          socket,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TCPBoundSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TCPBoundSocketReceiver = class {
  /**
   * @param {!network.mojom.TCPBoundSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TCPBoundSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TCPBoundSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPBoundSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPBoundSocket_Listen_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec.$,
        impl.listen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TCPBoundSocket_Connect_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TCPBoundSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPBoundSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TCPBoundSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TCPBoundSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TCPBoundSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TCPBoundSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TCPBoundSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPBoundSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPBoundSocket_Listen_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec.$,
        this.listen.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TCPBoundSocket_Connect_ParamsSpec.$,
        network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TCPConnectedSocket');
goog.provide('network.mojom.TCPConnectedSocketReceiver');
goog.provide('network.mojom.TCPConnectedSocketCallbackRouter');
goog.provide('network.mojom.TCPConnectedSocketInterface');
goog.provide('network.mojom.TCPConnectedSocketRemote');
goog.provide('network.mojom.TCPConnectedSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TCPConnectedSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TCPConnectedSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TCPConnectedSocketInterface = class {
  
  /**
   * @param { !network.mojom.HostPortPair } hostPortPair
   * @param { ?network.mojom.TLSClientSocketOptions } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TLSClientSocketPendingReceiver } receiver
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
        sslInfo: ?network.mojom.SSLInfo,
   *  }>}
   */

  upgradeToTLS(hostPortPair, options, trafficAnnotation, receiver, observer) {}
  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setSendBufferSize(sendBufferSize) {}
  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setReceiveBufferSize(receiveBufferSize) {}
  
  /**
   * @param { !boolean } noDelay
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setNoDelay(noDelay) {}
  
  /**
   * @param { !boolean } enable
   * @param { !number } delaySecs
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setKeepAlive(enable, delaySecs) {}
};

/**
 * @export
 * @implements { network.mojom.TCPConnectedSocketInterface }
 */
network.mojom.TCPConnectedSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TCPConnectedSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TCPConnectedSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TCPConnectedSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.HostPortPair } hostPortPair
   * @param { ?network.mojom.TLSClientSocketOptions } options
   * @param { !network.mojom.MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network.mojom.TLSClientSocketPendingReceiver } receiver
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
        sslInfo: ?network.mojom.SSLInfo,
   *  }>}
   */

  upgradeToTLS(
      hostPortPair,
      options,
      trafficAnnotation,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        [
          hostPortPair,
          options,
          trafficAnnotation,
          receiver,
          observer
        ],
        false);
  }

  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setSendBufferSize(
      sendBufferSize) {
    return this.proxy.sendMessage(
        1,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        [
          sendBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setReceiveBufferSize(
      receiveBufferSize) {
    return this.proxy.sendMessage(
        2,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        [
          receiveBufferSize
        ],
        false);
  }

  
  /**
   * @param { !boolean } noDelay
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setNoDelay(
      noDelay) {
    return this.proxy.sendMessage(
        3,
        network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        [
          noDelay
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   * @param { !number } delaySecs
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setKeepAlive(
      enable,
      delaySecs) {
    return this.proxy.sendMessage(
        4,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        [
          enable,
          delaySecs
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TCPConnectedSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TCPConnectedSocketReceiver = class {
  /**
   * @param {!network.mojom.TCPConnectedSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TCPConnectedSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TCPConnectedSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPConnectedSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        impl.upgradeToTLS.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        impl.setSendBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        impl.setReceiveBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        impl.setNoDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        impl.setKeepAlive.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TCPConnectedSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPConnectedSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TCPConnectedSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TCPConnectedSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TCPConnectedSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TCPConnectedSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TCPConnectedSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPConnectedSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeToTLS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        this.upgradeToTLS.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSendBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        this.setSendBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiveBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        this.setReceiveBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNoDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        this.setNoDelay.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        this.setKeepAlive.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.SocketObserver');
goog.provide('network.mojom.SocketObserverReceiver');
goog.provide('network.mojom.SocketObserverCallbackRouter');
goog.provide('network.mojom.SocketObserverInterface');
goog.provide('network.mojom.SocketObserverRemote');
goog.provide('network.mojom.SocketObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.SocketObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.SocketObserver.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.SocketObserverInterface = class {
  
  /**
   * @param { !number } netError
   */

  onReadError(netError) {}
  
  /**
   * @param { !number } netError
   */

  onWriteError(netError) {}
};

/**
 * @export
 * @implements { network.mojom.SocketObserverInterface }
 */
network.mojom.SocketObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.SocketObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.SocketObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.SocketObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } netError
   */

  onReadError(
      netError) {
    this.proxy.sendMessage(
        0,
        network.mojom.SocketObserver_OnReadError_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }

  
  /**
   * @param { !number } netError
   */

  onWriteError(
      netError) {
    this.proxy.sendMessage(
        1,
        network.mojom.SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SocketObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.SocketObserverReceiver = class {
  /**
   * @param {!network.mojom.SocketObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.SocketObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.SocketObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SocketObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.SocketObserver_OnReadError_ParamsSpec.$,
        null,
        impl.onReadError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        impl.onWriteError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.SocketObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SocketObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.SocketObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.SocketObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SocketObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.SocketObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.SocketObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.SocketObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.SocketObserver_OnReadError_ParamsSpec.$,
        null,
        this.onReadError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWriteError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        this.onWriteError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TCPServerSocket');
goog.provide('network.mojom.TCPServerSocketReceiver');
goog.provide('network.mojom.TCPServerSocketCallbackRouter');
goog.provide('network.mojom.TCPServerSocketInterface');
goog.provide('network.mojom.TCPServerSocketRemote');
goog.provide('network.mojom.TCPServerSocketPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.TCPServerSocketPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.TCPServerSocket.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.TCPServerSocketInterface = class {
  
  /**
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        remoteAddr: ?network.mojom.IPEndPoint,
        connectedSocket: ?network.mojom.TCPConnectedSocketRemote,
        sendStream: ?MojoHandle,
        receiveStream: ?MojoHandle,
   *  }>}
   */

  accept(observer) {}
};

/**
 * @export
 * @implements { network.mojom.TCPServerSocketInterface }
 */
network.mojom.TCPServerSocketRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.TCPServerSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.TCPServerSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.TCPServerSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?network.mojom.SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        remoteAddr: ?network.mojom.IPEndPoint,
        connectedSocket: ?network.mojom.TCPConnectedSocketRemote,
        sendStream: ?MojoHandle,
        receiveStream: ?MojoHandle,
   *  }>}
   */

  accept(
      observer) {
    return this.proxy.sendMessage(
        0,
        network.mojom.TCPServerSocket_Accept_ParamsSpec.$,
        network.mojom.TCPServerSocket_Accept_ResponseParamsSpec.$,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the TCPServerSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.TCPServerSocketReceiver = class {
  /**
   * @param {!network.mojom.TCPServerSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.TCPServerSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.TCPServerSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPServerSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPServerSocket_Accept_ParamsSpec.$,
        network.mojom.TCPServerSocket_Accept_ResponseParamsSpec.$,
        impl.accept.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.TCPServerSocket = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPServerSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.TCPServerSocketRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.TCPServerSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the TCPServerSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.TCPServerSocketCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.TCPServerSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.TCPServerSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.accept =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.TCPServerSocket_Accept_ParamsSpec.$,
        network.mojom.TCPServerSocket_Accept_ResponseParamsSpec.$,
        this.accept.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.TCPKeepAliveOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPKeepAliveOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocketOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPServerSocketOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPServerSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPBoundSocket_Listen_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPBoundSocket_Listen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPBoundSocket_Connect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPBoundSocket_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SocketObserver_OnReadError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketObserver_OnReadError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.SocketObserver_OnWriteError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.SocketObserver_OnWriteError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPServerSocket_Accept_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPServerSocket_Accept_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.TCPServerSocket_Accept_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.TCPServerSocket_Accept_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.TCPKeepAliveOptionsSpec.$,
    'TCPKeepAliveOptions',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'delay', 2,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPKeepAliveOptions');

/** @record */
network.mojom.TCPKeepAliveOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
    /** @export { !number } */
    this.delay;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocketOptionsSpec.$,
    'TCPConnectedSocketOptions',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveBufferSize', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noDelay', 8,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'keepAliveOptions', 16,
        0,
        network.mojom.TCPKeepAliveOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.TCPConnectedSocketOptions');

/** @record */
network.mojom.TCPConnectedSocketOptions = class {
  constructor() {
    /** @export { !number } */
    this.sendBufferSize;
    /** @export { !number } */
    this.receiveBufferSize;
    /** @export { !boolean } */
    this.noDelay;
    /** @export { (network.mojom.TCPKeepAliveOptions|undefined) } */
    this.keepAliveOptions;
  }
};



mojo.internal.Struct(
    network.mojom.TCPServerSocketOptionsSpec.$,
    'TCPServerSocketOptions',
    [
      mojo.internal.StructField(
        'backlog', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPServerSocketOptions');

/** @record */
network.mojom.TCPServerSocketOptions = class {
  constructor() {
    /** @export { !number } */
    this.backlog;
    /** @export { (boolean|undefined) } */
    this.ipv6Only;
  }
};



mojo.internal.Struct(
    network.mojom.TCPBoundSocket_Listen_ParamsSpec.$,
    'TCPBoundSocket_Listen_Params',
    [
      mojo.internal.StructField(
        'backlog', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 4,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPServerSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPBoundSocket_Listen_Params');

/** @record */
network.mojom.TCPBoundSocket_Listen_Params = class {
  constructor() {
    /** @export { !number } */
    this.backlog;
    /** @export { !network.mojom.TCPServerSocketPendingReceiver } */
    this.socket;
  }
};



mojo.internal.Struct(
    network.mojom.TCPBoundSocket_Listen_ResponseParamsSpec.$,
    'TCPBoundSocket_Listen_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPBoundSocket_Listen_ResponseParams');

/** @record */
network.mojom.TCPBoundSocket_Listen_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.TCPBoundSocket_Connect_ParamsSpec.$,
    'TCPBoundSocket_Connect_Params',
    [
      mojo.internal.StructField(
        'remoteAddrList', 0,
        0,
        network.mojom.AddressListSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tcpConnectedSocketOptions', 8,
        0,
        network.mojom.TCPConnectedSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'socket', 16,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TCPConnectedSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 20,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.TCPBoundSocket_Connect_Params');

/** @record */
network.mojom.TCPBoundSocket_Connect_Params = class {
  constructor() {
    /** @export { !network.mojom.AddressList } */
    this.remoteAddrList;
    /** @export { (network.mojom.TCPConnectedSocketOptions|undefined) } */
    this.tcpConnectedSocketOptions;
    /** @export { !network.mojom.TCPConnectedSocketPendingReceiver } */
    this.socket;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.TCPBoundSocket_Connect_ResponseParamsSpec.$,
    'TCPBoundSocket_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.TCPBoundSocket_Connect_ResponseParams');

/** @record */
network.mojom.TCPBoundSocket_Connect_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.localAddr;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.peerAddr;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
    'TCPConnectedSocket_UpgradeToTLS_Params',
    [
      mojo.internal.StructField(
        'hostPortPair', 0,
        0,
        network.mojom.HostPortPairSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        network.mojom.TLSClientSocketOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network.mojom.MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 24,
        0,
        mojo.internal.InterfaceRequest(network.mojom.TLSClientSocketPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 28,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('network.mojom.TCPConnectedSocket_UpgradeToTLS_Params');

/** @record */
network.mojom.TCPConnectedSocket_UpgradeToTLS_Params = class {
  constructor() {
    /** @export { !network.mojom.HostPortPair } */
    this.hostPortPair;
    /** @export { (network.mojom.TLSClientSocketOptions|undefined) } */
    this.options;
    /** @export { !network.mojom.MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @export { !network.mojom.TLSClientSocketPendingReceiver } */
    this.receiver;
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
    'TCPConnectedSocket_UpgradeToTLS_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 8,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sslInfo', 16,
        0,
        network.mojom.SSLInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParams');

/** @record */
network.mojom.TCPConnectedSocket_UpgradeToTLS_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
    /** @export { (network.mojom.SSLInfo|undefined) } */
    this.sslInfo;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
    'TCPConnectedSocket_SetSendBufferSize_Params',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetSendBufferSize_Params');

/** @record */
network.mojom.TCPConnectedSocket_SetSendBufferSize_Params = class {
  constructor() {
    /** @export { !number } */
    this.sendBufferSize;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetSendBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParams');

/** @record */
network.mojom.TCPConnectedSocket_SetSendBufferSize_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
    'TCPConnectedSocket_SetReceiveBufferSize_Params',
    [
      mojo.internal.StructField(
        'receiveBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetReceiveBufferSize_Params');

/** @record */
network.mojom.TCPConnectedSocket_SetReceiveBufferSize_Params = class {
  constructor() {
    /** @export { !number } */
    this.receiveBufferSize;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetReceiveBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParams');

/** @record */
network.mojom.TCPConnectedSocket_SetReceiveBufferSize_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
    'TCPConnectedSocket_SetNoDelay_Params',
    [
      mojo.internal.StructField(
        'noDelay', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetNoDelay_Params');

/** @record */
network.mojom.TCPConnectedSocket_SetNoDelay_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.noDelay;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetNoDelay_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParams');

/** @record */
network.mojom.TCPConnectedSocket_SetNoDelay_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
    'TCPConnectedSocket_SetKeepAlive_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'delaySecs', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetKeepAlive_Params');

/** @record */
network.mojom.TCPConnectedSocket_SetKeepAlive_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
    /** @export { !number } */
    this.delaySecs;
  }
};



mojo.internal.Struct(
    network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetKeepAlive_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParams');

/** @record */
network.mojom.TCPConnectedSocket_SetKeepAlive_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    network.mojom.SocketObserver_OnReadError_ParamsSpec.$,
    'SocketObserver_OnReadError_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SocketObserver_OnReadError_Params');

/** @record */
network.mojom.SocketObserver_OnReadError_Params = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.SocketObserver_OnWriteError_ParamsSpec.$,
    'SocketObserver_OnWriteError_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.SocketObserver_OnWriteError_Params');

/** @record */
network.mojom.SocketObserver_OnWriteError_Params = class {
  constructor() {
    /** @export { !number } */
    this.netError;
  }
};



mojo.internal.Struct(
    network.mojom.TCPServerSocket_Accept_ParamsSpec.$,
    'TCPServerSocket_Accept_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(network.mojom.SocketObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.TCPServerSocket_Accept_Params');

/** @record */
network.mojom.TCPServerSocket_Accept_Params = class {
  constructor() {
    /** @export { (network.mojom.SocketObserverRemote|undefined) } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.TCPServerSocket_Accept_ResponseParamsSpec.$,
    'TCPServerSocket_Accept_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteAddr', 8,
        0,
        network.mojom.IPEndPointSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectedSocket', 16,
        0,
        mojo.internal.InterfaceProxy(network.mojom.TCPConnectedSocketRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sendStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiveStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.TCPServerSocket_Accept_ResponseParams');

/** @record */
network.mojom.TCPServerSocket_Accept_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.netError;
    /** @export { (network.mojom.IPEndPoint|undefined) } */
    this.remoteAddr;
    /** @export { (network.mojom.TCPConnectedSocketRemote|undefined) } */
    this.connectedSocket;
    /** @export { (MojoHandle|undefined) } */
    this.sendStream;
    /** @export { (MojoHandle|undefined) } */
    this.receiveStream;
  }
};

