// services/network/public/mojom/structured_headers.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/structured_headers.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/structured_headers.mojom-params-data.h"
#include "services/network/public/mojom/structured_headers.mojom-shared-message-ids.h"

#include "services/network/public/mojom/structured_headers.mojom-blink-import-headers.h"
#include "services/network/public/mojom/structured_headers.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
StructuredHeadersParameter::StructuredHeadersParameter()
    : key(),
      item() {}

StructuredHeadersParameter::StructuredHeadersParameter(
    const ::blink::String& key_in,
    StructuredHeadersItemPtr item_in)
    : key(std::move(key_in)),
      item(std::move(item_in)) {}

StructuredHeadersParameter::~StructuredHeadersParameter() = default;

void StructuredHeadersParameter::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item"), this->item,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StructuredHeadersItemPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StructuredHeadersParameter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StructuredHeadersParameterizedItem::StructuredHeadersParameterizedItem()
    : item(),
      parameters() {}

StructuredHeadersParameterizedItem::StructuredHeadersParameterizedItem(
    StructuredHeadersItemPtr item_in,
    ::blink::Vector<StructuredHeadersParameterPtr> parameters_in)
    : item(std::move(item_in)),
      parameters(std::move(parameters_in)) {}

StructuredHeadersParameterizedItem::~StructuredHeadersParameterizedItem() = default;

void StructuredHeadersParameterizedItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "item"), this->item,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StructuredHeadersItemPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parameters"), this->parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<StructuredHeadersParameterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StructuredHeadersParameterizedItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StructuredHeadersParameterizedMember::StructuredHeadersParameterizedMember()
    : member(),
      member_is_inner_list(),
      parameters() {}

StructuredHeadersParameterizedMember::StructuredHeadersParameterizedMember(
    ::blink::Vector<StructuredHeadersParameterizedItemPtr> member_in,
    bool member_is_inner_list_in,
    ::blink::Vector<StructuredHeadersParameterPtr> parameters_in)
    : member(std::move(member_in)),
      member_is_inner_list(std::move(member_is_inner_list_in)),
      parameters(std::move(parameters_in)) {}

StructuredHeadersParameterizedMember::~StructuredHeadersParameterizedMember() = default;

void StructuredHeadersParameterizedMember::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "member"), this->member,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<StructuredHeadersParameterizedItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "member_is_inner_list"), this->member_is_inner_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parameters"), this->parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<StructuredHeadersParameterPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StructuredHeadersParameterizedMember::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StructuredHeadersDictionaryMember::StructuredHeadersDictionaryMember()
    : key(),
      value() {}

StructuredHeadersDictionaryMember::StructuredHeadersDictionaryMember(
    const ::blink::String& key_in,
    StructuredHeadersParameterizedMemberPtr value_in)
    : key(std::move(key_in)),
      value(std::move(value_in)) {}

StructuredHeadersDictionaryMember::~StructuredHeadersDictionaryMember() = default;

void StructuredHeadersDictionaryMember::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StructuredHeadersParameterizedMemberPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StructuredHeadersDictionaryMember::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StructuredHeadersDictionary::StructuredHeadersDictionary()
    : members() {}

StructuredHeadersDictionary::StructuredHeadersDictionary(
    ::blink::Vector<StructuredHeadersDictionaryMemberPtr> members_in)
    : members(std::move(members_in)) {}

StructuredHeadersDictionary::~StructuredHeadersDictionary() = default;

void StructuredHeadersDictionary::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "members"), this->members,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<StructuredHeadersDictionaryMemberPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StructuredHeadersDictionary::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StructuredHeadersItemPtr
StructuredHeadersItem::NewNullValue(
    uint8_t value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNullValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewIntegerValue(
    int64_t value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIntegerValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewDecimalValue(
    double value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDecimalValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewStringValue(
    const ::blink::String& value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kStringValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewTokenValue(
    const ::blink::String& value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTokenValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewByteSequenceValue(
    const std::string& value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kByteSequenceValue)>,
      std::move(value));
}

StructuredHeadersItemPtr
StructuredHeadersItem::NewBooleanValue(
    bool value) {
  return StructuredHeadersItemPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBooleanValue)>,
      std::move(value));
}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
    uint8_t value)
    : tag_(Tag::kNullValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNullValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntegerValue)>,
    int64_t value)
    : tag_(Tag::kIntegerValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIntegerValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kDecimalValue)>,
    double value)
    : tag_(Tag::kDecimalValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDecimalValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
    const ::blink::String& value)
    : tag_(Tag::kStringValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kStringValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kTokenValue)>,
    const ::blink::String& value)
    : tag_(Tag::kTokenValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTokenValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kByteSequenceValue)>,
    const std::string& value)
    : tag_(Tag::kByteSequenceValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kByteSequenceValue)>,
            std::move(value)) {}

StructuredHeadersItem::StructuredHeadersItem(
    std::in_place_index_t<static_cast<size_t>(Tag::kBooleanValue)>,
    bool value)
    : tag_(Tag::kBooleanValue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBooleanValue)>,
            std::move(value)) {}
StructuredHeadersItem::~StructuredHeadersItem() {
  DestroyActive();
}

void StructuredHeadersItem::set_null_value(uint8_t null_value) {
  if (tag_ != Tag::kNullValue) {
    DestroyActive();
    tag_ = Tag::kNullValue;
  }
  data_.null_value = null_value;
}

void StructuredHeadersItem::set_integer_value(int64_t integer_value) {
  if (tag_ != Tag::kIntegerValue) {
    DestroyActive();
    tag_ = Tag::kIntegerValue;
  }
  data_.integer_value = integer_value;
}

void StructuredHeadersItem::set_decimal_value(double decimal_value) {
  if (tag_ != Tag::kDecimalValue) {
    DestroyActive();
    tag_ = Tag::kDecimalValue;
  }
  data_.decimal_value = decimal_value;
}

void StructuredHeadersItem::set_string_value(const ::blink::String& string_value) {
  if (tag_ == Tag::kStringValue) {
    data_.string_value = std::move(string_value);
  } else {
    DestroyActive();
    tag_ = Tag::kStringValue;
    new (&data_.string_value) ::blink::String(
        std::move(string_value));
  }
}

void StructuredHeadersItem::set_token_value(const ::blink::String& token_value) {
  if (tag_ == Tag::kTokenValue) {
    data_.token_value = std::move(token_value);
  } else {
    DestroyActive();
    tag_ = Tag::kTokenValue;
    new (&data_.token_value) ::blink::String(
        std::move(token_value));
  }
}

void StructuredHeadersItem::set_byte_sequence_value(const std::string& byte_sequence_value) {
  if (tag_ == Tag::kByteSequenceValue) {
    data_.byte_sequence_value = std::move(byte_sequence_value);
  } else {
    DestroyActive();
    tag_ = Tag::kByteSequenceValue;
    new (&data_.byte_sequence_value) std::string(
        std::move(byte_sequence_value));
  }
}

void StructuredHeadersItem::set_boolean_value(bool boolean_value) {
  if (tag_ != Tag::kBooleanValue) {
    DestroyActive();
    tag_ = Tag::kBooleanValue;
  }
  data_.boolean_value = boolean_value;
}


StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
    uint8_t value)
    : null_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIntegerValue)>,
    int64_t value)
    : integer_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDecimalValue)>,
    double value)
    : decimal_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
    const ::blink::String& value)
    : string_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTokenValue)>,
    const ::blink::String& value)
    : token_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kByteSequenceValue)>,
    const std::string& value)
    : byte_sequence_value(std::move(value)) {}

StructuredHeadersItem::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBooleanValue)>,
    bool value)
    : boolean_value(std::move(value)) {}

void StructuredHeadersItem::DestroyActive() {
  switch (tag_) {

    case Tag::kNullValue:
      std::destroy_at(&data_.null_value);
      break;
    case Tag::kIntegerValue:
      std::destroy_at(&data_.integer_value);
      break;
    case Tag::kDecimalValue:
      std::destroy_at(&data_.decimal_value);
      break;
    case Tag::kStringValue:
      std::destroy_at(&data_.string_value);
      break;
    case Tag::kTokenValue:
      std::destroy_at(&data_.token_value);
      break;
    case Tag::kByteSequenceValue:
      std::destroy_at(&data_.byte_sequence_value);
      break;
    case Tag::kBooleanValue:
      std::destroy_at(&data_.boolean_value);
      break;
  }
}

bool StructuredHeadersItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::StructuredHeadersParameter::DataView, ::network::mojom::blink::StructuredHeadersParameterPtr>::Read(
    ::network::mojom::blink::StructuredHeadersParameter::DataView input,
    ::network::mojom::blink::StructuredHeadersParameterPtr* output) {
  bool success = true;
  ::network::mojom::blink::StructuredHeadersParameterPtr result(::network::mojom::blink::StructuredHeadersParameter::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadItem(&result->item))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::StructuredHeadersParameterizedItem::DataView, ::network::mojom::blink::StructuredHeadersParameterizedItemPtr>::Read(
    ::network::mojom::blink::StructuredHeadersParameterizedItem::DataView input,
    ::network::mojom::blink::StructuredHeadersParameterizedItemPtr* output) {
  bool success = true;
  ::network::mojom::blink::StructuredHeadersParameterizedItemPtr result(::network::mojom::blink::StructuredHeadersParameterizedItem::New());
  
      if (success && !input.ReadItem(&result->item))
        success = false;
      if (success && !input.ReadParameters(&result->parameters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::StructuredHeadersParameterizedMember::DataView, ::network::mojom::blink::StructuredHeadersParameterizedMemberPtr>::Read(
    ::network::mojom::blink::StructuredHeadersParameterizedMember::DataView input,
    ::network::mojom::blink::StructuredHeadersParameterizedMemberPtr* output) {
  bool success = true;
  ::network::mojom::blink::StructuredHeadersParameterizedMemberPtr result(::network::mojom::blink::StructuredHeadersParameterizedMember::New());
  
      if (success && !input.ReadMember(&result->member))
        success = false;
      if (success)
        result->member_is_inner_list = input.member_is_inner_list();
      if (success && !input.ReadParameters(&result->parameters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::StructuredHeadersDictionaryMember::DataView, ::network::mojom::blink::StructuredHeadersDictionaryMemberPtr>::Read(
    ::network::mojom::blink::StructuredHeadersDictionaryMember::DataView input,
    ::network::mojom::blink::StructuredHeadersDictionaryMemberPtr* output) {
  bool success = true;
  ::network::mojom::blink::StructuredHeadersDictionaryMemberPtr result(::network::mojom::blink::StructuredHeadersDictionaryMember::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::StructuredHeadersDictionary::DataView, ::network::mojom::blink::StructuredHeadersDictionaryPtr>::Read(
    ::network::mojom::blink::StructuredHeadersDictionary::DataView input,
    ::network::mojom::blink::StructuredHeadersDictionaryPtr* output) {
  bool success = true;
  ::network::mojom::blink::StructuredHeadersDictionaryPtr result(::network::mojom::blink::StructuredHeadersDictionary::New());
  
      if (success && !input.ReadMembers(&result->members))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::blink::StructuredHeadersItem::DataView, ::network::mojom::blink::StructuredHeadersItemPtr>::Read(
    ::network::mojom::blink::StructuredHeadersItem::DataView input,
    ::network::mojom::blink::StructuredHeadersItemPtr* output) {
  using UnionType = ::network::mojom::blink::StructuredHeadersItem;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNullValue: {
      *output = UnionType::NewNullValue(input.null_value());
      break;
    }
    case Tag::kIntegerValue: {
      *output = UnionType::NewIntegerValue(input.integer_value());
      break;
    }
    case Tag::kDecimalValue: {
      *output = UnionType::NewDecimalValue(input.decimal_value());
      break;
    }
    case Tag::kStringValue: {
      ::blink::String result_string_value{};
      if (!input.ReadStringValue(&result_string_value))
        return false;

      *output = UnionType::NewStringValue(
          std::move(result_string_value));
      break;
    }
    case Tag::kTokenValue: {
      ::blink::String result_token_value{};
      if (!input.ReadTokenValue(&result_token_value))
        return false;

      *output = UnionType::NewTokenValue(
          std::move(result_token_value));
      break;
    }
    case Tag::kByteSequenceValue: {
      std::string result_byte_sequence_value{};
      if (!input.ReadByteSequenceValue(&result_byte_sequence_value))
        return false;

      *output = UnionType::NewByteSequenceValue(
          std::move(result_byte_sequence_value));
      break;
    }
    case Tag::kBooleanValue: {
      *output = UnionType::NewBooleanValue(input.boolean_value());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif