// services/network/public/mojom/sri_message_signature.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/sri_message_signature.mojom-shared-internal.h"




#include "services/network/public/mojom/sri_message_signature.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::SRIMessageSignatureError>
    : public mojo::internal::EnumHashImpl<::network::mojom::SRIMessageSignatureError> {};

template <>
struct hash<::network::mojom::SRIMessageSignatureComponentParameter_Type>
    : public mojo::internal::EnumHashImpl<::network::mojom::SRIMessageSignatureComponentParameter_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SRIMessageSignatureError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SRIMessageSignatureError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureComponentParameter_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SRIMessageSignatureComponentParameter_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SRIMessageSignatureComponentParameter_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureComponentParameterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureComponentParameterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureComponentParameter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::SRIMessageSignatureComponentParameter_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatureComponentParameter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureComponentParameterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureComponentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureComponentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureComponent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in SRIMessageSignatureComponent struct");

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType>
        params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentParameterDataView>>(
      in_params,
      params_fragment,
      &params_validate_params);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in SRIMessageSignatureComponent struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatureComponent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureComponentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in SRIMessageSignature struct");

    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType>
        signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature,
      signature_fragment,
      &signature_validate_params);

    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signature.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in SRIMessageSignature struct");

    decltype(Traits::components(input)) in_components = Traits::components(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->components)::BaseType>
        components_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& components_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentDataView>>(
      in_components,
      components_fragment,
      &components_validate_params);

    fragment->components.Set(
        components_fragment.is_null() ? nullptr : components_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->components.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null components in SRIMessageSignature struct");
    fragment->created_$flag = Traits::created(input).has_value();
    if (Traits::created(input).has_value()) {
      fragment->created_$value = Traits::created(input).value();
    }
    fragment->expires_$flag = Traits::expires(input).has_value();
    if (Traits::expires(input).has_value()) {
      fragment->expires_$value = Traits::expires(input).value();
    }

    decltype(Traits::keyid(input)) in_keyid = Traits::keyid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyid)::BaseType>
        keyid_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& keyid_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_keyid,
      keyid_fragment,
      &keyid_validate_params);

    fragment->keyid.Set(
        keyid_fragment.is_null() ? nullptr : keyid_fragment.data());

    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_nonce,
      nonce_fragment);

    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tag,
      tag_fragment);

    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());

    decltype(Traits::serialized_signature_params(input)) in_serialized_signature_params = Traits::serialized_signature_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_signature_params)::BaseType> serialized_signature_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serialized_signature_params,
      serialized_signature_params_fragment);

    fragment->serialized_signature_params.Set(
        serialized_signature_params_fragment.is_null() ? nullptr : serialized_signature_params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serialized_signature_params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serialized_signature_params in SRIMessageSignature struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureIssueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureIssueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureIssue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::network::mojom::SRIMessageSignatureError>(
      Traits::error(input),
      &fragment->error);

    decltype(Traits::signature_base(input)) in_signature_base = Traits::signature_base(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature_base)::BaseType> signature_base_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_signature_base,
      signature_base_fragment);

    fragment->signature_base.Set(
        signature_base_fragment.is_null() ? nullptr : signature_base_fragment.data());

    decltype(Traits::integrity_assertions(input)) in_integrity_assertions = Traits::integrity_assertions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->integrity_assertions)::BaseType>
        integrity_assertions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& integrity_assertions_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_integrity_assertions,
      integrity_assertions_fragment,
      &integrity_assertions_validate_params);

    fragment->integrity_assertions.Set(
        integrity_assertions_fragment.is_null() ? nullptr : integrity_assertions_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatureIssue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureIssueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::signatures(input)) in_signatures = Traits::signatures(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signatures)::BaseType>
        signatures_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureDataView>>(
      in_signatures,
      signatures_fragment,
      &signatures_validate_params);

    fragment->signatures.Set(
        signatures_fragment.is_null() ? nullptr : signatures_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->signatures.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signatures in SRIMessageSignatures struct");

    decltype(Traits::issues(input)) in_issues = Traits::issues(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issues)::BaseType>
        issues_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>>(
      in_issues,
      issues_fragment,
      &issues_validate_params);

    fragment->issues.Set(
        issues_fragment.is_null() ? nullptr : issues_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issues.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issues in SRIMessageSignatures struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SRIMessageSignatureComponentParameterDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SRIMessageSignatureComponentDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureComponentDataView::GetParamsDataView(
    mojo::ArrayDataView<SRIMessageSignatureComponentParameterDataView>* output) {
  auto pointer = data_->params.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureComponentParameterDataView>(pointer, message_);
}


inline void SRIMessageSignatureDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetComponentsDataView(
    mojo::ArrayDataView<SRIMessageSignatureComponentDataView>* output) {
  auto pointer = data_->components.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureComponentDataView>(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetKeyidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->keyid.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetNonceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetSerializedSignatureParamsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serialized_signature_params.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SRIMessageSignatureIssueDataView::GetSignatureBaseDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signature_base.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureIssueDataView::GetIntegrityAssertionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->integrity_assertions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void SRIMessageSignaturesDataView::GetSignaturesDataView(
    mojo::ArrayDataView<SRIMessageSignatureDataView>* output) {
  auto pointer = data_->signatures.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureDataView>(pointer, message_);
}
inline void SRIMessageSignaturesDataView::GetIssuesDataView(
    mojo::ArrayDataView<SRIMessageSignatureIssueDataView>* output) {
  auto pointer = data_->issues.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureIssueDataView>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SRIMessageSignatureError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SRIMessageSignatureComponentParameter_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureComponentParameter_Type value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_